/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.orders.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Calendar;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.orders.base.Order;
import org.aspcfs.modules.orders.base.OrderList;
import org.aspcfs.modules.orders.base.OrderPaymentList;
import org.aspcfs.modules.orders.beans.StatusBean;
import org.aspcfs.modules.products.base.ProductCategoryList;
import org.aspcfs.modules.products.base.ProductOptionList;
import org.aspcfs.modules.products.base.ProductOptionValuesList;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class Orders
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return this.executeCommandSearchForm(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearchForm(ActionContext context) {
        if (!this.hasPermission(context, "orders-view")) {
            return "PermissionError";
        }
        if (Orders.isPortalUser(context)) {
            return this.executeCommandSearch(context);
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList statusSelect = systemStatus.getLookupList(db, "lookup_order_status");
            statusSelect.addItem(-1, "All Open Orders");
            context.getRequest().setAttribute("statusSelect", (Object)statusSelect);
            LookupList list = new LookupList(db, "lookup_product_category_type");
            ProductCategoryList categoryList = new ProductCategoryList();
            categoryList.buildList(db);
            HtmlSelect select = categoryList.getHtmlSelect(list.getIdFromValue("Publication"));
            context.getRequest().setAttribute("categorySelect", (Object)select);
            PagedListInfo orderListInfo = this.getPagedListInfo(context, "searchOrderListInfo");
            orderListInfo.setCurrentLetter("");
            orderListInfo.setCurrentOffset(0);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Search Orders", "Orders Search");
        return "SearchOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearch(ActionContext context) {
        String string;
        if (!this.hasPermission(context, "orders-view")) {
            return "PermissionError";
        }
        String source = context.getRequest().getParameter("source");
        OrderList orderList = new OrderList();
        this.addModuleBean(context, "View Orders", "Search Results");
        PagedListInfo searchListInfo = this.getPagedListInfo(context, "searchOrderListInfo");
        searchListInfo.setLink("Orders.do?command=Search");
        Connection db = null;
        try {
            if (Orders.isPortalUser(context)) {
                source = "searchForm";
            }
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList typeSelect = systemStatus.getLookupList(db, "lookup_order_type");
            context.getRequest().setAttribute("typeSelect", (Object)typeSelect);
            LookupList statusSelect = systemStatus.getLookupList(db, "lookup_order_status");
            context.getRequest().setAttribute("statusSelect", (Object)statusSelect);
            statusSelect.addItem(-1, "All Open Orders");
            orderList.setPagedListInfo(searchListInfo);
            orderList.setStatusId(searchListInfo.getFilterKey("listFilter1"));
            if (orderList.getStatusId() == -1) {
                orderList.setClosedOnly(0);
            }
            orderList.setCategoryId(searchListInfo.getFilterKey("listFilter2"));
            searchListInfo.setSearchCriteria(orderList, context);
            if (Orders.isPortalUser(context)) {
                orderList.setOrgId(Orders.getPortalUserPermittedOrgId(context));
            }
            orderList.buildList(db);
            context.getRequest().setAttribute("orderList", (Object)orderList);
            string = "ListOK";
        }
        catch (Exception e) {
            String string2;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string2 = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string2;
        }
        this.freeConnection(context, db);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "orders-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Order newOrder = null;
        ProductOptionList optionList = null;
        ProductOptionValuesList optionValuesList = null;
        int tempid = -1;
        try {
            tempid = Integer.parseInt(context.getRequest().getParameter("id"));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("actionError", (Object)"Invalid criteria, please review and make necessary changes before submitting");
            return "SearchCriteriaError";
        }
        try {
            db = this.getConnection(context);
            newOrder = new Order();
            newOrder.setBuildProducts(true);
            newOrder.queryRecord(db, tempid);
            optionList = new ProductOptionList();
            optionList.buildList(db);
            context.getRequest().setAttribute("productOptionList", (Object)optionList);
            optionValuesList = new ProductOptionValuesList();
            optionValuesList.buildList(db);
            context.getRequest().setAttribute("productOptionValuesList", (Object)optionValuesList);
            OrderPaymentList paymentList = new OrderPaymentList();
            paymentList.setOrderId(newOrder.getId());
            paymentList.buildList(db);
            context.getRequest().setAttribute("paymentList", (Object)paymentList);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList typeSelect = systemStatus.getLookupList(db, "lookup_order_type");
            context.getRequest().setAttribute("typeSelect", (Object)typeSelect);
            LookupList statusSelect = systemStatus.getLookupList(db, "lookup_order_status");
            context.getRequest().setAttribute("statusSelect", (Object)statusSelect);
            LookupList paymentSelect = systemStatus.getLookupList(db, "lookup_payment_status");
            context.getRequest().setAttribute("paymentSelect", (Object)paymentSelect);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("actionError", (Object)"The specified order could not be found");
            String string = "SearchCriteriaError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        String action = context.getRequest().getParameter("action");
        if (action != null && action.equals("modify")) {
            this.addModuleBean(context, "Orders", "Modify Order Details");
            return "DetailsOK";
        }
        this.addModuleBean(context, "View Orders", "View Order Details");
        context.getRequest().setAttribute("OrderDetails", (Object)newOrder);
        return "DetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyStatus(ActionContext context) {
        if (!this.hasPermission(context, "orders-view")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        Connection db = null;
        Order newOrder = null;
        ProductOptionList optionList = null;
        ProductOptionValuesList optionValuesList = null;
        try {
            String tempOrderId = context.getRequest().getParameter("id");
            int tempid = Integer.parseInt(tempOrderId);
            db = this.getConnection(context);
            newOrder = new Order();
            newOrder.setBuildProducts(true);
            newOrder.queryRecord(db, tempid);
            optionList = new ProductOptionList();
            optionList.buildList(db);
            context.getRequest().setAttribute("productOptionList", (Object)optionList);
            optionValuesList = new ProductOptionValuesList();
            optionValuesList.buildList(db);
            context.getRequest().setAttribute("productOptionValuesList", (Object)optionValuesList);
            OrderPaymentList paymentList = new OrderPaymentList();
            paymentList.setOrderId(newOrder.getId());
            paymentList.buildList(db);
            context.getRequest().setAttribute("paymentList", (Object)paymentList);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList typeSelect = systemStatus.getLookupList(db, "lookup_order_type");
            context.getRequest().setAttribute("typeSelect", (Object)typeSelect);
            LookupList statusSelect = systemStatus.getLookupList(db, "lookup_order_status");
            statusSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("statusSelect", (Object)statusSelect);
            StatusBean statusBean = new StatusBean();
            statusBean.setStatusId(newOrder.getStatusId());
            statusBean.setAuthorizationCode(newOrder.getNotes());
            context.getRequest().setAttribute("statusBean", (Object)statusBean);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        context.getRequest().setAttribute("OrderDetails", (Object)newOrder);
        return "ModifyStatusOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveStatus(ActionContext context) {
        if (!this.hasPermission(context, "orders-view")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        Connection db = null;
        Order newOrder = null;
        ProductOptionList optionList = null;
        Object optionValuesList = null;
        try {
            String tempOrderId = context.getRequest().getParameter("id");
            int tempid = Integer.parseInt(tempOrderId);
            db = this.getConnection(context);
            newOrder = new Order();
            newOrder.setBuildProducts(true);
            newOrder.queryRecord(db, tempid);
            optionList = new ProductOptionList();
            optionList.buildList(db);
            context.getRequest().setAttribute("productOptionList", (Object)optionList);
            Calendar now = Calendar.getInstance();
            Timestamp rightNow = new Timestamp(now.getTimeInMillis());
            StatusBean statusBean = (StatusBean)((Object)context.getFormBean());
            if (statusBean.getStatusId() != -1 && statusBean.getStatusId() != 0) {
                newOrder.setStatusId(statusBean.getStatusId());
            }
            newOrder.setNotes(statusBean.getAuthorizationCode());
            newOrder.setModified(rightNow);
            newOrder.update(db);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        context.getRequest().setAttribute("OrderDetails", (Object)newOrder);
        return "SaveStatusOK";
    }
}

