/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.orders.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Calendar;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.orders.base.Order;
import org.aspcfs.modules.orders.base.OrderPayment;
import org.aspcfs.modules.orders.base.OrderProduct;
import org.aspcfs.modules.orders.base.PaymentCreditCard;
import org.aspcfs.modules.orders.beans.StatusBean;
import org.aspcfs.modules.products.base.ProductOptionList;
import org.aspcfs.modules.products.base.ProductOptionValuesList;
import org.aspcfs.utils.SecurityKey;
import org.aspcfs.utils.web.LookupList;

public final class OrdersPayments
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        if (!this.hasPermission(context, "orders-view")) {
            return "PermissionError";
        }
        return "OK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        String creditCardPassword;
        if (!this.hasPermission(context, "orders-view")) {
            return "PermissionError";
        }
        int paymentId = -1;
        try {
            paymentId = Integer.parseInt(context.getRequest().getParameter("paymentId"));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("actionError", (Object)"Invalid criteria, please review and make necessary changes before submitting");
            return "SearchCriteriaError";
        }
        OrderProduct orderProduct = null;
        Object paymentStatusList = null;
        OrderPayment orderPayment = null;
        Order order = null;
        Connection db = null;
        PaymentCreditCard creditCard = new PaymentCreditCard();
        try {
            db = this.getConnection(context);
            orderPayment = new OrderPayment();
            orderPayment.setBuildOrderPaymentStatusList(true);
            orderPayment.queryRecord(db, paymentId);
            context.getRequest().setAttribute("orderPayment", (Object)orderPayment);
            orderProduct = new OrderProduct();
            orderProduct.setBuildProduct(true);
            orderProduct.setBuildProductOptions(true);
            orderProduct.setBuildProductStatus(true);
            orderProduct.queryRecord(db, orderPayment.getOrderItemId());
            context.getRequest().setAttribute("orderProduct", (Object)orderProduct);
            order = new Order();
            order.setBuildProducts(true);
            order.setBuildAddressList(true);
            order.queryRecord(db, orderProduct.getOrderId());
            context.getRequest().setAttribute("order", (Object)order);
            ProductOptionList optionList = new ProductOptionList();
            optionList.buildList(db);
            context.getRequest().setAttribute("productOptionList", (Object)optionList);
            ProductOptionValuesList valuesList = new ProductOptionValuesList();
            valuesList.buildList(db);
            context.getRequest().setAttribute("productOptionValuesList", (Object)valuesList);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList paymentMethod = systemStatus.getLookupList(db, "lookup_payment_methods");
            context.getRequest().setAttribute("paymentMethod", (Object)paymentMethod);
            LookupList paymentSelect = systemStatus.getLookupList(db, "lookup_payment_status");
            context.getRequest().setAttribute("paymentSelect", (Object)paymentSelect);
            LookupList creditCardType = systemStatus.getLookupList(db, "lookup_creditcard_types");
            context.getRequest().setAttribute("creditCardType", (Object)creditCardType);
            creditCard.queryRecord(db, orderPayment.getCreditCardId());
            context.getRequest().setAttribute("creditCard", (Object)creditCard);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("actionError", (Object)"The specified payment could not be found");
            String valuesList = "SearchCriteriaError";
            return valuesList;
        }
        finally {
            this.freeConnection(context, db);
        }
        String resetPassword = context.getRequest().getParameter("resetPassword");
        if ("true".equals(resetPassword)) {
            context.getSession().removeAttribute("creditCardPassword");
        }
        if ((creditCardPassword = context.getRequest().getParameter("creditCardPassword")) == null) {
            creditCardPassword = (String)context.getSession().getAttribute("creditCardPassword");
        }
        if (creditCardPassword != null && !"".equals(creditCardPassword)) {
            try {
                creditCard.setCardNumber(SecurityKey.useEncodedKey(this.getPath(context, "keys") + "order_private.enc", creditCardPassword, creditCard.getCardNumber()));
                context.getSession().setAttribute("creditCardPassword", (Object)creditCardPassword);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                context.getRequest().setAttribute("actionError", (Object)"Invalid Password, try again");
            }
        }
        this.addModuleBean(context, "OrdersProducts", "OrdersProducts Details");
        return "DetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "orders-view")) {
            return "PermissionError";
        }
        int paymentId = Integer.parseInt(context.getRequest().getParameter("paymentId"));
        OrderProduct orderProduct = null;
        Object paymentStatusList = null;
        OrderPayment orderPayment = null;
        Order order = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            orderPayment = new OrderPayment();
            orderPayment.setBuildOrderPaymentStatusList(true);
            orderPayment.queryRecord(db, paymentId);
            context.getRequest().setAttribute("orderPayment", (Object)orderPayment);
            StatusBean paymentBean = new StatusBean();
            paymentBean.setStatusId(orderPayment.getStatusId());
            context.getRequest().setAttribute("statusBean", (Object)paymentBean);
            orderProduct = new OrderProduct();
            orderProduct.setBuildProduct(true);
            orderProduct.setBuildProductOptions(true);
            orderProduct.setBuildProductStatus(true);
            orderProduct.queryRecord(db, orderPayment.getOrderItemId());
            context.getRequest().setAttribute("orderProduct", (Object)orderProduct);
            order = new Order();
            order.setBuildProducts(true);
            order.setBuildAddressList(true);
            order.queryRecord(db, orderProduct.getOrderId());
            context.getRequest().setAttribute("order", (Object)order);
            ProductOptionList optionList = new ProductOptionList();
            optionList.buildList(db);
            context.getRequest().setAttribute("productOptionList", (Object)optionList);
            ProductOptionValuesList valuesList = new ProductOptionValuesList();
            valuesList.buildList(db);
            context.getRequest().setAttribute("productOptionValuesList", (Object)valuesList);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList paymentMethod = systemStatus.getLookupList(db, "lookup_payment_methods");
            context.getRequest().setAttribute("paymentMethod", (Object)paymentMethod);
            LookupList paymentSelect = systemStatus.getLookupList(db, "lookup_payment_status");
            paymentSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("paymentSelect", (Object)paymentSelect);
            LookupList creditCardType = systemStatus.getLookupList(db, "lookup_creditcard_types");
            context.getRequest().setAttribute("creditCardType", (Object)creditCardType);
            PaymentCreditCard creditCard = new PaymentCreditCard();
            creditCard.queryRecord(db, orderPayment.getCreditCardId());
            context.getRequest().setAttribute("creditCard", (Object)creditCard);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "OrdersProducts", "OrdersProducts Details");
        return "ModifyOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "orders-view")) {
            return "PermissionError";
        }
        int paymentId = Integer.parseInt(context.getRequest().getParameter("paymentId"));
        Object orderProduct = null;
        Object paymentStatusList = null;
        OrderPayment orderPayment = null;
        Object order = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            orderPayment = new OrderPayment();
            orderPayment.setBuildOrderPaymentStatusList(true);
            orderPayment.queryRecord(db, paymentId);
            context.getRequest().setAttribute("orderPayment", (Object)orderPayment);
            Calendar now = Calendar.getInstance();
            Timestamp rightNow = new Timestamp(now.getTimeInMillis());
            StatusBean statusBean = (StatusBean)((Object)context.getFormBean());
            if (statusBean.getStatusId() != -1 && statusBean.getStatusId() != 0) {
                orderPayment.setStatusId(statusBean.getStatusId());
            }
            if (statusBean.getAuthorizationRefNumber() != null) {
                orderPayment.setAuthorizationRefNumber(statusBean.getAuthorizationRefNumber());
            }
            if (statusBean.getAuthorizationCode() != null) {
                orderPayment.setAuthorizationCode(statusBean.getAuthorizationCode());
            }
            if (statusBean.getAuthorizationDate() != null) {
                orderPayment.setAuthorizationDate(statusBean.getAuthorizationDate());
            }
            orderPayment.setEnteredBy(this.getUserId(context));
            orderPayment.setModifiedBy(this.getUserId(context));
            orderPayment.update(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "OrdersProducts", "OrdersProducts Details");
        return "SaveOK";
    }
}

