/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.orders.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.orders.base.OrderAddress;
import org.aspcfs.modules.orders.base.OrderAddressList;
import org.aspcfs.modules.orders.base.OrderPaymentList;
import org.aspcfs.modules.orders.base.OrderProduct;
import org.aspcfs.modules.orders.base.OrderProductList;
import org.aspcfs.modules.quotes.base.Quote;
import org.aspcfs.modules.quotes.base.QuoteProduct;
import org.aspcfs.utils.DatabaseUtils;

public class Order
extends GenericBean {
    private int id = -1;
    private int parentId = -1;
    private int orgId = -1;
    private int quoteId = -1;
    private int salesId = -1;
    private int orderedBy = -1;
    private int billingContactId = -1;
    private int sourceId = -1;
    private double grandTotal = 0.0;
    private Timestamp submitted = null;
    private int statusId = -1;
    private Timestamp statusDate = null;
    private Timestamp contractDate = null;
    private Timestamp expirationDate = null;
    private Timestamp approxShipDate = null;
    private Timestamp approxDeliveryDate = null;
    private int orderTermsId = -1;
    private int orderTypeId = -1;
    private String description = null;
    private String notes = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private String name = null;
    private String nameLast = null;
    private String nameFirst = null;
    private String nameMiddle = null;
    private boolean buildProducts = false;
    private OrderProductList productList = new OrderProductList();
    private boolean buildAddressList = false;
    private OrderAddressList addressList = new OrderAddressList();

    public void setSubmitted(Timestamp tmp) {
        this.submitted = tmp;
    }

    public void setSubmitted(String tmp) {
        this.submitted = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setAddressList(OrderAddressList tmp) {
        this.addressList = tmp;
    }

    public void setBuildAddressList(boolean tmp) {
        this.buildAddressList = tmp;
    }

    public void setBuildAddressList(String tmp) {
        this.buildAddressList = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildAddressList() {
        return this.buildAddressList;
    }

    public OrderAddressList getAddressList() {
        return this.addressList;
    }

    public Timestamp getSubmitted() {
        return this.submitted;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setBillingContactId(int tmp) {
        this.billingContactId = tmp;
    }

    public void setBillingContactId(String tmp) {
        this.billingContactId = Integer.parseInt(tmp);
    }

    public void setSourceId(int tmp) {
        this.sourceId = tmp;
    }

    public void setSourceId(String tmp) {
        this.sourceId = Integer.parseInt(tmp);
    }

    public void setQuoteId(int tmp) {
        this.quoteId = tmp;
    }

    public void setQuoteId(String tmp) {
        this.quoteId = Integer.parseInt(tmp);
    }

    public void setGrandTotal(double tmp) {
        this.grandTotal = tmp;
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setStatusDate(Timestamp tmp) {
        this.statusDate = tmp;
    }

    public void setOrderTermsId(int tmp) {
        this.orderTermsId = tmp;
    }

    public void setOrderTermsId(String tmp) {
        this.orderTermsId = Integer.parseInt(tmp);
    }

    public void setOrderTypeId(int tmp) {
        this.orderTypeId = tmp;
    }

    public void setOrderTypeId(String tmp) {
        this.orderTypeId = Integer.parseInt(tmp);
    }

    public void setExpirationDate(Timestamp tmp) {
        this.expirationDate = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setNotes(String tmp) {
        this.notes = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setNameLast(String tmp) {
        this.nameLast = tmp;
    }

    public void setNameFirst(String tmp) {
        this.nameFirst = tmp;
    }

    public void setNameMiddle(String tmp) {
        this.nameMiddle = tmp;
    }

    public void setBuildProducts(boolean tmp) {
        this.buildProducts = tmp;
    }

    public void setProductList(OrderProductList tmp) {
        this.productList = tmp;
    }

    public void setSalesId(int tmp) {
        this.salesId = tmp;
    }

    public void setSalesId(String tmp) {
        this.salesId = Integer.parseInt(tmp);
    }

    public void setOrderedBy(int tmp) {
        this.orderedBy = tmp;
    }

    public void setOrderedBy(String tmp) {
        this.orderedBy = Integer.parseInt(tmp);
    }

    public void setContractDate(Timestamp tmp) {
        this.contractDate = tmp;
    }

    public void setContractDate(String tmp) {
        this.contractDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setRequestItems(HttpServletRequest request) {
        this.addressList = new OrderAddressList(request);
    }

    public Timestamp getContractDate() {
        return this.contractDate;
    }

    public int getSalesId() {
        return this.salesId;
    }

    public int getOrderedBy() {
        return this.orderedBy;
    }

    public int getId() {
        return this.id;
    }

    public int getParentId() {
        return this.parentId;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getBillingContactId() {
        return this.billingContactId;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public int getQuoteId() {
        return this.quoteId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public Timestamp getStatusDate() {
        return this.statusDate;
    }

    public int getOrderTermsId() {
        return this.orderTermsId;
    }

    public int getOrderTypeId() {
        return this.orderTypeId;
    }

    public Timestamp getExpirationDate() {
        return this.expirationDate;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNotes() {
        return this.notes;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public double getGrandTotal() {
        return this.grandTotal;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLast() {
        return this.nameLast;
    }

    public String getNameFirst() {
        return this.nameFirst;
    }

    public String getNameMiddle() {
        return this.nameMiddle;
    }

    public boolean getBuildProducts() {
        return this.buildProducts;
    }

    public OrderProductList getProductList() {
        return this.productList;
    }

    public Order() {
    }

    public Order(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public Order(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Order Number");
        }
        PreparedStatement pst = db.prepareStatement(" SELECT oe.*, \t\t\t\t org.name, ct_billing.namelast, ct_billing.namefirst, ct_billing.namemiddle  FROM order_entry oe  LEFT JOIN organization org ON (oe.org_id = org.org_id)  LEFT JOIN lookup_order_status los ON ( oe.status_id = los.code )  LEFT JOIN contact ct_billing ON (oe.billing_contact_id = ct_billing.contact_id)  WHERE oe.order_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Order Entry not found");
        }
        if (this.buildProducts) {
            this.buildProducts(db);
        }
        if (this.buildAddressList) {
            this.buildAddressList(db);
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("order_id"));
        this.parentId = DatabaseUtils.getInt(rs, "parent_id");
        this.orgId = rs.getInt("org_id");
        this.quoteId = DatabaseUtils.getInt(rs, "quote_id");
        this.salesId = DatabaseUtils.getInt(rs, "sales_id");
        this.orderedBy = DatabaseUtils.getInt(rs, "orderedby");
        this.billingContactId = DatabaseUtils.getInt(rs, "billing_contact_id");
        this.sourceId = DatabaseUtils.getInt(rs, "source_id");
        this.grandTotal = DatabaseUtils.getDouble(rs, "grand_total");
        this.statusId = DatabaseUtils.getInt(rs, "status_id");
        this.statusDate = rs.getTimestamp("status_date");
        this.contractDate = rs.getTimestamp("contract_date");
        this.expirationDate = rs.getTimestamp("expiration_date");
        this.orderTermsId = DatabaseUtils.getInt(rs, "order_terms_id");
        this.orderTypeId = DatabaseUtils.getInt(rs, "order_type_id");
        this.description = rs.getString("description");
        this.notes = rs.getString("notes");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.approxDeliveryDate = rs.getTimestamp("approx_delivery_date");
        this.approxShipDate = rs.getTimestamp("approx_ship_date");
        this.name = rs.getString("name");
        this.nameFirst = rs.getString("namefirst");
        this.nameMiddle = rs.getString("namemiddle");
        this.nameLast = rs.getString("namelast");
        this.submitted = rs.getTimestamp("submitted");
    }

    public void buildProducts(Connection db) throws SQLException {
        this.productList.setOrderId(this.getId());
        this.productList.setBuildResources(true);
        this.productList.buildList(db);
        this.determineTotal();
    }

    public void buildAddressList(Connection db) throws SQLException {
        this.addressList.setOrderId(this.getId());
        this.addressList.buildList(db);
    }

    public OrderAddress getAddress(String thisType) {
        return (OrderAddress)this.addressList.getAddress(thisType);
    }

    public void determineTotal() {
        this.grandTotal = 0.0;
        for (OrderProduct thisProduct : this.productList) {
            this.grandTotal += thisProduct.getTotalPrice();
        }
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "order_entry_order_id_seq");
        sql.append("INSERT INTO order_entry(parent_id, org_id, quote_id, sales_id, orderedby, billing_contact_id, source_id, grand_total, status_id, status_date, contract_date, expiration_date, order_terms_id, order_type_id, description, notes, ");
        if (this.id > -1) {
            sql.append("order_id, ");
        }
        if (this.approxDeliveryDate != null) {
            sql.append("approx_delivery_date, ");
        }
        if (this.approxShipDate != null) {
            sql.append("approx_ship_date, ");
        }
        if (this.entered != null) {
            sql.append("entered, ");
        }
        sql.append("enteredby, ");
        if (this.modified != null) {
            sql.append("modified, ");
        }
        sql.append("modifiedby, submitted ) ");
        sql.append("VALUES( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
        if (this.id > -1) {
            sql.append("?,");
        }
        if (this.entered != null) {
            sql.append("?, ");
        }
        sql.append("?, ");
        if (this.modified != null) {
            sql.append("?, ");
        }
        sql.append("? , ? )");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getParentId());
        pst.setInt(++i, this.getOrgId());
        DatabaseUtils.setInt(pst, ++i, this.getQuoteId());
        DatabaseUtils.setInt(pst, ++i, this.getSalesId());
        DatabaseUtils.setInt(pst, ++i, this.getOrderedBy());
        DatabaseUtils.setInt(pst, ++i, this.getBillingContactId());
        DatabaseUtils.setInt(pst, ++i, this.getSourceId());
        DatabaseUtils.setDouble(pst, ++i, this.getGrandTotal());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        DatabaseUtils.setTimestamp(pst, ++i, this.getStatusDate());
        DatabaseUtils.setTimestamp(pst, ++i, this.getContractDate());
        DatabaseUtils.setTimestamp(pst, ++i, this.getExpirationDate());
        DatabaseUtils.setInt(pst, ++i, this.getOrderTermsId());
        DatabaseUtils.setInt(pst, ++i, this.getOrderTypeId());
        pst.setString(++i, this.getDescription());
        pst.setString(++i, this.getNotes());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.approxDeliveryDate != null) {
            pst.setTimestamp(++i, this.getApproxDeliveryDate());
        }
        if (this.approxShipDate != null) {
            pst.setTimestamp(++i, this.getApproxShipDate());
        }
        if (this.entered != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        pst.setInt(++i, this.getEnteredBy());
        if (this.modified != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setInt(++i, this.getModifiedBy());
        pst.setTimestamp(++i, this.getSubmitted());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "order_entry_order_id_seq", this.id);
        for (OrderAddress thisAddress : this.getAddressList()) {
            thisAddress.process(db, this.getId(), this.getEnteredBy(), this.getModifiedBy());
        }
        result = true;
        return result;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Order ID not specified");
        }
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.getAddressList().delete(db);
            this.addressList = null;
            OrderPaymentList paymentList = new OrderPaymentList();
            paymentList.setOrderId(this.getId());
            paymentList.buildList(db);
            paymentList.delete(db);
            paymentList = null;
            this.buildProducts(db);
            this.productList.delete(db);
            this.productList = null;
            PreparedStatement pst = null;
            pst = db.prepareStatement("DELETE FROM payment_creditcard WHERE order_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM payment_eft WHERE order_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM order_address WHERE order_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM order_entry WHERE order_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE order_entry  SET sales_id = ?,      orderedby = ?,      billing_contact_id = ?,      source_id = ?,      grand_total = ?,      status_id = ?,      status_date = ?,      contract_date = ?,      expiration_date = ?,      order_terms_id = ?,      order_type_id = ?,      description = ?,      notes = ?,      modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + "     modifiedby = ? ");
        sql.append(" WHERE order_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getSalesId());
        DatabaseUtils.setInt(pst, ++i, this.getOrderedBy());
        DatabaseUtils.setInt(pst, ++i, this.getBillingContactId());
        DatabaseUtils.setInt(pst, ++i, this.getSourceId());
        DatabaseUtils.setDouble(pst, ++i, this.getGrandTotal());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        DatabaseUtils.setTimestamp(pst, ++i, this.getStatusDate());
        DatabaseUtils.setTimestamp(pst, ++i, this.getContractDate());
        DatabaseUtils.setTimestamp(pst, ++i, this.getExpirationDate());
        DatabaseUtils.setInt(pst, ++i, this.getOrderTermsId());
        DatabaseUtils.setInt(pst, ++i, this.getOrderTypeId());
        pst.setString(++i, this.getDescription());
        pst.setString(++i, this.getNotes());
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        Dependency thisDependency;
        if (this.getId() == -1) {
            throw new SQLException("Order ID not specified");
        }
        Object sql = null;
        DependencyList dependencyList = new DependencyList();
        PreparedStatement pst = null;
        ResultSet rs = null;
        int i = 0;
        try {
            int parentCount;
            i = 0;
            pst = db.prepareStatement(" SELECT count(*) as parentcount  FROM order_entry  WHERE parent_id = ?");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (parentCount = rs.getInt("parentcount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("numberOfChildrenOfThisOrder");
                thisDependency.setCount(parentCount);
                thisDependency.setCanDelete(false);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        try {
            int productCount;
            i = 0;
            pst = db.prepareStatement(" SELECT count(*) AS productcount  FROM order_product op  WHERE op.order_id = ? ");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (productCount = rs.getInt("productcount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("numberOfProductsAssociatedWithThisOrder");
                thisDependency.setCount(productCount);
                thisDependency.setCanDelete(false);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    public boolean createOrderFromQuote(Connection db, int quoteId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        boolean result = true;
        Quote quote = new Quote(db, quoteId);
        quote.buildProducts(db);
        quote.retrieveTicket(db);
        pst = db.prepareStatement(" SELECT code from lookup_order_status  WHERE description = ? ");
        pst.setString(1, "Pending");
        rs = pst.executeQuery();
        if (rs.next()) {
            this.setStatusId(rs.getInt("code"));
        }
        rs.close();
        pst.close();
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.setQuoteId(quoteId);
            this.setOrgId(quote.getOrgId());
            this.setBillingContactId(quote.getContactId());
            this.setDescription(quote.getShortDescription());
            this.setNotes(quote.getNotes());
            this.setGrandTotal(quote.getGrandTotal());
            this.setEnteredBy(quote.getModifiedBy());
            this.setModifiedBy(quote.getModifiedBy());
            this.insert(db);
            if (quote.getProductList().size() > 0) {
                for (QuoteProduct quoteProduct : quote.getProductList()) {
                    OrderProduct product = new OrderProduct();
                    product.setEnteredBy(quote.getModifiedBy());
                    product.setModifiedBy(quote.getModifiedBy());
                    product.setOrderId(this.getId());
                    product.setStatusId(this.getStatusId());
                    product.setStatusDate(this.getEntered());
                    if (product.createProductFromQuoteProduct(db, quoteProduct.getId())) continue;
                    result = false;
                    break;
                }
            }
            if (commit) {
                db.commit();
            }
        }
        catch (Exception e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public Timestamp getApproxDeliveryDate() {
        return this.approxDeliveryDate;
    }

    public void setApproxDeliveryDate(Timestamp approxDeliveryDate) {
        this.approxDeliveryDate = approxDeliveryDate;
    }

    public void setApproxDeliveryDate(String approxDeliveryDate) {
        this.approxDeliveryDate = DatabaseUtils.parseTimestamp(approxDeliveryDate);
    }

    public Timestamp getApproxShipDate() {
        return this.approxShipDate;
    }

    public void setApproxShipDate(Timestamp approxShipDate) {
        this.approxShipDate = approxShipDate;
    }

    public void setApproxShipDate(String approxShipDate) {
        this.approxShipDate = DatabaseUtils.parseTimestamp(approxShipDate);
    }
}

