/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.orders.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.base.AddressList;
import org.aspcfs.modules.orders.base.OrderAddress;

public class OrderAddressList
extends AddressList {
    public static final String tableName = "order_address";
    public static final String uniqueField = "address_id";

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public OrderAddressList() {
    }

    public OrderAddressList(HttpServletRequest request) {
        int i = 0;
        while (request.getParameter("address" + ++i + "type") != null) {
            OrderAddress thisAddress = new OrderAddress();
            thisAddress.buildRecord(request, i);
            if (!thisAddress.isValid()) continue;
            this.addElement(thisAddress);
        }
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlSelect.append("SELECT * FROM order_address a left join lookup_orderaddress_types l on (a.address_type = l.code) WHERE 1=1 ");
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM order_address a, lookup_orderaddress_types l WHERE a.address_type = l.code ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND city < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            if (this.pagedListInfo.getColumnToSortBy() != null && !this.pagedListInfo.getColumnToSortBy().equals("")) {
                sqlOrder.append("ORDER BY " + this.pagedListInfo.getColumnToSortBy() + ", city ");
                if (this.pagedListInfo.getSortOrder() != null && !this.pagedListInfo.getSortOrder().equals("")) {
                    sqlOrder.append(this.pagedListInfo.getSortOrder() + " ");
                }
            } else {
                sqlOrder.append("ORDER BY city ");
            }
            if (this.pagedListInfo.getItemsPerPage() > 0) {
                sqlOrder.append("LIMIT " + this.pagedListInfo.getItemsPerPage() + " ");
            }
            sqlOrder.append("OFFSET " + this.pagedListInfo.getCurrentOffset() + " ");
        }
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            OrderAddress thisAddress = new OrderAddress(rs);
            this.addElement(thisAddress);
        }
        rs.close();
        pst.close();
    }

    public void delete(Connection db) throws SQLException {
        for (OrderAddress thisAddress : this) {
            thisAddress.delete(db);
        }
    }
}

