/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.orders.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.orders.base.Order;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class OrderList
extends ArrayList {
    public static final String tableName = "order_entry";
    public static final String uniqueField = "order_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int orgId = -1;
    private int sourceId = -1;
    private int statusId = -1;
    private int typeId = -1;
    private int categoryId = -1;
    private boolean buildResources = false;
    private int closedOnly = -1;
    private boolean typeExists = false;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setTypeExists(boolean tmp) {
        this.typeExists = tmp;
    }

    public void setTypeExists(String tmp) {
        this.typeExists = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getTypeExists() {
        return this.typeExists;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public void setClosedOnly(int tmp) {
        this.closedOnly = tmp;
    }

    public void setClosedOnly(String tmp) {
        this.closedOnly = Integer.parseInt(tmp);
    }

    public int getClosedOnly() {
        return this.closedOnly;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setTypeId(int tmp) {
        this.typeId = tmp;
    }

    public void setTypeId(String tmp) {
        this.typeId = Integer.parseInt(tmp);
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setSourceId(int tmp) {
        this.sourceId = tmp;
    }

    public void setSourceId(String tmp) {
        this.sourceId = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setBuildResources(boolean tmp) {
        this.buildResources = tmp;
    }

    public void setBuildResources(String tmp) {
        this.buildResources = DatabaseUtils.parseBoolean(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public boolean getBuildResources() {
        return this.buildResources;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM order_entry oe  LEFT JOIN organization org ON (oe.org_id = org.org_id)  LEFT JOIN lookup_order_status loes ON ( oe.status_id = loes.code )  LEFT JOIN contact ct_billing ON (oe.billing_contact_id = ct_billing.contact_id)  WHERE oe.order_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
                items = this.prepareFilter(pst);
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("oe.entered", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY oe.order_id");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("   oe.order_id, oe.parent_id, oe.org_id, oe.quote_id, oe.sales_id, oe.orderedby, oe.billing_contact_id, oe.source_id,    oe.grand_total, oe.status_id, oe.contract_date, oe.status_date, oe.expiration_date, oe.order_terms_id, oe.order_type_id,    oe.description, oe.notes, oe.entered, oe.enteredby, oe.modified, oe.modifiedby, oe.submitted,    org.name, ct_billing.namelast, ct_billing.namefirst, ct_billing.namemiddle  FROM order_entry oe  LEFT JOIN organization org ON (oe.org_id = org.org_id)  LEFT JOIN lookup_order_status loes ON ( oe.status_id = loes.code )  LEFT JOIN contact ct_billing ON (oe.billing_contact_id = ct_billing.contact_id)  WHERE oe.order_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Order thisOrder = new Order(rs);
            this.add(thisOrder);
        }
        rs.close();
        pst.close();
        if (this.buildResources) {
            for (Order thisOrder : this) {
                thisOrder.buildProducts(db);
            }
        }
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.orgId > -1) {
            sqlFilter.append("AND oe.org_id = ? ");
        }
        if (this.sourceId > -1) {
            sqlFilter.append("AND oe.source_id = ? ");
        }
        if (this.statusId > -1) {
            sqlFilter.append("AND oe.status_id = ? ");
        }
        if (this.typeId > -1) {
            sqlFilter.append("AND oe.order_type_id = ? ");
        }
        if (this.closedOnly == 1) {
            sqlFilter.append(" AND loes.description IN ( 'Closed' , 'Complete', 'Cancelled', 'Rejected' ) ");
        } else if (this.closedOnly == 0) {
            sqlFilter.append(" AND loes.description NOT IN ( 'Closed' , 'Complete', 'Cancelled', 'Rejected' ) ");
        }
        if (this.categoryId > -1) {
            sqlFilter.append(" AND oe.order_id IN (SELECT order_id  FROM order_product  WHERE product_id IN (SELECT product_id  FROM product_catalog_category_map pccm  WHERE pccm.category_id = ? )) ");
        }
        if (this.typeExists) {
            sqlFilter.append("AND oe.order_type_id IS NOT NULL ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.orgId > -1) {
            pst.setInt(++i, this.orgId);
        }
        if (this.sourceId > -1) {
            pst.setInt(++i, this.sourceId);
        }
        if (this.statusId > -1) {
            pst.setInt(++i, this.statusId);
        }
        if (this.typeId > -1) {
            pst.setInt(++i, this.typeId);
        }
        if (this.categoryId > -1) {
            pst.setInt(++i, this.categoryId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }
}

