/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.orders.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.orders.base.OrderPaymentStatus;
import org.aspcfs.modules.orders.base.OrderPaymentStatusList;
import org.aspcfs.utils.DatabaseUtils;

public class OrderPayment
extends GenericBean {
    private int id = -1;
    private int orderId = -1;
    private int orderItemId = -1;
    private int historyId = -1;
    private int gatewayId = -1;
    private int paymentMethodId = -1;
    private double amount = 0.0;
    private String authorizationRefNumber = null;
    private String authorizationCode = null;
    private Timestamp authorizationDate = null;
    private Timestamp dateToProcess = null;
    private int creditCardId = -1;
    private int bankId = -1;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private int statusId = -1;
    private String status = null;
    private boolean buildOrderPaymentStatusList = false;
    private OrderPaymentStatusList orderPaymentStatusList = null;

    public int getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(int gatewayId) {
        this.gatewayId = gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = Integer.parseInt(gatewayId);
    }

    public void setDateToProcess(Timestamp tmp) {
        this.dateToProcess = tmp;
    }

    public void setDateToProcess(String tmp) {
        this.dateToProcess = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setCreditCardId(int tmp) {
        this.creditCardId = tmp;
    }

    public void setCreditCardId(String tmp) {
        this.creditCardId = Integer.parseInt(tmp);
    }

    public void setBankId(int tmp) {
        this.bankId = tmp;
    }

    public void setBankId(String tmp) {
        this.bankId = Integer.parseInt(tmp);
    }

    public void setOrderItemId(int tmp) {
        this.orderItemId = tmp;
    }

    public void setOrderItemId(String tmp) {
        this.orderItemId = Integer.parseInt(tmp);
    }

    public void setHistoryId(int tmp) {
        this.historyId = tmp;
    }

    public void setHistoryId(String tmp) {
        this.historyId = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setStatus(String tmp) {
        this.status = tmp;
    }

    public void setBuildOrderPaymentStatusList(boolean tmp) {
        this.buildOrderPaymentStatusList = tmp;
    }

    public void setBuildOrderPaymentStatusList(String tmp) {
        this.buildOrderPaymentStatusList = DatabaseUtils.parseBoolean(tmp);
    }

    public void setOrderPaymentStatusList(OrderPaymentStatusList tmp) {
        this.orderPaymentStatusList = tmp;
    }

    public boolean getBuildOrderPaymentStatusList() {
        return this.buildOrderPaymentStatusList;
    }

    public OrderPaymentStatusList getOrderPaymentStatusList() {
        return this.orderPaymentStatusList;
    }

    public String getStatus() {
        return this.status;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public int getOrderItemId() {
        return this.orderItemId;
    }

    public int getHistoryId() {
        return this.historyId;
    }

    public Timestamp getDateToProcess() {
        return this.dateToProcess;
    }

    public int getCreditCardId() {
        return this.creditCardId;
    }

    public int getBankId() {
        return this.bankId;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setOrderId(int tmp) {
        this.orderId = tmp;
    }

    public void setOrderId(String tmp) {
        this.orderId = Integer.parseInt(tmp);
    }

    public void setPaymentMethodId(int tmp) {
        this.paymentMethodId = tmp;
    }

    public void setPaymentMethodId(String tmp) {
        this.paymentMethodId = Integer.parseInt(tmp);
    }

    public void setAmount(double tmp) {
        this.amount = tmp;
    }

    public void setAuthorizationRefNumber(String tmp) {
        this.authorizationRefNumber = tmp;
    }

    public void setAuthorizationCode(String tmp) {
        this.authorizationCode = tmp;
    }

    public void setAuthorizationDate(Timestamp tmp) {
        this.authorizationDate = tmp;
    }

    public void setAuthorizationDate(String tmp) {
        this.authorizationDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getOrderId() {
        return this.orderId;
    }

    public int getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public double getAmount() {
        return this.amount;
    }

    public String getAuthorizationRefNumber() {
        return this.authorizationRefNumber;
    }

    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public Timestamp getAuthorizationDate() {
        return this.authorizationDate;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public OrderPayment() {
    }

    public OrderPayment(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public OrderPayment(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Payment Number");
        }
        PreparedStatement pst = db.prepareStatement(" SELECT op.*, ps.description AS status_description  FROM order_payment op  LEFT JOIN lookup_payment_status ps  ON ( op.status_id = ps.code )  WHERE op.payment_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Payment Entry not found");
        }
        if (this.buildOrderPaymentStatusList) {
            this.buildStatusList(db);
        }
    }

    public void buildStatusList(Connection db) throws SQLException {
        this.orderPaymentStatusList = new OrderPaymentStatusList();
        this.orderPaymentStatusList.setPaymentId(this.getId());
        this.orderPaymentStatusList.buildList(db);
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("payment_id"));
        this.orderId = rs.getInt("order_id");
        this.paymentMethodId = DatabaseUtils.getInt(rs, "payment_method_id");
        this.amount = DatabaseUtils.getDouble(rs, "payment_amount");
        this.authorizationRefNumber = rs.getString("authorization_ref_number");
        this.authorizationCode = rs.getString("authorization_code");
        this.authorizationDate = rs.getTimestamp("authorization_date");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = DatabaseUtils.getInt(rs, "modifiedby");
        this.orderItemId = DatabaseUtils.getInt(rs, "order_item_id");
        this.historyId = DatabaseUtils.getInt(rs, "history_id");
        this.dateToProcess = rs.getTimestamp("date_to_process");
        this.creditCardId = DatabaseUtils.getInt(rs, "creditcard_id");
        this.bankId = DatabaseUtils.getInt(rs, "bank_id");
        this.statusId = DatabaseUtils.getInt(rs, "status_id");
        this.gatewayId = DatabaseUtils.getInt(rs, "gateway_id");
        this.status = rs.getString("status_description");
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        this.id = DatabaseUtils.getNextSeq(db, "order_payment_payment_id_seq");
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO order_payment(order_id, order_item_id, history_id, payment_method_id, payment_amount,  \tauthorization_ref_number, authorization_code, authorization_date, status_id, gateway_id, ");
        if (this.id > -1) {
            sql.append("payment_id, ");
        }
        if (this.entered != null) {
            sql.append(" entered, ");
        }
        sql.append(" enteredby, ");
        if (this.modified != null) {
            sql.append(" modified, ");
        }
        sql.append(" modifiedby, date_to_process, creditcard_id, bank_id )");
        sql.append("VALUES( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,  ");
        if (this.id > -1) {
            sql.append("?,");
        }
        if (this.entered != null) {
            sql.append("?, ");
        }
        sql.append("?, ");
        if (this.modified != null) {
            sql.append("?, ");
        }
        sql.append("?, ?, ?, ? )");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.getOrderId());
        DatabaseUtils.setInt(pst, ++i, this.getOrderItemId());
        DatabaseUtils.setInt(pst, ++i, this.getHistoryId());
        pst.setInt(++i, this.getPaymentMethodId());
        DatabaseUtils.setDouble(pst, ++i, this.getAmount());
        pst.setString(++i, this.getAuthorizationRefNumber());
        pst.setString(++i, this.getAuthorizationCode());
        pst.setTimestamp(++i, this.getAuthorizationDate());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        DatabaseUtils.setInt(pst, ++i, this.getGatewayId());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.entered != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        pst.setInt(++i, this.getEnteredBy());
        if (this.modified != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setInt(++i, this.getModifiedBy());
        DatabaseUtils.setTimestamp(pst, ++i, this.getDateToProcess());
        DatabaseUtils.setInt(pst, ++i, this.getCreditCardId());
        DatabaseUtils.setInt(pst, ++i, this.getBankId());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "order_payment_payment_id_seq", this.id);
        this.insertPaymentStatus(db);
        result = true;
        return result;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Order ID not specified");
        }
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            OrderPaymentStatusList statusList = new OrderPaymentStatusList();
            statusList.setPaymentId(this.getId());
            statusList.buildList(db);
            statusList.delete(db);
            statusList = null;
            PreparedStatement pst = db.prepareStatement("DELETE FROM order_payment WHERE payment_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE order_payment  SET payment_method_id = ?,      order_item_id = ?,      history_id = ?,      payment_amount = ?,      authorization_ref_number = ?,      authorization_code = ?,      authorization_date = ?,      status_id = ?,      gateway_id = ?,      modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + "     modifiedby = ? " + " WHERE payment_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getPaymentMethodId());
        DatabaseUtils.setInt(pst, ++i, this.getOrderItemId());
        DatabaseUtils.setInt(pst, ++i, this.getHistoryId());
        DatabaseUtils.setDouble(pst, ++i, this.getAmount());
        pst.setString(++i, this.getAuthorizationRefNumber());
        pst.setString(++i, this.getAuthorizationCode());
        DatabaseUtils.setTimestamp(pst, ++i, this.getAuthorizationDate());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        DatabaseUtils.setInt(pst, ++i, this.getGatewayId());
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        this.insertPaymentStatus(db);
        return resultCount;
    }

    public void insertPaymentStatus(Connection db) throws SQLException {
        OrderPaymentStatus thisStatus = new OrderPaymentStatus();
        thisStatus.setPaymentId(this.getId());
        thisStatus.setStatusId(this.getStatusId());
        thisStatus.setEnteredBy(this.getModifiedBy());
        thisStatus.setModifiedBy(this.getModifiedBy());
        thisStatus.insert(db);
    }
}

