/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.orders.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.orders.base.OrderPayment;
import org.aspcfs.utils.web.PagedListInfo;

public class OrderPaymentList
extends ArrayList {
    public static final String tableName = "order_payment";
    public static final String uniqueField = "payment_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int orderId = -1;
    private int orderItemId = -1;
    private int statusId = -1;
    private int historyId = -1;
    private int paymentMethodId = -1;
    private String status = null;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setOrderId(int tmp) {
        this.orderId = tmp;
    }

    public void setOrderId(String tmp) {
        this.orderId = Integer.parseInt(tmp);
    }

    public void setPaymentMethodId(int tmp) {
        this.paymentMethodId = tmp;
    }

    public void setPaymentMethodId(String tmp) {
        this.paymentMethodId = Integer.parseInt(tmp);
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setOrderItemId(int tmp) {
        this.orderItemId = tmp;
    }

    public void setOrderItemId(String tmp) {
        this.orderItemId = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setHistoryId(int tmp) {
        this.historyId = tmp;
    }

    public void setHistoryId(String tmp) {
        this.historyId = Integer.parseInt(tmp);
    }

    public void setStatus(String tmp) {
        this.status = tmp;
    }

    public String getStatus() {
        return this.status;
    }

    public int getOrderItemId() {
        return this.orderItemId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public int getHistoryId() {
        return this.historyId;
    }

    public int getOrderId() {
        return this.orderId;
    }

    public int getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM order_payment op  LEFT JOIN lookup_payment_status ps  ON ( op.status_id = ps.code )  WHERE op.payment_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
                items = this.prepareFilter(pst);
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("op.entered", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY op.entered");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT");
        }
        sqlSelect.append(" op.*, ps.description AS status_description  FROM order_payment op  LEFT JOIN lookup_payment_status ps  ON ( op.status_id = ps.code )  WHERE op.payment_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            OrderPayment thisPayment = new OrderPayment(rs);
            this.add(thisPayment);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.orderId > -1) {
            sqlFilter.append("AND op.order_id = ? ");
        }
        if (this.orderItemId > -1) {
            sqlFilter.append(" AND op.order_item_id = ? ");
        }
        if (this.historyId > -1) {
            sqlFilter.append(" AND op.history_id = ? ");
        }
        if (this.statusId > -1) {
            sqlFilter.append(" AND op.status_id = ? ");
        }
        if (this.status != null) {
            sqlFilter.append(" AND ps.description = ? ");
        }
        if (this.paymentMethodId > -1) {
            sqlFilter.append("AND op.payment_method_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.orderId > -1) {
            pst.setInt(++i, this.orderId);
        }
        if (this.orderItemId > -1) {
            pst.setInt(++i, this.getOrderItemId());
        }
        if (this.historyId > -1) {
            pst.setInt(++i, this.getHistoryId());
        }
        if (this.statusId > -1) {
            pst.setInt(++i, this.getStatusId());
        }
        if (this.status != null) {
            pst.setString(++i, this.getStatus());
        }
        if (this.paymentMethodId > -1) {
            pst.setInt(++i, this.paymentMethodId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public void delete(Connection db) throws SQLException {
        for (OrderPayment orderPayment : this) {
            orderPayment.delete(db);
        }
    }
}

