/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.orders.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class OrderPaymentStatus
extends GenericBean {
    private int id = -1;
    private int paymentId = -1;
    private int statusId = -1;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private String status = null;

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setPaymentId(int tmp) {
        this.paymentId = tmp;
    }

    public void setPaymentId(String tmp) {
        this.paymentId = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setStatus(String tmp) {
        this.status = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getPaymentId() {
        return this.paymentId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public String getStatus() {
        return this.status;
    }

    public OrderPaymentStatus() throws SQLException {
    }

    public OrderPaymentStatus(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public OrderPaymentStatus(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id < 0) {
            throw new SQLException("Incorrect Payment Status Number ");
        }
        PreparedStatement pst = db.prepareStatement(" SELECT ops.*, ps.description AS status_description  FROM order_payment_status ops  LEFT JOIN lookup_payment_status ps  ON ( ops.status_id = ps.code )  WHERE ops.payment_status_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("Payment Status Entry Not Found");
        }
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("payment_status_id"));
        this.setPaymentId(rs.getInt("payment_id"));
        this.setStatusId(DatabaseUtils.getInt(rs, "status_id"));
        this.setEntered(rs.getTimestamp("entered"));
        this.setEnteredBy(DatabaseUtils.getInt(rs, "enteredby"));
        this.setModified(rs.getTimestamp("modified"));
        this.setModifiedBy(DatabaseUtils.getInt(rs, "modifiedby"));
        this.setStatus(rs.getString("status_description"));
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        if (!this.isValid(db)) {
            return result;
        }
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "order_payment_status_payment_status_id_seq");
        sql.append("INSERT INTO order_payment_status (payment_id, status_id, ");
        if (this.id > -1) {
            sql.append("payment_status_id, ");
        }
        if (this.entered != null) {
            sql.append("entered, ");
        }
        sql.append("enteredby, ");
        if (this.modified != null) {
            sql.append("modified, ");
        }
        sql.append("modifiedby) ");
        sql.append("VALUES( ?, ?, ");
        if (this.id > -1) {
            sql.append("?, ");
        }
        if (this.entered != null) {
            sql.append("?, ");
        }
        sql.append("?, ");
        if (this.modified != null) {
            sql.append("?, ");
        }
        sql.append("? ) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.getPaymentId());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.entered != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        pst.setInt(++i, this.getEnteredBy());
        if (this.modified != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setInt(++i, this.getModifiedBy());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "order_payment_status_payment_status_id_seq", this.id);
        result = true;
        return result;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Order Payment Status not specified ");
        }
        try {
            PreparedStatement pst = null;
            pst = db.prepareStatement(" DELETE FROM order_payment_status WHERE payment_status_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new SQLException(e.getMessage());
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (!this.isValid(db)) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE order_payment_status  SET payment_id = ?,  status_id = ?,  modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + " modifiedby = ? " + " WHERE payment_status_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getPaymentId());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean isValid(Connection db) throws SQLException {
        return true;
    }
}

