/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.orders.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.modules.orders.base.OrderPaymentStatus;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class OrderPaymentStatusList
extends ArrayList
implements SyncableList {
    public static final String tableName = "order_payment_status";
    public static final String uniqueField = "payment_status_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int enteredBy = -1;
    private int id = -1;
    private int statusId = -1;
    private int paymentId = -1;
    private String status = null;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setPaymentId(int tmp) {
        this.paymentId = tmp;
    }

    public void setPaymentId(String tmp) {
        this.paymentId = Integer.parseInt(tmp);
    }

    public void setStatus(String tmp) {
        this.status = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public String getStatus() {
        return this.status;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getId() {
        return this.id;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public int getPaymentId() {
        return this.paymentId;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM order_payment_status ops  LEFT JOIN lookup_payment_status ps  ON ( ops.status_id = ps.code )  WHERE ops.payment_status_id > 0 ");
        this.createFilter(sqlFilter, db);
        sqlOrder.append("ORDER BY ops.entered ");
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append(" SELECT ");
        }
        sqlSelect.append(" ops.*, ps.description AS status_description  FROM order_payment_status ops  LEFT JOIN lookup_payment_status ps  ON ( ops.status_id = ps.code )  WHERE ops.payment_status_id > 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            OrderPaymentStatus orderPaymentStatus = new OrderPaymentStatus(rs);
            this.add(orderPaymentStatus);
        }
        rs.close();
        pst.close();
    }

    public void delete(Connection db) throws SQLException {
        for (OrderPaymentStatus orderPaymentStatus : this) {
            orderPaymentStatus.delete(db);
        }
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) {
        if (this.enteredBy > -1) {
            sqlFilter.append(" AND ops.enteredby = ? ");
        }
        if (this.id > -1) {
            sqlFilter.append(" AND ops.payment_status_id = ? ");
        }
        if (this.paymentId > -1) {
            sqlFilter.append(" AND ops.payment_id = ? ");
        }
        if (this.statusId > -1) {
            sqlFilter.append(" AND ops.status_id = ? ");
        }
        if (this.status != null) {
            sqlFilter.append(" AND ps.description = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND pctlg.entered >= ? ");
            }
            sqlFilter.append(" AND pctlg.entered < ? ");
        } else if (this.syncType == 3) {
            sqlFilter.append(" AND pctlg.modified >= ? ");
            sqlFilter.append(" AND pctlg.entered < ? ");
            sqlFilter.append(" AND pctlg.modified < ? ");
        } else if (this.syncType == 5) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND pctlg.entered >= ? ");
            }
            if (this.nextAnchor != null) {
                sqlFilter.append("AND pctlg.entered < ? ");
            }
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enteredBy > -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.paymentId > -1) {
            pst.setInt(++i, this.getPaymentId());
        }
        if (this.statusId > -1) {
            pst.setInt(++i, this.getStatusId());
        }
        if (this.status != null) {
            pst.setString(++i, this.getStatus());
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        } else if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        } else if (this.syncType == 5) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            if (this.nextAnchor != null) {
                pst.setTimestamp(++i, this.nextAnchor);
            }
        }
        return i;
    }
}

