/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.orders.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.orders.base.OrderProductOption;
import org.aspcfs.modules.orders.base.OrderProductOptionList;
import org.aspcfs.modules.orders.base.OrderProductStatus;
import org.aspcfs.modules.orders.base.OrderProductStatusList;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.quotes.base.QuoteProduct;
import org.aspcfs.modules.quotes.base.QuoteProductOption;
import org.aspcfs.utils.DatabaseUtils;

public class OrderProduct
extends GenericBean {
    private int id = -1;
    private int orderId = -1;
    private int productId = -1;
    private int quantity = 0;
    private int msrpCurrency = -1;
    private double msrpAmount = 0.0;
    private int priceCurrency = -1;
    private double priceAmount = 0.0;
    private int recurringCurrency = -1;
    private double recurringAmount = 0.0;
    private int recurringType = -1;
    private double extendedPrice = 0.0;
    private double singleTotalPrice = 0.0;
    private double totalPrice = 0.0;
    private int statusId = -1;
    private Timestamp statusDate = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private boolean buildProduct = false;
    protected ProductCatalog product = null;
    private boolean buildProductOptions = false;
    private OrderProductOptionList productOptionList = new OrderProductOptionList();
    private boolean buildProductStatus = false;
    private OrderProductStatusList productStatusList = new OrderProductStatusList();

    public void setBuildProduct(boolean tmp) {
        this.buildProduct = tmp;
    }

    public void setBuildProduct(String tmp) {
        this.buildProduct = DatabaseUtils.parseBoolean(tmp);
    }

    public void setSingleTotalPrice(double tmp) {
        this.singleTotalPrice = tmp;
    }

    public double getSingleTotalPrice() {
        this.singleTotalPrice = 0.0;
        this.singleTotalPrice = this.getPriceAmount() - this.getExtendedPrice();
        for (OrderProductOption option : this.getProductOptionList()) {
            this.singleTotalPrice += option.getTotalPrice();
        }
        return this.singleTotalPrice;
    }

    public boolean getBuildProduct() {
        return this.buildProduct;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setProduct(ProductCatalog tmp) {
        this.product = tmp;
    }

    public ProductCatalog getProduct() {
        return this.product;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setOrderId(int tmp) {
        this.orderId = tmp;
    }

    public void setOrderId(String tmp) {
        this.orderId = Integer.parseInt(tmp);
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public void setQuantity(int tmp) {
        this.quantity = tmp;
    }

    public void setQuantity(String tmp) {
        this.quantity = Integer.parseInt(tmp);
    }

    public void setPriceCurrency(int tmp) {
        this.priceCurrency = tmp;
    }

    public void setPriceCurrency(String tmp) {
        this.priceCurrency = Integer.parseInt(tmp);
    }

    public void setMsrpAmount(double tmp) {
        this.msrpAmount = tmp;
    }

    public void setPriceAmount(double tmp) {
        this.priceAmount = tmp;
    }

    public void setRecurringAmount(double tmp) {
        this.recurringAmount = tmp;
    }

    public void setMsrpCurrency(int tmp) {
        this.msrpCurrency = tmp;
    }

    public void setMsrpCurrency(String tmp) {
        this.msrpCurrency = Integer.parseInt(tmp);
    }

    public void setRecurringCurrency(int tmp) {
        this.recurringCurrency = tmp;
    }

    public void setRecurringCurrency(String tmp) {
        this.recurringCurrency = Integer.parseInt(tmp);
    }

    public void setRecurringType(int tmp) {
        this.recurringType = tmp;
    }

    public void setRecurringType(String tmp) {
        this.recurringType = Integer.parseInt(tmp);
    }

    public void setExtendedPrice(double tmp) {
        this.extendedPrice = tmp;
    }

    public void setTotalPrice(double tmp) {
        this.totalPrice = tmp;
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setStatusDate(Timestamp tmp) {
        this.statusDate = tmp;
    }

    public void setStatusDate(String tmp) {
        this.statusDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setBuildProductOptions(boolean tmp) {
        this.buildProductOptions = tmp;
    }

    public void setBuildProductOptions(String tmp) {
        this.buildProductOptions = DatabaseUtils.parseBoolean(tmp);
    }

    public void setProductOptionList(OrderProductOptionList tmp) {
        this.productOptionList = tmp;
    }

    public void setBuildProductStatus(boolean tmp) {
        this.buildProductStatus = tmp;
    }

    public void setBuildProductStatus(String tmp) {
        this.buildProductStatus = DatabaseUtils.parseBoolean(tmp);
    }

    public void setProductStatusList(OrderProductStatusList tmp) {
        this.productStatusList = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getOrderId() {
        return this.orderId;
    }

    public int getProductId() {
        return this.productId;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public int getPriceCurrency() {
        return this.priceCurrency;
    }

    public double getMsrpAmount() {
        return this.msrpAmount;
    }

    public double getPriceAmount() {
        return this.priceAmount;
    }

    public double getRecurringAmount() {
        return this.recurringAmount;
    }

    public int getMsrpCurrency() {
        return this.msrpCurrency;
    }

    public int getRecurringCurrency() {
        return this.recurringCurrency;
    }

    public int getRecurringType() {
        return this.recurringType;
    }

    public double getExtendedPrice() {
        return this.extendedPrice;
    }

    public double getTotalPrice() {
        this.totalPrice = 0.0;
        this.totalPrice = (double)this.getQuantity() * (this.getPriceAmount() - this.getExtendedPrice());
        for (OrderProductOption option : this.getProductOptionList()) {
            this.totalPrice += (double)this.getQuantity() * option.getTotalPrice();
        }
        return this.totalPrice;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public Timestamp getStatusDate() {
        return this.statusDate;
    }

    public boolean getBuildProductOptions() {
        return this.buildProductOptions;
    }

    public OrderProductOptionList getProductOptionList() {
        return this.productOptionList;
    }

    public boolean getBuildProductStatus() {
        return this.buildProductStatus;
    }

    public OrderProductStatusList getProductStatusList() {
        return this.productStatusList;
    }

    public OrderProduct() {
    }

    public OrderProduct(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public OrderProduct(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Order Product Number");
        }
        PreparedStatement pst = db.prepareStatement(" SELECT op.item_id, op.order_id, op.product_id, op.quantity, op.msrp_currency, op.msrp_amount,    op.price_currency, op.price_amount, op.recurring_currency, op.recurring_amount, op.recurring_type,    op.extended_price, op.total_price, op.status_id, op.status_date  FROM order_product op  WHERE op.item_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Order Product not found");
        }
        if (this.buildProduct) {
            this.buildProduct(db);
        }
        if (this.buildProductOptions) {
            this.buildProductOptions(db);
        }
        if (this.buildProductStatus) {
            this.buildProductStatus(db);
        }
        this.determineTotal();
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("item_id"));
        this.orderId = rs.getInt("order_id");
        this.productId = rs.getInt("product_id");
        this.quantity = rs.getInt("quantity");
        this.msrpCurrency = DatabaseUtils.getInt(rs, "msrp_currency");
        this.msrpAmount = DatabaseUtils.getDouble(rs, "msrp_amount");
        this.priceCurrency = DatabaseUtils.getInt(rs, "price_currency");
        this.priceAmount = DatabaseUtils.getDouble(rs, "price_amount");
        this.recurringCurrency = DatabaseUtils.getInt(rs, "recurring_currency");
        this.recurringAmount = DatabaseUtils.getDouble(rs, "recurring_amount");
        this.recurringType = DatabaseUtils.getInt(rs, "recurring_type");
        this.extendedPrice = DatabaseUtils.getDouble(rs, "extended_price");
        this.totalPrice = DatabaseUtils.getDouble(rs, "total_price");
        this.statusId = DatabaseUtils.getInt(rs, "status_id");
        this.statusDate = rs.getTimestamp("status_date");
    }

    public void buildProductOptions(Connection db) throws SQLException {
        this.productOptionList = new OrderProductOptionList();
        this.productOptionList.setItemId(this.getId());
        this.productOptionList.buildList(db);
    }

    public void determineTotal() {
        this.totalPrice = 0.0;
        this.totalPrice = (double)this.getQuantity() * (this.getPriceAmount() - this.getExtendedPrice());
        for (OrderProductOption option : this.getProductOptionList()) {
            this.totalPrice += (double)this.getQuantity() * option.getTotalPrice();
        }
    }

    public void buildProductStatus(Connection db) throws SQLException {
        this.productStatusList.setItemId(this.getId());
        this.productStatusList.buildList(db);
    }

    public void buildProduct(Connection db) throws SQLException {
        this.product = new ProductCatalog(db, this.getProductId());
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        if (!this.isValid(db)) {
            return result;
        }
        if (this.quantity == 0) {
            this.quantity = 1;
        }
        this.determineTotal();
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            StringBuffer sql = new StringBuffer();
            this.id = DatabaseUtils.getNextSeq(db, "order_product_item_id_seq");
            sql.append(" INSERT INTO order_product(" + (this.id > -1 ? "item_id, " : "") + "order_id, product_id, " + "   quantity, msrp_currency, msrp_amount, price_currency, price_amount, recurring_currency, " + "   recurring_amount, recurring_type, extended_price, " + "   total_price, status_id, status_date)");
            sql.append(" VALUES(" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.getOrderId());
            pst.setInt(++i, this.getProductId());
            pst.setInt(++i, this.getQuantity());
            DatabaseUtils.setInt(pst, ++i, this.getMsrpCurrency());
            pst.setDouble(++i, this.getMsrpAmount());
            DatabaseUtils.setInt(pst, ++i, this.getPriceCurrency());
            pst.setDouble(++i, this.getPriceAmount());
            DatabaseUtils.setInt(pst, ++i, this.getRecurringCurrency());
            pst.setDouble(++i, this.getRecurringAmount());
            DatabaseUtils.setInt(pst, ++i, this.getRecurringType());
            pst.setDouble(++i, this.getExtendedPrice());
            pst.setDouble(++i, this.getTotalPrice());
            DatabaseUtils.setInt(pst, ++i, this.getStatusId());
            DatabaseUtils.setTimestamp(pst, ++i, this.getStatusDate());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "order_product_item_id_seq", this.id);
            this.insertProductStatus(db);
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public void insertProductStatus(Connection db) throws SQLException {
        OrderProductStatus orderProductStatus = new OrderProductStatus();
        orderProductStatus.setOrderId(this.getOrderId());
        orderProductStatus.setItemId(this.getId());
        orderProductStatus.setStatusId(this.getStatusId());
        orderProductStatus.setEnteredBy(this.getModifiedBy());
        orderProductStatus.setModifiedBy(this.getModifiedBy());
        orderProductStatus.insert(db);
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Item ID not specified");
        }
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.buildProductOptions(db);
            this.productOptionList.delete(db);
            this.productOptionList = null;
            this.buildProductStatus(db);
            this.productStatusList.delete(db);
            this.productStatusList = null;
            PreparedStatement pst = db.prepareStatement(" DELETE FROM order_product WHERE item_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (!this.isValid(db)) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE order_product  SET quantity = ? ,      msrp_currency = ?,      msrp_amount = ?,      price_currency = ?,      price_amount = ?,      recurring_currency = ?,      recurring_amount = ?,      recurring_type = ?,      extended_price = ?,      total_price = ?,      status_id = ?,      status_date = ?  WHERE item_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getQuantity());
        DatabaseUtils.setInt(pst, ++i, this.getMsrpCurrency());
        pst.setDouble(++i, this.getMsrpAmount());
        DatabaseUtils.setInt(pst, ++i, this.getPriceCurrency());
        pst.setDouble(++i, this.getPriceAmount());
        DatabaseUtils.setInt(pst, ++i, this.getRecurringCurrency());
        pst.setDouble(++i, this.getRecurringAmount());
        DatabaseUtils.setInt(pst, ++i, this.getRecurringType());
        pst.setDouble(++i, this.getExtendedPrice());
        pst.setDouble(++i, this.getTotalPrice());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        pst.setTimestamp(++i, this.getStatusDate());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        this.insertProductStatus(db);
        return resultCount;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Item ID not specified");
        }
        Object sql = null;
        DependencyList dependencyList = new DependencyList();
        Object pst = null;
        Object rs = null;
        boolean i = false;
        return dependencyList;
    }

    protected boolean isValid(Connection db) throws SQLException {
        return true;
    }

    public boolean createProductFromQuoteProduct(Connection db, int id) throws SQLException {
        Object pst = null;
        Object rs = null;
        boolean result = true;
        QuoteProduct quoteProduct = new QuoteProduct(db, id);
        quoteProduct.buildProductOptions(db);
        Timestamp currentTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
        this.setProductId(quoteProduct.getProductId());
        this.setQuantity(quoteProduct.getQuantity());
        this.setPriceCurrency(quoteProduct.getPriceCurrency());
        this.setPriceAmount(quoteProduct.getPriceAmount());
        this.setRecurringCurrency(quoteProduct.getRecurringCurrency());
        this.setRecurringAmount(quoteProduct.getRecurringAmount());
        this.setRecurringType(quoteProduct.getRecurringType());
        this.setExtendedPrice(quoteProduct.getExtendedPrice());
        this.setTotalPrice(quoteProduct.getTotalPrice());
        this.setStatusDate(currentTime);
        this.insert(db);
        if (quoteProduct.getProductOptionList().size() > 0) {
            for (QuoteProductOption quoteProductOption : quoteProduct.getProductOptionList()) {
                OrderProductOption orderProductOption = new OrderProductOption();
                orderProductOption.setStatusId(this.getStatusId());
                orderProductOption.setItemId(this.getId());
                if (orderProductOption.createOptionFromQuoteProductOption(db, quoteProductOption.getId())) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

