/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.orders.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.orders.base.OrderProduct;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class OrderProductList
extends ArrayList {
    public static final String tableName = "order_product";
    public static final String uniqueField = "item_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int orderId = -1;
    private int productId = -1;
    private int statusId = -1;
    private boolean buildResources = false;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setOrderId(int tmp) {
        this.orderId = tmp;
    }

    public void setOrderId(String tmp) {
        this.orderId = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setBuildResources(boolean tmp) {
        this.buildResources = tmp;
    }

    public void setBuildResources(String tmp) {
        this.buildResources = DatabaseUtils.parseBoolean(tmp);
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public int getProductId() {
        return this.productId;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getOrderId() {
        return this.orderId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public boolean getBuildResources() {
        return this.buildResources;
    }

    public void buildList(Connection db) throws SQLException {
        System.out.println("inside the build function");
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM order_product op WHERE op.item_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
                items = this.prepareFilter(pst);
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY status_date");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("     op.item_id, op.order_id, op.product_id,      op.quantity, op.msrp_currency, op.msrp_amount, op.price_currency, op.price_amount,      op.recurring_currency, op.recurring_amount, op.recurring_type,      op.extended_price, op.total_price, op.status_id, op.status_date  FROM order_product op  WHERE op.item_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            OrderProduct thisOrderProduct = new OrderProduct(rs);
            this.add(thisOrderProduct);
        }
        rs.close();
        pst.close();
        if (this.buildResources) {
            for (OrderProduct thisOrderProduct : this) {
                thisOrderProduct.buildProduct(db);
                thisOrderProduct.buildProductOptions(db);
            }
        }
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.orderId > -1) {
            sqlFilter.append("AND op.order_id = ? ");
        }
        if (this.productId > -1) {
            sqlFilter.append("AND op.product_id = ? ");
        }
        if (this.statusId > -1) {
            sqlFilter.append("AND op.status_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.orderId > -1) {
            pst.setInt(++i, this.orderId);
        }
        if (this.productId > -1) {
            pst.setInt(++i, this.productId);
        }
        if (this.statusId > -1) {
            pst.setInt(++i, this.statusId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public void insert(Connection db) throws SQLException {
        for (OrderProduct thisProduct : this) {
            thisProduct.insert(db);
        }
    }

    public void delete(Connection db) throws SQLException {
        for (OrderProduct thisProduct : this) {
            thisProduct.delete(db);
        }
    }
}

