/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.orders.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.quotes.base.QuoteProductOption;
import org.aspcfs.utils.DatabaseUtils;

public class OrderProductOption
extends GenericBean {
    private int id = -1;
    private int itemId = -1;
    private int productOptionId = -1;
    private int quantity = 0;
    private int priceCurrency = -1;
    private double priceAmount = 0.0;
    private int recurringCurrency = -1;
    private double recurringAmount = 0.0;
    private int recurringType = -1;
    private double extendedPrice = 0.0;
    private double totalPrice = 0.0;
    private int statusId = -1;
    private boolean booleanValue = false;
    private double floatValue = 0.0;
    private Timestamp timestampValue = null;
    private int integerValue = -1;
    private String textValue = null;

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setItemId(int tmp) {
        this.itemId = tmp;
    }

    public void setItemId(String tmp) {
        this.itemId = Integer.parseInt(tmp);
    }

    public void setProductOptionId(int tmp) {
        this.productOptionId = tmp;
    }

    public void setProductOptionId(String tmp) {
        this.productOptionId = Integer.parseInt(tmp);
    }

    public void setQuantity(int tmp) {
        this.quantity = tmp;
    }

    public void setQuantity(String tmp) {
        this.quantity = Integer.parseInt(tmp);
    }

    public void setPriceCurrency(int tmp) {
        this.priceCurrency = tmp;
    }

    public void setPriceCurrency(String tmp) {
        this.priceCurrency = Integer.parseInt(tmp);
    }

    public void setPriceAmount(double tmp) {
        this.priceAmount = tmp;
    }

    public void setPriceAmount(String tmp) {
        this.priceAmount = Double.parseDouble(tmp);
    }

    public void setRecurringCurrency(int tmp) {
        this.recurringCurrency = tmp;
    }

    public void setRecurringCurrency(String tmp) {
        this.recurringCurrency = Integer.parseInt(tmp);
    }

    public void setRecurringAmount(double tmp) {
        this.recurringAmount = tmp;
    }

    public void setRecurringAmount(String tmp) {
        this.recurringAmount = Double.parseDouble(tmp);
    }

    public void setRecurringType(int tmp) {
        this.recurringType = tmp;
    }

    public void setRecurringType(String tmp) {
        this.recurringType = Integer.parseInt(tmp);
    }

    public void setExtendedPrice(double tmp) {
        this.extendedPrice = tmp;
    }

    public void setExtendedPrice(String tmp) {
        this.extendedPrice = Double.parseDouble(tmp);
    }

    public void setTotalPrice(double tmp) {
        this.totalPrice = tmp;
    }

    public void setTotalPrice(String tmp) {
        this.totalPrice = Double.parseDouble(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setBooleanValue(boolean tmp) {
        this.booleanValue = tmp;
    }

    public void setBooleanValue(String tmp) {
        this.booleanValue = DatabaseUtils.parseBoolean(tmp);
    }

    public void setFloatValue(double tmp) {
        this.floatValue = tmp;
    }

    public void setTimestampValue(Timestamp tmp) {
        this.timestampValue = tmp;
    }

    public void setTimestampValue(String tmp) {
        this.timestampValue = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setIntegerValue(int tmp) {
        this.integerValue = tmp;
    }

    public void setIntegerValue(String tmp) {
        this.integerValue = Integer.parseInt(tmp);
    }

    public void setTextValue(String tmp) {
        this.textValue = tmp;
    }

    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    public double getFloatValue() {
        return this.floatValue;
    }

    public Timestamp getTimestampValue() {
        return this.timestampValue;
    }

    public int getIntegerValue() {
        return this.integerValue;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public int getId() {
        return this.id;
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getProductOptionId() {
        return this.productOptionId;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public int getPriceCurrency() {
        return this.priceCurrency;
    }

    public double getPriceAmount() {
        return this.priceAmount;
    }

    public int getRecurringCurrency() {
        return this.recurringCurrency;
    }

    public double getRecurringAmount() {
        return this.recurringAmount;
    }

    public int getRecurringType() {
        return this.recurringType;
    }

    public double getExtendedPrice() {
        return this.extendedPrice;
    }

    public double getTotalPrice() {
        return this.totalPrice;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public OrderProductOption() {
    }

    public OrderProductOption(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public OrderProductOption(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void determineTotal() {
        this.totalPrice = this.priceAmount * (double)this.quantity;
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Invalid Order Product Option ID Number");
        }
        PreparedStatement pst = db.prepareStatement(" SELECT opt.*,  bool.value AS boolean_value,   float.value AS float_value, intr.value AS integer_value,  tst.value AS timestamp_value, txt.value AS text_value  FROM order_product_options opt  LEFT JOIN order_product_option_boolean bool  ON ( opt.order_product_option_id = bool.order_product_option_id )  LEFT JOIN order_product_option_float float  ON ( opt.order_product_option_id = float.order_product_option_id )  LEFT JOIN order_product_option_timestamp tst  ON ( opt.order_product_option_id = tst.order_product_option_id )  LEFT JOIN order_product_option_integer intr  ON ( opt.order_product_option_id = intr.order_product_option_id )  LEFT JOIN order_product_option_text txt  ON ( opt.order_product_option_id = txt.order_product_option_id )  WHERE opt.order_product_option_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Order Product Option not found");
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("order_product_option_id"));
        this.itemId = rs.getInt("item_id");
        this.productOptionId = rs.getInt("product_option_id");
        this.quantity = DatabaseUtils.getInt(rs, "quantity");
        this.priceCurrency = DatabaseUtils.getInt(rs, "price_currency");
        this.priceAmount = DatabaseUtils.getDouble(rs, "price_amount");
        this.recurringCurrency = DatabaseUtils.getInt(rs, "recurring_currency");
        this.recurringAmount = DatabaseUtils.getDouble(rs, "recurring_amount");
        this.recurringType = DatabaseUtils.getInt(rs, "recurring_type");
        this.extendedPrice = DatabaseUtils.getDouble(rs, "extended_price");
        this.totalPrice = DatabaseUtils.getDouble(rs, "total_price");
        this.statusId = DatabaseUtils.getInt(rs, "status_id");
        this.booleanValue = rs.getBoolean("boolean_value");
        this.floatValue = DatabaseUtils.getDouble(rs, "float_value");
        this.integerValue = DatabaseUtils.getInt(rs, "integer_value");
        this.textValue = rs.getString("text_value");
        this.timestampValue = rs.getTimestamp("timestamp_value");
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        if (!this.isValid(db)) {
            return result;
        }
        if (this.quantity == 0) {
            this.quantity = 1;
        }
        this.determineTotal();
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "order_product_options_order_product_option_id_seq");
        sql.append(" INSERT INTO order_product_options(" + (this.id > -1 ? "order_product_option_id, " : "") + "item_id, product_option_id, " + "   quantity, price_currency, price_amount, recurring_currency, " + "   recurring_amount, recurring_type, extended_price, total_price, status_id) ");
        sql.append(" VALUES(" + (this.id > -1 ? "?, " : "") + "?, ?,?, ?, ?, ?, ?, ?, ?, ?, ? )");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.getItemId());
        pst.setInt(++i, this.getProductOptionId());
        DatabaseUtils.setInt(pst, ++i, this.getQuantity());
        DatabaseUtils.setInt(pst, ++i, this.getPriceCurrency());
        DatabaseUtils.setDouble(pst, ++i, this.getPriceAmount());
        DatabaseUtils.setInt(pst, ++i, this.getRecurringCurrency());
        DatabaseUtils.setDouble(pst, ++i, this.getRecurringAmount());
        DatabaseUtils.setInt(pst, ++i, this.getRecurringType());
        DatabaseUtils.setDouble(pst, ++i, this.getExtendedPrice());
        DatabaseUtils.setDouble(pst, ++i, this.getTotalPrice());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "order_product_options_order_product_option_id_seq", this.id);
        if (this.getBooleanValue()) {
            sql = new StringBuffer("");
            sql.append(" INSERT INTO order_product_option_boolean ( order_product_option_id, value )  VALUES ( ? , ? ) ");
            pst = db.prepareStatement(sql.toString());
            pst.setInt(1, this.id);
            pst.setBoolean(2, this.getBooleanValue());
            pst.execute();
            pst.close();
        }
        if ((int)this.getFloatValue() > 0) {
            sql = new StringBuffer("");
            sql.append(" INSERT INTO order_product_option_float ( order_product_option_id, value ) VALUES ( ? , ? ) ");
            pst = db.prepareStatement(sql.toString());
            pst.setInt(1, this.id);
            pst.setDouble(2, this.getFloatValue());
            pst.execute();
            pst.close();
        }
        if (this.getTimestampValue() != null) {
            sql = new StringBuffer("");
            sql.append(" INSERT INTO order_product_option_timestamp ( order_product_option_id, value ) VALUES ( ? , ? ) ");
            pst = db.prepareStatement(sql.toString());
            pst.setInt(1, this.id);
            pst.setTimestamp(2, this.getTimestampValue());
            pst.execute();
            pst.close();
        }
        if (this.getIntegerValue() > -1) {
            sql = new StringBuffer("");
            sql.append(" INSERT INTO order_product_option_integer ( order_product_option_id, value ) VALUES ( ? , ? ) ");
            pst = db.prepareStatement(sql.toString());
            pst.setInt(1, this.id);
            DatabaseUtils.setInt(pst, 2, this.getIntegerValue());
            pst.execute();
            pst.close();
        }
        if (this.getTextValue() != null) {
            sql = new StringBuffer("");
            sql.append(" INSERT INTO order_product_option_text ( order_product_option_id, value ) VALUES ( ? , ? ) ");
            pst = db.prepareStatement(sql.toString());
            pst.setInt(1, this.id);
            pst.setString(2, this.getTextValue());
            pst.execute();
            pst.close();
        }
        result = true;
        return result;
    }

    public boolean delete(Connection db) throws SQLException {
        PreparedStatement pst = null;
        if (this.getId() == -1) {
            throw new SQLException("Order Product Option ID not specified");
        }
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            pst = db.prepareStatement(" DELETE FROM order_product_option_boolean WHERE order_product_option_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement(" DELETE FROM order_product_option_float WHERE order_product_option_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement(" DELETE FROM order_product_option_timestamp WHERE order_product_option_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement(" DELETE FROM order_product_option_integer WHERE order_product_option_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement(" DELETE FROM order_product_option_text WHERE order_product_option_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement(" DELETE FROM order_product_options WHERE order_product_option_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE order_product_options  SET quantity = ?,      price_currency = ?,      price_amount = ?,      recurring_currency = ?,      recurring_amount = ?,      recurring_type = ?,      extended_price = ?,      total_price = ?,      status_id = ? ");
        sql.append(" WHERE order_product_option_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getQuantity());
        DatabaseUtils.setInt(pst, ++i, this.getPriceCurrency());
        DatabaseUtils.setDouble(pst, ++i, this.getPriceAmount());
        DatabaseUtils.setInt(pst, ++i, this.getRecurringCurrency());
        DatabaseUtils.setDouble(pst, ++i, this.getRecurringAmount());
        DatabaseUtils.setInt(pst, ++i, this.getRecurringType());
        DatabaseUtils.setDouble(pst, ++i, this.getExtendedPrice());
        DatabaseUtils.setDouble(pst, ++i, this.getTotalPrice());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        sql = new StringBuffer("");
        sql.append(" UPDATE order_product_option_boolean  SET " + DatabaseUtils.addQuotes(db, "value") + " = ? " + " WHERE order_product_option_id = ? ");
        pst = db.prepareStatement(sql.toString());
        pst.setBoolean(1, this.getBooleanValue());
        DatabaseUtils.setInt(pst, 2, this.getId());
        int result1Count = pst.executeUpdate();
        pst.close();
        sql = new StringBuffer("");
        sql.append(" UPDATE order_product_option_float  SET " + DatabaseUtils.addQuotes(db, "value") + " = ? " + " WHERE order_product_option_id = ? ");
        pst = db.prepareStatement(sql.toString());
        pst.setDouble(1, this.getFloatValue());
        DatabaseUtils.setInt(pst, 2, this.getId());
        result1Count = pst.executeUpdate();
        pst.close();
        sql = new StringBuffer("");
        sql.append(" UPDATE order_product_option_timestamp  SET " + DatabaseUtils.addQuotes(db, "value") + " = ? " + " WHERE order_product_option_id = ? ");
        pst = db.prepareStatement(sql.toString());
        pst.setTimestamp(1, this.getTimestampValue());
        DatabaseUtils.setInt(pst, 2, this.getId());
        result1Count = pst.executeUpdate();
        pst.close();
        sql = new StringBuffer("");
        sql.append(" UPDATE order_product_option_integer  SET " + DatabaseUtils.addQuotes(db, "value") + " = ? " + " WHERE order_product_option_id = ? ");
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, 1, this.getIntegerValue());
        DatabaseUtils.setInt(pst, 2, this.getId());
        result1Count = pst.executeUpdate();
        pst.close();
        sql = new StringBuffer("");
        sql.append(" UPDATE order_product_option_text  SET " + DatabaseUtils.addQuotes(db, "value") + " = ? " + " WHERE order_product_option_id = ? ");
        pst = db.prepareStatement(sql.toString());
        pst.setString(1, this.getTextValue());
        DatabaseUtils.setInt(pst, 2, this.getId());
        result1Count = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Order Product Option ID not specified");
        }
        Object sql = null;
        DependencyList dependencyList = new DependencyList();
        Object pst = null;
        Object rs = null;
        boolean i = false;
        return dependencyList;
    }

    protected boolean isValid(Connection db) throws SQLException {
        return true;
    }

    public boolean createOptionFromQuoteProductOption(Connection db, int id) throws SQLException {
        Object pst = null;
        Object rs = null;
        QuoteProductOption quoteProductOption = new QuoteProductOption(db, id);
        this.setProductOptionId(quoteProductOption.getProductOptionId());
        this.setQuantity(quoteProductOption.getQuantity());
        this.setPriceCurrency(quoteProductOption.getPriceCurrency());
        this.setPriceAmount(quoteProductOption.getPriceAmount());
        this.setRecurringCurrency(quoteProductOption.getRecurringCurrency());
        this.setRecurringAmount(quoteProductOption.getRecurringAmount());
        this.setRecurringType(quoteProductOption.getRecurringType());
        this.setExtendedPrice(quoteProductOption.getExtendedPrice());
        this.setIntegerValue(quoteProductOption.getIntegerValue());
        this.setTotalPrice(quoteProductOption.getTotalPrice());
        this.insert(db);
        return true;
    }
}

