/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.orders.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class OrderProductStatus
extends GenericBean {
    private int id = -1;
    private int orderId = -1;
    private int itemId = -1;
    private int statusId = -1;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private int productId = -1;

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setOrderId(int tmp) {
        this.orderId = tmp;
    }

    public void setOrderId(String tmp) {
        this.orderId = Integer.parseInt(tmp);
    }

    public void setItemId(int tmp) {
        this.itemId = tmp;
    }

    public void setItemId(String tmp) {
        this.itemId = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getOrderId() {
        return this.orderId;
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getProductId() {
        return this.productId;
    }

    public OrderProductStatus() {
    }

    public OrderProductStatus(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public OrderProductStatus(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Order Product Status ID Number");
        }
        PreparedStatement pst = db.prepareStatement(" SELECT ops.order_product_status_id, ops.order_id, ops.item_id,         ops.status_id, ops.entered, ops.enteredby,    \t   ops.modified, ops.modifiedby,         prod.product_id  FROM order_product_status ops, order_product prod  WHERE ops.item_id = prod.item_id AND ops.order_product_status_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Order Product Status ID not found");
        }
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("order_product_status_id"));
        this.orderId = rs.getInt("order_id");
        this.itemId = rs.getInt("item_id");
        this.statusId = DatabaseUtils.getInt(rs, "status_id");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredBy");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedBy");
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "order_product_status_order_product_status_id_seq");
        sql.append(" INSERT INTO order_product_status(order_id, item_id, status_id, ");
        if (this.id > -1) {
            sql.append("order_product_status_id, ");
        }
        if (this.entered != null) {
            sql.append("entered, ");
        }
        sql.append("enteredby, ");
        if (this.modified != null) {
            sql.append("modified, ");
        }
        sql.append(" modifiedby ) ");
        sql.append(" VALUES( ?, ?, ?, ");
        if (this.id > -1) {
            sql.append("?, ");
        }
        if (this.entered != null) {
            sql.append("?, ");
        }
        sql.append("?, ");
        if (this.modified != null) {
            sql.append("?, ");
        }
        sql.append("?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.getOrderId());
        pst.setInt(++i, this.getItemId());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.entered != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        pst.setInt(++i, this.getEnteredBy());
        if (this.modified != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setInt(++i, this.getModifiedBy());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "order_product_status_order_product_status_id_seq", this.id);
        result = true;
        return result;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Order ID not specified");
        }
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement(" DELETE FROM order_product_status WHERE order_product_status_id = ?");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE order_product_status  SET status_id = ?      entered = ?,      enteredby = ?,      modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + "     modifiedby = ?, " + " WHERE order_product_status = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        pst.setTimestamp(++i, this.getEntered());
        pst.setInt(++i, this.getEnteredBy());
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }
}

