/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.orders.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.orders.base.OrderProductStatus;
import org.aspcfs.utils.web.PagedListInfo;

public class OrderProductStatusList
extends ArrayList {
    public static final String tableName = "order_product_status";
    public static final String uniqueField = "order_product_status_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int itemId = -1;
    private int statusId = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setItemId(int tmp) {
        this.itemId = tmp;
    }

    public void setItemId(String tmp) {
        this.itemId = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM order_product_status ops WHERE ops.order_product_status_id > -1 ");
        this.createFilter(sqlFilter);
        sqlOrder.append("ORDER BY status_id");
        sqlSelect.append("SELECT ");
        sqlSelect.append("     ops.order_product_status_id, ops.order_id, ops.item_id,      ops.status_id, ops.entered, ops.enteredby,    \tops.modified, ops.modifiedby  FROM order_product_status ops, order_product prod  WHERE ops.item_id = prod.item_id AND ops.order_product_status_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            OrderProductStatus thisStatus = new OrderProductStatus(rs);
            this.add(thisStatus);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.itemId > -1) {
            sqlFilter.append("AND ops.item_id = ? ");
        }
        if (this.statusId > -1) {
            sqlFilter.append("AND ops.status_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND ops.entered > ? ");
            }
            sqlFilter.append("AND ops.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND ops.modified > ? ");
            sqlFilter.append("AND ops.entered < ? ");
            sqlFilter.append("AND ops.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.itemId > -1) {
            pst.setInt(++i, this.itemId);
        }
        if (this.statusId > -1) {
            pst.setInt(++i, this.statusId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public void insert(Connection db) throws SQLException {
        for (OrderProductStatus thisStatus : this) {
            thisStatus.insert(db);
        }
    }

    public void delete(Connection db) throws SQLException {
        for (OrderProductStatus thisStatus : this) {
            thisStatus.delete(db);
        }
    }
}

