/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.orders.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.security.Key;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.PrivateString;

public class PaymentCreditCard
extends GenericBean {
    private int id = -1;
    private int orderId = -1;
    private int cardType = -1;
    private String cardNumber;
    private String cardSecurityCode;
    private int expirationMonth = -1;
    private int expirationYear = -1;
    private String nameOnCard;
    private String companyNameOnCard;
    private Timestamp entered;
    private int enteredBy = -1;
    private Timestamp modified;
    private int modifiedBy = -1;
    private Key publicKey;
    private Key privateKey;

    public void setOrderId(int tmp) {
        this.orderId = tmp;
    }

    public void setOrderId(String tmp) {
        this.orderId = Integer.parseInt(tmp);
    }

    public int getOrderId() {
        return this.orderId;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setCardType(int tmp) {
        this.cardType = tmp;
    }

    public void setCardType(String tmp) {
        this.cardType = Integer.parseInt(tmp);
    }

    public void setCardNumber(String tmp) {
        this.cardNumber = tmp;
    }

    public void setCardSecurityCode(String tmp) {
        this.cardSecurityCode = tmp;
    }

    public void setExpirationMonth(int tmp) {
        this.expirationMonth = tmp;
    }

    public void setExpirationMonth(String tmp) {
        this.expirationMonth = Integer.parseInt(tmp);
    }

    public void setExpirationYear(int tmp) {
        this.expirationYear = tmp;
    }

    public void setExpirationYear(String tmp) {
        this.expirationYear = Integer.parseInt(tmp);
    }

    public void setNameOnCard(String tmp) {
        this.nameOnCard = tmp;
    }

    public void setCompanyNameOnCard(String tmp) {
        this.companyNameOnCard = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setPublicKey(Key tmp) {
        this.publicKey = tmp;
    }

    public Key getPublicKey() {
        return this.publicKey;
    }

    public void setPrivateKey(Key tmp) {
        this.privateKey = tmp;
    }

    public Key getPrivateKey() {
        return this.privateKey;
    }

    public int getId() {
        return this.id;
    }

    public int getCardType() {
        return this.cardType;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public String getEncryptedCardNumber() {
        return PrivateString.encryptAsymmetric(this.publicKey, this.getCardNumber());
    }

    public String getCardSecurityCode() {
        return this.cardSecurityCode;
    }

    public int getExpirationMonth() {
        return this.expirationMonth;
    }

    public int getExpirationYear() {
        return this.expirationYear;
    }

    public String getNameOnCard() {
        return this.nameOnCard;
    }

    public String getCompanyNameOnCard() {
        return this.companyNameOnCard;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public PaymentCreditCard() {
    }

    public PaymentCreditCard(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public PaymentCreditCard(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Credit Card ID");
        }
        PreparedStatement pst = db.prepareStatement(" SELECT pc.creditcard_id, pc.card_type, pc.card_number, pc.card_security_code, \t\t     pc.expiration_month, pc.expiration_year, pc.name_on_card, pc.company_name_on_card, \t       pc.entered, pc.enteredby, pc.modified, pc.modifiedby, pc.order_id  FROM payment_creditcard pc  WHERE pc.creditcard_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Credit Card Entry not found");
        }
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("creditcard_id"));
        this.cardType = DatabaseUtils.getInt(rs, "card_type");
        this.cardNumber = rs.getString("card_number");
        this.cardSecurityCode = rs.getString("card_security_code");
        this.expirationMonth = DatabaseUtils.getInt(rs, "expiration_month");
        this.expirationYear = DatabaseUtils.getInt(rs, "expiration_year");
        this.nameOnCard = rs.getString("name_on_card");
        this.companyNameOnCard = rs.getString("company_name_on_card");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.orderId = DatabaseUtils.getInt(rs, "order_id");
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        this.id = DatabaseUtils.getNextSeq(db, "payment_creditcard_creditcard_id_seq");
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO payment_creditcard(card_type, card_number, card_security_code,  \texpiration_month, expiration_year, name_on_card, company_name_on_card, ");
        if (this.id > -1) {
            sql.append("creditcard_id, ");
        }
        if (this.entered != null) {
            sql.append("entered, ");
        }
        sql.append("enteredby, ");
        if (this.modified != null) {
            sql.append("modified, ");
        }
        sql.append("modifiedby, order_id )");
        sql.append("VALUES( ?, ?, ?, ?, ?, ?, ?, ");
        if (this.id > -1) {
            sql.append("?, ");
        }
        if (this.entered != null) {
            sql.append("?, ");
        }
        sql.append("?, ");
        if (this.modified != null) {
            sql.append("?, ");
        }
        sql.append("?, ? )");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getCardType());
        pst.setString(++i, this.getEncryptedCardNumber());
        pst.setString(++i, this.getCardSecurityCode());
        DatabaseUtils.setInt(pst, ++i, this.getExpirationMonth());
        DatabaseUtils.setInt(pst, ++i, this.getExpirationYear());
        pst.setString(++i, this.getNameOnCard());
        pst.setString(++i, this.getCompanyNameOnCard());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.entered != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        pst.setInt(++i, this.getEnteredBy());
        if (this.modified != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setInt(++i, this.getModifiedBy());
        DatabaseUtils.setInt(pst, ++i, this.getOrderId());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "payment_creditcard_creditcard_id_seq", this.id);
        result = true;
        return result;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Credit Card ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("DELETE FROM payment_creditcard WHERE creditcard_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE order_payment SET card_type = ?,      card_number = ?,      card_security_code = ?,      expiration_month = ?,      expiration_year = ?,      name_on_card = ?,      company_name_on_card = ?      entered = ?,      enteredby = ?,      modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + "     modifiedby = ? , " + "WHERE creditcard_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getCardType());
        pst.setString(++i, this.getCardNumber());
        pst.setString(++i, this.getCardSecurityCode());
        pst.setInt(++i, this.getExpirationMonth());
        pst.setInt(++i, this.getExpirationYear());
        pst.setString(++i, this.getNameOnCard());
        pst.setString(++i, this.getCompanyNameOnCard());
        pst.setTimestamp(++i, this.getEntered());
        pst.setInt(++i, this.getEnteredBy());
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }
}

