/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.orders.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class PaymentEFT
extends GenericBean {
    private int id = -1;
    private int orderId = -1;
    private String bankName = null;
    private String routingNumber = null;
    private String accountNumber = null;
    private String nameOnAccount = null;
    private String companyNameOnAccount = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;

    public void setOrderId(int tmp) {
        this.orderId = tmp;
    }

    public void setOrderId(String tmp) {
        this.orderId = Integer.parseInt(tmp);
    }

    public int getOrderId() {
        return this.orderId;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setBankName(String tmp) {
        this.bankName = tmp;
    }

    public void setRoutingNumber(String tmp) {
        this.routingNumber = tmp;
    }

    public void setAccountNumber(String tmp) {
        this.accountNumber = tmp;
    }

    public void setNameOnAccount(String tmp) {
        this.nameOnAccount = tmp;
    }

    public void setCompanyNameOnAccount(String tmp) {
        this.companyNameOnAccount = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public String getBankName() {
        return this.bankName;
    }

    public String getRoutingNumber() {
        return this.routingNumber;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public String getNameOnAccount() {
        return this.nameOnAccount;
    }

    public String getCompanyNameOnAccount() {
        return this.companyNameOnAccount;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public PaymentEFT() {
    }

    public PaymentEFT(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public PaymentEFT(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid EFT ID Specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT eft.bank_id,         eft.bank_name, eft.routing_number,         eft.account_number, eft.name_on_account,         eft.company_name_on_account, eft.entered,         eft.enteredby, eft.modified, eft.modifiedby, eft.order_id FROM payment_eft eft WHERE eft.bank_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Credit Card Entry not found");
        }
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("bank_id"));
        this.bankName = rs.getString("bank_name");
        this.routingNumber = rs.getString("routing_number");
        this.accountNumber = rs.getString("account_number");
        this.nameOnAccount = rs.getString("name_on_account");
        this.companyNameOnAccount = rs.getString("company_name_on_account");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = DatabaseUtils.getInt(rs, "enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = DatabaseUtils.getInt(rs, "modifiedby");
        this.orderId = DatabaseUtils.getInt(rs, "order_id");
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        this.id = DatabaseUtils.getNextSeq(db, "payment_eft_bank_id_seq");
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO payment_eft(bank_name, routing_number, account_number,  \tname_on_account, company_name_on_account ");
        if (this.id > -1) {
            sql.append("bank_id, ");
        }
        if (this.entered != null) {
            sql.append(" entered, ");
        }
        sql.append(" enteredby, ");
        if (this.modified != null) {
            sql.append(" modified, ");
        }
        sql.append(" modifiedby, order_id )");
        sql.append("VALUES( ?, ?, ?, ?, ?, ?, ");
        if (this.id > -1) {
            sql.append("?, ");
        }
        if (this.entered != null) {
            sql.append("?, ");
        }
        sql.append("?, ");
        if (this.modified != null) {
            sql.append("?, ");
        }
        sql.append("?, ? )");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.getBankName());
        pst.setString(++i, this.getRoutingNumber());
        pst.setString(++i, this.getAccountNumber());
        pst.setString(++i, this.getNameOnAccount());
        pst.setString(++i, this.getCompanyNameOnAccount());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.entered != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        pst.setInt(++i, this.getEnteredBy());
        if (this.modified != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setInt(++i, this.getModifiedBy());
        DatabaseUtils.setInt(pst, ++i, this.getOrderId());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "payment_eft_bank_id_seq", this.id);
        result = true;
        return result;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Bank ID not specified");
        }
        PreparedStatement pst = db.prepareStatement(" DELETE FROM payment_eft WHERE bank_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE order_eft  SET bank_name = ?,      routing_number = ?,      account_number = ?,      name_on_account= ?,      company_name_on_account = ?      entered = ?,      enteredby = ?,      modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + "     modifiedby = ?, " + " WHERE bank_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.getBankName());
        pst.setString(++i, this.getRoutingNumber());
        pst.setString(++i, this.getAccountNumber());
        pst.setString(++i, this.getNameOnAccount());
        pst.setString(++i, this.getCompanyNameOnAccount());
        pst.setTimestamp(++i, this.getEntered());
        pst.setInt(++i, this.getEnteredBy());
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }
}

