/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.awt.Color;
import java.awt.Paint;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationList;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.base.GraphSummaryList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.base.OpportunityComponentList;
import org.aspcfs.modules.pipeline.base.OpportunityComponentLog;
import org.aspcfs.modules.pipeline.base.OpportunityComponentLogList;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.modules.pipeline.base.OpportunityHeaderList;
import org.aspcfs.modules.pipeline.base.OpportunityList;
import org.aspcfs.modules.pipeline.beans.OpportunityBean;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.UserUtils;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;
import org.aspcfs.utils.web.ViewpointInfo;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class Leads
extends CFSModule {
    public static Date createDate(int y, int m, int d) {
        GregorianCalendar calendar = new GregorianCalendar(y, m, d, 0, 0, 0);
        return calendar.getTime();
    }

    public String executeCommandDefault(ActionContext context) {
        return this.executeCommandDashboard(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPrepare(ActionContext context) {
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        User thisRec = this.getUser(context, userId);
        UserList shortChildList = thisRec.getShortChildList();
        UserList userList = thisRec.getFullChildList(shortChildList, new UserList());
        userList = UserList.sortEnabledUsers(userList, new UserList());
        userList.setMyId(userId);
        String tempString = "";
        if (!thisRec.getEnabled() || thisRec.getExpires() != null && thisRec.getExpires().before(new Timestamp(Calendar.getInstance().getTimeInMillis()))) {
            tempString = " *";
        }
        userList.setMyValue(thisRec.getContact().getNameLastFirst() + tempString);
        userList.setIncludeMe(true);
        userList.setExcludeDisabledIfUnselected(true);
        userList.setExcludeExpiredIfUnselected(true);
        context.getRequest().setAttribute("UserList", (Object)userList);
        String id = context.getRequest().getParameter("headerId");
        if (id != null && !"-1".equals(id) && !this.hasPermission(context, "pipeline-opportunities-add")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (id != null && !"-1".equals(id)) {
                OpportunityHeader oppHeader = new OpportunityHeader(db, Integer.parseInt(id));
                context.getRequest().setAttribute("opportunityHeader", (Object)oppHeader);
            }
            if ("list".equals(context.getRequest().getParameter("source"))) {
                this.addModuleBean(context, "View Opportunities", "Add Opportunity");
            } else {
                this.addModuleBean(context, "Add Opportunity", "Add Opportunity");
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            String string = "PrepareOK";
            return string;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveComponent(ActionContext context) {
        boolean recordInserted = false;
        boolean isValid = false;
        int resultCount = 0;
        String componentId = context.getRequest().getParameter("id");
        String permission = "pipeline-opportunities-add";
        SystemStatus systemStatus = this.getSystemStatus(context);
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        OpportunityBean bean = new OpportunityBean();
        OpportunityHeader header = null;
        OpportunityComponent oldComponent = null;
        OpportunityComponent newComponent = (OpportunityComponent)((Object)context.getFormBean());
        if (!systemStatus.hasField("opportunity.componentTypes")) {
            newComponent.setTypeList(context.getRequest().getParameterValues("selectedList"));
        }
        newComponent.setEnteredBy(this.getUserId(context));
        newComponent.setModifiedBy(this.getUserId(context));
        String action = newComponent.getId() > 0 ? "modify" : "insert";
        Connection db = null;
        if ("modify".equals(action)) {
            permission = "pipeline-opportunities-edit";
        }
        if (!this.hasPermission(context, permission)) {
            return "PermissionError";
        }
        try {
            db = this.getConnection(context);
            header = new OpportunityHeader(db, newComponent.getHeaderId());
            newComponent.setContactId(header.getContactLink());
            newComponent.setOrgId(header.getAccountLink());
            bean.setHeader(header);
            if (newComponent.getId() > 0) {
                oldComponent = new OpportunityComponent(db, Integer.parseInt(componentId));
                if (!this.hasViewpointAuthority(db, context, "pipeline", oldComponent.getOwner(), userId) && !this.hasViewpointAuthority(db, context, "pipeline", header.getManager(), userId)) {
                    String string = "PermissionError";
                    return string;
                }
                newComponent.setModifiedBy(this.getUserId(context));
                bean.setComponent(newComponent);
                isValid = this.validateObject(context, db, (Object)bean);
                boolean bl = isValid = this.validateObject(context, db, (Object)newComponent) && isValid;
                if (isValid) {
                    resultCount = newComponent.update(db, context);
                }
                if (resultCount == 1) {
                    newComponent.queryRecord(db, newComponent.getId());
                    this.processUpdateHook(context, (Object)oldComponent, (Object)newComponent);
                }
            } else {
                if (!this.hasViewpointAuthority(db, context, "pipeline", header.getManager(), userId)) {
                    String string = "PermissionError";
                    return string;
                }
                bean.setComponent(newComponent);
                isValid = this.validateObject(context, db, (Object)bean);
                boolean bl = isValid = this.validateObject(context, db, (Object)newComponent) && isValid;
                if (isValid) {
                    recordInserted = newComponent.insert(db, context);
                }
            }
            if (recordInserted) {
                this.processInsertHook(context, (Object)newComponent);
                this.addRecentItem(context, (Object)newComponent);
            } else if ("modify".equals(action) && resultCount == -1) {
                UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
                User thisRec = thisUser.getUserRecord();
                UserList shortChildList = thisRec.getShortChildList();
                UserList userList = thisRec.getFullChildList(shortChildList, new UserList());
                userList.setMyId(this.getUserId(context));
                userList.setMyValue(thisUser.getContact().getNameLastFirst());
                userList.setIncludeMe(true);
                userList.setExcludeDisabledIfUnselected(true);
                userList.setExcludeExpiredIfUnselected(true);
                context.getRequest().setAttribute("UserList", (Object)userList);
                LookupList typeSelect = new LookupList(db, "lookup_opportunity_types");
                context.getRequest().setAttribute("TypeSelect", (Object)typeSelect);
                context.getRequest().setAttribute("TypeList", (Object)newComponent.getTypeList());
            } else if ("insert".equals(action) && !recordInserted) {
                LookupList typeSelect = new LookupList(db, "lookup_opportunity_types");
                context.getRequest().setAttribute("TypeSelect", (Object)typeSelect);
                context.getRequest().setAttribute("TypeList", (Object)newComponent.getTypeList());
            }
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            if (!systemStatus.hasField("opportunity.componentTypes")) {
                newComponent.setTypeListToTypes(db);
            }
            context.getRequest().setAttribute("ComponentDetails", (Object)newComponent);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if ("insert".equals(action)) {
            if (recordInserted) {
                return this.executeCommandDetailsOpp(context);
            }
        } else if (resultCount == 1) {
            if ("list".equals(context.getRequest().getParameter("return"))) {
                return this.executeCommandSearch(context);
            }
            if ("details".equals(context.getRequest().getParameter("return"))) {
                return this.executeCommandDetailsComponent(context);
            }
            if (context.getRequest().getParameter("popup") != null) {
                return "PopupCloseOK";
            }
            return this.executeCommandDetailsComponent(context);
        }
        return this.executeCommandPrepare(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-add")) {
            return "PermissionError";
        }
        boolean recordInserted = false;
        boolean isValid = false;
        SystemStatus systemStatus = this.getSystemStatus(context);
        OpportunityBean newOpp = (OpportunityBean)((Object)context.getRequest().getAttribute("OppDetails"));
        Contact linkedContact = null;
        if (!systemStatus.hasField("opportunity.componentTypes")) {
            newOpp.getComponent().setTypeList(context.getRequest().getParameterValues("selectedList"));
        }
        newOpp.getComponent().setEnteredBy(this.getUserId(context));
        newOpp.getComponent().setModifiedBy(this.getUserId(context));
        newOpp.getHeader().setEnteredBy(this.getUserId(context));
        newOpp.getHeader().setModifiedBy(this.getUserId(context));
        if (newOpp.getHeader().getAccountLink() > -1) {
            newOpp.getHeader().setContactLink("-1");
        } else if (newOpp.getHeader().getContactLink() > -1) {
            newOpp.getHeader().setAccountLink("-1");
        }
        context.getRequest().setAttribute("oppDetails", (Object)newOpp);
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (newOpp.getHeader().getContactLink() > -1) {
                linkedContact = new Contact(db, newOpp.getHeader().getContactLink());
                newOpp.getHeader().setContactName(linkedContact.getNameLastFirst());
            }
            isValid = this.validateObject(context, db, (Object)newOpp);
            isValid = this.validateObject(context, db, (Object)newOpp.getHeader()) && isValid;
            boolean bl = isValid = this.validateObject(context, db, (Object)newOpp.getComponent()) && isValid;
            if (isValid) {
                recordInserted = newOpp.insert(db, context);
            }
            if (recordInserted) {
                newOpp.getComponent().setContactId(newOpp.getHeader().getContactLink());
                newOpp.getComponent().setOrgId(newOpp.getHeader().getAccountLink());
                this.processInsertHook(context, (Object)newOpp.getComponent());
            } else {
                LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
                context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
                LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
                context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
                LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
                context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
                LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
                context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
                LookupList typeSelect = new LookupList(db, "lookup_opportunity_types");
                context.getRequest().setAttribute("TypeSelect", (Object)typeSelect);
                context.getRequest().setAttribute("TypeList", (Object)newOpp.getComponent().getTypeList());
                AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
                context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
                if (newOpp.getHeader().getAccountLink() > -1) {
                    Organization thisOrg = new Organization(db, newOpp.getHeader().getAccountLink());
                    newOpp.getHeader().setAccountName(thisOrg.getName());
                }
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            this.addRecentItem(context, (Object)newOpp.getHeader());
            if (context.getRequest().getParameter("popup") != null) {
                return "CloseInsertOppPopup";
            }
            context.getRequest().setAttribute("headerId", (Object)String.valueOf(newOpp.getHeader().getId()));
            return this.executeCommandDetailsOpp(context);
        }
        return this.executeCommandPrepare(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetailsOpp(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-view")) {
            return "PermissionError";
        }
        int headerId = -1;
        PagedListInfo searchOppListInfo = this.getPagedListInfo(context, "SearchOppListInfo", false);
        OpportunityHeader thisHeader = null;
        OpportunityComponentList componentList = null;
        this.addModuleBean(context, "View Opportunities", "View Opportunity Details");
        String fromQuoteDetails = context.getRequest().getParameter("fromQuoteDetails");
        String viewSource = context.getRequest().getParameter("viewSource");
        if (fromQuoteDetails != null && "true".equals(fromQuoteDetails)) {
            context.getSession().removeAttribute("LeadsComponentListInfo");
            context.getSession().removeAttribute("PipelineViewpointInfo");
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        headerId = context.getRequest().getParameter("headerId") != null ? Integer.parseInt(context.getRequest().getParameter("headerId")) : Integer.parseInt((String)context.getRequest().getAttribute("headerId"));
        Connection db = null;
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            context.getSession().removeAttribute("LeadsComponentListInfo");
        }
        PagedListInfo componentListInfo = this.getPagedListInfo(context, "LeadsComponentListInfo");
        componentListInfo.setLink("Leads.do?command=DetailsOpp&headerId=" + headerId + RequestUtils.addLinkParams(context.getRequest(), "viewSource"));
        try {
            db = this.getConnection(context);
            thisHeader = new OpportunityHeader();
            thisHeader.setBuildComponentCount(true);
            thisHeader.queryRecord(db, headerId);
            context.getRequest().setAttribute("opportunityHeader", (Object)thisHeader);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            componentList = new OpportunityComponentList();
            componentList.setPagedListInfo(componentListInfo);
            componentList.setAccessType(thisHeader.getAccessType());
            String accessType = searchOppListInfo.getSearchOptionValue("searchcodeAccessType");
            if (viewSource == null || !"dashboard".equals(viewSource)) {
                if (accessType != null && !"".equals(accessType.trim()) && 626030335 == accessTypeList.getRuleId(Integer.parseInt(accessType))) {
                    if (searchOppListInfo.getFilterKey("listFilter2") != -1) {
                        componentList.setControlledHierarchy(1, this.getUserRange(context, searchOppListInfo.getFilterKey("listFilter2")));
                    } else {
                        componentList.setControlledHierarchy(1, this.getUserRange(context));
                    }
                } else if (accessType != null && !"".equals(accessType.trim()) && 626030334 == accessTypeList.getRuleId(Integer.parseInt(accessType))) {
                    if (searchOppListInfo.getFilterKey("listFilter2") != -1) {
                        componentList.setControlledHierarchy(0, this.getUserRange(context, searchOppListInfo.getFilterKey("listFilter2")));
                    } else {
                        componentList.setControlledHierarchy(0, this.getUserRange(context));
                    }
                } else {
                    componentList.setOwnerIdRange(this.getUserRange(context));
                    componentList.setControlledHierarchyOnly(-1);
                }
            } else {
                componentList.setOwnerIdRange(this.getUserRange(context));
                componentList.setControlledHierarchyOnly(-1);
            }
            componentList.setHeaderId(thisHeader.getId());
            componentList.setIncludeOnlyTrashed(thisHeader.isTrashed());
            componentList.buildList(db);
            context.getRequest().setAttribute("ComponentList", (Object)componentList);
            if (!this.allowMultiple(context) && componentList.size() > 0) {
                OpportunityComponent thisComponent = (OpportunityComponent)((Object)componentList.get(0));
                context.getRequest().setAttribute("LeadsComponentDetails", (Object)thisComponent);
            }
            this.addRecentItem(context, (Object)thisHeader);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (!this.allowMultiple(context) && componentList.size() > 0) {
            return Leads.getReturn(context, "DetailsComponent");
        }
        return "OppDetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearchForm(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-view")) {
            return "PermissionError";
        }
        Connection db = null;
        PagedListInfo searchOppListInfo = this.getPagedListInfo(context, "SearchOppListInfo");
        SystemStatus systemStatus = this.getSystemStatus(context);
        context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int vpUserId = viewpointInfo.getVpUserId(this.getUserId(context));
        int userId = this.getUserId(context);
        if (vpUserId != -1 && vpUserId != userId) {
            userId = vpUserId;
        }
        try {
            db = this.getConnection(context);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            LookupList typeSelect = new LookupList(db, "lookup_opportunity_types");
            typeSelect.addItem(0, systemStatus.getLabel("accounts.allTypes", "All Types"));
            context.getRequest().setAttribute("TypeSelect", (Object)typeSelect);
            AccessTypeList accessTypeList = null;
            accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            User thisRec = this.getUser(context, userId);
            UserList shortChildList = thisRec.getShortChildList();
            UserList userList = thisRec.getFullChildList(shortChildList, new UserList());
            userList = UserList.sortEnabledUsers(userList, new UserList());
            userList.setMyId(userId);
            userList.setMyValue(thisRec.getContact().getNameLastFirst());
            userList.setIncludeMe(true);
            userList.setExcludeDisabledIfUnselected(true);
            userList.setExcludeExpiredIfUnselected(true);
            context.getRequest().setAttribute("UserList", (Object)userList);
            if (!"".equals(searchOppListInfo.getSearchOptionValue("searchcodeOrgId")) && !"-1".equals(searchOppListInfo.getSearchOptionValue("searchcodeOrgId"))) {
                String orgId = searchOppListInfo.getSearchOptionValue("searchcodeOrgId");
                Organization thisOrg = new Organization(db, Integer.parseInt(orgId));
                context.getRequest().setAttribute("OrgDetails", (Object)thisOrg);
            }
            if (!"".equals(searchOppListInfo.getSearchOptionValue("searchcodeContactId")) && !"-1".equals(searchOppListInfo.getSearchOptionValue("searchcodeContactId"))) {
                String id = searchOppListInfo.getSearchOptionValue("searchcodeContactId");
                Contact thisContact = new Contact(db, Integer.parseInt(id));
                context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            }
            LookupList stageSelect = new LookupList(db, "lookup_stage");
            stageSelect.addItem(-1, systemStatus.getLabel("pipeline.allstages", "All Stages"));
            context.getRequest().setAttribute("StageList", (Object)stageSelect);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            siteList.addItem(-2, systemStatus.getLabel("accounts.allSites"));
            siteList.setJsEvent("onChange=\"javascript:resetSiteData(this.form);\"");
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Search Opportunities", "Search Opportunities");
        return "SearchOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        Connection db = null;
        OpportunityHeader thisOpp = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        String id = null;
        if (!this.hasPermission(context, "pipeline-opportunities-delete")) {
            return "PermissionError";
        }
        if (context.getRequest().getParameter("id") != null) {
            id = context.getRequest().getParameter("id");
        }
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            thisOpp = new OpportunityHeader(db, id);
            DependencyList dependencies = thisOpp.processDependencies(db, this.allowMultiple(context));
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            if (dependencies.size() == 0) {
                htmlDialog.setShowAndConfirm(false);
                htmlDialog.setDeleteUrl("javascript:window.location.href='Leads.do?command=DeleteOpp&id=" + id + RequestUtils.addLinkParams(context.getRequest(), "viewSource") + "'");
            } else if (dependencies.canDelete()) {
                dependencies.setSystemStatus(systemStatus);
                htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
                htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='Leads.do?command=TrashOpp&id=" + id + RequestUtils.addLinkParams(context.getRequest(), "viewSource") + "'");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
            } else {
                htmlDialog.addMessage(dependencies.getHtmlString());
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.opportunity.cannotDeleteHeader"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDashboard(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-dashboard-view")) {
            if (!this.hasPermission(context, "pipeline-opportunities-view")) {
                return "PermissionError";
            }
            return this.executeCommandSearch(context);
        }
        this.addModuleBean(context, "Dashboard", "Dashboard");
        int idToUse = 0;
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        User thisRec = null;
        int overrideId = StringUtils.parseInt(context.getRequest().getParameter("oid"), -1);
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            overrideId = -1;
            context.getSession().removeAttribute("leadsoverride");
            context.getSession().removeAttribute("leadsothername");
            context.getSession().removeAttribute("leadspreviousId");
        }
        if (overrideId < 0) {
            overrideId = context.getSession().getAttribute("leadsoverride") != null ? StringUtils.parseInt((String)context.getSession().getAttribute("leadsoverride"), -1) : userId;
        }
        String checkFileName = null;
        Connection db = null;
        UserList fullChildList = new UserList();
        UserList shortChildList = new UserList();
        OpportunityComponentList realFullOppList = new OpportunityComponentList();
        HtmlSelect graphTypeSelect = new HtmlSelect();
        String graphString = null;
        if (context.getRequest().getParameter("whichGraph") != null) {
            graphString = context.getRequest().getParameter("whichGraph");
            context.getSession().setAttribute("pipelineGraph", (Object)graphString);
        } else {
            graphString = (String)context.getRequest().getSession().getAttribute("pipelineGraph") != null ? (String)context.getRequest().getSession().getAttribute("pipelineGraph") : "gmr";
        }
        Locale locale = this.getUser(context, this.getUserId(context)).getLocale();
        try {
            File checkFile;
            db = this.getConnection(context);
            UserList vpUserList = this.addViewpoints(db, context, "pipeline");
            viewpointInfo.setVpUserName(vpUserList);
            idToUse = this.hasViewpointAuthority(db, context, "pipeline", overrideId, userId) ? overrideId : this.getUserId(context);
            thisRec = this.getUser(context, idToUse);
            shortChildList = thisRec.getShortChildList();
            shortChildList = UserList.sortEnabledUsers(shortChildList, new UserList());
            if (context.getRequest().getParameter("oid") != null && !"true".equals(context.getRequest().getParameter("reset"))) {
                context.getRequest().setAttribute("override", (Object)String.valueOf(idToUse));
                context.getRequest().setAttribute("othername", (Object)thisRec.getContact().getNameFull());
                context.getRequest().setAttribute("previousId", (Object)String.valueOf(thisRec.getManagerId()));
                context.getSession().setAttribute("leadsoverride", (Object)String.valueOf(overrideId));
                context.getSession().setAttribute("leadsothername", (Object)thisRec.getContact().getNameFull());
                context.getSession().setAttribute("leadspreviousId", (Object)String.valueOf(thisRec.getManagerId()));
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            graphTypeSelect.setSelectName("whichGraph");
            graphTypeSelect.setJsEvent("onChange=\"document.Dashboard.submit();\"");
            graphTypeSelect.addItem("gmr", systemStatus.getLabel("pipeline.graphTypeSelect.item.GMR"));
            graphTypeSelect.addItem("ramr", systemStatus.getLabel("pipeline.graphTypeSelect.item.RAMR"));
            graphTypeSelect.addItem("cgmr", systemStatus.getLabel("pipeline.graphTypeSelect.item.CGMR"));
            graphTypeSelect.addItem("cramr", systemStatus.getLabel("pipeline.graphTypeSelect.item.CRAMR"));
            graphTypeSelect.setDefaultKey(graphString);
            PagedListInfo dashboardListInfo = this.getPagedListInfo(context, "DashboardListInfo");
            dashboardListInfo.setLink("Leads.do?command=Dashboard");
            dashboardListInfo.setColumnToSortBy("x.description");
            OpportunityHeaderList headerList = new OpportunityHeaderList();
            headerList.setPagedListInfo(dashboardListInfo);
            headerList.setOwner(idToUse);
            headerList.setQueryOpenOnly(true);
            headerList.setComponentsOwnedByUser(idToUse);
            headerList.setBuildTotalValues(true);
            headerList.setBuildActionPlans(true);
            headerList.buildList(db);
            context.getRequest().setAttribute("oppList", (Object)headerList);
            if (thisRec.getIsValid()) {
                if (graphString.equals("gmr")) {
                    checkFileName = thisRec.getGmr().getLastFileName();
                } else if (graphString.equals("ramr")) {
                    checkFileName = thisRec.getRamr().getLastFileName();
                } else if (graphString.equals("cgmr")) {
                    checkFileName = thisRec.getCgmr().getLastFileName();
                } else if (graphString.equals("cramr")) {
                    checkFileName = thisRec.getCramr().getLastFileName();
                }
            }
            if (checkFileName != null && !(checkFile = new File(context.getServletContext().getRealPath("/") + "graphs" + fs + checkFileName + ".jpg")).exists()) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Leads-> Invalidating data, file not found: " + context.getServletContext().getRealPath("/") + "graphs" + fs + checkFileName + ".jpg");
                }
                thisRec.setIsValid(false, true);
                checkFileName = null;
            }
            if (checkFileName == null) {
                fullChildList = thisRec.getFullChildList(shortChildList, new UserList());
                fullChildList = UserList.sortEnabledUsers(fullChildList, new UserList());
                String range = fullChildList.getUserListIds(idToUse);
                realFullOppList.setOwnerIdRange(range);
                realFullOppList.setQueryOpenOnly(true);
                realFullOppList.setIncludeOnlyForGraph(true);
                if (Leads.getPref(context, "OPPORTUNITY.DEFAULT_TERM") != null) {
                    realFullOppList.setDefaultTerms(Leads.getPref(context, "OPPORTUNITY.DEFAULT_TERM"));
                }
                if (Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS") != null) {
                    realFullOppList.setDefaultUnits(Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS"));
                }
                Calendar calendar = Calendar.getInstance(this.getUserTimeZone(context), UserUtils.getUserLocale(context.getRequest()));
                realFullOppList.setCloseDateEnd(new Timestamp(calendar.getTimeInMillis() + 34128000000L));
                realFullOppList.buildList(db);
            }
            shortChildList.buildPipelineValues(db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String systemStatus = "SystemError";
            return systemStatus;
        }
        finally {
            this.freeConnection(context, db);
        }
        try {
            if (checkFileName != null) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Leads-> Using cached chart");
                }
                context.getRequest().setAttribute("GraphFileName", (Object)checkFileName);
            } else {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Leads-> Preparing the chart");
                }
                OpportunityComponentList tempOppList = new OpportunityComponentList();
                for (OpportunityComponent tempOppComponent : realFullOppList) {
                    if (tempOppComponent.getOwner() != idToUse) continue;
                    tempOppList.add(tempOppComponent);
                }
                UserList tempUserList = new UserList();
                for (User thisRecord : fullChildList) {
                    tempUserList = this.prepareLines(context, thisRecord, realFullOppList, tempUserList);
                }
                UserList linesToDraw = new UserList();
                linesToDraw = this.calculateLine(tempUserList, linesToDraw);
                tempUserList = this.prepareLines(context, thisRec, tempOppList, tempUserList);
                linesToDraw = this.calculateLine(thisRec, linesToDraw);
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Leads-> Drawing the chart");
                }
                XYSeriesCollection categoryData = this.createCategoryDataset(linesToDraw, graphString);
                JFreeChart chart = ChartFactory.createTimeSeriesChart((String)"", (String)"", (String)"", (XYDataset)categoryData, (boolean)false, (boolean)true, (boolean)false);
                chart.setBackgroundPaint((Paint)Color.white);
                SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, locale);
                XYPlot plot = chart.getXYPlot();
                ValueAxis yAxis = plot.getRangeAxis();
                yAxis.setTickMarksVisible(true);
                yAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits((Locale)locale));
                DateAxis axis = (DateAxis)plot.getDomainAxis();
                axis.setDateFormatOverride((DateFormat)sdf);
                XYItemRenderer renderer = plot.getRenderer();
                if (renderer instanceof StandardXYItemRenderer) {
                    StandardXYItemRenderer rr = (StandardXYItemRenderer)renderer;
                    rr.setPlotShapes(true);
                    rr.setShapesFilled(false);
                    rr.setItemLabelsVisible(true);
                    StandardXYToolTipGenerator ttg = new StandardXYToolTipGenerator("{2} ({1})", (DateFormat)sdf, NumberFormat.getInstance(locale));
                    rr.setToolTipGenerator((XYToolTipGenerator)ttg);
                }
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Leads-> Drawing the chart");
                }
                int width = 275;
                int height = 200;
                String filePath = context.getServletContext().getRealPath("/") + "graphs" + fs;
                File graphDirectory = new File(filePath);
                if (!graphDirectory.exists()) {
                    graphDirectory.mkdirs();
                }
                Date testDate = new Date();
                String fileName = String.valueOf(idToUse) + String.valueOf(testDate.getTime()) + String.valueOf(context.getSession().getCreationTime());
                ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
                File imageFile = new File(filePath + fileName + ".jpg");
                ChartUtilities.saveChartAsJPEG((File)imageFile, (float)1.0f, (JFreeChart)chart, (int)width, (int)height, (ChartRenderingInfo)info);
                PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(filePath + fileName + ".map")));
                ChartUtilities.writeImageMap((PrintWriter)pw, (String)fileName, (ChartRenderingInfo)info, (boolean)false);
                pw.flush();
                pw.close();
                if (graphString.equals("gmr")) {
                    thisRec.getGmr().setLastFileName(fileName);
                } else if (graphString.equals("ramr")) {
                    thisRec.getRamr().setLastFileName(fileName);
                } else if (graphString.equals("cgmr")) {
                    thisRec.getCgmr().setLastFileName(fileName);
                } else if (graphString.equals("cramr")) {
                    thisRec.getCramr().setLastFileName(fileName);
                }
                context.getRequest().setAttribute("GraphFileName", (Object)fileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            System.out.println("Leads-> GraphicsError exception occurred here");
            return "GraphicsError";
        }
        context.getRequest().setAttribute("ShortChildList", (Object)shortChildList);
        context.getRequest().setAttribute("GraphTypeList", (Object)graphTypeSelect);
        return "DashboardOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteOpp(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-delete")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        boolean recordDeleted = false;
        OpportunityHeader newOpp = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            newOpp = new OpportunityHeader(db, context.getRequest().getParameter("id"));
            if (!this.hasViewpointAuthority(db, context, "pipeline", newOpp.getManager(), userId)) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = newOpp.delete(db, context, Leads.getDbNamePath(context));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Opportunities", "Delete an opportunity");
        if (recordDeleted) {
            context.getRequest().setAttribute("refreshUrl", (Object)"Leads.do?command=Search");
            this.deleteRecentItem(context, (Object)newOpp);
            return "OppDeleteOK";
        }
        this.processErrors(context, newOpp.getErrors());
        return this.executeCommandSearch(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandTrashOpp(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-delete")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        boolean recordUpdated = false;
        OpportunityHeader newOpp = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            newOpp = new OpportunityHeader(db, context.getRequest().getParameter("id"));
            if (!this.hasViewpointAuthority(db, context, "pipeline", newOpp.getManager(), userId)) {
                String string = "PermissionError";
                return string;
            }
            recordUpdated = newOpp.updateStatus(db, context, true, this.getUserId(context));
            newOpp.invalidateUserData(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordUpdated) {
            context.getRequest().setAttribute("refreshUrl", (Object)"Leads.do?command=Search");
            this.deleteRecentItem(context, (Object)newOpp);
            return "OppDeleteOK";
        }
        this.processErrors(context, newOpp.getErrors());
        return this.executeCommandSearch(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRestoreOpp(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-delete")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        boolean recordUpdated = false;
        OpportunityHeader newOpp = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            newOpp = new OpportunityHeader(db, context.getRequest().getParameter("id"));
            if (!this.hasViewpointAuthority(db, context, "pipeline", newOpp.getManager(), userId)) {
                String string = "PermissionError";
                return string;
            }
            recordUpdated = newOpp.updateStatus(db, context, false, this.getUserId(context));
            newOpp.invalidateUserData(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("headerId", (Object)context.getRequest().getParameter("id"));
        return this.executeCommandDetailsOpp(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteComponent(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-delete")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        boolean recordDeleted = false;
        OpportunityComponent component = null;
        OpportunityHeader header = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            component = new OpportunityComponent(db, context.getRequest().getParameter("id"));
            header = new OpportunityHeader(db, component.getHeaderId());
            if (!this.hasViewpointAuthority(db, context, "pipeline", component.getOwner(), userId) && !this.hasViewpointAuthority(db, context, "pipeline", header.getManager(), userId)) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = component.delete(db, context);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordDeleted) {
            this.deleteRecentItem(context, (Object)component);
            if (context.getRequest().getParameter("return") != null && context.getRequest().getParameter("return").equals("list")) {
                context.getRequest().setAttribute("refreshUrl", (Object)"Leads.do?command=Search");
                return "ComponentDeleteOK";
            }
            context.getRequest().setAttribute("refreshUrl", (Object)("Leads.do?command=DetailsOpp&headerId=" + component.getHeaderId()));
            return "ComponentDeleteOK";
        }
        this.processErrors(context, component.getErrors());
        return this.executeCommandSearch(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmComponentDelete(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-delete")) {
            return "PermissionError";
        }
        HtmlDialog htmlDialog = new HtmlDialog();
        String id = context.getRequest().getParameter("id");
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            htmlDialog.setShowAndConfirm(false);
            htmlDialog.setDeleteUrl("javascript:window.location.href='LeadsComponents.do?command=DeleteComponent&id=" + id + "&return=" + context.getRequest().getParameter("return") + "'");
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyComponent(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-edit")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        Connection db = null;
        OpportunityComponent component = null;
        this.addModuleBean(context, "View Opportunities", "Opportunities");
        String componentId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            component = new OpportunityComponent(db, componentId);
            OpportunityHeader oppHeader = new OpportunityHeader(db, component.getHeaderId());
            context.getRequest().setAttribute("opportunityHeader", (Object)oppHeader);
            if (!this.hasViewpointAuthority(db, context, "pipeline", component.getOwner(), userId) && !this.hasViewpointAuthority(db, context, "pipeline", oppHeader.getManager(), userId)) {
                String string = "PermissionError";
                return string;
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String systemStatus = "SystemError";
            return systemStatus;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("ComponentDetails", (Object)component);
        this.addRecentItem(context, (Object)component);
        User thisRec = this.getUser(context, userId);
        UserList shortChildList = thisRec.getShortChildList();
        UserList userList = thisRec.getFullChildList(shortChildList, new UserList());
        userList = UserList.sortEnabledUsers(userList, new UserList());
        userList.setMyId(userId);
        userList.setMyValue(thisRec.getContact().getNameLastFirst());
        userList.setIncludeMe(true);
        userList.setExcludeDisabledIfUnselected(true);
        userList.setExcludeExpiredIfUnselected(true);
        context.getRequest().setAttribute("UserList", (Object)userList);
        if (context.getRequest().getParameter("popup") != null) {
            return "ModifyPopupOK";
        }
        return this.executeCommandPrepare(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyOpp(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-edit")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Opportunities", "Modify Opportunity");
        Connection db = null;
        OpportunityHeader thisHeader = null;
        int headerId = Integer.parseInt(context.getRequest().getParameter("headerId"));
        try {
            db = this.getConnection(context);
            thisHeader = new OpportunityHeader();
            thisHeader.setBuildComponentCount(true);
            thisHeader.setBuildRecordDetails(true);
            thisHeader.queryRecord(db, headerId);
            context.getRequest().setAttribute("opportunityHeader", (Object)thisHeader);
            this.addRecentItem(context, (Object)thisHeader);
            String string = Leads.getReturn(context, "ModifyOpp");
            return string;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearch(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-view")) {
            return "PermissionError";
        }
        PagedListInfo searchOppListInfo = this.getPagedListInfo(context, "SearchOppListInfo");
        searchOppListInfo.setLink("Leads.do?command=Search");
        SystemStatus systemStatus = this.getSystemStatus(context);
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int vpUserId = viewpointInfo.getVpUserId(this.getUserId(context));
        int userId = this.getUserId(context);
        boolean fetchedList = false;
        boolean isValid = false;
        if (vpUserId != -1 && vpUserId != userId) {
            userId = vpUserId;
        }
        Connection db = null;
        OpportunityList oppList = new OpportunityList();
        try {
            db = this.getConnection(context);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            LookupList typeSelect = new LookupList(db, "lookup_opportunity_types");
            typeSelect.addItem(0, systemStatus.getLabel("accounts.allTypes", "All Types"));
            context.getRequest().setAttribute("TypeSelect", (Object)typeSelect);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
            context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            oppList.setPagedListInfo(searchOppListInfo);
            searchOppListInfo.setIsValid(true);
            searchOppListInfo.setSearchCriteria(oppList, context);
            if (oppList.getSiteId() == -2) {
                oppList.setSiteId(this.getUser(context, vpUserId).getSiteId());
                oppList.setIncludeAllSites(true);
            } else {
                oppList.setIncludeAllSites(false);
            }
            if (626030335 == accessTypeList.getRuleId(oppList.getAccessType())) {
                if (searchOppListInfo.getFilterKey("listFilter2") != -1) {
                    oppList.setControlledHierarchy(1, this.getUserRange(context, searchOppListInfo.getFilterKey("listFilter2")));
                } else if (!this.excludeHierarchy(context)) {
                    oppList.setControlledHierarchy(1, this.getUserRange(context, userId));
                }
            } else if (626030334 == accessTypeList.getRuleId(oppList.getAccessType())) {
                if (searchOppListInfo.getFilterKey("listFilter2") != -1) {
                    oppList.setControlledHierarchy(0, this.getUserRange(context, searchOppListInfo.getFilterKey("listFilter2")));
                } else if (!this.excludeHierarchy(context)) {
                    oppList.setControlledHierarchy(0, this.getUserRange(context, userId));
                }
            } else {
                oppList.setOwner(userId);
                oppList.setControlledHierarchyOnly(-1);
            }
            if ("open".equals(searchOppListInfo.getListView())) {
                oppList.setQueryOpenOnly(true);
            } else if ("closed".equals(searchOppListInfo.getListView())) {
                oppList.setQueryClosedOnly(true);
            }
            oppList.setTypeId(searchOppListInfo.getFilterKey("listFilter1"));
            isValid = searchOppListInfo.getIsValid();
            if (isValid) {
                fetchedList = oppList.buildList(db);
            }
            context.getRequest().setAttribute("OpportunityList", (Object)oppList);
            User thisRec = this.getUser(context, userId);
            UserList shortChildList = thisRec.getShortChildList();
            UserList userList = thisRec.getFullChildList(shortChildList, new UserList());
            userList = UserList.sortEnabledUsers(userList, new UserList());
            userList.setMyId(userId);
            userList.setMyValue(thisRec.getContact().getNameLastFirst());
            userList.setIncludeMe(true);
            userList.setExcludeDisabledIfUnselected(true);
            userList.setExcludeExpiredIfUnselected(true);
            context.getRequest().setAttribute("UserList", (Object)userList);
            this.addModuleBean(context, "View Opportunities", "Opportunities Add");
            if (fetchedList) {
                OrganizationList disabledOrgs = new OrganizationList();
                disabledOrgs.setIncludeEnabled(0);
                disabledOrgs.buildList(db);
                context.getRequest().setAttribute("disabledOrgs", (Object)disabledOrgs);
                String string = "OppListOK";
                return string;
            }
            this.processErrors(context, oppList.getErrors());
            String string = this.executeCommandSearchForm(context);
            return string;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateOpp(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-edit")) {
            return "PermissionError";
        }
        boolean isValid = false;
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        Connection db = null;
        int resultCount = 0;
        String headerId = context.getRequest().getParameter("headerId");
        String type = context.getRequest().getParameter("type");
        try {
            db = this.getConnection(context);
            OpportunityHeader oldHeader = new OpportunityHeader(db, headerId);
            OpportunityHeader oppHeader = new OpportunityHeader(db, headerId);
            if (!this.hasViewpointAuthority(db, context, "pipeline", oppHeader.getManager(), userId)) {
                String string = "PermissionError";
                return string;
            }
            oppHeader.setModifiedBy(this.getUserId(context));
            oppHeader.setDescription(context.getRequest().getParameter("description"));
            if (type.equals("contact")) {
                oppHeader.setContactLink(context.getRequest().getParameter("contactLink"));
                oppHeader.setAccountLink(-1);
            } else if (type.equals("org")) {
                oppHeader.setAccountLink(context.getRequest().getParameter("accountLink"));
                oppHeader.setContactLink(-1);
            }
            isValid = this.validateObject(context, db, (Object)oppHeader);
            if (isValid) {
                resultCount = oppHeader.update(db);
            }
            if (resultCount == 1) {
                oppHeader.checkResetActionStepAttachment(db, oldHeader);
                this.processUpdateHook(context, (Object)oldHeader, (Object)oppHeader);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == 1) {
            if (context.getRequest().getParameter("return") != null && context.getRequest().getParameter("return").equals("list")) {
                return this.executeCommandSearch(context);
            }
            return this.executeCommandDetailsOpp(context);
        }
        if (resultCount == -1 || !isValid) {
            return this.executeCommandModifyOpp(context);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetailsComponent(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-view")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        this.addModuleBean(context, "View Opportunities", "Component Details");
        String componentId = context.getRequest().getParameter("id");
        OpportunityComponent thisComponent = null;
        OpportunityHeader header = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            AccessTypeList accessTypeList = null;
            accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            thisComponent = new OpportunityComponent(db, Integer.parseInt(componentId));
            header = new OpportunityHeader(db, thisComponent.getHeaderId());
            if (!this.hasViewpointAuthority(db, context, "pipeline", thisComponent.getOwner(), userId) && accessTypeList.getCode(626030334) != header.getAccessType()) {
                String string = "PermissionError";
                return string;
            }
            thisComponent.checkEnabledOwnerAccount(db);
            context.getRequest().setAttribute("opportunityHeader", (Object)header);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("LeadsComponentDetails", (Object)thisComponent);
        this.addRecentItem(context, (Object)thisComponent);
        return "DetailsComponentOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandComponentHistoryDetails(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-view")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        this.addModuleBean(context, "View Opportunities", "Component Details");
        String historyId = context.getRequest().getParameter("id");
        String componentId = context.getRequest().getParameter("componentId");
        String headerId = context.getRequest().getParameter("headerId");
        OpportunityComponentLog thisComponentLog = null;
        OpportunityComponent component = null;
        OpportunityHeader header = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisComponentLog = new OpportunityComponentLog(db, Integer.parseInt(historyId));
            if (componentId != null && !"".equals(componentId.trim()) && Integer.parseInt(componentId) != -1) {
                component = new OpportunityComponent(db, Integer.parseInt(componentId));
                context.getRequest().setAttribute("opportunityComponent", (Object)component);
            }
            if (headerId != null && !"".equals(headerId.trim())) {
                header = new OpportunityHeader(db, Integer.parseInt(headerId));
                context.getRequest().setAttribute("opportunityHeader", (Object)header);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("componentLogDetails", (Object)thisComponentLog);
        return "ComponentHistoryDetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandComponentHistory(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-view")) {
            return "PermissionError";
        }
        int headerId = -1;
        int componentId = -1;
        PagedListInfo componentHistoryListInfo = this.getPagedListInfo(context, "componentHistoryListInfo");
        OpportunityHeader thisHeader = null;
        OpportunityComponent thisComponent = null;
        OpportunityComponentLogList componentLogList = null;
        this.addModuleBean(context, "View Opportunities", "View Opportunity Details");
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        headerId = context.getRequest().getParameter("headerId") != null ? Integer.parseInt(context.getRequest().getParameter("headerId")) : Integer.parseInt((String)context.getRequest().getAttribute("headerId"));
        if (context.getRequest().getParameter("id") != null) {
            componentId = Integer.parseInt(context.getRequest().getParameter("id"));
        } else if (context.getRequest().getAttribute("id") != null) {
            componentId = Integer.parseInt((String)context.getRequest().getAttribute("id"));
        }
        Connection db = null;
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            context.getSession().removeAttribute("componentHistoryListInfo");
        }
        componentHistoryListInfo.setLink("LeadsComponents.do?command=ComponentHistory&headerId=" + headerId + RequestUtils.addLinkParams(context.getRequest(), "id|viewSource"));
        try {
            db = this.getConnection(context);
            if (componentId > -1) {
                thisComponent = new OpportunityComponent();
                thisComponent.queryRecord(db, componentId);
                context.getRequest().setAttribute("opportunityComponent", (Object)thisComponent);
            }
            thisHeader = new OpportunityHeader();
            thisHeader.setBuildComponentCount(true);
            thisHeader.queryRecord(db, headerId);
            context.getRequest().setAttribute("opportunityHeader", (Object)thisHeader);
            componentLogList = new OpportunityComponentLogList();
            componentLogList.setPagedListInfo(componentHistoryListInfo);
            componentLogList.setHeaderId(thisHeader.getId());
            if (componentId > -1) {
                componentLogList.setComponentId(componentId);
            }
            componentLogList.buildList(db);
            context.getRequest().setAttribute("componentHistoryList", (Object)componentLogList);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ComponentHistoryOK";
    }

    private UserList prepareLines(ActionContext context, User pertainsTo, OpportunityComponentList oppList, UserList usersToGraph) {
        Timestamp myDate = null;
        Calendar readDate = Calendar.getInstance();
        Calendar readDateAdjusted = Calendar.getInstance();
        int x = 0;
        Double ramrAddTerm = new Double(0.0);
        Double gmrAddTerm = new Double(0.0);
        Double cgmrAddTerm = new Double(0.0);
        Double cramrAddTerm = new Double(0.0);
        String valKey = "";
        Calendar rightNow = Calendar.getInstance();
        rightNow.set(5, 1);
        Calendar rightNowAdjusted = Calendar.getInstance();
        rightNowAdjusted.set(5, 1);
        rightNowAdjusted.add(5, -1);
        Calendar twelveMonths = Calendar.getInstance();
        twelveMonths.set(5, 1);
        twelveMonths.add(2, 13);
        if (!pertainsTo.getIsValid()) {
            pertainsTo.doOpportunityLock();
            if (!pertainsTo.getIsValid()) {
                try {
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("Leads-> (RE)BUILDING DATA FOR " + pertainsTo.getId());
                    }
                    pertainsTo.setGmr(new GraphSummaryList());
                    pertainsTo.setRamr(new GraphSummaryList());
                    pertainsTo.setCgmr(new GraphSummaryList());
                    pertainsTo.setCramr(new GraphSummaryList());
                    for (OpportunityComponent tempOpp : oppList) {
                        if (tempOpp.getOwner() != pertainsTo.getId()) continue;
                        myDate = tempOpp.getCloseDate();
                        readDate.setTime(myDate);
                        readDateAdjusted.setTime(myDate);
                        if (Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS") != null && Leads.getPref(context, "OPPORTUNITY.DEFAULT_TERM") != null) {
                            readDateAdjusted.add(2, (int)Math.round(tempOpp.getTermsInMonths(Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS"), Leads.getPref(context, "OPPORTUNITY.DEFAULT_TERM"))));
                        } else {
                            readDateAdjusted.add(2, (int)Math.round(tempOpp.getTermsInMonths()));
                        }
                        if (readDate.get(5) >= 15) {
                            readDate.add(2, 1);
                        }
                        valKey = String.valueOf(readDate.get(1)) + String.valueOf(readDate.get(2));
                        gmrAddTerm = Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS") != null && Leads.getPref(context, "OPPORTUNITY.DEFAULT_TERM") != null && Leads.getPref(context, "OPPORTUNITY.MULTIPLIER") != null ? new Double(tempOpp.getGuess(Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS"), Leads.getPref(context, "OPPORTUNITY.MULTIPLIER")) / tempOpp.getTermsInMonths(Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS"), Leads.getPref(context, "OPPORTUNITY.DEFAULT_TERM"))) : new Double(tempOpp.getGuess() / tempOpp.getTermsInMonths());
                        ramrAddTerm = Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS") != null && Leads.getPref(context, "OPPORTUNITY.DEFAULT_TERM") != null && Leads.getPref(context, "OPPORTUNITY.MULTIPLIER") != null ? new Double(tempOpp.getGuess(Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS"), Leads.getPref(context, "OPPORTUNITY.MULTIPLIER")) / tempOpp.getTermsInMonths(Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS"), Leads.getPref(context, "OPPORTUNITY.DEFAULT_TERM")) * tempOpp.getCloseProb()) : new Double(tempOpp.getGuess() / tempOpp.getTermsInMonths() * tempOpp.getCloseProb());
                        cgmrAddTerm = Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS") != null && Leads.getPref(context, "OPPORTUNITY.DEFAULT_TERM") != null && Leads.getPref(context, "OPPORTUNITY.MULTIPLIER") != null ? new Double(tempOpp.getGuess(Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS"), Leads.getPref(context, "OPPORTUNITY.MULTIPLIER")) / tempOpp.getTermsInMonths(Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS"), Leads.getPref(context, "OPPORTUNITY.DEFAULT_TERM")) * tempOpp.getCommission()) : new Double(tempOpp.getGuess() / tempOpp.getTermsInMonths() * tempOpp.getCommission());
                        cramrAddTerm = Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS") != null && Leads.getPref(context, "OPPORTUNITY.DEFAULT_TERM") != null && Leads.getPref(context, "OPPORTUNITY.MULTIPLIER") != null ? new Double(tempOpp.getGuess(Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS"), Leads.getPref(context, "OPPORTUNITY.MULTIPLIER")) / tempOpp.getTermsInMonths(Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS"), Leads.getPref(context, "OPPORTUNITY.DEFAULT_TERM")) * tempOpp.getCloseProb() * tempOpp.getCommission()) : new Double(tempOpp.getGuess() / tempOpp.getTermsInMonths() * tempOpp.getCloseProb() * tempOpp.getCommission());
                        if ((rightNow.before(readDate) || rightNowAdjusted.before(readDate)) && twelveMonths.after(readDate) || rightNow.equals(readDate) || twelveMonths.equals(readDate)) {
                            pertainsTo.setGraphValues(valKey, gmrAddTerm, ramrAddTerm, cgmrAddTerm, cramrAddTerm);
                        } else if (rightNowAdjusted.after(readDate) && (rightNow.before(readDateAdjusted) || rightNowAdjusted.before(readDateAdjusted))) {
                            pertainsTo.setGraphValues(valKey, gmrAddTerm, ramrAddTerm, cgmrAddTerm, cramrAddTerm);
                        }
                        if (Math.round(Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS") != null && Leads.getPref(context, "OPPORTUNITY.DEFAULT_TERM") != null ? tempOpp.getTermsInMonths(Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS"), Leads.getPref(context, "OPPORTUNITY.DEFAULT_TERM")) : tempOpp.getTermsInMonths()) <= 1L) continue;
                        x = 1;
                        while ((long)x < Math.round(tempOpp.getTermsInMonths(Leads.getPref(context, "OPPORTUNITY.DEFAULT_UNITS"), Leads.getPref(context, "OPPORTUNITY.DEFAULT_TERM")))) {
                            readDate.add(2, 1);
                            if ((rightNow.before(readDate) || rightNowAdjusted.before(readDate)) && twelveMonths.after(readDate) || rightNow.equals(readDate) || twelveMonths.equals(readDate)) {
                                valKey = String.valueOf(readDate.get(1)) + String.valueOf(readDate.get(2));
                                pertainsTo.setGraphValues(valKey, gmrAddTerm, ramrAddTerm, cgmrAddTerm, cramrAddTerm);
                            }
                            ++x;
                        }
                    }
                    pertainsTo.setIsValid(true, true);
                }
                catch (Exception e) {
                    System.err.println("Leads-> Unwanted exception occurred: " + e.toString());
                }
            }
            pertainsTo.doOpportunityUnlock();
        }
        usersToGraph.add(pertainsTo);
        if (oppList.size() == 0) {
            return new UserList();
        }
        return usersToGraph;
    }

    private XYSeriesCollection createCategoryDataset(UserList linesToDraw, String whichGraph) {
        XYSeriesCollection xyDataset = new XYSeriesCollection();
        if (System.getProperty("DEBUG") != null) {
            System.out.println("Leads-> Lines to draw: " + linesToDraw.size());
        }
        if (linesToDraw.size() == 0) {
            return xyDataset;
        }
        for (User thisUser : linesToDraw) {
            XYSeries dataSeries = new XYSeries((Comparable)((Object)""));
            String[] valKeys = thisUser.getGmr().getRange(12);
            Calendar iteratorDate = Calendar.getInstance();
            for (int count = 0; count < 12; ++count) {
                Date dateValue = Leads.createDate(iteratorDate.get(1), iteratorDate.get(2), 1);
                Double itemValue = new Double(0.0);
                if (whichGraph.equals("gmr")) {
                    itemValue = thisUser.getGmr().getValue(valKeys[count]);
                } else if (whichGraph.equals("ramr")) {
                    itemValue = thisUser.getRamr().getValue(valKeys[count]);
                } else if (whichGraph.equals("cgmr")) {
                    itemValue = thisUser.getCgmr().getValue(valKeys[count]);
                } else if (whichGraph.equals("cramr")) {
                    itemValue = thisUser.getCramr().getValue(valKeys[count]);
                }
                iteratorDate.add(2, 1);
                dataSeries.add((double)dateValue.getTime(), (Number)itemValue);
            }
            xyDataset.addSeries(dataSeries);
        }
        return xyDataset;
    }

    private UserList calculateLine(User primaryNode, UserList currentLines) {
        if (currentLines.size() == 0) {
            currentLines.add(primaryNode);
            return currentLines;
        }
        User thisLine = new User();
        String[] valKeys = thisLine.getGmr().getRange(12);
        Iterator x = currentLines.iterator();
        User addToMe = (User)((Object)x.next());
        for (int count = 0; count < 12; ++count) {
            thisLine.getGmr().setValue(valKeys[count], new Double(primaryNode.getGmr().getValue(valKeys[count]) + addToMe.getGmr().getValue(valKeys[count])));
            thisLine.getRamr().setValue(valKeys[count], new Double(primaryNode.getRamr().getValue(valKeys[count]) + addToMe.getRamr().getValue(valKeys[count])));
            thisLine.getCgmr().setValue(valKeys[count], new Double(primaryNode.getCgmr().getValue(valKeys[count]) + addToMe.getCgmr().getValue(valKeys[count])));
            thisLine.getCramr().setValue(valKeys[count], new Double(primaryNode.getCramr().getValue(valKeys[count]) + addToMe.getCramr().getValue(valKeys[count])));
        }
        currentLines.add(thisLine);
        return currentLines;
    }

    private UserList calculateLine(UserList toRollUp, UserList currentLines) {
        if (toRollUp.size() == 0) {
            return new UserList();
        }
        User thisLine = new User();
        String[] valKeys = thisLine.getGmr().getRange(12);
        for (User thisUser : toRollUp) {
            for (int count = 0; count < 12; ++count) {
                thisLine.getGmr().setValue(valKeys[count], thisUser.getGmr().getValue(valKeys[count]));
                thisLine.getRamr().setValue(valKeys[count], thisUser.getRamr().getValue(valKeys[count]));
                thisLine.getCgmr().setValue(valKeys[count], thisUser.getCgmr().getValue(valKeys[count]));
                thisLine.getCramr().setValue(valKeys[count], thisUser.getCramr().getValue(valKeys[count]));
            }
        }
        currentLines.add(thisLine);
        return currentLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAccessTypeJSList(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return Leads.getReturn(context, "AccessTypeJSList");
    }

    private boolean allowMultiple(ActionContext context) {
        String multiple = this.getSystemPref(context, OpportunityComponent.MULTPLE_CONFIG_NAME, "multiple");
        return OpportunityComponent.allowMultiple(multiple);
    }

    private boolean excludeHierarchy(ActionContext context) {
        String exclude = this.getSystemPref(context, OpportunityComponent.MULTPLE_CONFIG_NAME, "excludeHierarchy");
        return DatabaseUtils.parseBoolean(exclude);
    }
}

