/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.contacts.base.Call;
import org.aspcfs.modules.contacts.base.CallList;
import org.aspcfs.modules.contacts.base.CallResult;
import org.aspcfs.modules.contacts.base.CallResultList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.mycfs.base.CFSNote;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;
import org.aspcfs.utils.web.ViewpointInfo;

public final class LeadsCalls
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        int MINIMIZED_ITEMS_PER_PAGE = 5;
        if (!this.hasPermission(context, "pipeline-opportunities-calls-view")) {
            return "PermissionError";
        }
        String headerId = context.getRequest().getParameter("headerId");
        this.addModuleBean(context, "View Opportunities", "Opportunity Activities");
        PagedListInfo leadsCallListInfo = this.getPagedListInfo(context, "LeadsCallListInfo");
        leadsCallListInfo.setLink("LeadsCalls.do?command=View&headerId=" + headerId + RequestUtils.addLinkParams(context.getRequest(), "viewSource"));
        if ("true".equals(context.getRequest().getParameter("resetList"))) {
            context.getSession().removeAttribute("LeadsCallsListInfo");
            context.getSession().removeAttribute("LeadsCompletedCallsListInfo");
        }
        String sectionId = null;
        if (context.getRequest().getParameter("pagedListSectionId") != null) {
            sectionId = context.getRequest().getParameter("pagedListSectionId");
        }
        Connection db = null;
        CallList callList = new CallList();
        callList.setOppHeaderId(Integer.parseInt(headerId));
        String pendingPagedListId = "LeadsCallsListInfo";
        if (sectionId == null || pendingPagedListId.equals(sectionId)) {
            PagedListInfo callListInfo = this.getPagedListInfo(context, pendingPagedListId, "c.alertdate", null);
            callListInfo.setLink("LeadsCalls.do?command=View&headerId=" + headerId + RequestUtils.addLinkParams(context.getRequest(), "viewSource"));
            if (sectionId == null) {
                if (!callListInfo.getExpandedSelection()) {
                    if (callListInfo.getItemsPerPage() != MINIMIZED_ITEMS_PER_PAGE) {
                        callListInfo.setItemsPerPage(MINIMIZED_ITEMS_PER_PAGE);
                    }
                } else if (callListInfo.getItemsPerPage() == MINIMIZED_ITEMS_PER_PAGE) {
                    callListInfo.setItemsPerPage(10);
                }
            } else if (sectionId.equals(callListInfo.getId())) {
                callListInfo.setExpandedSelection(true);
            }
            callList.setPagedListInfo(callListInfo);
            callList.setOnlyPending(true);
        }
        CallList completedCallList = new CallList();
        completedCallList.setOppHeaderId(Integer.parseInt(headerId));
        String completedPagedListId = "LeadsCompletedCallsListInfo";
        if (sectionId == null || completedPagedListId.equals(sectionId)) {
            PagedListInfo completedCallListInfo = this.getPagedListInfo(context, completedPagedListId, "c.entered", "desc");
            completedCallListInfo.setLink("LeadsCalls.do?command=View&headerId=" + headerId + RequestUtils.addLinkParams(context.getRequest(), "viewSource"));
            if (sectionId == null) {
                if (!completedCallListInfo.getExpandedSelection()) {
                    if (completedCallListInfo.getItemsPerPage() != MINIMIZED_ITEMS_PER_PAGE) {
                        completedCallListInfo.setItemsPerPage(MINIMIZED_ITEMS_PER_PAGE);
                    }
                } else if (completedCallListInfo.getItemsPerPage() == MINIMIZED_ITEMS_PER_PAGE) {
                    completedCallListInfo.setItemsPerPage(10);
                }
            } else if (sectionId.equals(completedCallListInfo.getId())) {
                completedCallListInfo.setExpandedSelection(true);
            }
            completedCallList.setPagedListInfo(completedCallListInfo);
        }
        try {
            db = this.getConnection(context);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            OpportunityHeader oppHeader = new OpportunityHeader(db, headerId);
            oppHeader.buildManagerOwnerIdRange(db, accessTypeList, this.getUserRange(context));
            context.getRequest().setAttribute("opportunityHeader", (Object)oppHeader);
            if (oppHeader.isTrashed()) {
                callList.setIncludeOnlyTrashed(true);
            }
            if (sectionId == null || pendingPagedListId.equals(sectionId)) {
                callList.buildList(db);
            }
            if (oppHeader.isTrashed()) {
                completedCallList.setIncludeOnlyTrashed(true);
            }
            if (sectionId == null || completedPagedListId.equals(sectionId)) {
                completedCallList.buildList(db);
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList callTypeList = systemStatus.getLookupList(db, "lookup_call_types");
            context.getRequest().setAttribute("CallTypeList", (Object)callTypeList);
            CallResultList resultList = new CallResultList();
            resultList.buildList(db);
            context.getRequest().setAttribute("callResultList", (Object)resultList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("CallList", (Object)callList);
        context.getRequest().setAttribute("CompletedCallList", (Object)completedCallList);
        return LeadsCalls.getReturn(context, "View");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandLog(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-calls-add")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        String headerId = context.getRequest().getParameter("headerId");
        this.addModuleBean(context, "View Opportunities", "Opportunity Activities");
        Connection db = null;
        try {
            db = this.getConnection(context);
            OpportunityHeader oppHeader = new OpportunityHeader(db, headerId);
            context.getRequest().setAttribute("opportunityHeader", (Object)oppHeader);
            if (oppHeader.getAccountLink() > -1) {
                Organization oppOrg = new Organization(db, oppHeader.getAccountLink());
                context.getRequest().setAttribute("OrgDetails", (Object)oppOrg);
                ContactList contactList = new ContactList();
                if (oppOrg.getOwner() != userId && userId != this.getUserId(context)) {
                    contactList.setOwner(userId);
                } else if (oppOrg.getOwner() == this.getUserId(context)) {
                    contactList.setOwner(this.getUserId(context));
                }
                contactList.setBuildDetails(false);
                contactList.setBuildTypes(false);
                contactList.setOrgId(oppHeader.getAccountLink());
                contactList.buildList(db);
                context.getRequest().setAttribute("ContactList", (Object)contactList);
            } else {
                Contact contact = new Contact(db, oppHeader.getContactLink());
                context.getRequest().setAttribute("ContactDetails", (Object)contact);
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList callTypeList = systemStatus.getLookupList(db, "lookup_call_types");
            callTypeList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CallTypeList", (Object)callTypeList);
            CallResultList resultList = new CallResultList();
            resultList.buildList(db);
            context.getRequest().setAttribute("callResultList", (Object)resultList);
            LookupList priorityList = systemStatus.getLookupList(db, "lookup_call_priority");
            context.getRequest().setAttribute("PriorityList", (Object)priorityList);
            LookupList reminderList = systemStatus.getLookupList(db, "lookup_call_reminder");
            reminderList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("ReminderTypeList", (Object)reminderList);
            context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (context.getRequest().getParameter("actionSource") != null) {
            return LeadsCalls.getReturn(context, "LogCall");
        }
        return LeadsCalls.getReturn(context, "Log");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSchedule(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-calls-add")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        String headerId = context.getRequest().getParameter("headerId");
        this.addModuleBean(context, "View Opportunities", "Opportunity Activities");
        Connection db = null;
        try {
            db = this.getConnection(context);
            OpportunityHeader oppHeader = new OpportunityHeader(db, headerId);
            context.getRequest().setAttribute("opportunityHeader", (Object)oppHeader);
            if (oppHeader.getAccountLink() > -1) {
                Organization oppOrg = new Organization(db, oppHeader.getAccountLink());
                context.getRequest().setAttribute("OrgDetails", (Object)oppOrg);
                ContactList contactList = new ContactList();
                if (oppOrg.getOwner() != userId && userId != this.getUserId(context)) {
                    contactList.setOwner(userId);
                } else if (oppOrg.getOwner() == this.getUserId(context)) {
                    contactList.setOwner(this.getUserId(context));
                }
                contactList.setBuildDetails(false);
                contactList.setBuildTypes(false);
                contactList.setOrgId(oppHeader.getAccountLink());
                contactList.buildList(db);
                context.getRequest().setAttribute("ContactList", (Object)contactList);
            } else {
                Contact contact = new Contact(db, oppHeader.getContactLink());
                context.getRequest().setAttribute("ContactDetails", (Object)contact);
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList callTypeList = systemStatus.getLookupList(db, "lookup_call_types");
            callTypeList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CallTypeList", (Object)callTypeList);
            CallResultList resultList = new CallResultList();
            resultList.buildList(db);
            context.getRequest().setAttribute("callResultList", (Object)resultList);
            LookupList priorityList = systemStatus.getLookupList(db, "lookup_call_priority");
            context.getRequest().setAttribute("PriorityList", (Object)priorityList);
            LookupList reminderList = systemStatus.getLookupList(db, "lookup_call_reminder");
            reminderList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("ReminderTypeList", (Object)reminderList);
            context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("action", (Object)"schedule");
        if (context.getRequest().getParameter("actionSource") != null) {
            return LeadsCalls.getReturn(context, "LogCall");
        }
        return LeadsCalls.getReturn(context, "Log");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        String permission = "pipeline-opportunities-calls-add";
        boolean recordInserted = false;
        boolean isValid = false;
        int resultCount = -1;
        Call parentCall = null;
        Call previousCall = null;
        int tmpStatusId = -1;
        this.addModuleBean(context, "View Opportunities", "Opportunity Activities");
        String parentId = context.getRequest().getParameter("parentId");
        String action = context.getRequest().getParameter("action");
        if ("schedule".equals(context.getRequest().getParameter("action"))) {
            context.getRequest().setAttribute("action", (Object)"schedule");
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        Call previousParentCall = null;
        Call thisCall = (Call)((Object)context.getFormBean());
        thisCall.setModifiedBy(this.getUserId(context));
        if (thisCall.getId() > 0) {
            permission = "pipeline-opportunities-calls-edit";
        }
        if (!this.hasPermission(context, permission)) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            String headerId = context.getRequest().getParameter("headerId");
            OpportunityHeader oppHeader = new OpportunityHeader(db, headerId);
            context.getRequest().setAttribute("opportunityHeader", (Object)oppHeader);
            if (thisCall.getId() > 0 && !this.hasViewpointAuthority(db, context, "pipeline", (previousCall = new Call(db, thisCall.getId())).getEnteredBy(), userId)) {
                String string = "PermissionError";
                return string;
            }
            if (parentId != null && Integer.parseInt(parentId) > -1) {
                parentCall = new Call(db, Integer.parseInt(parentId));
            }
            if ((tmpStatusId = thisCall.getStatusId()) == 3 && !"pending".equals(context.getRequest().getParameter("view"))) {
                thisCall.setCheckAlertDate(false);
            }
            if (thisCall.getId() > 0) {
                if (thisCall.getStatusId() == 2 && previousCall.getAlertDate() == null && thisCall.getAlertDate() != null) {
                    thisCall.setStatusId(3);
                }
                if (isValid = this.validateObject(context, db, (Object)thisCall)) {
                    resultCount = thisCall.update(db, context);
                }
            } else {
                if (thisCall.getId() == -1) {
                    if ("cancel".equals(action)) {
                        thisCall.setStatusId(1);
                    } else if (thisCall.getAlertDate() != null) {
                        thisCall.setStatusId(3);
                    } else {
                        thisCall.setStatusId(2);
                    }
                }
                thisCall.setEnteredBy(this.getUserId(context));
                if (parentCall != null && parentCall.getOppHeaderId() != -1) {
                    thisCall.setOppHeaderId(parentCall.getOppHeaderId());
                }
                if (isValid = this.validateObject(context, db, (Object)thisCall)) {
                    recordInserted = thisCall.insert(db, context);
                }
            }
            if (!recordInserted && resultCount == -1) {
                thisCall.setStatusId(tmpStatusId);
                if (thisCall.getId() > 0) {
                    Call tempCall = new Call(db, thisCall.getId());
                    if (thisCall.getAlertText() != null && !"".equals(thisCall.getAlertText())) {
                        thisCall.setHasFollowup(true);
                    }
                    thisCall.setCallType(tempCall.getCallType());
                    this.addModifyFormElements(db, context, thisCall);
                    if (resultCount == 0) {
                        HashMap<String, String> errors = new HashMap<String, String>();
                        SystemStatus systemStatus = this.getSystemStatus(context);
                        errors.put("actionError", systemStatus.getLabel("object.validation.recordUpdatedByAnotherUser"));
                        this.processErrors(context, errors);
                        context.getRequest().setAttribute("CallDetails", (Object)tempCall);
                    }
                }
            } else {
                if (parentCall != null) {
                    previousParentCall = new Call(db, parentCall.getId());
                    parentCall.setStatusId(2);
                    parentCall.update(db, context);
                    this.processUpdateHook(context, (Object)previousParentCall, (Object)parentCall);
                }
                thisCall = new Call(db, thisCall.getId());
                if (recordInserted) {
                    this.processInsertHook(context, (Object)thisCall);
                } else if (resultCount > 0) {
                    this.processUpdateHook(context, (Object)previousCall, (Object)thisCall);
                }
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            if (context.getRequest().getParameter("actionSource") != null) {
                return LeadsCalls.getReturn(context, "InsertCall");
            }
            return LeadsCalls.getReturn(context, "Insert");
        }
        if (resultCount == 1) {
            if ("list".equals(context.getRequest().getParameter("return"))) {
                return this.executeCommandView(context);
            }
            return "UpdateOK";
        }
        if (parentId != null && Integer.parseInt(parentId) > -1) {
            if (action != null && "cancel".equals(action)) {
                return this.executeCommandCancel(context);
            }
            return this.executeCommandComplete(context);
        }
        if (thisCall.getId() > 0) {
            return LeadsCalls.getReturn(context, "Modify");
        }
        return this.executeCommandLog(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-calls-view")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        String callId = context.getRequest().getParameter("id");
        String headerId = context.getRequest().getParameter("headerId");
        Connection db = null;
        Call thisCall = null;
        try {
            db = this.getConnection(context);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            thisCall = new Call(db, callId);
            OpportunityHeader oppHeader = new OpportunityHeader(db, headerId);
            oppHeader.buildManagerOwnerIdRange(db, accessTypeList, this.getUserRange(context));
            context.getRequest().setAttribute("opportunityHeader", (Object)oppHeader);
            if (!this.hasViewpointAuthority(db, context, "pipeline", thisCall.getEnteredBy(), userId) && oppHeader.getAccessType() != accessTypeList.getCode(626030334)) {
                String string = "PermissionError";
                return string;
            }
            if (thisCall.getAlertDate() != null) {
                SystemStatus systemStatus = this.getSystemStatus(context);
                LookupList reminderList = systemStatus.getLookupList(db, "lookup_call_reminder");
                context.getRequest().setAttribute("ReminderTypeList", (Object)reminderList);
            }
            if (thisCall.getResultId() > -1) {
                CallResult thisResult = new CallResult(db, thisCall.getResultId());
                context.getRequest().setAttribute("CallResult", (Object)thisResult);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("CallDetails", (Object)thisCall);
        this.addModuleBean(context, "View Opportunities", "Opportunity Activities");
        return LeadsCalls.getReturn(context, "Details");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-calls-delete")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        SystemStatus systemStatus = this.getSystemStatus(context);
        Exception errorMessage = null;
        boolean recordDeleted = false;
        String headerId = context.getRequest().getParameter("headerId");
        Call thisCall = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisCall = new Call(db, context.getRequest().getParameter("id"));
            if (!this.hasViewpointAuthority(db, context, "pipeline", thisCall.getEnteredBy(), userId)) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = thisCall.delete(db);
            if (!recordDeleted) {
                thisCall.getErrors().put("actionError", systemStatus.getLabel("obejct.validation.actionError.callDeletion"));
                this.processErrors(context, thisCall.getErrors());
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordDeleted) {
                context.getRequest().setAttribute("headerId", (Object)headerId);
                return this.executeCommandView(context);
            }
            this.processErrors(context, thisCall.getErrors());
            return this.executeCommandView(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-calls-edit")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        String headerId = context.getRequest().getParameter("headerId");
        int callId = Integer.parseInt(context.getRequest().getParameter("id"));
        Connection db = null;
        Call thisCall = null;
        try {
            db = this.getConnection(context);
            thisCall = (Call)((Object)context.getFormBean());
            if (thisCall.getId() == -1) {
                thisCall = new Call(db, callId);
            }
            OpportunityHeader oppHeader = new OpportunityHeader(db, headerId);
            context.getRequest().setAttribute("opportunityHeader", (Object)oppHeader);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            if (!this.hasViewpointAuthority(db, context, "pipeline", thisCall.getEnteredBy(), userId) && oppHeader.getAccessType() != accessTypeList.getCode(626030334)) {
                String string = "PermissionError";
                return string;
            }
            if (oppHeader.getAccountLink() > -1) {
                Organization oppOrg = new Organization(db, oppHeader.getAccountLink());
                context.getRequest().setAttribute("OrgDetails", (Object)oppOrg);
                ContactList contactList = new ContactList();
                if (oppOrg.getOwner() != userId && userId != this.getUserId(context)) {
                    contactList.setOwner(userId);
                } else if (oppOrg.getOwner() == this.getUserId(context)) {
                    contactList.setOwner(this.getUserId(context));
                } else {
                    contactList.setOwner(oppOrg.getOwner());
                }
                contactList.setOwner(userId);
                contactList.setBuildDetails(false);
                contactList.setBuildTypes(false);
                contactList.setOrgId(oppHeader.getAccountLink());
                contactList.setDefaultContactId(thisCall.getContactId());
                contactList.buildList(db);
                context.getRequest().setAttribute("ContactList", (Object)contactList);
            } else {
                Contact contact = new Contact(db, oppHeader.getContactLink());
                context.getRequest().setAttribute("ContactDetails", (Object)contact);
            }
            this.addModifyFormElements(db, context, thisCall);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Opportunities", "Opportunity Activities");
        context.getRequest().setAttribute("CallDetails", (Object)thisCall);
        context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        if (context.getRequest().getParameter("popup") != null) {
            return "ModifyPopupOK";
        }
        return "ModifyOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandForwardCall(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-calls-view")) {
            return "PermissionError";
        }
        String msgId = context.getRequest().getParameter("id");
        String headerId = context.getRequest().getParameter("headerId");
        CFSNote newNote = null;
        this.addModuleBean(context, "View Opportunities", "Opportunity Activities");
        context.getRequest().setAttribute("forwardType", (Object)String.valueOf(15));
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            Call thisCall = new Call(db, msgId);
            OpportunityHeader oppHeader = new OpportunityHeader(db, Integer.parseInt(headerId));
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            if (!this.hasViewpointAuthority(db, context, "pipeline", thisCall.getEnteredBy(), userId) && oppHeader.getAccessType() != accessTypeList.getCode(626030334)) {
                String string = "PermissionError";
                return string;
            }
            newNote = new CFSNote();
            String contactName = "Contact Name: ";
            String type = "Type: ";
            String length = "Length: ";
            String subject = "Subject: ";
            String notes = "Notes: ";
            String entered = "Entered: ";
            String modified = "Modified: ";
            contactName = systemStatus.getLabel("mail.label.contactName");
            type = systemStatus.getLabel("mail.label.type");
            length = systemStatus.getLabel("mail.label.length");
            subject = systemStatus.getLabel("mail.label.subject.colon");
            notes = systemStatus.getLabel("mail.label.notes");
            entered = systemStatus.getLabel("mail.label.entered");
            modified = systemStatus.getLabel("mail.label.modified");
            newNote.setBody(contactName + StringUtils.toString(thisCall.getContactName()) + "\n" + type + StringUtils.toString(thisCall.getCallType()) + "\n" + length + StringUtils.toString(thisCall.getLengthText()) + "\n" + subject + StringUtils.toString(thisCall.getSubject()) + (!StringUtils.toString(thisCall.getSubject()).equals(StringUtils.toString(thisCall.getAlertText())) && !"".equals(StringUtils.toString(thisCall.getAlertText())) ? "\\" + StringUtils.toString(thisCall.getAlertText()) : "") + "\n" + notes + StringUtils.toString(thisCall.getNotes()) + "\n" + entered + this.getUser(context, thisCall.getEnteredBy()).getContact().getNameFirstLast() + " - " + DateUtils.getServerToUserDateTimeString(this.getUserTimeZone(context), 3, 1, thisCall.getEntered()) + "\n" + modified + this.getUser(context, thisCall.getModifiedBy()).getContact().getNameFirstLast() + " - " + DateUtils.getServerToUserDateTimeString(this.getUserTimeZone(context), 3, 1, thisCall.getModified()));
            context.getRequest().setAttribute("opportunityHeader", (Object)oppHeader);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("Note", (Object)newNote);
        return "ForwardCallOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSendCall(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-calls-view")) {
            return "PermissionError";
        }
        String msgId = context.getRequest().getParameter("id");
        String headerId = context.getRequest().getParameter("headerId");
        Object newNote = null;
        this.addModuleBean(context, "View Opportunities", "Opportunity Activities");
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        Connection db = null;
        try {
            db = this.getConnection(context);
            Call thisCall = new Call(db, msgId);
            if (!this.hasViewpointAuthority(db, context, "pipeline", thisCall.getEnteredBy(), userId)) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("CallDetails", (Object)thisCall);
            OpportunityHeader oppHeader = new OpportunityHeader(db, Integer.parseInt(headerId));
            context.getRequest().setAttribute("opportunityHeader", (Object)oppHeader);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("Note", newNote);
        return "SendCallOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandComplete(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-calls-edit")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        this.addModuleBean(context, "View Opportunities", "Complete Activity");
        String headerId = context.getRequest().getParameter("headerId");
        int callId = -1;
        callId = context.getRequest().getParameter("parentId") != null && !"".equals(context.getRequest().getParameter("parentId")) ? Integer.parseInt(context.getRequest().getParameter("parentId")) : Integer.parseInt(context.getRequest().getParameter("id"));
        Connection db = null;
        Call thisCall = null;
        try {
            db = this.getConnection(context);
            thisCall = new Call(db, callId);
            context.getRequest().setAttribute("PreviousCallDetails", (Object)thisCall);
            OpportunityHeader oppHeader = new OpportunityHeader(db, Integer.parseInt(headerId));
            context.getRequest().setAttribute("opportunityHeader", (Object)oppHeader);
            if (oppHeader.getAccountLink() > -1) {
                ContactList contactList = new ContactList();
                contactList.setOwner(userId);
                contactList.setBuildDetails(false);
                contactList.setBuildTypes(false);
                contactList.setOrgId(oppHeader.getAccountLink());
                contactList.setIncludeEnabled(-1);
                contactList.buildList(db);
                context.getRequest().setAttribute("ContactList", (Object)contactList);
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList callTypeList = systemStatus.getLookupList(db, "lookup_call_types");
            callTypeList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CallTypeList", (Object)callTypeList);
            CallResultList resultList = new CallResultList();
            resultList.buildList(db);
            context.getRequest().setAttribute("callResultList", (Object)resultList);
            LookupList priorityList = systemStatus.getLookupList(db, "lookup_call_priority");
            context.getRequest().setAttribute("PriorityList", (Object)priorityList);
            LookupList reminderList = systemStatus.getLookupList(db, "lookup_call_reminder");
            context.getRequest().setAttribute("ReminderTypeList", (Object)reminderList);
            context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return LeadsCalls.getReturn(context, "Log");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCancel(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-calls-delete")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Opportunities", "Opportunity Activities");
        String headerId = context.getRequest().getParameter("headerId");
        int callId = -1;
        callId = context.getRequest().getParameter("parentId") != null && !"".equals(context.getRequest().getParameter("parentId")) ? Integer.parseInt(context.getRequest().getParameter("parentId")) : Integer.parseInt(context.getRequest().getParameter("id"));
        Connection db = null;
        Call thisCall = null;
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        try {
            db = this.getConnection(context);
            thisCall = new Call(db, callId);
            context.getRequest().setAttribute("PreviousCallDetails", (Object)thisCall);
            Call nextCall = new Call();
            nextCall.setCallTypeId(thisCall.getAlertCallTypeId());
            nextCall.setSubject(thisCall.getAlertText());
            nextCall.setNotes(thisCall.getFollowupNotes());
            context.getRequest().setAttribute("CallDetails", (Object)nextCall);
            OpportunityHeader oppHeader = new OpportunityHeader(db, Integer.parseInt(headerId));
            context.getRequest().setAttribute("opportunityHeader", (Object)oppHeader);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList callTypeList = systemStatus.getLookupList(db, "lookup_call_types");
            callTypeList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CallTypeList", (Object)callTypeList);
            CallResultList resultList = new CallResultList();
            resultList.buildList(db);
            context.getRequest().setAttribute("callResultList", (Object)resultList);
            LookupList priorityList = systemStatus.getLookupList(db, "lookup_call_priority");
            context.getRequest().setAttribute("PriorityList", (Object)priorityList);
            if (oppHeader.getAccountLink() > -1) {
                ContactList contactList = new ContactList();
                contactList.setOwner(userId);
                contactList.setBuildDetails(false);
                contactList.setBuildTypes(false);
                contactList.setOrgId(oppHeader.getAccountLink());
                contactList.setIncludeEnabled(-1);
                contactList.buildList(db);
                context.getRequest().setAttribute("ContactList", (Object)contactList);
                context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return LeadsCalls.getReturn(context, "Log");
    }

    private void addModifyFormElements(Connection db, ActionContext context, Call thisCall) throws SQLException {
        SystemStatus systemStatus = this.getSystemStatus(context);
        LookupList callTypeList = systemStatus.getLookupList(db, "lookup_call_types");
        callTypeList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("CallTypeList", (Object)callTypeList);
        LookupList reminderList = systemStatus.getLookupList(db, "lookup_call_reminder");
        context.getRequest().setAttribute("ReminderTypeList", (Object)reminderList);
        LookupList priorityList = systemStatus.getLookupList(db, "lookup_call_priority");
        context.getRequest().setAttribute("PriorityList", (Object)priorityList);
        if ("pending".equals(context.getRequest().getParameter("view")) || thisCall.getStatusId() == 2 && (thisCall.getAlertDate() == null || context.getRequest().getAttribute("alertDateWarning") != null)) {
            if (thisCall.getResultId() > -1) {
                CallResult thisResult = new CallResult(db, thisCall.getResultId());
                context.getRequest().setAttribute("CallResult", (Object)thisResult);
            }
            if (!"pending".equals(context.getRequest().getParameter("view"))) {
                CallResultList resultList = new CallResultList();
                resultList.buildList(db);
                context.getRequest().setAttribute("callResultList", (Object)resultList);
            }
        } else {
            CallResultList resultList = new CallResultList();
            resultList.buildList(db);
            context.getRequest().setAttribute("callResultList", (Object)resultList);
        }
    }
}

