/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.actions.ProjectManagementFileFolders;
import com.zeroio.iteam.base.FileFolderHierarchy;
import com.zeroio.iteam.base.FileFolderList;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.iteam.base.FileItemVersion;
import com.zeroio.webutils.FileDownload;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;

public final class LeadsDocuments
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-documents-view")) {
            return "PermissionError";
        }
        String folderId = context.getRequest().getParameter("folderId");
        if (folderId == null) {
            folderId = (String)context.getRequest().getAttribute("folderId");
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            int opportunityId = this.addOpportunity(context, db);
            FileFolderList folders = new FileFolderList();
            if (folderId == null || "-1".equals(folderId) || "0".equals(folderId) || "".equals(folderId)) {
                folders.setTopLevelOnly(true);
            } else {
                folders.setParentId(Integer.parseInt(folderId));
                ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
            }
            folders.setLinkModuleId(3);
            folders.setLinkItemId(opportunityId);
            folders.setBuildItemCount(true);
            folders.buildList(db);
            FileItemList documents = new FileItemList();
            if (folderId == null || "-1".equals(folderId) || "0".equals(folderId) || "".equals(folderId)) {
                documents.setTopLevelOnly(true);
            } else {
                documents.setFolderId(Integer.parseInt(folderId));
            }
            documents.setLinkModuleId(3);
            documents.setLinkItemId(opportunityId);
            documents.buildList(db);
            context.getRequest().setAttribute("fileItemList", (Object)documents);
            context.getRequest().setAttribute("fileFolderList", (Object)folders);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Opportunities", "View Documents");
        if (errorMessage == null) {
            return "ViewOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-documents-add")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            int opportunityId = this.addOpportunity(context, db);
            String folderId = context.getRequest().getParameter("folderId");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Opportunities", "Upload Document");
        if (errorMessage == null) {
            return "AddOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpload(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-documents-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordInserted = false;
        boolean isValid = false;
        try {
            String filePath = this.getPath(context, "opportunities");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            String id = (String)parts.get("id");
            String subject = (String)parts.get("subject");
            String folderId = (String)parts.get("folderId");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            if (subject != null) {
                context.getRequest().setAttribute("subject", (Object)subject);
            }
            if (parts.get("id" + (String)parts.get("id")) instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("id" + id);
                db = this.getConnection(context);
                int opportunityId = this.addOpportunity(context, db, id);
                FileItem thisItem = new FileItem();
                thisItem.setLinkModuleId(3);
                thisItem.setLinkItemId(opportunityId);
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                thisItem.setFolderId(Integer.parseInt(folderId));
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setVersion(1.0);
                thisItem.setSize(newFileInfo.getSize());
                isValid = this.validateObject(context, db, thisItem);
                if (isValid) {
                    recordInserted = thisItem.insert(db);
                }
            } else {
                recordInserted = false;
                HashMap<String, String> errors = new HashMap<String, String>();
                SystemStatus systemStatus = this.getSystemStatus(context);
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                if (subject != null && "".equals(subject.trim())) {
                    errors.put("subjectError", systemStatus.getLabel("object.validation.required"));
                }
                this.processErrors(context, errors);
                context.getRequest().setAttribute("headerId", (Object)id);
            }
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return "UploadOK";
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddVersion(ActionContext context) {
        String folderId;
        if (!this.hasPermission(context, "pipeline-opportunities-documents-add")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        String itemId = context.getRequest().getParameter("fid");
        if (itemId == null) {
            itemId = (String)context.getRequest().getAttribute("fid");
        }
        if ((folderId = context.getRequest().getParameter("folderId")) == null) {
            folderId = (String)context.getRequest().getAttribute("folderId");
        }
        if (folderId != null) {
            context.getRequest().setAttribute("folderId", (Object)folderId);
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            int opportunityId = this.addOpportunity(context, db);
            FileItem thisFile = new FileItem(db, Integer.parseInt(itemId), opportunityId, 3);
            context.getRequest().setAttribute("FileItem", (Object)thisFile);
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Opportunities", "Upload New Document Version");
        if (errorMessage == null) {
            return "AddVersionOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUploadVersion(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-documents-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordInserted = false;
        boolean isValid = false;
        try {
            String filePath = this.getPath(context, "opportunities");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            String id = (String)parts.get("id");
            String itemId = (String)parts.get("fid");
            String subject = (String)parts.get("subject");
            String versionId = (String)parts.get("versionId");
            String folderId = (String)parts.get("folderId");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            if (subject != null) {
                context.getRequest().setAttribute("subject", (Object)subject);
            }
            db = this.getConnection(context);
            int opportunityId = this.addOpportunity(context, db, id);
            if (parts.get("id" + (String)parts.get("id")) instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("id" + id);
                FileItem thisItem = new FileItem();
                thisItem.setLinkModuleId(3);
                thisItem.setLinkItemId(opportunityId);
                thisItem.setId(Integer.parseInt(itemId));
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setVersion(Double.parseDouble(versionId));
                thisItem.setSize(newFileInfo.getSize());
                isValid = this.validateObject(context, db, thisItem);
                if (isValid) {
                    recordInserted = thisItem.insertVersion(db);
                }
            } else {
                recordInserted = false;
                HashMap<String, String> errors = new HashMap<String, String>();
                SystemStatus systemStatus = this.getSystemStatus(context);
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                if (subject != null && "".equals(subject.trim())) {
                    errors.put("subjectError", systemStatus.getLabel("object.validation.required"));
                }
                this.processErrors(context, errors);
            }
            context.getRequest().setAttribute("fid", (Object)itemId);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return "UploadOK";
        }
        return this.executeCommandAddVersion(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-documents-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        String folderId = context.getRequest().getParameter("folderId");
        if (folderId != null) {
            context.getRequest().setAttribute("folderId", (Object)folderId);
        }
        String itemId = context.getRequest().getParameter("fid");
        try {
            db = this.getConnection(context);
            int opportunityId = this.addOpportunity(context, db);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), opportunityId, 3);
            thisItem.buildVersionList(db);
            if (!(folderId == null || "-1".equals(folderId) || "0".equals(folderId) || "".equals(folderId) || " ".equals(folderId))) {
                ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
            }
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Opportunities", "Document Details");
        if (errorMessage == null) {
            return "DetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownload(ActionContext context) {
        Exception errorMessage;
        block27: {
            if (!this.hasPermission(context, "pipeline-opportunities-documents-view")) {
                return "PermissionError";
            }
            errorMessage = null;
            String itemId = context.getRequest().getParameter("fid");
            String version = context.getRequest().getParameter("ver");
            String view = context.getRequest().getParameter("view");
            FileItem thisItem = null;
            SystemStatus systemStatus = this.getSystemStatus(context);
            Connection db = null;
            int opportunityId = -1;
            try {
                db = this.getConnection(context);
                opportunityId = this.addOpportunity(context, db);
                thisItem = new FileItem(db, Integer.parseInt(itemId), opportunityId, 3);
                if (version != null) {
                    thisItem.buildVersionList(db);
                }
            }
            catch (Exception e) {
                errorMessage = e;
            }
            finally {
                this.freeConnection(context, db);
            }
            try {
                if (version == null) {
                    FileItem itemToDownload = thisItem;
                    itemToDownload.setEnteredBy(this.getUserId(context));
                    String filePath = this.getPath(context, "opportunities") + LeadsDocuments.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                    FileDownload fileDownload = new FileDownload();
                    fileDownload.setFullPath(filePath);
                    fileDownload.setDisplayName(itemToDownload.getClientFilename());
                    if (fileDownload.fileExists()) {
                        if (view != null && "true".equals(view)) {
                            fileDownload.setFileTimestamp(thisItem.getModificationDate().getTime());
                            fileDownload.streamContent(context);
                        } else {
                            fileDownload.sendFile(context);
                        }
                    } else {
                        db = null;
                        System.err.println("LeadsDocuments-> Trying to send a file that does not exist");
                        context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                        String string = this.executeCommandView(context);
                        return string;
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block27;
                }
                FileItemVersion itemToDownload = thisItem.getVersion(Double.parseDouble(version));
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "opportunities") + LeadsDocuments.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    if (view != null && "true".equals(view)) {
                        fileDownload.setFileTimestamp(itemToDownload.getModificationDate().getTime());
                        fileDownload.streamContent(context);
                    } else {
                        fileDownload.sendFile(context);
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block27;
                }
                db = null;
                System.err.println("LeadsDocuments-> Trying to send a file that does not exist");
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                String string = this.executeCommandView(context);
                return string;
            }
            catch (SocketException se) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println(se.toString());
                }
            }
            catch (Exception e) {
                errorMessage = e;
                System.out.println(e.toString());
            }
            finally {
                if (db != null) {
                    this.freeConnection(context, db);
                }
            }
        }
        this.addModuleBean(context, "View Opportunities", "");
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-documents-edit")) {
            return "PermissionError";
        }
        String itemId = context.getRequest().getParameter("fid");
        String folderId = context.getRequest().getParameter("folderId");
        if (folderId != null) {
            context.getRequest().setAttribute("folderId", (Object)folderId);
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            int opportunityId = this.addOpportunity(context, db);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), opportunityId, 3);
            thisItem.buildVersionList(db);
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Opportunities", "Modify Document Information");
        return "ModifyOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-documents-edit")) {
            return "PermissionError";
        }
        boolean recordInserted = false;
        boolean isValid = false;
        String itemId = context.getRequest().getParameter("fid");
        String subject = context.getRequest().getParameter("subject");
        String filename = context.getRequest().getParameter("clientFilename");
        Connection db = null;
        int opportunityId = -1;
        try {
            db = this.getConnection(context);
            opportunityId = this.addOpportunity(context, db);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), opportunityId, 3);
            thisItem.setClientFilename(filename);
            thisItem.setSubject(subject);
            isValid = this.validateObject(context, db, thisItem);
            if (isValid) {
                recordInserted = thisItem.update(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Opportunities", "");
        if (recordInserted && isValid) {
            return "UpdateOK";
        }
        context.getRequest().setAttribute("fid", (Object)itemId);
        return this.executeCommandModify(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-documents-delete")) {
            return "PermissionError";
        }
        boolean recordDeleted = false;
        String itemId = context.getRequest().getParameter("fid");
        Connection db = null;
        try {
            db = this.getConnection(context);
            int opportunityId = this.addOpportunity(context, db);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), opportunityId, 3);
            recordDeleted = thisItem.delete(db, this.getPath(context, "opportunities"));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Opportunities", "Delete Document");
        if (recordDeleted) {
            return "DeleteOK";
        }
        return "DeleteERROR";
    }

    private int addOpportunity(ActionContext context, Connection db) throws SQLException {
        String opportunityId = context.getRequest().getParameter("headerId");
        if (opportunityId == null) {
            opportunityId = (String)context.getRequest().getAttribute("headerId");
        }
        return this.addOpportunity(context, db, opportunityId);
    }

    private int addOpportunity(ActionContext context, Connection db, String opportunityId) throws SQLException {
        context.getRequest().setAttribute("headerId", (Object)opportunityId);
        OpportunityHeader thisOpportunity = new OpportunityHeader(db, opportunityId);
        AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
        thisOpportunity.buildManagerOwnerIdRange(db, accessTypeList, this.getUserRange(context));
        context.getRequest().setAttribute("opportunityHeader", (Object)thisOpportunity);
        return thisOpportunity.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMove(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-documents-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String itemId = context.getRequest().getParameter("fid");
        try {
            db = this.getConnection(context);
            int opportunityId = this.addOpportunity(context, db);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), opportunityId, 3);
            thisItem.buildVersionList(db);
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
            FileFolderHierarchy hierarchy = new FileFolderHierarchy();
            hierarchy.setLinkModuleId(3);
            hierarchy.setLinkItemId(opportunityId);
            hierarchy.build(db);
            context.getRequest().setAttribute("folderHierarchy", (Object)hierarchy);
            String string = "MoveOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveMove(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-opportunities-documents-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String newFolderId = context.getRequest().getParameter("folderId");
        String itemId = context.getRequest().getParameter("fid");
        try {
            db = this.getConnection(context);
            int opportunityId = this.addOpportunity(context, db);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), opportunityId, 3);
            thisItem.buildVersionList(db);
            thisItem.updateFolderId(db, Integer.parseInt(newFolderId));
            String string = "PopupCloseOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }
}

