/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.orders.base.Order;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.products.base.ProductCatalogList;
import org.aspcfs.modules.products.base.ProductOptionList;
import org.aspcfs.modules.products.base.ProductOptionValuesList;
import org.aspcfs.modules.quotes.base.Quote;
import org.aspcfs.modules.quotes.base.QuoteList;
import org.aspcfs.modules.quotes.base.QuoteNote;
import org.aspcfs.modules.quotes.base.QuoteNoteList;
import org.aspcfs.modules.quotes.base.QuoteProduct;
import org.aspcfs.modules.quotes.base.QuoteProductList;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;
import org.aspcfs.utils.web.ViewpointInfo;

public final class LeadsQuotes
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandQuoteList(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-quotes-view")) {
            return "PermissionError";
        }
        int headerId = -1;
        OpportunityHeader thisHeader = null;
        this.addModuleBean(context, "View Opportunities", "View Opportunity Details");
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        headerId = context.getRequest().getParameter("headerId") != null ? Integer.parseInt(context.getRequest().getParameter("headerId")) : Integer.parseInt((String)context.getRequest().getAttribute("headerId"));
        Connection db = null;
        QuoteList quotes = new QuoteList();
        PagedListInfo quoteListInfo = this.getPagedListInfo(context, "LeadsQuoteListInfo", "qe.group_id", "desc");
        quoteListInfo.setLink("LeadsQuotes.do?command=QuoteList&headerId=" + headerId + RequestUtils.addLinkParams(context.getRequest(), "viewSource"));
        quotes.setPagedListInfo(quoteListInfo);
        try {
            db = this.getConnection(context);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            thisHeader = new OpportunityHeader();
            thisHeader.queryRecord(db, headerId);
            thisHeader.buildManagerOwnerIdRange(db, accessTypeList, this.getUserRange(context));
            context.getRequest().setAttribute("opportunityHeader", (Object)thisHeader);
            quoteListInfo.setSearchCriteria(quotes, context);
            quotes.setHeaderId(headerId);
            if (thisHeader.isTrashed()) {
                quotes.setIncludeOnlyTrashed(true);
            }
            quotes.buildList(db);
            context.getRequest().setAttribute("quoteList", (Object)quotes);
            this.addRecentItem(context, (Object)thisHeader);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList statusSelect = systemStatus.getLookupList(db, "lookup_quote_status");
            statusSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("quoteStatusList", (Object)statusSelect);
            String string = "QuoteListOK";
            return string;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        String quoteId;
        String printQuote;
        if (!this.hasPermission(context, "pipeline-quotes-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Opportunity Quotes", "View Opportunity Quote Details");
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        if ((printQuote = context.getRequest().getParameter("canPrint")) != null && !"".equals(printQuote)) {
            context.getRequest().setAttribute("canPrint", (Object)printQuote);
        }
        if ((quoteId = (String)context.getRequest().getAttribute("quoteId")) == null || "".equals(quoteId)) {
            quoteId = context.getRequest().getParameter("quoteId");
        }
        Connection db = null;
        Quote quote = null;
        QuoteProductList quoteProducts = null;
        ProductCatalogList productList = null;
        ProductOptionList optionList = null;
        ProductOptionValuesList valuesList = null;
        OpportunityHeader thisHeader = null;
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        Organization thisOrganization = null;
        try {
            db = this.getConnection(context);
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, Integer.parseInt(quoteId));
            quote.retrieveTicket(db);
            if (quote.getHeaderId() == -1) {
                context.getRequest().setAttribute("actionError", (Object)"Quote unrelated to the current Opportunity");
                String string = "UserError";
                return string;
            }
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            thisHeader = new OpportunityHeader();
            thisHeader.setBuildComponentCount(true);
            thisHeader.queryRecord(db, quote.getHeaderId());
            thisHeader.buildManagerOwnerIdRange(db, accessTypeList, this.getUserRange(context));
            context.getRequest().setAttribute("opportunityHeader", (Object)thisHeader);
            thisOrganization = new Organization(db, quote.getOrgId());
            optionList = new ProductOptionList();
            optionList.setBuildConfigDetails(true);
            optionList.buildList(db);
            context.getRequest().setAttribute("optionList", (Object)optionList);
            productList = new ProductCatalogList();
            quoteProducts = quote.getProductList();
            for (QuoteProduct quoteProduct : quoteProducts) {
                quoteProduct.buildProductOptions(db);
                quoteProduct.queryRecord(db, quoteProduct.getId());
                ProductCatalog product = new ProductCatalog();
                product.setBuildOptions(true);
                product.queryRecord(db, quoteProduct.getProductId());
                productList.add(product);
            }
            context.getRequest().setAttribute("quoteProductList", (Object)quoteProducts);
            context.getRequest().setAttribute("productList", (Object)productList);
            int orderId = quote.getOrderId(db);
            if (orderId != -1) {
                Order order = new Order(db, orderId);
                context.getRequest().setAttribute("order", (Object)order);
            }
            Quote quoteBean = new Quote();
            context.getRequest().setAttribute("quoteBean", (Object)quoteBean);
            valuesList = new ProductOptionValuesList();
            valuesList.buildList(db);
            context.getRequest().setAttribute("productOptionValuesList", (Object)valuesList);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
            if (quote.getLogoFileId() > 0) {
                FileItem thisItem = new FileItem(db, quote.getLogoFileId(), 126200514, 126200511);
                context.getRequest().setAttribute("fileItem", (Object)thisItem);
            }
        }
        catch (Exception errorMessage) {
            errorMessage.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("quote", (Object)quote);
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        return "DetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRemoveProduct(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-quotes-edit")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        String quoteName = context.getRequest().getParameter("quoteId");
        String productName = context.getRequest().getParameter("productId");
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        int quoteId = Integer.parseInt(quoteName);
        int productId = Integer.parseInt(productName);
        QuoteProduct quoteProduct = null;
        ProductCatalog product = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            quoteProduct = new QuoteProduct(db, productId);
            Quote previousQuote = new Quote();
            previousQuote.setBuildProducts(true);
            previousQuote.queryRecord(db, quoteProduct.getQuoteId());
            product = new ProductCatalog(db, quoteProduct.getProductId());
            quoteProduct.delete(db);
            Quote quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, quoteProduct.getQuoteId());
            this.processUpdateHook(context, (Object)previousQuote, (Object)quote);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandDetails(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveNotes(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-quotes-view")) {
            return "PermissionError";
        }
        boolean isValid = false;
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        int quoteId = -1;
        int recordCount = -1;
        OpportunityHeader header = null;
        String quoteIdString = context.getRequest().getParameter("quoteId");
        StringBuffer oldNotes = new StringBuffer("");
        User user = this.getUser(context, this.getUserId(context));
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        int orgId = user.getContact().getOrgId();
        QuoteNote quoteNote = null;
        Quote quote = null;
        Quote previousQuote = null;
        Quote notes = (Quote)((Object)context.getFormBean());
        if (notes == null) {
            notes = new Quote();
        }
        Organization thisOrganization = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            quoteId = Integer.parseInt(quoteIdString);
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, quoteId);
            context.getRequest().setAttribute("quote", (Object)quote);
            previousQuote = new Quote(db, quoteId);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            header = new OpportunityHeader();
            header.setBuildComponentCount(true);
            header.queryRecord(db, quote.getHeaderId());
            header.buildManagerOwnerIdRange(db, accessTypeList, this.getUserRange(context));
            context.getRequest().setAttribute("opportunityHeader", (Object)header);
            thisOrganization = new Organization(db, quote.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            if (notes.getNotes() != null) {
                quoteNote = new QuoteNote();
                quoteNote.setQuoteId(quote.getId());
                quoteNote.setEnteredBy(this.getUserId(context));
                quoteNote.setModifiedBy(this.getUserId(context));
                quoteNote.setNotes(notes.getNotes());
                isValid = this.validateObject(context, db, (Object)quoteNote);
                if (isValid) {
                    quoteNote.insert(db);
                }
                this.processInsertHook(context, (Object)quoteNote);
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
            if (quote.getStatusId() == list.getIdFromValue("Rejected by customer")) {
                quote.setStatusId(list.getIdFromValue("Pending customer acceptance"));
                Timestamp currentTimestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
                quote.setIssuedDate(currentTimestamp);
                quote.setStatusDate(currentTimestamp);
                boolean bl = isValid = isValid && this.validateObject(context, db, (Object)quote);
                if (isValid) {
                    recordCount = quote.update(db);
                }
                if (recordCount == 1) {
                    this.processUpdateHook(context, (Object)previousQuote, (Object)quote);
                }
            }
            QuoteNoteList noteList = new QuoteNoteList();
            noteList.setQuoteId(quote.getId());
            noteList.buildList(db);
            context.getRequest().setAttribute("quoteNoteList", (Object)noteList);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SaveNotesOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSubmit(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-quotes-edit")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        int quoteId = -1;
        String quoteIdString = context.getRequest().getParameter("quoteId");
        Quote quote = null;
        Connection db = null;
        Quote quoteBean = (Quote)((Object)context.getFormBean());
        try {
            db = this.getConnection(context);
            quoteId = Integer.parseInt(quoteIdString);
            quote = new Quote();
            quote.queryRecord(db, quoteId);
            context.getRequest().setAttribute("quote", (Object)quote);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SubmitOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-quotes-delete")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        Quote quote = null;
        int quoteId = Integer.parseInt(context.getRequest().getParameter("quoteId"));
        Connection db = null;
        try {
            db = this.getConnection(context);
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, quoteId);
            context.getRequest().setAttribute("refreshUrl", (Object)("LeadsQuotes.do?command=QuoteList&headerId=" + quote.getHeaderId()));
            quote.delete(db);
            this.processDeleteHook(context, (Object)quote);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandTrash(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-quotes-delete")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        Quote quote = null;
        int quoteId = Integer.parseInt(context.getRequest().getParameter("quoteId"));
        Connection db = null;
        try {
            db = this.getConnection(context);
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, quoteId);
            context.getRequest().setAttribute("refreshUrl", (Object)("LeadsQuotes.do?command=QuoteList&headerId=" + quote.getHeaderId()));
            quote.updateStatus(db, true, this.getUserId(context));
            this.processDeleteHook(context, (Object)quote);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-quotes-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        Quote quote = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        String quoteId = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        if (context.getRequest().getParameter("quoteId") != null) {
            quoteId = context.getRequest().getParameter("quoteId");
        }
        try {
            db = this.getConnection(context);
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.setBuildTicket(true);
            quote.queryRecord(db, Integer.parseInt(quoteId));
            htmlDialog.setTitle("Centric CRM: Quote Management");
            DependencyList dependencies = quote.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (quote.getOrderId(db) != -1) {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("quotes.deleteRelatedOrdersFirst"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
            } else {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("quotes.dependencies"));
                htmlDialog.addButton(systemStatus.getLabel("button.deleteAll"), "javascript:window.location.href='LeadsQuotes.do?command=Trash&quoteId=" + quote.getId() + "'");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyForm(ActionContext context) {
        String quoteIdString;
        if (!this.hasPermission(context, "pipeline-quotes-edit")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        if ((quoteIdString = (String)context.getRequest().getAttribute("quoteId")) == null || "".equals(quoteIdString)) {
            quoteIdString = context.getRequest().getParameter("quoteId");
        }
        OpportunityHeader opportunityHeader = null;
        Quote quote = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            list2.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
            quote = new Quote(db, Integer.parseInt(quoteIdString));
            context.getRequest().setAttribute("quoteBean", (Object)quote);
            int headerId = quote.getHeaderId();
            if (headerId != -1) {
                opportunityHeader = new OpportunityHeader(db, headerId);
                context.getRequest().setAttribute("opportunityHeader", (Object)opportunityHeader);
            }
            if (opportunityHeader.getAccountLink() != -1) {
                ContactList contactList = new ContactList();
                contactList.setOrgId(quote.getOrgId());
                contactList.setIncludeEnabled(-1);
                contactList.setDefaultContactId(quote.getContactId());
                contactList.buildList(db);
                context.getRequest().setAttribute("contactList", (Object)contactList);
            } else {
                Contact oppContact = new Contact(db, opportunityHeader.getContactLink());
                if (oppContact.getOrgId() != -1) {
                    context.getRequest().setAttribute("ContactDetails", (Object)oppContact);
                    quote.setContactId(oppContact.getId());
                }
            }
            Organization orgDetails = new Organization(db, quote.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
            FileItemList itemList = new FileItemList();
            itemList.setLinkModuleId(126200511);
            itemList.setLinkItemId(126200514);
            itemList.buildList(db);
            context.getRequest().setAttribute("fileItemList", (Object)itemList);
            context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ModifyFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-quotes-edit")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        boolean isValid = false;
        String version = context.getRequest().getParameter("versionId");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        String orgIdString = context.getRequest().getParameter("orgId");
        int orgId = -1;
        if (orgIdString != null && !"".equals(orgIdString)) {
            orgId = Integer.parseInt(orgIdString);
        }
        String quoteIdString = context.getRequest().getParameter("quoteId");
        int quoteId = -1;
        if (quoteIdString != null && !"".equals(quoteIdString)) {
            quoteId = Integer.parseInt(quoteIdString);
        }
        int resultCount = -1;
        Quote quote = null;
        Quote previousQuote = null;
        Quote quoteBean = (Quote)((Object)context.getFormBean());
        User user = this.getUser(context, this.getUserId(context));
        String printQuote = (String)context.getRequest().getAttribute("canPrint");
        if (printQuote != null && !"".equals(printQuote)) {
            context.getRequest().setAttribute("canPrint", (Object)printQuote);
        } else {
            printQuote = quoteBean.getCanPrint();
            context.getRequest().setAttribute("canPrint", (Object)printQuote);
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            quote = new Quote(db, quoteId);
            previousQuote = new Quote(db, quoteId);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
            int contactId = quoteBean.getContactId();
            if (quoteBean.getContactId() != -1) {
                quote.setContactId(quoteBean.getContactId());
            }
            quote.setShortDescription(quoteBean.getShortDescription());
            quote.setExpirationDate(quoteBean.getExpirationDate());
            quote.setIssuedDate(quoteBean.getIssuedDate());
            quote.setNotes(quoteBean.getNotes());
            quote.setStatusId(quoteBean.getStatusId());
            quote.setHeaderId(quoteBean.getHeaderId());
            quote.setDeliveryId(quoteBean.getDeliveryId());
            quote.setEmailAddress(quoteBean.getEmailAddress());
            quote.setFaxNumber(quoteBean.getFaxNumber());
            quote.setPhoneNumber(quoteBean.getPhoneNumber());
            quote.setAddress(quoteBean.getAddress());
            quote.setCloseIt(quoteBean.getCloseIt());
            quote.setClosed(quoteBean.getClosed());
            quote.setSubmitAction(quoteBean.getSubmitAction());
            quote.setLogoFileId(quoteBean.getLogoFileId());
            quote.setModifiedBy(user.getId());
            isValid = this.validateObject(context, db, (Object)quoteBean);
            if (isValid) {
                resultCount = quote.update(db);
            }
            if (resultCount == 1) {
                this.processUpdateHook(context, (Object)previousQuote, (Object)quote);
            }
            Organization orgDetails = new Organization(db, orgId);
            context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == -1 || !isValid) {
            return this.executeCommandModifyForm(context);
        }
        return LeadsQuotes.getReturn(context, "Modify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddQuote(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-quotes-add")) {
            return "PermissionError";
        }
        boolean isValid = false;
        boolean recordInserted = false;
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        String orgIdString = context.getRequest().getParameter("orgId");
        int orgId = -1;
        if (orgIdString != null && !"".equals(orgIdString)) {
            orgId = Integer.parseInt(orgIdString);
        }
        Quote quote = null;
        User user = this.getUser(context, this.getUserId(context));
        Connection db = null;
        try {
            db = this.getConnection(context);
            quote = (Quote)((Object)context.getFormBean());
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
            int contactId = quote.getContactId();
            if (contactId != -1) {
                Organization orgDetails = new Organization(db, quote.getOrgId());
                context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
            } else {
                quote.setStatusId(list.getIdFromValue("Incomplete"));
            }
            quote.setEnteredBy(user.getId());
            quote.setModifiedBy(user.getId());
            quote.setVersion(quote.getNewVersion());
            isValid = this.validateObject(context, db, (Object)quote);
            if (isValid) {
                quote.createNewGroup(db);
                recordInserted = quote.insert(db);
                String quoteId = "" + quote.getId();
                context.getRequest().setAttribute("quoteId", (Object)quoteId);
            }
            if (recordInserted) {
                this.processInsertHook(context, (Object)quote);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (!isValid) {
            return this.executeCommandAddQuoteForm(context);
        }
        return "SaveOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddQuoteForm(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-quotes-add")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        int headerId = -1;
        String headerIdString = context.getRequest().getParameter("headerId");
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        if (headerIdString != null && !"".equals(headerIdString)) {
            headerId = Integer.parseInt(headerIdString);
        }
        Quote quote = (Quote)((Object)context.getFormBean());
        Connection db = null;
        try {
            Contact oppContact;
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            list2.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
            OpportunityHeader opportunityHeader = new OpportunityHeader();
            opportunityHeader.queryRecord(db, headerId);
            context.getRequest().setAttribute("opportunityHeader", (Object)opportunityHeader);
            ContactList contactList = new ContactList();
            if (opportunityHeader.getAccountLink() != -1) {
                contactList.setOrgId(opportunityHeader.getAccountLink());
            } else {
                oppContact = new Contact(db, opportunityHeader.getContactLink());
                if (oppContact.getOrgId() != -1) {
                    contactList.setOrgId(oppContact.getOrgId());
                    context.getRequest().setAttribute("ContactDetails", (Object)oppContact);
                    quote.setContactId(opportunityHeader.getContactLink());
                }
            }
            if (contactList.getOrgId() != -1) {
                contactList.buildList(db);
            } else {
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("actionError", systemStatus.getLabel("object.validation.opportunities.quotes.noQuotesForGeneralContacts"));
                this.processErrors(context, errors);
            }
            context.getRequest().setAttribute("contactList", (Object)contactList);
            if (quote == null) {
                quote = new Quote();
            }
            if (opportunityHeader.getAccountLink() != -1) {
                quote.setOrgId(opportunityHeader.getAccountLink());
                quote.setName(opportunityHeader.getAccountName());
            } else {
                oppContact = new Contact(db, opportunityHeader.getContactLink());
                if (oppContact.getOrgId() != -1) {
                    quote.setOrgId(oppContact.getOrgId());
                    quote.setName(oppContact.getOrgName());
                    quote.setContactId(oppContact.getId());
                }
            }
            quote.setEnteredBy(userId);
            quote.setModifiedBy(userId);
            quote.setHeaderId(headerId);
            context.getRequest().setAttribute("quoteBean", (Object)quote);
            FileItemList itemList = new FileItemList();
            itemList.setLinkModuleId(126200511);
            itemList.setLinkItemId(126200514);
            itemList.buildList(db);
            context.getRequest().setAttribute("fileItemList", (Object)itemList);
            context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddQuoteFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddVersion(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-quotes-add")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        String orgIdString = context.getRequest().getParameter("orgId");
        String quoteId = context.getRequest().getParameter("quoteId");
        Quote quote = null;
        Quote oldQuote = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (quoteId != null && !"".equals(quoteId)) {
                oldQuote = new Quote();
                oldQuote.setBuildProducts(true);
                oldQuote.queryRecord(db, Integer.parseInt(quoteId));
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            quote = new Quote();
            quote.setStatusId(list.getIdFromValue("Incomplete"));
            quote = oldQuote.addVersion(db, quote);
            quote.queryRecord(db, quote.getId());
            this.processUpdateHook(context, (Object)oldQuote, (Object)quote);
            String quoteIdString = String.valueOf(quote.getId());
            context.getRequest().setAttribute("quoteId", (Object)quoteIdString);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandModifyForm(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewHistory(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-quotes-view")) {
            return "PermissionError";
        }
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        Connection db = null;
        Quote quote = null;
        String quoteId = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            quoteId = context.getRequest().getParameter("quoteId");
            db = this.getConnection(context);
            quote = new Quote();
            quote.setBuildHistory(true);
            quote.setSystemStatus(systemStatus);
            quote.queryRecord(db, Integer.parseInt(quoteId));
            context.getRequest().setAttribute("quote", (Object)quote);
            OpportunityHeader header = new OpportunityHeader();
            header.queryRecord(db, quote.getHeaderId());
            context.getRequest().setAttribute("opportunityHeader", (Object)header);
            Organization orgDetails = new Organization(db, quote.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "View Quotes", "View Quote Details");
        return "ViewHistoryOK";
    }
}

