/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.webutils.FileDownload;
import java.io.File;
import java.net.SocketException;
import java.sql.Connection;
import java.util.Date;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.pipeline.base.OpportunityReport;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.ViewpointInfo;

public final class LeadsReports
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return this.executeCommandExportList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandExportList(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-reports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        PagedListInfo rptListInfo = this.getPagedListInfo(context, "LeadRptListInfo");
        rptListInfo.setLink("LeadsReports.do?command=ExportList");
        FileItemList files = new FileItemList();
        files.setLinkModuleId(12);
        files.setLinkItemId(-1);
        files.setPagedListInfo(rptListInfo);
        try {
            db = this.getConnection(context);
            if ("all".equals(rptListInfo.getListView())) {
                files.setOwnerIdRange(this.getUserRange(context, userId));
            } else {
                files.setOwner(userId);
            }
            files.buildList(db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Reports", "ViewReports");
        context.getRequest().setAttribute("FileList", (Object)files);
        return "ExportListOK";
    }

    public String executeCommandExportForm(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-reports-add")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Reports", "Generate new");
        return "ExportFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandExport(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-reports-add")) {
            return "PermissionError";
        }
        Connection db = null;
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        boolean recordInserted = false;
        boolean isValid = false;
        String subject = context.getRequest().getParameter("subject");
        String ownerCriteria = context.getRequest().getParameter("criteria1");
        String filePath = this.getPath(context, "lead-reports") + DateUtils.getDatePath(new Date());
        OpportunityReport oppReport = new OpportunityReport();
        oppReport.setCriteria(context.getRequest().getParameterValues("selectedList"));
        oppReport.setFilePath(filePath);
        oppReport.setSubject(subject);
        PagedListInfo thisInfo = new PagedListInfo();
        thisInfo.setColumnToSortBy(context.getRequest().getParameter("sort"));
        thisInfo.setItemsPerPage(0);
        oppReport.setPagedListInfo(thisInfo);
        if (ownerCriteria.equals("my")) {
            oppReport.setOwner(userId);
        } else if (ownerCriteria.equals("all")) {
            oppReport.setOwnerIdRange(this.getUserRange(context, userId));
        }
        try {
            db = this.getConnection(context);
            oppReport.buildReportFull(db, context);
            oppReport.setEnteredBy(this.getUserId(context));
            oppReport.setModifiedBy(this.getUserId(context));
            isValid = this.validateObject(context, db, oppReport);
            if (isValid) {
                oppReport.saveAndInsert(db);
                String string = "ExportOK";
                return string;
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ExportFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandShowExportHtml(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-reports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String projectId = context.getRequest().getParameter("pid");
        String itemId = context.getRequest().getParameter("fid");
        try {
            db = this.getConnection(context);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), -1, 12);
            String filePath = this.getPath(context, "lead-reports") + LeadsReports.getDatePath(thisItem.getEntered()) + thisItem.getFilename() + ".html";
            String textToShow = LeadsReports.includeFile(filePath);
            context.getRequest().setAttribute("ReportText", (Object)textToShow);
        }
        catch (Exception e) {
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ExportHtmlOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownloadCSVExport(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-reports-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        FileItem thisItem = null;
        Connection db = null;
        String itemId = context.getRequest().getParameter("fid");
        try {
            db = this.getConnection(context);
            thisItem = new FileItem(db, Integer.parseInt(itemId), -1, 12);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        try {
            FileItem itemToDownload = null;
            itemToDownload = thisItem;
            String filePath = this.getPath(context, "lead-reports") + LeadsReports.getDatePath(itemToDownload.getEntered()) + itemToDownload.getFilename() + ".csv";
            FileDownload fileDownload = new FileDownload();
            fileDownload.setFullPath(filePath);
            fileDownload.setDisplayName(itemToDownload.getClientFilename());
            if (fileDownload.fileExists()) {
                fileDownload.sendFile(context);
                db = this.getConnection(context);
                itemToDownload.updateCounter(db);
            } else {
                System.err.println("PMF-> Trying to send a file that does not exist");
            }
        }
        catch (SocketException se) {
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "-none-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteCSVExport(ActionContext context) {
        if (!this.hasPermission(context, "pipeline-reports-delete")) {
            return "PermissionError";
        }
        boolean recordDeleted = false;
        Connection db = null;
        ViewpointInfo viewpointInfo = this.getViewpointInfo(context, "PipelineViewpointInfo");
        int userId = viewpointInfo.getVpUserId(this.getUserId(context));
        String projectId = context.getRequest().getParameter("pid");
        String itemId = context.getRequest().getParameter("fid");
        try {
            String filePath2;
            File fileToDelete2;
            db = this.getConnection(context);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), -1, 12);
            if (!this.hasViewpointAuthority(db, context, "pipeline", thisItem.getEnteredBy(), userId)) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = thisItem.delete(db, this.getPath(context, "lead-reports"));
            String filePath1 = this.getPath(context, "lead-reports") + LeadsReports.getDatePath(thisItem.getEntered()) + thisItem.getFilename() + ".csv";
            File fileToDelete1 = new File(filePath1);
            if (!fileToDelete1.delete()) {
                System.err.println("FileItem-> Tried to delete csv: " + filePath1);
            }
            if (!(fileToDelete2 = new File(filePath2 = this.getPath(context, "lead-reports") + LeadsReports.getDatePath(thisItem.getEntered()) + thisItem.getFilename() + ".html")).delete()) {
                System.err.println("FileItem-> Tried to delete html: " + filePath2);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Reports", "Reports del");
        if (recordDeleted) {
            return "DeleteExportOK";
        }
        return "DeleteExportERROR";
    }
}

