/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.beans.OpportunityBean;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupList;

public final class OpportunityForm
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPrepare(ActionContext context) {
        Connection db = null;
        OpportunityComponent thisComponent = null;
        OpportunityBean thisOpp = (OpportunityBean)((Object)context.getRequest().getAttribute("OppDetails"));
        if (thisOpp == null) {
            thisComponent = (OpportunityComponent)((Object)context.getRequest().getAttribute("ComponentDetails"));
        }
        SystemStatus thisSystem = this.getSystemStatus(context);
        HtmlSelect busTypeSelect = new HtmlSelect();
        busTypeSelect.setSelectName("type");
        busTypeSelect.addItem("N", thisSystem.getLabel("pipeline.businessType.new"));
        busTypeSelect.addItem("E", thisSystem.getLabel("pipeline.businessType.existing"));
        busTypeSelect.build();
        context.getRequest().setAttribute("BusTypeList", (Object)busTypeSelect);
        HtmlSelect unitSelect = new HtmlSelect();
        unitSelect.setSelectName("units");
        if (!thisSystem.hasField("opportunity.units.week")) {
            unitSelect.addItem("W", thisSystem.getLabel("pipeline.units.weeks"));
        }
        if (!thisSystem.hasField("opportunity.units.month")) {
            unitSelect.addItem("M", thisSystem.getLabel("pipeline.units.months"));
        }
        context.getRequest().setAttribute("UnitTypeList", (Object)unitSelect);
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            if (OpportunityForm.getPref(context, "OPPORTUNITY.CLOSE_PROBABILITY") != null) {
                StringTokenizer str = new StringTokenizer(OpportunityForm.getPref(context, "OPPORTUNITY.CLOSE_PROBABILITY"), ",");
                HtmlSelect closeProbSelect = new HtmlSelect();
                while (str.hasMoreTokens()) {
                    String closeProb = str.nextToken();
                    closeProbSelect.addItem(Math.round(Float.parseFloat(closeProb)), closeProb + "%");
                }
                context.getRequest().setAttribute("closeProbSelect", (Object)closeProbSelect);
            }
            LookupList stageSelect = new LookupList(db, "lookup_stage");
            context.getRequest().setAttribute("StageList", (Object)stageSelect);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        boolean popup = "true".equals(context.getRequest().getParameter("popup"));
        if (thisOpp != null && thisOpp.getHeader().getId() > 0 || thisComponent != null && thisComponent.getId() > 0) {
            if (popup) {
                return "PrepareModifyOppPopupOK";
            }
            return "PrepareModifyOppOK";
        }
        if (popup) {
            return "PrepareAddOppPopupOK";
        }
        return "PrepareAddOppOK";
    }
}

