/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.base;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.beans.GenericBean;
import com.zeroio.webdav.utils.ICalendar;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.contacts.base.ContactHistory;
import org.aspcfs.modules.pipeline.base.OpportunityComponentLog;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.LookupElement;
import org.aspcfs.utils.web.LookupList;

public class OpportunityComponent
extends GenericBean {
    public static int COMPLETE = 1;
    public static int INCOMPLETE = 2;
    public static double TENTATIVE_PROBABILITY = 0.8;
    public static String MULTPLE_CONFIG_NAME = "org.aspcfs.modules.pipeline.base.OpportunityComponent";
    protected int id = -1;
    protected int headerId = -1;
    protected int owner = -1;
    protected String description = null;
    protected Timestamp closeDate = null;
    protected double closeProb = 0.0;
    protected double terms = 0.0;
    protected String units = null;
    protected double low = 0.0;
    protected double guess = 0.0;
    protected double high = 0.0;
    protected int stage = -1;
    protected String stageName = null;
    protected Timestamp stageDate = null;
    protected double commission = 0.0;
    protected String type = null;
    protected Timestamp alertDate = null;
    protected String alertDateTimeZone = null;
    protected String alertText = null;
    protected String notes = null;
    protected Timestamp entered = null;
    protected Timestamp modified = null;
    protected int enteredBy = -1;
    protected int modifiedBy = -1;
    protected boolean enabled = true;
    protected String closeDateTimeZone = null;
    protected Timestamp trashedDate = null;
    protected int environment = -1;
    protected int competitors = -1;
    protected int compellingEvent = -1;
    protected int budget = -1;
    protected boolean stageChange = false;
    protected boolean closeIt = false;
    protected boolean openIt = false;
    protected String closed = null;
    protected String accountName = null;
    protected boolean hasEnabledOwnerAccount = true;
    protected ArrayList typeList = null;
    protected LookupList types = new LookupList();
    private int contactId = -1;
    private int orgId = -1;
    protected int status = INCOMPLETE;
    protected ArrayList ignoredValidationFields = new ArrayList();
    private boolean importComponent = false;
    private boolean updateOnInsert = true;

    public OpportunityComponent() {
    }

    public OpportunityComponent(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public OpportunityComponent(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public OpportunityComponent(Connection db, String id) throws SQLException {
        this.queryRecord(db, Integer.parseInt(id));
    }

    public void setTypeList(ArrayList typeList) {
        this.typeList = typeList;
    }

    public void setTypeList(String[] criteriaString) {
        if (criteriaString != null) {
            String[] params = criteriaString;
            this.typeList = new ArrayList<String>(Arrays.asList(params));
        } else {
            this.typeList = new ArrayList();
        }
    }

    public void setHeaderId(int tmp) {
        this.headerId = tmp;
    }

    public void setHeaderId(String tmp) {
        this.headerId = Integer.parseInt(tmp);
    }

    public void setAlertText(String alertText) {
        this.alertText = alertText;
    }

    public void setHasEnabledOwnerAccount(boolean hasEnabledOwnerAccount) {
        this.hasEnabledOwnerAccount = hasEnabledOwnerAccount;
    }

    public void setOpenIt(boolean openIt) {
        this.openIt = openIt;
    }

    public void setOpenIt(String openIt) {
        this.openIt = DatabaseUtils.parseBoolean(openIt);
    }

    public void setTypes(LookupList types) {
        this.types = types;
    }

    public void setAlertDate(Timestamp tmp) {
        this.alertDate = tmp;
    }

    public void setAlertDate(String tmp) {
        this.alertDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setAlertDateTimeZone(String tmp) {
        this.alertDateTimeZone = tmp;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public void setCloseDate(Timestamp tmp) {
        this.closeDate = tmp;
    }

    public void setStageDate(Timestamp tmp) {
        this.stageDate = tmp;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabled(String tmp) {
        this.enabled = "on".equalsIgnoreCase(tmp) || "true".equalsIgnoreCase(tmp);
    }

    public void setCloseDate(String tmp) {
        this.closeDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setStageDate(String tmp) {
        this.stageDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setOwner(String owner) {
        this.owner = Integer.parseInt(owner);
    }

    public void setStageChange(boolean stageChange) {
        this.stageChange = stageChange;
    }

    public void setClosed(String closed) {
        this.closed = closed;
    }

    public void setOwner(int owner) {
        this.owner = owner;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setStageName(String stageName) {
        this.stageName = stageName;
    }

    public void setTerms(String terms) {
        try {
            this.terms = Double.parseDouble(terms);
        }
        catch (NumberFormatException ne) {
            this.errors.put("termsError", terms + " is invalid input for this field");
        }
    }

    public void setTerms(double tmp) {
        this.terms = tmp;
    }

    public void setModifiedBy(int modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnteredBy(int enteredBy) {
        this.enteredBy = enteredBy;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCloseDateTimeZone(String tmp) {
        this.closeDateTimeZone = tmp;
    }

    public String getCloseDateTimeZone() {
        return this.closeDateTimeZone;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public boolean isTrashed() {
        return this.trashedDate != null;
    }

    public double getLow() {
        return this.low;
    }

    public void setLow(double tmp) {
        this.low = tmp;
    }

    public void setLow(String tmp) {
        this.low = Double.parseDouble(tmp);
    }

    public double getGuess() {
        return this.guess;
    }

    public double getGuess(String defaultUnits, String multiplierString) {
        if (defaultUnits != null && "W".equals(defaultUnits)) {
            double multiplier = 1.0;
            if (multiplierString != null && !"".equals(multiplierString)) {
                multiplier = Double.parseDouble(multiplierString);
            }
            return this.guess * multiplier;
        }
        return this.guess;
    }

    public void setGuess(double tmp) {
        this.guess = tmp;
    }

    public void setGuess(String tmp) {
        this.guess = Double.parseDouble(tmp);
    }

    public double getHigh() {
        return this.high;
    }

    public void setHigh(double tmp) {
        this.high = tmp;
    }

    public void setHigh(String tmp) {
        this.high = Double.parseDouble(tmp);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public int getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(int tmp) {
        this.environment = tmp;
    }

    public void setEnvironment(String tmp) {
        this.environment = Integer.parseInt(tmp);
    }

    public int getCompetitors() {
        return this.competitors;
    }

    public void setCompetitors(int tmp) {
        this.competitors = tmp;
    }

    public void setCompetitors(String tmp) {
        this.competitors = Integer.parseInt(tmp);
    }

    public int getCompellingEvent() {
        return this.compellingEvent;
    }

    public void setCompellingEvent(int tmp) {
        this.compellingEvent = tmp;
    }

    public void setCompellingEvent(String tmp) {
        this.compellingEvent = Integer.parseInt(tmp);
    }

    public int getBudget() {
        return this.budget;
    }

    public void setBudget(int tmp) {
        this.budget = tmp;
    }

    public void setBudget(String tmp) {
        this.budget = Integer.parseInt(tmp);
    }

    public void setCloseProb(String closeProb) {
        if (closeProb != null && closeProb.endsWith("%")) {
            closeProb = closeProb.substring(0, closeProb.length() - 1);
        }
        try {
            this.closeProb = Double.parseDouble(closeProb) / 100.0;
        }
        catch (NumberFormatException ne) {
            this.errors.put("closeProbError", closeProb + " is invalid input for this field");
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("Opportunity-> Close prob: " + closeProb);
        }
    }

    public void setCommission(String commission) {
        if (commission != null && commission.endsWith("%")) {
            commission = commission.substring(0, commission.length() - 1);
        }
        this.commission = Double.parseDouble(commission) / 100.0;
    }

    public void setStage(String stage) {
        this.stage = Integer.parseInt(stage);
    }

    public void setStage(int tmp) {
        this.stage = tmp;
    }

    public void setCloseIt(boolean closeIt) {
        this.closeIt = closeIt;
    }

    public void setCloseNow(String tmp) {
        this.closeIt = "ON".equalsIgnoreCase(tmp) || "true".equalsIgnoreCase(tmp);
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatus(String status) {
        this.status = Integer.parseInt(status);
    }

    public void setImportComponent(boolean importComponent) {
        this.importComponent = importComponent;
    }

    public boolean getImportComponent() {
        return this.importComponent;
    }

    public void setImportComponent(String importComponent) {
        this.importComponent = DatabaseUtils.parseBoolean(importComponent);
    }

    public void setUpdateOnInsert(boolean tmp) {
        this.updateOnInsert = tmp;
    }

    public void setUpdateOnInsert(String tmp) {
        this.updateOnInsert = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getUpdateOnInsert() {
        return this.updateOnInsert;
    }

    public int getStatus() {
        return this.status;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public ArrayList getTypeList() {
        return this.typeList;
    }

    public String getAlertText() {
        return this.alertText;
    }

    public int getHeaderId() {
        return this.headerId;
    }

    public boolean getHasEnabledOwnerAccount() {
        return this.hasEnabledOwnerAccount;
    }

    public LookupList getTypes() {
        return this.types;
    }

    public String getNotes() {
        return this.notes;
    }

    public Timestamp getAlertDate() {
        return this.alertDate;
    }

    public String getAlertDateTimeZone() {
        return this.alertDateTimeZone;
    }

    public Timestamp getCloseDate() {
        return this.closeDate;
    }

    public Timestamp getStageDate() {
        return this.stageDate;
    }

    public String getAlertDateString() {
        String tmp = "";
        try {
            return DateFormat.getDateInstance(3).format(this.alertDate);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getCloseDateString() {
        String tmp = "";
        try {
            return DateFormat.getDateInstance(3).format(this.closeDate);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getStageDateString() {
        String tmp = "";
        try {
            return DateFormat.getDateInstance(3).format(this.stageDate);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public boolean getOpenIt() {
        return this.openIt;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public String getModifiedString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getClosed() {
        return this.closed;
    }

    public boolean getStageChange() {
        return this.stageChange;
    }

    public String getUnits() {
        return this.units;
    }

    public double getTerms() {
        return this.terms;
    }

    public double getTermsInMonths() {
        if (this.getUnits().equals("W")) {
            return Math.ceil(this.terms / 4.333);
        }
        return this.terms;
    }

    public double getTermsInMonths(String defaultUnits, String defaultTermsString) throws NumberFormatException {
        if (defaultUnits != null && "W".equals(defaultUnits)) {
            if (this.getUnits().equals("W")) {
                double defaultTerms = 1.0;
                if (defaultTermsString != null && !"".equals(defaultTermsString)) {
                    defaultTerms = Double.parseDouble(defaultTermsString);
                }
                return Math.ceil(this.terms * defaultTerms / 4.333);
            }
        } else if (this.getUnits().equals("W")) {
            return Math.ceil(this.terms / 4.333);
        }
        return this.terms;
    }

    public String getTermsString() {
        Double tmp = new Double(OpportunityComponent.round((double)this.terms, (int)2));
        String toReturn = String.valueOf(tmp);
        if (toReturn.endsWith(".0")) {
            return toReturn.substring(0, toReturn.length() - 2);
        }
        return toReturn;
    }

    public String getStageName() {
        if (this.getClosed() != null) {
            this.setStageName("Closed");
        }
        return this.stageName;
    }

    public String getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }

    public int getOwner() {
        return this.owner;
    }

    public int getStage() {
        return this.stage;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getCloseIt() {
        return this.closeIt;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public String getDescription() {
        return this.description;
    }

    public String getShortDescription() {
        if (this.description.length() <= 40) {
            return this.description;
        }
        return this.description.substring(0, 40) + "...";
    }

    public double getCloseProb() {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("Opportunity-> Close Prob: " + this.closeProb);
        }
        return this.closeProb;
    }

    public String getCloseProbString() {
        return String.valueOf(this.closeProb);
    }

    public String getCloseProbValue() {
        double value_2dp = (double)Math.round(this.closeProb * 100.0 * 100.0) / 100.0;
        String toReturn = String.valueOf(value_2dp);
        if (toReturn.endsWith(".0")) {
            return toReturn.substring(0, toReturn.length() - 2);
        }
        return toReturn;
    }

    public String getCloseProbPercent() {
        NumberFormat percentFormatter = NumberFormat.getPercentInstance(Locale.US);
        String percentOut = percentFormatter.format(this.closeProb);
        return percentOut;
    }

    public double getCommission() {
        return this.commission;
    }

    public String getCommissionString() {
        String stringOut = new BigDecimal(String.valueOf(this.commission)).toString();
        return stringOut;
    }

    public String getCommissionPercent() {
        NumberFormat percentFormatter = NumberFormat.getPercentInstance(Locale.US);
        String percentOut = percentFormatter.format(this.commission);
        return percentOut;
    }

    public String getCommissionValue() {
        double value_2dp = (double)Math.round(this.commission * 100.0 * 100.0) / 100.0;
        String toReturn = String.valueOf(value_2dp);
        if (toReturn.endsWith(".0")) {
            return toReturn.substring(0, toReturn.length() - 2);
        }
        return toReturn;
    }

    public int getContactId() {
        return this.contactId;
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public int getOrgId() {
        return this.orgId;
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public static boolean allowMultiple(String multiple) {
        return multiple == null || !"false".equals(multiple);
    }

    public void addIgnoredValidationField(String field) {
        this.ignoredValidationFields.add(field);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Opportunity Component ID not specified.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT oc.*, y.description AS stagename FROM opportunity_component oc LEFT JOIN lookup_stage y ON (oc.stage = y.code) WHERE id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
        this.buildTypes(db);
    }

    public void checkEnabledOwnerAccount(Connection db) throws SQLException {
        if (this.getOwner() == -1) {
            throw new SQLException("ID not specified for lookup.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT * FROM " + DatabaseUtils.addQuotes(db, "access") + " " + "WHERE user_id = ? AND enabled = ? ");
        pst.setInt(1, this.getOwner());
        pst.setBoolean(2, true);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.setHasEnabledOwnerAccount(true);
        } else {
            this.setHasEnabledOwnerAccount(false);
        }
        rs.close();
        pst.close();
    }

    public boolean insert(Connection db, ActionContext context) throws SQLException {
        if (this.insert(db)) {
            this.invalidateUserData(context);
            return true;
        }
        return false;
    }

    public int update(Connection db, ActionContext context) throws SQLException {
        int oldId = -1;
        int result = -1;
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement("SELECT owner FROM opportunity_component WHERE id = ?");
            pst.setInt(1, this.getId());
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                oldId = rs.getInt("owner");
            }
            rs.close();
            pst.close();
            result = this.update(db);
            if (result == 1) {
                this.invalidateUserData(context);
                if (oldId != this.getOwner()) {
                    this.invalidateUserData(context, oldId);
                }
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public boolean delete(Connection db, ActionContext context) throws SQLException {
        if (this.delete(db)) {
            if (context != null) {
                this.invalidateUserData(context);
            }
            return true;
        }
        return false;
    }

    public boolean disable(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Opportunity Component ID not specified");
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        boolean success = false;
        sql.append("UPDATE opportunity_component SET enabled = ? WHERE id = ? AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setBoolean(++i, false);
        pst.setInt(++i, this.id);
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        int resultCount = pst.executeUpdate();
        pst.close();
        if (resultCount == 1) {
            success = true;
        }
        return success;
    }

    public int updateHeaderModified(Connection db) throws SQLException {
        if (this.getHeaderId() == -1) {
            throw new SQLException("Opportunity Header ID not specified");
        }
        int resultCount = -1;
        int i = 0;
        PreparedStatement pst = db.prepareStatement("UPDATE opportunity_header set modified = CURRENT_TIMESTAMP, modifiedby = ? WHERE opp_id = ? ");
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getHeaderId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("===========================================\r\n");
        out.append("Id: " + this.id + "\r\n");
        out.append("Opportunity Component: " + this.description + "\r\n");
        out.append("Close Date: " + this.getCloseDateString() + "\r\n");
        out.append("Stage Date: " + this.getStageDateString() + "\r\n");
        out.append("Alert Date: " + this.getAlertDateString() + "\r\n");
        return out.toString();
    }

    public boolean insert(Connection db) throws SQLException {
        if (this.getHeaderId() == -1) {
            throw new SQLException("You must associate an opportunity component with an opportunity.");
        }
        boolean doCommit = false;
        try {
            doCommit = db.getAutoCommit();
            if (doCommit) {
                db.setAutoCommit(false);
            }
            StringBuffer sql = new StringBuffer();
            this.id = DatabaseUtils.getNextSeq(db, "opportunity_component_id_seq");
            sql.append("INSERT INTO opportunity_component (owner, closedate, closedate_timezone, stage, description, opp_id, status_id, trashed_date, ");
            sql.append("environment, competitors, compelling_event, budget, ");
            if (this.id > -1) {
                sql.append("id, ");
            }
            if (this.stageDate != null) {
                sql.append("stagedate, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("enteredBy, modifiedBy ) ");
            sql.append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.stageDate != null) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setInt(++i, this.getOwner());
            pst.setTimestamp(++i, this.getCloseDate());
            pst.setString(++i, this.getCloseDateTimeZone());
            pst.setInt(++i, this.getStage());
            pst.setString(++i, this.getDescription());
            pst.setInt(++i, this.getHeaderId());
            pst.setInt(++i, this.getStatus());
            DatabaseUtils.setTimestamp(pst, ++i, this.getTrashedDate());
            DatabaseUtils.setInt(pst, ++i, this.getEnvironment());
            DatabaseUtils.setInt(pst, ++i, this.getCompetitors());
            DatabaseUtils.setInt(pst, ++i, this.getCompellingEvent());
            DatabaseUtils.setInt(pst, ++i, this.getBudget());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.stageDate != null) {
                pst.setTimestamp(++i, this.stageDate);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            if (this.modified != null) {
                pst.setTimestamp(++i, this.modified);
            }
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "opportunity_component_id_seq", this.id);
            if (this.updateOnInsert) {
                this.update(db, true);
            }
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void buildTypes(Connection db) throws SQLException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        PreparedStatement pst = db.prepareStatement("SELECT otl.type_id FROM opportunity_component_levels otl WHERE otl.opp_id = ? ORDER BY otl." + DatabaseUtils.addQuotes(db, "level") + " ");
        pst.setInt(1, this.id);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            list.add(new Integer(rs.getInt("type_id")));
        }
        Iterator li = list.iterator();
        while (li.hasNext()) {
            int thisTypeId = (Integer)li.next();
            this.types.add(new LookupElement(db, thisTypeId, "lookup_opportunity_types"));
        }
        rs.close();
        pst.close();
    }

    public boolean resetType(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("ID not specified");
        }
        String sql = "DELETE FROM opportunity_component_levels WHERE opp_id = ? ";
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
        return true;
    }

    public boolean insertType(Connection db, int type_id, int level) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("ID not specified");
        }
        String sql = "INSERT INTO opportunity_component_levels (opp_id, type_id, " + DatabaseUtils.addQuotes(db, "level") + ") " + "VALUES (?, ?, ?) ";
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(++i, this.getId());
        pst.setInt(++i, type_id);
        pst.setInt(++i, level);
        pst.execute();
        pst.close();
        return true;
    }

    public void changeStatus(Connection db, int thisStatus) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("ID not specified");
        }
        this.status = thisStatus;
        int i = 0;
        PreparedStatement pst = db.prepareStatement("UPDATE opportunity_component SET status_id = ? WHERE id = ? ");
        pst.setInt(++i, this.status);
        pst.setInt(++i, this.getId());
        pst.executeUpdate();
        pst.close();
    }

    public void invalidateUserData(ActionContext context) {
        this.invalidateUserData(context, this.owner);
    }

    public boolean reassign(Connection db, int newOwner) throws SQLException {
        int result = -1;
        this.setOwner(newOwner);
        result = this.update(db);
        return result != -1;
    }

    public void invalidateUserData(ActionContext context, int userId) {
        if (context != null) {
            ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
            SystemStatus systemStatus = (SystemStatus)((Hashtable)context.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
            systemStatus.getHierarchyList().getUser(userId).setIsValid(false, true);
        }
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            throw new SQLException("Opportunity Component ID was not specified");
        }
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            resultCount = this.update(db, false);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return resultCount;
    }

    protected boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("The Opportunity Component could not be found.");
        }
        Statement st = null;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.resetType(db);
            ContactHistory.deleteObject(db, 4, this.getId());
            int pipelineComponent = ActionPlan.getMapIdGivenConstantId(db, 1011200517);
            int i = 0;
            PreparedStatement pst = db.prepareStatement("UPDATE action_item_work SET link_module_id = ?, link_item_id = ? WHERE link_module_id = ? AND link_item_id = ? ");
            DatabaseUtils.setInt(pst, ++i, -1);
            DatabaseUtils.setInt(pst, ++i, -1);
            pst.setInt(++i, pipelineComponent);
            pst.setInt(++i, this.getId());
            pst.executeUpdate();
            pst.close();
            pst = db.prepareStatement("DELETE FROM opportunity_component_log WHERE component_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            st = db.createStatement();
            st.executeUpdate("DELETE FROM opportunity_component WHERE id = " + this.getId());
            st.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.headerId = rs.getInt("opp_id");
        this.owner = rs.getInt("owner");
        this.description = rs.getString("description");
        this.closeDate = rs.getTimestamp("closedate");
        this.closeProb = rs.getDouble("closeprob");
        this.terms = rs.getDouble("terms");
        this.units = rs.getString("units");
        this.low = rs.getDouble("lowvalue");
        this.guess = rs.getDouble("guessvalue");
        this.high = rs.getDouble("highvalue");
        this.stage = rs.getInt("stage");
        this.stageDate = rs.getTimestamp("stagedate");
        this.commission = rs.getDouble("commission");
        this.type = rs.getString("type");
        this.alertDate = rs.getTimestamp("alertdate");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.closed = rs.getString("closed");
        if (!rs.wasNull()) {
            this.closeIt = true;
        }
        this.alertText = rs.getString("alert");
        this.enabled = rs.getBoolean("enabled");
        this.notes = rs.getString("notes");
        this.alertDateTimeZone = rs.getString("alertdate_timezone");
        this.closeDateTimeZone = rs.getString("closedate_timezone");
        this.trashedDate = rs.getTimestamp("trashed_date");
        this.environment = DatabaseUtils.getInt(rs, "environment");
        this.competitors = DatabaseUtils.getInt(rs, "competitors");
        this.compellingEvent = DatabaseUtils.getInt(rs, "compelling_event");
        this.budget = DatabaseUtils.getInt(rs, "budget");
        this.stageName = rs.getString("stagename");
    }

    protected int update(Connection db, boolean override) throws SQLException {
        int resultCount = 0;
        PreparedStatement pst = null;
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            if (!override) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Opportunity Component-> Retrieving values from previous Opportunity Component");
                }
                pst = db.prepareStatement("SELECT stage, closed FROM opportunity_component WHERE id = ? ");
                pst.setInt(1, this.getId());
                ResultSet rs = pst.executeQuery();
                if (rs.next()) {
                    int currentStage = DatabaseUtils.getInt(rs, "stage", -1);
                    if (currentStage != this.stage || this.getCloseIt()) {
                        this.setStageChange(true);
                    } else {
                        this.setStageChange(false);
                    }
                    this.closed = rs.getString("closed");
                    if (!rs.wasNull() && !this.getCloseIt()) {
                        this.setOpenIt(true);
                    }
                }
                rs.close();
                pst.close();
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Opportunity Component-> Updating the opportunity component");
            }
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE opportunity_component SET lowvalue = ?, guessvalue = ?, highvalue = ?, closeprob = ?, commission = ?, ");
            if (this.getStageChange() && !override) {
                sql.append("stagedate = " + DatabaseUtils.getCurrentTimestamp(db) + ", ");
            }
            sql.append("" + DatabaseUtils.addQuotes(db, "type") + " = ?, stage = ?, description = ?, " + "closedate = ?, closedate_timezone = ?, alertdate = ?, alert = ?, alertdate_timezone = ?, terms = ?, units = ?, owner = ?, notes = ?, ");
            sql.append("environment = ?, competitors = ?, compelling_event = ?, budget = ?, ");
            if (!override) {
                sql.append("modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", ");
            }
            sql.append("modifiedby = ? ");
            if (this.getCloseIt()) {
                sql.append(", closed = CURRENT_TIMESTAMP ");
            } else if (this.getOpenIt()) {
                sql.append(", closed = ? ");
            }
            sql.append("WHERE id = ? ");
            if (!override) {
                sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
            }
            int i = 0;
            pst = db.prepareStatement(sql.toString());
            pst.setDouble(++i, this.getLow());
            pst.setDouble(++i, this.getGuess());
            pst.setDouble(++i, this.getHigh());
            pst.setDouble(++i, this.getCloseProb());
            pst.setDouble(++i, this.getCommission());
            pst.setString(++i, this.getType());
            pst.setInt(++i, this.getStage());
            pst.setString(++i, this.getDescription());
            DatabaseUtils.setTimestamp(pst, ++i, this.getCloseDate());
            pst.setString(++i, this.getCloseDateTimeZone());
            DatabaseUtils.setTimestamp(pst, ++i, this.getAlertDate());
            pst.setString(++i, this.getAlertText());
            pst.setString(++i, this.getAlertDateTimeZone());
            pst.setDouble(++i, this.getTerms());
            pst.setString(++i, this.getUnits());
            pst.setInt(++i, this.getOwner());
            pst.setString(++i, this.getNotes());
            DatabaseUtils.setInt(pst, ++i, this.getEnvironment());
            DatabaseUtils.setInt(pst, ++i, this.getCompetitors());
            DatabaseUtils.setInt(pst, ++i, this.getCompellingEvent());
            DatabaseUtils.setInt(pst, ++i, this.getBudget());
            pst.setInt(++i, this.getModifiedBy());
            if (this.getOpenIt()) {
                pst.setNull(++i, 91);
            }
            pst.setInt(++i, this.getId());
            if (!override && this.getModified() != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            resultCount = pst.executeUpdate();
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Opportunity Component-> ResultCount: " + resultCount);
            }
            pst.close();
            if (resultCount == 1) {
                if (this.typeList != null) {
                    this.resetType(db);
                    int lvlcount = 0;
                    for (int k = 0; k < this.typeList.size(); ++k) {
                        String val = (String)this.typeList.get(k);
                        if (val != null && !"".equals(val)) {
                            int type_id = Integer.parseInt((String)this.typeList.get(k));
                            this.insertType(db, type_id, ++lvlcount);
                            continue;
                        }
                        --lvlcount;
                    }
                }
                this.updateHeaderModified(db);
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("OpportunityComponent-> Adding Component Log Entry");
                }
                OpportunityComponentLog oppCompLog = new OpportunityComponentLog(db, this);
                oppCompLog.insert(db);
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            e.printStackTrace(System.out);
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return resultCount;
    }

    public boolean updateStatus(Connection db, ActionContext context, boolean toTrash, int tmpUserId) throws SQLException {
        int count = 0;
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE opportunity_component SET trashed_date = ?, modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + "modifiedby = ? " + "WHERE id = ? ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (toTrash) {
                DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(System.currentTimeMillis()));
            } else {
                DatabaseUtils.setTimestamp(pst, ++i, null);
            }
            DatabaseUtils.setInt(pst, ++i, tmpUserId);
            pst.setInt(++i, this.getId());
            count = pst.executeUpdate();
            pst.close();
            this.invalidateUserData(context);
            ContactHistory.trash(db, 4, this.getId(), !toTrash);
            int pipelineComponent = ActionPlan.getMapIdGivenConstantId(db, 1011200517);
            i = 0;
            pst = db.prepareStatement("UPDATE action_item_work SET link_module_id = ?, link_item_id = ? WHERE link_module_id = ? AND link_item_id = ? ");
            DatabaseUtils.setInt(pst, ++i, -1);
            DatabaseUtils.setInt(pst, ++i, -1);
            pst.setInt(++i, pipelineComponent);
            pst.setInt(++i, this.getId());
            pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("alertDate");
        thisList.add("stageDate");
        thisList.add("closeDate");
        return thisList;
    }

    public static ArrayList getNumberParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("low");
        thisList.add("guess");
        thisList.add("high");
        return thisList;
    }

    public void setTypeListToTypes(Connection db) throws SQLException {
        for (String tmpId : this.typeList) {
            this.types.add(new LookupElement(db, Integer.parseInt(tmpId), "lookup_opportunity_types"));
        }
    }

    public String generateWebcalEvent(TimeZone tz, Timestamp created, String category, String currency, Locale locale, Timestamp alertDate) {
        StringBuffer webcal = new StringBuffer();
        String CRLF = System.getProperty("line.separator");
        String desc = "";
        if (this.description != null) {
            desc = desc + "Component: " + this.description.trim();
        }
        desc = desc + "\\nGuess Amount: " + ICalendar.getCurrencyFormat((double)this.guess, (String)currency, (Locale)locale);
        desc = desc + "\\nClose Date: " + this.getCloseDateString();
        webcal.append("BEGIN:VEVENT" + CRLF);
        webcal.append("UID:www.centriccrm.com-opportunity-alerts-" + this.getId() + CRLF);
        if (created != null) {
            webcal.append("DTSTAMP:" + ICalendar.getDateTimeUTC((Timestamp)created) + CRLF);
        }
        if (this.entered != null) {
            webcal.append("CREATED:" + ICalendar.getDateTimeUTC((Timestamp)this.entered) + CRLF);
        }
        if (alertDate != null) {
            webcal.append("DTSTART;TZID=" + tz.getID() + ":" + ICalendar.getDateTime((TimeZone)tz, (Timestamp)alertDate) + CRLF);
        }
        if (this.alertText != null) {
            webcal.append(ICalendar.foldLine((String)("SUMMARY:" + this.alertText)) + CRLF);
        }
        if (desc != null) {
            webcal.append(ICalendar.foldLine((String)("DESCRIPTION:" + ICalendar.parseNewLine((String)desc))) + CRLF);
        }
        if (category != null) {
            webcal.append("CATEGORIES:" + category + CRLF);
        }
        webcal.append("END:VEVENT" + CRLF);
        return webcal.toString();
    }
}

