/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.base;

import java.io.File;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;

public class OpportunityComponentEmail {
    private String subject = null;
    private String body = null;
    private String relationshipType = null;
    private String relationshipName = null;
    private OpportunityHeader opportunity = null;
    private OpportunityComponent component = null;
    private String url = null;

    public void render(String templateFile) throws Exception {
        File configFile = new File(templateFile);
        XMLUtils xml = new XMLUtils(configFile);
        Element mappings = xml.getFirstChild("mappings");
        Template messageSubject = new Template();
        messageSubject.setText(XMLUtils.getNodeText(XMLUtils.getElement(mappings, "map", "id", "notifier.opportunity.subject")));
        messageSubject.addParseElement("\r\n", "");
        messageSubject.addParseElement("\r", "");
        messageSubject.addParseElement("\n", "");
        messageSubject.addParseElement("${opportunity.relationshipName}", StringUtils.toHtml(this.relationshipName));
        this.subject = messageSubject.getParsedText();
        Template messageBody = new Template();
        messageBody.setText(XMLUtils.getNodeText(XMLUtils.getElement(mappings, "map", "id", "notifier.opportunity.body")));
        messageBody.addParseElement("${opportunity.relationshipType}", StringUtils.toHtml(this.relationshipType));
        messageBody.addParseElement("${opportunity.relationshipName}", StringUtils.toHtml(this.relationshipName));
        messageBody.addParseElement("${opportunity.description}", StringUtils.toHtml(this.opportunity.getDescription()));
        messageBody.addParseElement("${component.description}", StringUtils.toHtml(this.component.getDescription()));
        messageBody.addParseElement("${component.alertText}", StringUtils.toHtml(this.component.getAlertText()));
        messageBody.addParseElement("${component.notes}", StringUtils.toHtml(this.component.getNotes()));
        messageBody.addParseElement("${link}", this.url);
        this.body = messageBody.getParsedText();
        if (System.getProperty("DEBUG") != null) {
            System.out.println("OpportunityComponentEmail-> Subject: " + this.subject);
            System.out.println("OpportunityComponentEmail-> Body: " + this.body);
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public void setRelationshipName(String relationshipName) {
        this.relationshipName = relationshipName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setOpportunity(OpportunityHeader opportunity) {
        this.opportunity = opportunity;
    }

    public void setComponent(OpportunityComponent component) {
        this.component = component;
    }
}

