/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class OpportunityComponentList
extends ArrayList {
    public static final String tableName = "opportunity_component";
    public static final String uniqueField = "id";
    protected Timestamp lastAnchor = null;
    protected Timestamp nextAnchor = null;
    protected int syncType = -1;
    protected PagedListInfo pagedListInfo = null;
    protected int headerId = -1;
    protected int enteredBy = -1;
    protected boolean hasAlertDate = false;
    protected Timestamp alertDate = null;
    protected int owner = -1;
    private int contactId = -1;
    private int orgId = -1;
    protected String ownerIdRange = null;
    protected Timestamp alertRangeStart = null;
    protected Timestamp alertRangeEnd = null;
    protected Timestamp closeDateStart = null;
    protected Timestamp closeDateEnd = null;
    protected boolean queryOpenOnly = false;
    protected int environment = -1;
    protected int competitors = -1;
    protected int compellingEvent = -1;
    protected int budget = -1;
    protected int controlledHierarchyOnly = -1;
    protected int accessType = -1;
    private Timestamp trashedDate = null;
    private boolean includeOnlyTrashed = false;
    private double defaultTerms = 1.0;
    private String defaultUnits = null;
    private String units = null;
    private boolean includeOnlyForGraph = false;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setHeaderId(String tmp) {
        this.headerId = Integer.parseInt(tmp);
    }

    public void setHeaderId(int tmp) {
        this.headerId = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setOwnerIdRange(String ownerIdRange) {
        this.ownerIdRange = ownerIdRange;
    }

    public void setAlertRangeStart(Timestamp tmp) {
        this.alertRangeStart = tmp;
    }

    public void setAlertRangeStart(String tmp) {
        this.alertRangeStart = Timestamp.valueOf(tmp);
    }

    public void setAlertRangeEnd(Timestamp tmp) {
        this.alertRangeEnd = tmp;
    }

    public void setAlertRangeEnd(String tmp) {
        this.alertRangeEnd = Timestamp.valueOf(tmp);
    }

    public Timestamp getAlertRangeStart() {
        return this.alertRangeStart;
    }

    public Timestamp getAlertRangeEnd() {
        return this.alertRangeEnd;
    }

    public void setHasAlertDate(boolean tmp) {
        this.hasAlertDate = tmp;
    }

    public void setAlertDate(Timestamp tmp) {
        this.alertDate = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getCloseDateStart() {
        return this.closeDateStart;
    }

    public Timestamp getCloseDateEnd() {
        return this.closeDateEnd;
    }

    public void setCloseDateStart(Timestamp tmp) {
        this.closeDateStart = tmp;
    }

    public int getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(int tmp) {
        this.environment = tmp;
    }

    public void setEnvironment(String tmp) {
        this.environment = Integer.parseInt(tmp);
    }

    public int getCompetitors() {
        return this.competitors;
    }

    public void setCompetitors(int tmp) {
        this.competitors = tmp;
    }

    public void setCompetitors(String tmp) {
        this.competitors = Integer.parseInt(tmp);
    }

    public int getCompellingEvent() {
        return this.compellingEvent;
    }

    public void setCompellingEvent(int tmp) {
        this.compellingEvent = tmp;
    }

    public void setCompellingEvent(String tmp) {
        this.compellingEvent = Integer.parseInt(tmp);
    }

    public int getBudget() {
        return this.budget;
    }

    public void setBudget(int tmp) {
        this.budget = tmp;
    }

    public void setBudget(String tmp) {
        this.budget = Integer.parseInt(tmp);
    }

    public double getDefaultTerms() {
        return this.defaultTerms;
    }

    public void setDefaultTerms(double tmp) {
        this.defaultTerms = tmp;
    }

    public void setDefaultTerms(String tmp) {
        this.defaultTerms = Double.parseDouble(tmp);
    }

    public String getDefaultUnits() {
        return this.defaultUnits;
    }

    public void setDefaultUnits(String tmp) {
        this.defaultUnits = tmp;
    }

    public void setCloseDateStart(String tmp) {
        try {
            Date tmpDate = DateFormat.getDateTimeInstance(3, 1).parse(tmp);
            this.closeDateStart = new Timestamp(new Date().getTime());
            this.closeDateStart.setTime(tmpDate.getTime());
        }
        catch (Exception e) {
            this.closeDateStart = null;
        }
    }

    public void setCloseDateEnd(Timestamp tmp) {
        this.closeDateEnd = tmp;
    }

    public void setCloseDateEnd(String tmp) {
        try {
            Date tmpDate = DateFormat.getDateTimeInstance(3, 1).parse(tmp);
            this.closeDateEnd = new Timestamp(new Date().getTime());
            this.closeDateEnd.setTime(tmpDate.getTime());
        }
        catch (Exception e) {
            this.closeDateEnd = null;
        }
    }

    public void setOwner(int tmp) {
        this.owner = tmp;
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public String getOwnerIdRange() {
        return this.ownerIdRange;
    }

    public boolean getQueryOpenOnly() {
        return this.queryOpenOnly;
    }

    public void setQueryOpenOnly(boolean queryOpenOnly) {
        this.queryOpenOnly = queryOpenOnly;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setIncludeOnlyTrashed(boolean tmp) {
        this.includeOnlyTrashed = tmp;
    }

    public void setIncludeOnlyTrashed(String tmp) {
        this.includeOnlyTrashed = DatabaseUtils.parseBoolean(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public boolean getIncludeOnlyTrashed() {
        return this.includeOnlyTrashed;
    }

    public int getListSize() {
        return this.size();
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public boolean getHasAlertDate() {
        return this.hasAlertDate;
    }

    public int getControlledHierarchyOnly() {
        return this.controlledHierarchyOnly;
    }

    public void setControlledHierarchyOnly(int tmp) {
        this.controlledHierarchyOnly = tmp;
    }

    public void setControlledHierarchyOnly(String tmp) {
        this.controlledHierarchyOnly = Integer.parseInt(tmp);
    }

    public void setControlledHierarchy(int hierarchy, String tmp) {
        this.controlledHierarchyOnly = hierarchy;
        this.ownerIdRange = tmp;
    }

    public int getAccessType() {
        return this.accessType;
    }

    public void setAccessType(int tmp) {
        this.accessType = tmp;
    }

    public void setAccessType(String tmp) {
        this.accessType = Integer.parseInt(tmp);
    }

    public void setUnits(String tmp) {
        this.units = tmp;
    }

    public void setIncludeOnlyForGraph(boolean tmp) {
        this.includeOnlyForGraph = tmp;
    }

    public void setIncludeOnlyForGraph(String tmp) {
        this.includeOnlyForGraph = DatabaseUtils.parseBoolean(tmp);
    }

    public String getUnits() {
        return this.units;
    }

    public boolean getIncludeOnlyForGraph() {
        return this.includeOnlyForGraph;
    }

    public HashMap queryRecordCount(Connection db, TimeZone timeZone) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        HashMap<String, Integer> events = new HashMap<String, Integer>();
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlTail = new StringBuffer();
        this.createFilter(db, sqlFilter);
        sqlSelect.append("SELECT alertdate, count(*) as nocols FROM opportunity_component oc WHERE oc.opp_id > -1 ");
        sqlTail.append("GROUP BY alertdate ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlTail.toString());
        this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            String alertDate = DateUtils.getServerToUserDateString(timeZone, 3, rs.getTimestamp("alertdate"));
            int temp = rs.getInt("nocols");
            events.put(alertDate, new Integer(temp));
        }
        rs.close();
        pst.close();
        return events;
    }

    public void buildShortList(Connection db) throws SQLException {
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        this.createFilter(db, sqlFilter);
        sqlSelect.append("SELECT oc.opp_id, oc.id, oc.description, oc.alertdate, oc.alert, oc.closedate, oc.guessvalue FROM opportunity_component oc  LEFT JOIN opportunity_header oh ON (oc.opp_id = oh.opp_id) LEFT JOIN organization org ON (oh.acctlink = org.org_id) WHERE oc.opp_id > -1 ");
        PreparedStatement pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString());
        this.prepareFilter(pst);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            OpportunityComponent thisOpp = new OpportunityComponent();
            thisOpp.setHeaderId(rs.getInt("opp_id"));
            thisOpp.setId(rs.getInt(uniqueField));
            thisOpp.setDescription(rs.getString("description"));
            thisOpp.setAlertDate(rs.getTimestamp("alertdate"));
            thisOpp.setAlertText(rs.getString("alert"));
            thisOpp.setCloseDate(rs.getString("closedate"));
            thisOpp.setGuess(rs.getDouble("guessvalue"));
            this.add(thisOpp);
        }
        rs.close();
        pst.close();
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM opportunity_component oc LEFT JOIN lookup_stage y ON (oc.stage = y.code) WHERE oc.id > -1 ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(oc.description) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("oc.closed", "desc");
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY oc.closed");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("oc.*, y.description AS stagename FROM opportunity_component oc LEFT JOIN lookup_stage y ON (oc.stage = y.code) WHERE y.code = oc.stage AND oc.opp_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            OpportunityComponent thisOppComponent = new OpportunityComponent(rs);
            this.add(thisOppComponent);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.headerId != -1) {
            sqlFilter.append("AND oc.opp_id = ? ");
        }
        if (this.enteredBy != -1) {
            sqlFilter.append("AND oc.enteredby = ? ");
        }
        if (this.hasAlertDate) {
            sqlFilter.append("AND oc.alertdate IS NOT NULL ");
        }
        if (this.alertDate != null) {
            sqlFilter.append("AND oc.alertdate = ? ");
        }
        if (this.alertRangeStart != null) {
            sqlFilter.append("AND oc.alertdate >= ? ");
        }
        if (this.alertRangeEnd != null) {
            sqlFilter.append("AND oc.alertdate < ? ");
        }
        if (this.closeDateStart != null) {
            sqlFilter.append("AND oc.closedate >= ? ");
        }
        if (this.closeDateEnd != null) {
            sqlFilter.append("AND oc.closedate <= ? ");
        }
        if (this.controlledHierarchyOnly != -1) {
            if (this.controlledHierarchyOnly == 0) {
                sqlFilter.append("AND (oc.owner IN (" + this.ownerIdRange + ") " + "OR oc.opp_id IN (SELECT opp_id from opportunity_header x " + "WHERE x.access_type = ?)) ");
            } else {
                sqlFilter.append("AND oc.owner IN (" + this.ownerIdRange + ") ");
            }
        } else {
            if (this.owner != -1) {
                sqlFilter.append("AND oc.owner = ? ");
            }
            if (this.ownerIdRange != null) {
                sqlFilter.append("AND oc.owner in (" + this.ownerIdRange + ") ");
            }
        }
        if (this.queryOpenOnly) {
            sqlFilter.append("AND oc.closed IS NULL ");
        }
        if (this.includeOnlyTrashed) {
            sqlFilter.append("AND oc.trashed_date IS NOT NULL ");
        } else if (this.trashedDate != null) {
            sqlFilter.append("AND oc.trashed_date = ? ");
        } else {
            sqlFilter.append("AND oc.trashed_date IS NULL ");
        }
        if (this.environment != -1) {
            sqlFilter.append("AND oc.environment = ? ");
        }
        if (this.competitors != -1) {
            sqlFilter.append("AND oc.competitors = ? ");
        }
        if (this.compellingEvent != -1) {
            sqlFilter.append("AND oc.compelling_event = ? ");
        }
        if (this.budget != -1) {
            sqlFilter.append("AND oc.budget = ? ");
        }
        if (this.units != null) {
            sqlFilter.append("AND oc.units = ? ");
        }
        if (this.includeOnlyForGraph) {
            if (this.defaultUnits == null || "".equals(this.defaultUnits)) {
                sqlFilter.append("AND ((oc.units = ? AND oc.id IN ( SELECT id FROM opportunity_component WHERE " + DatabaseUtils.addTimestampInterval(db, 3, "terms", "closedate") + " > " + DatabaseUtils.getCurrentTimestamp(db) + " )) OR ( oc.units = ? AND oc.id IN (  " + "SELECT id FROM opportunity_component WHERE " + DatabaseUtils.addTimestampInterval(db, 2, "terms", "closedate") + " > " + DatabaseUtils.getCurrentTimestamp(db) + " ))) ");
            } else {
                sqlFilter.append("AND oc.id IN ( SELECT id FROM opportunity_component WHERE " + DatabaseUtils.addTimestampInterval(db, 2, "terms", "closedate", this.defaultUnits, Math.round(this.defaultTerms)) + " > " + DatabaseUtils.getCurrentTimestamp(db) + " ) ");
            }
        }
        if (this.contactId != -1) {
            sqlFilter.append("AND oc.opp_id IN (SELECT opp_id from opportunity_header x WHERE x.contactlink = ?) ");
        }
        if (this.orgId != -1) {
            sqlFilter.append("AND oc.opp_id IN (SELECT opp_id from opportunity_header x WHERE x.acctlink = ?) ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    public int reassignElements(Connection db, int newOwner) throws SQLException {
        int total = 0;
        for (OpportunityComponent thisOpp : this) {
            if (!thisOpp.reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }

    public int reassignElements(Connection db, int newOwner, int userId) throws SQLException {
        int total = 0;
        for (OpportunityComponent thisOpp : this) {
            thisOpp.setModifiedBy(userId);
            if (!thisOpp.reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.headerId != -1) {
            pst.setInt(++i, this.headerId);
        }
        if (this.enteredBy != -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.alertDate != null) {
            pst.setTimestamp(++i, this.alertDate);
        }
        if (this.alertRangeStart != null) {
            pst.setTimestamp(++i, this.alertRangeStart);
        }
        if (this.alertRangeEnd != null) {
            pst.setTimestamp(++i, this.alertRangeEnd);
        }
        if (this.closeDateStart != null) {
            pst.setTimestamp(++i, this.closeDateStart);
        }
        if (this.closeDateEnd != null) {
            pst.setTimestamp(++i, this.closeDateEnd);
        }
        if (this.controlledHierarchyOnly != -1) {
            if (this.controlledHierarchyOnly == 0) {
                pst.setInt(++i, this.getAccessType());
            }
        } else if (this.owner != -1) {
            pst.setInt(++i, this.owner);
        }
        if (!this.includeOnlyTrashed && this.trashedDate != null) {
            pst.setTimestamp(++i, this.trashedDate);
        }
        if (this.environment != -1) {
            DatabaseUtils.setInt(pst, ++i, this.getEnvironment());
        }
        if (this.competitors != -1) {
            DatabaseUtils.setInt(pst, ++i, this.getCompetitors());
        }
        if (this.compellingEvent != -1) {
            DatabaseUtils.setInt(pst, ++i, this.getCompellingEvent());
        }
        if (this.budget != -1) {
            DatabaseUtils.setInt(pst, ++i, this.getBudget());
        }
        if (this.units != null) {
            pst.setString(++i, this.units);
        }
        if (this.includeOnlyForGraph && (this.defaultUnits == null || "".equals(this.defaultUnits))) {
            pst.setString(++i, "M");
            pst.setString(++i, "W");
        }
        if (this.contactId != -1) {
            pst.setInt(++i, this.contactId);
        }
        if (this.orgId != -1) {
            pst.setInt(++i, this.orgId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public static int retrieveRecordCount(Connection db, int moduleId, int itemId) throws SQLException {
        int count = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(*) as itemcount FROM opportunity_component oc WHERE opp_id > 0 ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            count = rs.getInt("itemcount");
        }
        rs.close();
        pst.close();
        return count;
    }

    public boolean updateStatus(Connection db, ActionContext context, boolean toTrash, int tmpUserId) throws SQLException {
        for (OpportunityComponent tmpOpportunityComponent : this) {
            tmpOpportunityComponent.updateStatus(db, context, toTrash, tmpUserId);
        }
        return true;
    }

    public void invalidateUserData(ActionContext context) throws SQLException {
        for (OpportunityComponent tmpOpportunityComponent : this) {
            tmpOpportunityComponent.invalidateUserData(context);
        }
    }

    public double getGuessSum() {
        double sum = 0.0;
        for (OpportunityComponent component : this) {
            sum += component.getGuess();
        }
        return sum;
    }
}

