/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.utils.DatabaseUtils;

public class OpportunityComponentLog
extends GenericBean {
    protected int id = -1;
    protected int componentId = -1;
    protected int headerId = -1;
    protected String description = null;
    protected double closeProb = 0.0;
    protected Timestamp closeDate = null;
    protected double terms = 0.0;
    protected String units = null;
    protected double low = 0.0;
    protected double guess = 0.0;
    protected double high = 0.0;
    protected int stage = -1;
    protected String stageName = null;
    protected int owner = -1;
    protected Timestamp entered = null;
    protected int enteredBy = -1;
    protected String closeDateTimeZone = null;
    protected Timestamp closed = null;

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getComponentId() {
        return this.componentId;
    }

    public void setComponentId(int tmp) {
        this.componentId = tmp;
    }

    public void setComponentId(String tmp) {
        this.componentId = Integer.parseInt(tmp);
    }

    public int getHeaderId() {
        return this.headerId;
    }

    public void setHeaderId(int tmp) {
        this.headerId = tmp;
    }

    public void setHeaderId(String tmp) {
        this.headerId = Integer.parseInt(tmp);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public double getCloseProb() {
        return this.closeProb;
    }

    public void setCloseProb(double tmp) {
        this.closeProb = tmp;
    }

    public void setCloseProb(String tmp) {
        this.closeProb = Double.parseDouble(tmp);
    }

    public Timestamp getCloseDate() {
        return this.closeDate;
    }

    public void setCloseDate(Timestamp tmp) {
        this.closeDate = tmp;
    }

    public void setCloseDate(String tmp) {
        this.closeDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public double getTerms() {
        return this.terms;
    }

    public void setTerms(double tmp) {
        this.terms = tmp;
    }

    public void setTerms(String tmp) {
        this.terms = Double.parseDouble(tmp);
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String tmp) {
        this.units = tmp;
    }

    public double getLow() {
        return this.low;
    }

    public void setLow(double tmp) {
        this.low = tmp;
    }

    public void setLow(String tmp) {
        this.low = Double.parseDouble(tmp);
    }

    public double getGuess() {
        return this.guess;
    }

    public void setGuess(double tmp) {
        this.guess = tmp;
    }

    public void setGuess(String tmp) {
        this.guess = Double.parseDouble(tmp);
    }

    public double getHigh() {
        return this.high;
    }

    public void setHigh(double tmp) {
        this.high = tmp;
    }

    public void setHigh(String tmp) {
        this.high = Double.parseDouble(tmp);
    }

    public int getStage() {
        return this.stage;
    }

    public void setStage(int tmp) {
        this.stage = tmp;
    }

    public void setStage(String tmp) {
        this.stage = Integer.parseInt(tmp);
    }

    public void setStageName(String tmp) {
        this.stageName = tmp;
    }

    public int getOwner() {
        return this.owner;
    }

    public void setOwner(int tmp) {
        this.owner = tmp;
    }

    public void setOwner(String tmp) {
        this.owner = Integer.parseInt(tmp);
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public String getCloseDateTimeZone() {
        return this.closeDateTimeZone;
    }

    public void setCloseDateTimeZone(String tmp) {
        this.closeDateTimeZone = tmp;
    }

    public Timestamp getClosed() {
        return this.closed;
    }

    public void setClosed(Timestamp tmp) {
        this.closed = tmp;
    }

    public void setClosed(String tmp) {
        this.closed = DatabaseUtils.parseTimestamp(tmp);
    }

    public OpportunityComponentLog() {
    }

    public OpportunityComponentLog(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public OpportunityComponentLog(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public OpportunityComponentLog(Connection db, String id) throws SQLException {
        this.queryRecord(db, Integer.parseInt(id));
    }

    public OpportunityComponentLog(Connection db, OpportunityComponent oppComp) throws SQLException {
        OpportunityComponent component = new OpportunityComponent(db, oppComp.getId());
        this.headerId = component.getHeaderId();
        this.componentId = component.getId();
        this.description = component.getDescription();
        this.closeProb = component.getCloseProb();
        this.closeDate = component.getCloseDate();
        this.terms = component.getTerms();
        this.units = component.getUnits();
        this.low = component.getLow();
        this.guess = component.getGuess();
        this.high = component.getHigh();
        this.stage = component.getStage();
        this.owner = component.getOwner();
        this.closeDateTimeZone = component.getAlertDateTimeZone();
        this.enteredBy = component.getModifiedBy();
        this.entered = component.getModified();
        this.closed = DatabaseUtils.parseTimestamp(component.getClosed());
    }

    public String getStageName() {
        if (this.getClosed() != null) {
            this.setStageName("Closed");
        }
        return this.stageName;
    }

    public String getCloseProbValue() {
        double value_2dp = (double)Math.round(this.closeProb * 100.0 * 100.0) / 100.0;
        String toReturn = String.valueOf(value_2dp);
        if (toReturn.endsWith(".0")) {
            return toReturn.substring(0, toReturn.length() - 2);
        }
        return toReturn;
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Opportunity Component Log ID not specified.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT ocl.*, y.description as stagename FROM opportunity_component_log ocl LEFT JOIN lookup_stage y ON (ocl.stage = y.code ) WHERE id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
    }

    public boolean insert(Connection db) throws SQLException {
        if (this.getHeaderId() == -1) {
            throw new SQLException("You must associate an opportunity component with an opportunity.");
        }
        boolean doCommit = false;
        try {
            doCommit = db.getAutoCommit();
            if (doCommit) {
                db.setAutoCommit(false);
            }
            StringBuffer sql = new StringBuffer();
            this.id = DatabaseUtils.getNextSeq(db, "opportunity_component_log_id_seq");
            sql.append("INSERT INTO opportunity_component_log (component_id, header_id, description, closeprob, closedate,  terms, units, lowvalue, guessvalue, highvalue, stage, owner,  closedate_timezone, ");
            if (this.id > -1) {
                sql.append("id, ");
            }
            if (this.closed != null) {
                sql.append("closed, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            sql.append("enteredBy ) ");
            sql.append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.closed != null) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            sql.append("? ) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setInt(++i, this.getComponentId());
            pst.setInt(++i, this.getHeaderId());
            pst.setString(++i, this.getDescription());
            pst.setDouble(++i, this.getCloseProb());
            pst.setTimestamp(++i, this.getCloseDate());
            pst.setDouble(++i, this.getTerms());
            pst.setString(++i, this.getUnits());
            pst.setDouble(++i, this.getLow());
            pst.setDouble(++i, this.getGuess());
            pst.setDouble(++i, this.getHigh());
            pst.setInt(++i, this.getStage());
            pst.setInt(++i, this.getOwner());
            pst.setString(++i, this.getCloseDateTimeZone());
            if (this.id > -1) {
                pst.setInt(++i, this.getId());
            }
            if (this.closed != null) {
                pst.setTimestamp(++i, this.closed);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.getEntered());
            }
            pst.setInt(++i, this.getEnteredBy());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "opportunity_component_log_id_seq", this.id);
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (doCommit) {
                db.rollback();
            }
            e.printStackTrace(System.out);
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.componentId = rs.getInt("component_id");
        this.headerId = rs.getInt("header_id");
        this.description = rs.getString("description");
        this.closeProb = rs.getDouble("closeprob");
        this.closeDate = rs.getTimestamp("closedate");
        this.terms = rs.getDouble("terms");
        this.units = rs.getString("units");
        this.low = rs.getDouble("lowvalue");
        this.guess = rs.getDouble("guessvalue");
        this.high = rs.getDouble("highvalue");
        this.stage = rs.getInt("stage");
        this.stageName = rs.getString("stagename");
        this.owner = rs.getInt("owner");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.closeDateTimeZone = rs.getString("closedate_timezone");
        this.closed = rs.getTimestamp("closed");
    }
}

