/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.pipeline.base.OpportunityComponentLog;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class OpportunityComponentLogList
extends ArrayList {
    public static final String tableName = "opportunity_component_log";
    public static final String uniqueField = "id";
    protected Timestamp lastAnchor = null;
    protected Timestamp nextAnchor = null;
    protected int syncType = -1;
    protected PagedListInfo pagedListInfo = null;
    protected int headerId = -1;
    protected int componentId = -1;

    public OpportunityComponentLogList() {
    }

    public OpportunityComponentLogList(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public static String getTableName() {
        return tableName;
    }

    public static String getUniqueField() {
        return uniqueField;
    }

    public int getComponentId() {
        return this.componentId;
    }

    public void setComponentId(int componentId) {
        this.componentId = componentId;
    }

    public int getHeaderId() {
        return this.headerId;
    }

    public void setHeaderId(int headerId) {
        this.headerId = headerId;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public void setLastAnchor(Timestamp lastAnchor) {
        this.lastAnchor = lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public void setNextAnchor(Timestamp nextAnchor) {
        this.nextAnchor = nextAnchor;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo pagedListInfo) {
        this.pagedListInfo = pagedListInfo;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public void setSyncType(int syncType) {
        this.syncType = syncType;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM opportunity_component_log ocl LEFT JOIN lookup_stage y ON (ocl.stage = y.code) WHERE ocl.id > -1 ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(ocl.description) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("ocl.entered", "asc");
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY ocl.entered");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("ocl.*, y.description AS stagename FROM opportunity_component_log ocl LEFT JOIN lookup_stage y ON (ocl.stage = y.code) WHERE ocl.id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            OpportunityComponentLog thisOppComponentLog = new OpportunityComponentLog(rs);
            this.add(thisOppComponentLog);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.headerId != -1) {
            sqlFilter.append("AND ocl.header_id = ? ");
        }
        if (this.componentId != -1) {
            sqlFilter.append("AND ocl.component_id = ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.headerId != -1) {
            pst.setInt(++i, this.headerId);
        }
        if (this.componentId != -1) {
            pst.setInt(++i, this.componentId);
        }
        return i;
    }
}

