/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.base;

import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.beans.GenericBean;
import com.zeroio.iteam.base.FileItemList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import org.aspcfs.modules.actionlist.base.ActionItemLog;
import org.aspcfs.modules.actionlist.base.ActionItemLogList;
import org.aspcfs.modules.actionlist.base.ActionList;
import org.aspcfs.modules.actionplans.base.ActionItemWorkList;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionPlanWorkList;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.CallList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactHistory;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.base.OpportunityComponentList;
import org.aspcfs.modules.quotes.base.QuoteList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;

public class OpportunityHeader
extends GenericBean {
    protected int id = -1;
    protected String description = null;
    private int accountLink = -1;
    private int contactLink = -1;
    private String accountName = "";
    private String contactName = "";
    private String contactCompanyName = "";
    private boolean accountEnabled = true;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private int manager = -1;
    private int accessType = -1;
    private int siteId = -1;
    private String siteName = null;
    private int custom1Integer = -1;
    private int componentCount = 0;
    private int ownerComponentCount = 0;
    private int componentId = -1;
    private boolean buildComponentCount = true;
    private boolean lock = false;
    private double totalValue = 0.0;
    private FileItemList files = new FileItemList();
    private Timestamp trashedDate = null;
    private OpportunityComponent component = null;
    private String managerOwnerIdRange = null;
    private boolean buildActionPlans = false;
    private ActionPlanWorkList planWorkList = null;
    private boolean buildRecordDetails = false;

    public boolean getBuildActionPlans() {
        return this.buildActionPlans;
    }

    public void setBuildActionPlans(boolean tmp) {
        this.buildActionPlans = tmp;
    }

    public void setBuildActionPlans(String tmp) {
        this.buildActionPlans = DatabaseUtils.parseBoolean(tmp);
    }

    public ActionPlanWorkList getPlanWorkList() {
        return this.planWorkList;
    }

    public void setPlanWorkList(ActionPlanWorkList tmp) {
        this.planWorkList = tmp;
    }

    public OpportunityHeader() {
    }

    public OpportunityHeader(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public OpportunityHeader(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Opportunity Header ID not specified.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT oh.opp_id AS header_opp_id, oh.description AS header_description, oh.acctlink AS header_acctlink, oh.contactlink AS header_contactlink, oh.entered AS header_entered, oh.enteredby AS header_enteredby, oh.modified AS header_modified, oh.modifiedby AS header_modifiedby, oh.trashed_date AS header_trashed_date, oh.manager AS header_manager, oh.access_type AS header_access_type, oh." + DatabaseUtils.addQuotes(db, "lock") + " AS header_lock, " + "oh.custom1_integer AS header_custom1_integer, oh.site_id AS header_site_id, " + "org.name as acct_name, org.enabled as accountenabled, " + "ct.namelast as last_name, ct.namefirst as first_name, " + "ct.org_name as ctcompany, lsi.description as sitename " + "FROM opportunity_header oh " + "LEFT JOIN organization org ON (oh.acctlink = org.org_id) " + "LEFT JOIN contact ct ON (oh.contactlink = ct.contact_id) " + "LEFT JOIN lookup_site_id lsi ON (oh.site_id = lsi.code) " + "WHERE opp_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
        if (this.buildComponentCount) {
            this.retrieveComponentCount(db);
        }
        if (this.buildActionPlans) {
            this.buildActionPlans(db);
        }
        if (this.buildRecordDetails) {
            this.buildRecordDetails(db);
        }
        this.buildFiles(db);
    }

    public void buildRecordDetails(Connection db) throws SQLException {
        if (this.contactLink > -1) {
            if (this.contactName == null || "".equals(this.contactName.trim())) {
                Contact contact = new Contact(db, this.contactLink);
                this.contactName = contact.getNameFull();
            }
        } else if (this.accountLink > -1) {
            // empty if block
        }
    }

    public void buildActionPlans(Connection db) throws SQLException {
        this.planWorkList = new ActionPlanWorkList();
        this.planWorkList.setOpportunityId(this.getId());
        this.planWorkList.setIncludeAllSites(true);
        this.planWorkList.buildList(db);
    }

    public OpportunityHeader(Connection db, String id) throws SQLException {
        this.queryRecord(db, Integer.parseInt(id));
    }

    public int getComponentCount() {
        return this.componentCount;
    }

    public void setOwnerComponentCount(int ownerComponentCount) {
        this.ownerComponentCount = ownerComponentCount;
    }

    public int getOwnerComponentCount() {
        return this.ownerComponentCount;
    }

    public void setComponentCount(int componentCount) {
        this.componentCount = componentCount;
    }

    public void setComponentCount(String componentCount) {
        this.componentCount = Integer.parseInt(componentCount);
    }

    public double getTotalValue() {
        return this.totalValue;
    }

    public double getTotalValue(int divisor) {
        return (double)Math.round(this.totalValue) / (double)divisor;
    }

    public void setTotalValue(double totalValue) {
        this.totalValue = totalValue;
    }

    public void setComponentId(int componentId) {
        this.componentId = componentId;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }

    public void setLock(String lock) {
        this.lock = DatabaseUtils.parseBoolean(lock);
    }

    public void setComponent(OpportunityComponent component) {
        this.component = component;
    }

    public void buildComponentDetails(Connection db) throws SQLException {
        if (this.component == null && this.componentId > -1) {
            this.component = new OpportunityComponent(db, this.componentId);
        }
    }

    public OpportunityComponent getComponent() {
        return this.component;
    }

    public boolean getLock() {
        return this.lock;
    }

    public int getComponentId() {
        return this.componentId;
    }

    public String getShortDescription() {
        if (this.description == null) {
            return null;
        }
        if (this.description.length() <= 40) {
            return this.description;
        }
        return this.description.substring(0, 40) + "...";
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public int getAccountLink() {
        return this.accountLink;
    }

    public int getContactLink() {
        return this.contactLink;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getContactName() {
        return this.contactName;
    }

    public String getContactCompanyName() {
        return this.contactCompanyName;
    }

    public String getDisplayName() {
        StringBuffer sb = new StringBuffer();
        if (this.accountName != null) {
            sb.append(this.accountName);
        }
        if (this.contactName != null && !"".equals(this.contactName.trim())) {
            if (sb.length() > 0) {
                sb.append(" (" + this.contactName + ")");
            } else {
                sb.append(this.contactName);
            }
        }
        if (this.contactCompanyName != null && !"".equals(this.contactCompanyName.trim())) {
            if (sb.length() > 0) {
                sb.append(" (" + this.contactCompanyName + ")");
            } else {
                sb.append(this.contactCompanyName);
            }
        }
        return sb.toString();
    }

    public boolean getAccountEnabled() {
        return this.accountEnabled;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setAccountLink(int tmp) {
        this.accountLink = tmp;
    }

    public void setContactLink(int tmp) {
        this.contactLink = tmp;
    }

    public void setAccountLink(String tmp) {
        this.accountLink = Integer.parseInt(tmp);
    }

    public void setContactLink(String tmp) {
        this.contactLink = Integer.parseInt(tmp);
    }

    public boolean getBuildComponentCount() {
        return this.buildComponentCount;
    }

    public void setBuildComponentCount(boolean buildComponentCount) {
        this.buildComponentCount = buildComponentCount;
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getModifiedString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public void buildFiles(Connection db) throws SQLException {
        this.files.clear();
        this.files.setLinkModuleId(3);
        this.files.setLinkItemId(this.getId());
        this.files.buildList(db);
    }

    public boolean hasFiles() {
        return this.files != null && this.files.size() > 0;
    }

    public void setAccountName(String tmp) {
        this.accountName = tmp;
    }

    public void setContactName(String tmp) {
        this.contactName = tmp;
    }

    public void setContactCompanyName(String tmp) {
        this.contactCompanyName = tmp;
    }

    public void setAccountEnabled(boolean tmp) {
        this.accountEnabled = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setCustom1Integer(int tmp) {
        this.custom1Integer = tmp;
    }

    public void setCustom1Integer(String tmp) {
        this.custom1Integer = Integer.parseInt(tmp);
    }

    public int getCustom1Integer() {
        return this.custom1Integer;
    }

    public FileItemList getFiles() {
        return this.files;
    }

    public void setFiles(FileItemList files) {
        this.files = files;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public int getManager() {
        return this.manager;
    }

    public void setManager(int tmp) {
        this.manager = tmp;
    }

    public void setManager(String tmp) {
        this.manager = Integer.parseInt(tmp);
    }

    public int getAccessType() {
        return this.accessType;
    }

    public void setAccessType(int tmp) {
        this.accessType = tmp;
    }

    public void setAccessType(String tmp) {
        this.accessType = Integer.parseInt(tmp);
    }

    public String getManagerOwnerIdRange() {
        return this.managerOwnerIdRange;
    }

    public void setManagerOwnerIdRange(String tmp) {
        this.managerOwnerIdRange = tmp;
    }

    public boolean getBuildRecordDetails() {
        return this.buildRecordDetails;
    }

    public void setBuildRecordDetails(boolean tmp) {
        this.buildRecordDetails = tmp;
    }

    public void setBuildRecordDetails(String tmp) {
        this.buildRecordDetails = DatabaseUtils.parseBoolean(tmp);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String tmp) {
        this.siteName = tmp;
    }

    public boolean insert(Connection db, ActionContext context) throws SQLException {
        return this.insert(db);
    }

    public boolean disable(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Opportunity Header ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("UPDATE opportunity_component SET enabled = ? WHERE opp_id = ? ");
        int i = 0;
        pst.setBoolean(++i, false);
        pst.setInt(++i, this.id);
        int resultCount = pst.executeUpdate();
        pst.close();
        return resultCount == 1;
    }

    public boolean insert(Connection db) throws SQLException {
        Contact thisContact = null;
        if (this.getAccountLink() == -1 && this.getContactLink() == -1) {
            throw new SQLException("You must associate an Opportunity Header with an account or contact.");
        }
        boolean doCommit = false;
        try {
            doCommit = db.getAutoCommit();
            if (doCommit) {
                db.setAutoCommit(false);
            }
            if (this.getContactLink() > 0) {
                thisContact = new Contact(db, this.getContactLink());
            }
            StringBuffer sql = new StringBuffer();
            this.id = DatabaseUtils.getNextSeq(db, "opportunity_header_opp_id_seq");
            sql.append("INSERT INTO opportunity_header (acctlink, contactlink, description, trashed_date, manager, access_type, site_id, ");
            if (this.id > -1) {
                sql.append("opp_id, ");
            }
            if (thisContact != null && thisContact.getOrgId() > 0) {
                sql.append("contact_org_id, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("enteredBy, modifiedBy, custom1_integer ) ");
            sql.append("VALUES (?, ?, ?, ?, ?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (thisContact != null && thisContact.getOrgId() > 0) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("?, ?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            DatabaseUtils.setInt(pst, ++i, this.getAccountLink());
            DatabaseUtils.setInt(pst, ++i, this.getContactLink());
            pst.setString(++i, this.getDescription());
            DatabaseUtils.setTimestamp(pst, ++i, this.getTrashedDate());
            DatabaseUtils.setInt(pst, ++i, this.getManager());
            DatabaseUtils.setInt(pst, ++i, this.getAccessType());
            DatabaseUtils.setInt(pst, ++i, this.getSiteId());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (thisContact != null && thisContact.getOrgId() > 0) {
                pst.setInt(++i, thisContact.getOrgId());
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            if (this.modified != null) {
                pst.setTimestamp(++i, this.modified);
            }
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            DatabaseUtils.setInt(pst, ++i, this.getCustom1Integer());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "opportunity_header_opp_id_seq", this.id);
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void updateLog(Connection db, int actionId) throws SQLException {
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            ActionItemLog thisLog = new ActionItemLog();
            thisLog.setEnteredBy(this.getEnteredBy());
            thisLog.setModifiedBy(this.getModifiedBy());
            thisLog.setItemId(actionId);
            thisLog.setLinkItemId(this.getId());
            thisLog.setType(42420032);
            thisLog.insert(db);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.id == -1) {
            throw new SQLException("Opportunity Header ID was not specified");
        }
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            resultCount = this.update(db, false);
            if (commit) {
                db.commit();
            }
        }
        catch (Exception e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return resultCount;
    }

    public DependencyList processDependencies(Connection db, boolean multiple) throws SQLException {
        Dependency thisDependency;
        ResultSet rs = null;
        DependencyList dependencyList = new DependencyList();
        String sql = "SELECT COUNT(*) as callcount FROM call_log c WHERE c.opp_id = ? AND c.trashed_date IS NULL ";
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(++i, this.getId());
        rs = pst.executeQuery();
        if (rs.next()) {
            thisDependency = new Dependency();
            thisDependency.setName("calls");
            thisDependency.setCount(rs.getInt("callcount"));
            thisDependency.setCanDelete(true);
            dependencyList.add(thisDependency);
        }
        rs.close();
        pst.close();
        sql = "SELECT COUNT(*) as documentcount FROM project_files pf WHERE pf.link_module_id = ? and pf.link_item_id = ? ";
        i = 0;
        pst = db.prepareStatement(sql);
        pst.setInt(++i, 3);
        pst.setInt(++i, this.getId());
        rs = pst.executeQuery();
        if (rs.next()) {
            thisDependency = new Dependency();
            thisDependency.setName("documents");
            thisDependency.setCount(rs.getInt("documentcount"));
            thisDependency.setCanDelete(true);
            dependencyList.add(thisDependency);
        }
        rs.close();
        pst.close();
        if (multiple) {
            sql = "SELECT COUNT(*) as componentcount FROM opportunity_component oc WHERE oc.opp_id = ? AND oc.trashed_date IS NULL ";
            i = 0;
            pst = db.prepareStatement(sql);
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next()) {
                thisDependency = new Dependency();
                thisDependency.setName("components");
                thisDependency.setCount(rs.getInt("componentcount"));
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        sql = "SELECT COUNT(DISTINCT(group_id)) as quotecount FROM quote_entry qe WHERE qe.opp_id = ? AND qe.trashed_date IS NULL ";
        i = 0;
        pst = db.prepareStatement(sql);
        pst.setInt(++i, this.getId());
        rs = pst.executeQuery();
        if (rs.next()) {
            thisDependency = new Dependency();
            thisDependency.setName("quotes");
            thisDependency.setCount(rs.getInt("quotecount"));
            thisDependency.setCanDelete(true);
            dependencyList.add(thisDependency);
        }
        rs.close();
        pst.close();
        ActionList actionList = ActionItemLogList.isItemLinked(db, this.getId(), 42420032);
        if (actionList != null) {
            Dependency thisDependency2 = new Dependency();
            thisDependency2.setName("actionLists");
            thisDependency2.setCount(1);
            thisDependency2.setCanDelete(true);
            dependencyList.add(thisDependency2);
        }
        return dependencyList;
    }

    public boolean resetType(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Opportunity ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("DELETE FROM opportunity_component_levels WHERE opp_id in (SELECT id from opportunity_component oc where oc.opp_id = ?) ");
        pst.setInt(1, this.id);
        pst.execute();
        pst.close();
        return true;
    }

    public boolean delete(Connection db, ActionContext context, String baseFilePath) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("The Opportunity Record could not be found.");
        }
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            this.resetType(db);
            ActionItemLog.deleteLink(db, this.getId(), 42420032);
            CallList callList = new CallList();
            callList.setOppHeaderId(this.id);
            callList.buildList(db);
            callList.delete(db);
            callList = null;
            callList = new CallList();
            callList.setOppHeaderId(this.id);
            callList.setIncludeOnlyTrashed(true);
            callList.buildList(db);
            callList.delete(db);
            callList = null;
            FileItemList fileList = new FileItemList();
            fileList.setLinkModuleId(3);
            fileList.setLinkItemId(this.getId());
            fileList.buildList(db);
            fileList.delete(db, this.getFileLibraryPath(baseFilePath, "opportunities"));
            fileList = null;
            QuoteList quoteList = new QuoteList();
            quoteList.setHeaderId(this.getId());
            quoteList.setDeleteAllQuotes(true);
            quoteList.buildList(db);
            quoteList.delete(db);
            quoteList = new QuoteList();
            quoteList.setHeaderId(this.getId());
            quoteList.setDeleteAllQuotes(true);
            quoteList.setIncludeOnlyTrashed(true);
            quoteList.buildList(db);
            quoteList.delete(db);
            OpportunityComponentList oppComponentList = new OpportunityComponentList();
            oppComponentList.setHeaderId(this.getId());
            oppComponentList.buildList(db);
            for (OpportunityComponent component : oppComponentList) {
                ContactHistory.deleteObject(db, 4, component.getId());
                component.delete(db, context);
            }
            oppComponentList = new OpportunityComponentList();
            oppComponentList.setHeaderId(this.getId());
            oppComponentList.setIncludeOnlyTrashed(true);
            oppComponentList.buildList(db);
            for (OpportunityComponent component : oppComponentList) {
                ContactHistory.deleteObject(db, 4, component.getId());
                component.delete(db, context);
            }
            PreparedStatement pst = db.prepareStatement("DELETE FROM opportunity_header WHERE opp_id = ? ");
            pst.setInt(1, this.id);
            pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("header_opp_id");
        this.description = rs.getString("header_description");
        this.accountLink = DatabaseUtils.getInt(rs, "header_acctlink");
        this.contactLink = DatabaseUtils.getInt(rs, "header_contactlink");
        this.entered = rs.getTimestamp("header_entered");
        this.enteredBy = rs.getInt("header_enteredby");
        this.modified = rs.getTimestamp("header_modified");
        this.modifiedBy = rs.getInt("header_modifiedby");
        this.trashedDate = rs.getTimestamp("header_trashed_date");
        this.manager = rs.getInt("header_manager");
        this.accessType = rs.getInt("header_access_type");
        this.lock = rs.getBoolean("header_lock");
        this.custom1Integer = rs.getInt("header_custom1_integer");
        this.siteId = DatabaseUtils.getInt(rs, "header_site_id");
        this.accountName = rs.getString("acct_name");
        this.accountEnabled = rs.getBoolean("accountenabled");
        String contactNameLast = rs.getString("last_name");
        String contactNameFirst = rs.getString("first_name");
        this.contactName = Contact.getNameLastFirst(contactNameLast, contactNameFirst);
        this.contactCompanyName = rs.getString("ctcompany");
        this.siteName = rs.getString("sitename");
    }

    protected int update(Connection db, boolean override) throws SQLException {
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        if (System.getProperty("DEBUG") != null) {
            System.out.println("Opportunity Header-> Updating the opportunity header");
        }
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            sql.append("UPDATE opportunity_header SET description = ?, acctlink = ?, contactlink = ?, custom1_integer = ?, trashed_date = ?, manager = ?, access_type = ?, ");
            if (!override) {
                sql.append("modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", ");
            }
            sql.append("modifiedby = ? ");
            sql.append("WHERE opp_id = ? ");
            if (!override) {
                sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
            }
            int i = 0;
            pst = db.prepareStatement(sql.toString());
            pst.setString(++i, this.getDescription());
            DatabaseUtils.setInt(pst, ++i, this.accountLink);
            DatabaseUtils.setInt(pst, ++i, this.contactLink);
            DatabaseUtils.setInt(pst, ++i, this.custom1Integer);
            DatabaseUtils.setTimestamp(pst, ++i, this.trashedDate);
            DatabaseUtils.setInt(pst, ++i, this.getManager());
            DatabaseUtils.setInt(pst, ++i, this.getAccessType());
            pst.setInt(++i, this.modifiedBy);
            pst.setInt(++i, this.id);
            if (!override && this.getModified() != null) {
                pst.setTimestamp(++i, this.modified);
            }
            resultCount = pst.executeUpdate();
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Opportunity Header-> ResultCount: " + resultCount);
            }
            pst.close();
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return resultCount;
    }

    public boolean updateStatus(Connection db, ActionContext context, boolean toTrash, int tmpUserId) throws SQLException {
        int count = 0;
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE opportunity_header SET trashed_date = ? , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , " + "modifiedby = ? " + "WHERE opp_id = ? ");
            int i = 0;
            pst = db.prepareStatement(sql.toString());
            if (toTrash) {
                DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(System.currentTimeMillis()));
            } else {
                DatabaseUtils.setTimestamp(pst, ++i, null);
            }
            DatabaseUtils.setInt(pst, ++i, tmpUserId);
            pst.setInt(++i, this.id);
            count = pst.executeUpdate();
            pst.close();
            QuoteList quoteList = new QuoteList();
            quoteList.setHeaderId(this.getId());
            if (!toTrash) {
                quoteList.setIncludeOnlyTrashed(true);
            }
            quoteList.setDeleteAllQuotes(true);
            quoteList.buildList(db);
            quoteList.updateStatus(db, toTrash, tmpUserId);
            OpportunityComponentList opportunityComponentList = new OpportunityComponentList();
            opportunityComponentList.setHeaderId(this.getId());
            if (!toTrash) {
                opportunityComponentList.setIncludeOnlyTrashed(true);
            }
            opportunityComponentList.buildList(db);
            opportunityComponentList.updateStatus(db, context, toTrash, tmpUserId);
            CallList callList = new CallList();
            callList.setOppHeaderId(this.getId());
            if (!toTrash) {
                callList.setIncludeOnlyTrashed(true);
            }
            callList.buildList(db);
            callList.updateStatus(db, toTrash, tmpUserId);
            this.invalidateUserData(context, db);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public boolean reassign(Connection db, int newOwner) throws SQLException {
        int result = -1;
        this.setManager(newOwner);
        result = this.update(db);
        return result != -1;
    }

    public void invalidateUserData(ActionContext context, Connection db) throws SQLException {
        OpportunityComponentList opportunityComponentList = new OpportunityComponentList();
        opportunityComponentList.setHeaderId(this.getId());
        opportunityComponentList.setIncludeOnlyTrashed(true);
        opportunityComponentList.buildList(db);
        opportunityComponentList.invalidateUserData(context);
        opportunityComponentList = new OpportunityComponentList();
        opportunityComponentList.setHeaderId(this.getId());
        opportunityComponentList.buildList(db);
        opportunityComponentList.invalidateUserData(context);
    }

    public void retrieveComponentCount(Connection db) throws SQLException {
        this.retrieveComponentCount(db, -1);
    }

    public void retrieveComponentCount(Connection db, int ownerId) throws SQLException {
        int count = 0;
        PreparedStatement pst = db.prepareStatement("SELECT COUNT(*) as componentcount FROM opportunity_component oc WHERE oc.opp_id = ? ");
        pst.setInt(1, this.id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            count = rs.getInt("componentcount");
        }
        rs.close();
        pst.close();
        this.setComponentCount(count);
        if (ownerId > -1) {
            pst = db.prepareStatement("SELECT COUNT(*) as componentcount FROM opportunity_component oc WHERE oc.opp_id = ? AND oc.owner = ? ");
            pst.setInt(1, this.id);
            pst.setInt(2, ownerId);
            rs = pst.executeQuery();
            if (rs.next()) {
                count = rs.getInt("componentcount");
            }
            rs.close();
            pst.close();
            this.setOwnerComponentCount(count);
        }
    }

    public void buildTotal(Connection db) throws SQLException {
        this.buildTotal(db, -1);
    }

    public void buildTotal(Connection db, int ownerId) throws SQLException {
        ResultSet rs;
        double total = 0.0;
        PreparedStatement pst = db.prepareStatement("SELECT sum(guessvalue) as total FROM opportunity_component oc WHERE oc.opp_id = ? AND oc.closed IS NULL " + (ownerId != -1 ? "AND oc.owner = ? " : ""));
        pst.setInt(1, this.id);
        if (ownerId != -1) {
            pst.setInt(2, ownerId);
        }
        if ((rs = pst.executeQuery()).next()) {
            total = rs.getDouble("total");
        }
        rs.close();
        pst.close();
        this.setTotalValue(total);
    }

    public static boolean isComponentOwner(Connection db, int id, int userId) throws SQLException {
        boolean isOwner = false;
        PreparedStatement pst = db.prepareStatement("SELECT opp_id FROM opportunity_component oc WHERE oc.opp_id = ? AND oc.owner = ?");
        pst.setInt(1, id);
        pst.setInt(2, userId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            isOwner = true;
        }
        rs.close();
        pst.close();
        return isOwner;
    }

    public boolean isTrashed() {
        return this.trashedDate != null;
    }

    public void buildManagerOwnerIdRange(Connection db, AccessTypeList accessTypeList, String userIdRange) throws SQLException {
        OpportunityComponentList components = new OpportunityComponentList();
        components.setControlledHierarchy(this.getAccessType() == accessTypeList.getCode(626030334) ? 0 : 1, userIdRange);
        components.setAccessType(this.getAccessType());
        components.setHeaderId(this.getId());
        components.buildList(db);
        StringBuffer users = new StringBuffer();
        users.append(this.manager);
        for (OpportunityComponent component : components) {
            if (component.getOwner() == this.manager) continue;
            users.append("," + component.getOwner());
        }
        this.setManagerOwnerIdRange(users.toString());
    }

    public void insertOpportunitySiteId(Connection db, int sId) throws SQLException {
        if (sId != -1) {
            PreparedStatement pst = db.prepareStatement("UPDATE opportunity_header SET site_id = ? WHERE opp_id = ? ");
            pst.setInt(1, sId);
            pst.setInt(2, this.getId());
            pst.executeUpdate();
            pst.close();
        }
    }

    public void checkResetActionStepAttachment(Connection db, OpportunityHeader oldHeader) throws SQLException {
        Contact contact;
        boolean resetAttachments = false;
        if (this.getAccountLink() != -1 && oldHeader.getAccountLink() != -1 && oldHeader.getAccountLink() != this.getAccountLink()) {
            resetAttachments = true;
        } else if (this.getAccountLink() == -1 && oldHeader.getAccountLink() != -1) {
            contact = new Contact(db, this.getContactLink());
            if (oldHeader.getAccountLink() != contact.getOrgId()) {
                resetAttachments = true;
            }
        } else if (this.getAccountLink() != -1 && oldHeader.getAccountLink() == -1) {
            contact = new Contact(db, oldHeader.getContactLink());
            if (contact.getOrgId() != this.getAccountLink()) {
                resetAttachments = true;
            }
        } else if (this.getAccountLink() == -1 && oldHeader.getAccountLink() == -1) {
            Contact contact1 = new Contact(db, this.getContactLink());
            Contact contact2 = new Contact(db, oldHeader.getContactLink());
            if (contact1.getOrgId() != contact2.getOrgId()) {
                resetAttachments = true;
            }
        }
        if (resetAttachments) {
            OpportunityComponentList components = new OpportunityComponentList();
            components.setHeaderId(this.getId());
            components.buildList(db);
            for (OpportunityComponent component : components) {
                ActionItemWorkList workList = new ActionItemWorkList();
                workList.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 1011200517));
                workList.setLinkItemId(component.getId());
                workList.buildList(db);
                workList.resetAttachment(db);
            }
        }
    }
}

