/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.base.OpportunityComponentList;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class OpportunityHeaderList
extends ArrayList {
    public static final String tableName = "opportunity_header";
    public static final String uniqueField = "opp_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    protected PagedListInfo pagedListInfo = null;
    protected int orgId = -1;
    protected int contactId = -1;
    protected int owner = -1;
    protected String ownerIdRange = null;
    protected ArrayList ignoreTypeIdList = new ArrayList();
    protected String description = null;
    protected int enteredBy = -1;
    protected boolean hasAlertDate = false;
    protected java.sql.Date alertDate = null;
    protected String accountOwnerIdRange = null;
    protected java.sql.Date alertRangeStart = null;
    protected java.sql.Date alertRangeEnd = null;
    protected java.sql.Date closeDateStart = null;
    protected java.sql.Date closeDateEnd = null;
    private boolean queryOpenOnly = false;
    private boolean queryClosedOnly = false;
    private int accessType = -1;
    private int controlledHierarchyOnly = -1;
    private int manager = -1;
    private int siteId = -1;
    private boolean includeAllSites = true;
    private boolean exclusiveToSite = false;
    private Timestamp trashedDate = null;
    private boolean includeOnlyTrashed = false;
    private boolean buildTotalValues = false;
    private int componentsOwnedByUser = -1;
    private boolean buildActionPlans = false;
    private boolean allowMultipleComponents = true;

    public void setAllowMultipleComponents(boolean tmp) {
        this.allowMultipleComponents = tmp;
    }

    public void setAllowMultipleComponents(String tmp) {
        this.allowMultipleComponents = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getAllowMultipleComponents() {
        return this.allowMultipleComponents;
    }

    public boolean getBuildActionPlans() {
        return this.buildActionPlans;
    }

    public void setBuildActionPlans(boolean tmp) {
        this.buildActionPlans = tmp;
    }

    public void setBuildActionPlans(String tmp) {
        this.buildActionPlans = DatabaseUtils.parseBoolean(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setBuildTotalValues(boolean buildTotalValues) {
        this.buildTotalValues = buildTotalValues;
    }

    public void setComponentsOwnedByUser(int componentsOwnedByUser) {
        this.componentsOwnedByUser = componentsOwnedByUser;
    }

    public int getComponentsOwnedByUser() {
        return this.componentsOwnedByUser;
    }

    public boolean getBuildTotalValues() {
        return this.buildTotalValues;
    }

    public void setAccountOwnerIdRange(String accountOwnerIdRange) {
        this.accountOwnerIdRange = accountOwnerIdRange;
    }

    public void setOwnerIdRange(String ownerIdRange) {
        this.ownerIdRange = ownerIdRange;
    }

    public void setAlertRangeStart(java.sql.Date tmp) {
        this.alertRangeStart = tmp;
    }

    public void setAlertRangeStart(String tmp) {
        this.alertRangeStart = java.sql.Date.valueOf(tmp);
    }

    public void setAlertRangeEnd(java.sql.Date tmp) {
        this.alertRangeEnd = tmp;
    }

    public void setAlertRangeEnd(String tmp) {
        this.alertRangeEnd = java.sql.Date.valueOf(tmp);
    }

    public void setQueryClosedOnly(boolean queryClosedOnly) {
        this.queryClosedOnly = queryClosedOnly;
    }

    public boolean getQueryClosedOnly() {
        return this.queryClosedOnly;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setIncludeOnlyTrashed(boolean tmp) {
        this.includeOnlyTrashed = tmp;
    }

    public void setIncludeOnlyTrashed(String tmp) {
        this.includeOnlyTrashed = DatabaseUtils.parseBoolean(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public boolean getIncludeOnlyTrashed() {
        return this.includeOnlyTrashed;
    }

    public java.sql.Date getAlertRangeStart() {
        return this.alertRangeStart;
    }

    public java.sql.Date getAlertRangeEnd() {
        return this.alertRangeEnd;
    }

    public boolean getQueryOpenOnly() {
        return this.queryOpenOnly;
    }

    public void setQueryOpenOnly(boolean queryOpenOnly) {
        this.queryOpenOnly = queryOpenOnly;
    }

    public void setHasAlertDate(boolean tmp) {
        this.hasAlertDate = tmp;
    }

    public void setAlertDate(java.sql.Date tmp) {
        this.alertDate = tmp;
    }

    public java.sql.Date getCloseDateStart() {
        return this.closeDateStart;
    }

    public java.sql.Date getCloseDateEnd() {
        return this.closeDateEnd;
    }

    public void setCloseDateStart(java.sql.Date tmp) {
        this.closeDateStart = tmp;
    }

    public void setCloseDateStart(String tmp) {
        try {
            Date tmpDate = DateFormat.getDateInstance(3).parse(tmp);
            this.closeDateStart = new java.sql.Date(new Date().getTime());
            this.closeDateStart.setTime(tmpDate.getTime());
        }
        catch (Exception e) {
            this.closeDateStart = null;
        }
    }

    public void setCloseDateEnd(java.sql.Date tmp) {
        this.closeDateEnd = tmp;
    }

    public void setCloseDateEnd(String tmp) {
        try {
            Date tmpDate = DateFormat.getDateInstance(3).parse(tmp);
            this.closeDateEnd = new java.sql.Date(new Date().getTime());
            this.closeDateEnd.setTime(tmpDate.getTime());
        }
        catch (Exception e) {
            this.closeDateEnd = null;
        }
    }

    public void setOwner(int tmp) {
        this.owner = tmp;
    }

    public void setOwner(String tmp) {
        this.owner = Integer.parseInt(tmp);
    }

    public String getAccountOwnerIdRange() {
        return this.accountOwnerIdRange;
    }

    public String getOwnerIdRange() {
        return this.ownerIdRange;
    }

    public int getListSize() {
        return this.size();
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public boolean getHasAlertDate() {
        return this.hasAlertDate;
    }

    public String getDescription() {
        return this.description;
    }

    public int getAccessType() {
        return this.accessType;
    }

    public void setAccessType(int tmp) {
        this.accessType = tmp;
    }

    public void setAccessType(String tmp) {
        this.accessType = Integer.parseInt(tmp);
    }

    public int getControlledHierarchyOnly() {
        return this.controlledHierarchyOnly;
    }

    public void setControlledHierarchyOnly(int tmp) {
        this.controlledHierarchyOnly = tmp;
    }

    public void setControlledHierarchyOnly(String tmp) {
        this.controlledHierarchyOnly = Integer.parseInt(tmp);
    }

    public void setControlledHierarchy(int tmp, String ownerRange) {
        this.controlledHierarchyOnly = tmp;
        this.ownerIdRange = ownerRange;
    }

    public int getManager() {
        return this.manager;
    }

    public void setManager(int tmp) {
        this.manager = tmp;
    }

    public void setManager(String tmp) {
        this.manager = Integer.parseInt(tmp);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public boolean getIncludeAllSites() {
        return this.includeAllSites;
    }

    public void setIncludeAllSites(boolean tmp) {
        this.includeAllSites = tmp;
    }

    public void setIncludeAllSites(String tmp) {
        this.includeAllSites = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getExclusiveToSite() {
        return this.exclusiveToSite;
    }

    public void setExclusiveToSite(boolean tmp) {
        this.exclusiveToSite = tmp;
    }

    public void setExclusiveToSite(String tmp) {
        this.exclusiveToSite = DatabaseUtils.parseBoolean(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM opportunity_header x WHERE x.opp_id > -1 ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(x.description) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("x.description", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY x.entered");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("x.opp_id AS header_opp_id, x.description AS header_description, x.acctlink AS header_acctlink, x.contactlink AS header_contactlink, x.entered AS header_entered, x.enteredby AS header_enteredby, x.modified AS header_modified, x.modifiedby AS header_modifiedby, x.trashed_date AS header_trashed_date, x.manager AS header_manager, x.access_type AS header_access_type, x." + DatabaseUtils.addQuotes(db, "lock") + " AS header_lock, " + "x.custom1_integer AS header_custom1_integer, x.site_id AS header_site_id, " + "org.name as acct_name, org.enabled as accountenabled, " + "ct.namelast as last_name, ct.namefirst as first_name, " + "ct.org_name as ctcompany, lsi.description as sitename " + "FROM opportunity_header x " + "LEFT JOIN organization org ON (x.acctlink = org.org_id) " + "LEFT JOIN contact ct ON (x.contactlink = ct.contact_id) " + "LEFT JOIN lookup_site_id lsi ON (x.site_id = lsi.code) " + "WHERE x.opp_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            OpportunityHeader thisOppHeader = new OpportunityHeader(rs);
            this.add(thisOppHeader);
        }
        rs.close();
        pst.close();
        for (OpportunityHeader thisOppHeader : this) {
            thisOppHeader.retrieveComponentCount(db, this.componentsOwnedByUser);
            if (this.buildTotalValues) {
                thisOppHeader.buildTotal(db, this.componentsOwnedByUser);
            }
            if (this.buildActionPlans) {
                thisOppHeader.buildActionPlans(db);
            }
            if (!this.allowMultipleComponents) {
                OpportunityComponentList opportunityComponentList = new OpportunityComponentList();
                opportunityComponentList.setHeaderId(thisOppHeader.getId());
                opportunityComponentList.buildList(db);
                if (opportunityComponentList.size() == 1) {
                    thisOppHeader.setComponent((OpportunityComponent)((Object)opportunityComponentList.get(0)));
                }
            }
            thisOppHeader.buildFiles(db);
        }
    }

    public void addIgnoreTypeId(String tmp) {
        this.ignoreTypeIdList.add(tmp);
    }

    public void addIgnoreTypeId(int tmp) {
        this.ignoreTypeIdList.add(String.valueOf(tmp));
    }

    public void delete(Connection db, ActionContext context, String baseFilePath) throws SQLException {
        for (OpportunityHeader thisOpportunity : this) {
            thisOpportunity.delete(db, context, baseFilePath);
        }
    }

    protected void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.orgId != -1) {
            sqlFilter.append("AND (x.acctlink = ? OR x.contactlink IN (SELECT contact_id from contact c where c.org_id = ? )) ");
        }
        if (this.contactId != -1) {
            sqlFilter.append("AND x.contactlink = ? ");
        }
        if (this.enteredBy != -1) {
            sqlFilter.append("AND x.enteredby = ? ");
        }
        if (!this.includeAllSites && this.orgId == -1 && this.contactId == -1) {
            if (this.siteId > -1) {
                sqlFilter.append("AND (x.site_id = ? ");
                if (!this.exclusiveToSite) {
                    sqlFilter.append(" OR x.site_id IS NULL ");
                }
                sqlFilter.append(") ");
            } else {
                sqlFilter.append("AND x.site_id IS NULL ");
            }
        }
        if (this.ignoreTypeIdList.size() > 0) {
            Iterator iList = this.ignoreTypeIdList.iterator();
            sqlFilter.append("AND x.contactlink NOT IN (");
            while (iList.hasNext()) {
                String placeHolder = (String)iList.next();
                sqlFilter.append("?");
                if (!iList.hasNext()) continue;
                sqlFilter.append(",");
            }
            sqlFilter.append(") ");
        }
        if (this.description != null) {
            if (this.description.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(x.description) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(x.description) = ? ");
            }
        }
        if (this.queryOpenOnly) {
            sqlFilter.append("AND x.opp_id IN (SELECT opp_id from opportunity_component oc where oc.closed IS NULL) ");
        }
        if (this.queryClosedOnly) {
            sqlFilter.append("AND x.opp_id NOT IN (SELECT opp_id from opportunity_component oc where oc.closed IS NULL) ");
        }
        if (this.accountOwnerIdRange != null) {
            sqlFilter.append("AND x.acctlink IN (SELECT org_id FROM organization WHERE owner IN (" + this.accountOwnerIdRange + ")) ");
        }
        if (this.controlledHierarchyOnly != -1) {
            if (this.controlledHierarchyOnly == 0) {
                sqlFilter.append("AND (x.opp_id IN ( SELECT opp_id FROM opportunity_component oc WHERE oc.owner IN (" + this.ownerIdRange + ")) " + "OR x.access_type = ?) ");
            } else {
                sqlFilter.append("AND x.opp_id IN ( SELECT opp_id FROM opportunity_component oc WHERE oc.owner IN (" + this.ownerIdRange + ") " + ")");
            }
        } else {
            if (this.owner != -1) {
                sqlFilter.append("AND ( (x.opp_id IN (SELECT opp_id FROM opportunity_component oc WHERE oc.owner = ? )) OR (x.opp_id NOT IN (SELECT opp_id FROM opportunity_component oc1 WHERE oc1.opp_id = x.opp_id ) AND x.manager = ?) ) ");
            }
            if (this.ownerIdRange != null) {
                sqlFilter.append("AND ( (x.opp_id IN (SELECT opp_id FROM opportunity_component oc WHERE oc.owner IN (" + this.ownerIdRange + ") ) ) " + "OR (x.opp_id NOT IN (SELECT opp_id from opportunity_component oc1 WHERE oc1.opp_id = x.opp_id) AND " + "x.manager IN (" + this.ownerIdRange + ") ) " + ") ");
            }
        }
        if (this.manager != -1) {
            sqlFilter.append("AND x.manager = ? ");
        }
        if (this.includeOnlyTrashed) {
            sqlFilter.append("AND x.trashed_date IS NOT NULL ");
        } else if (this.trashedDate != null) {
            sqlFilter.append("AND x.trashed_date = ? ");
        } else {
            sqlFilter.append("AND x.trashed_date IS NULL ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    public int reassignElements(Connection db, int newOwner) throws SQLException {
        int total = 0;
        for (OpportunityHeader thisOpp : this) {
            if (!thisOpp.reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }

    public int reassignElements(Connection db, int newOwner, int userId) throws SQLException {
        int total = 0;
        for (OpportunityHeader thisOpp : this) {
            thisOpp.setModifiedBy(userId);
            if (!thisOpp.reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.orgId != -1) {
            pst.setInt(++i, this.orgId);
            pst.setInt(++i, this.orgId);
        }
        if (this.contactId != -1) {
            pst.setInt(++i, this.contactId);
        }
        if (this.enteredBy != -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (!this.includeAllSites && this.orgId == -1 && this.contactId == -1 && this.siteId > -1) {
            pst.setInt(++i, this.siteId);
        }
        if (this.ignoreTypeIdList.size() > 0) {
            Iterator iList = this.ignoreTypeIdList.iterator();
            while (iList.hasNext()) {
                int thisType = Integer.parseInt((String)iList.next());
                pst.setInt(++i, thisType);
            }
        }
        if (this.description != null) {
            pst.setString(++i, this.description.toLowerCase());
        }
        if (this.controlledHierarchyOnly == 0) {
            DatabaseUtils.setInt(pst, ++i, this.getAccessType());
        } else if (this.controlledHierarchyOnly == -1 && this.owner != -1) {
            pst.setInt(++i, this.owner);
            pst.setInt(++i, this.owner);
        }
        if (this.manager != -1) {
            pst.setInt(++i, this.manager);
        }
        if (!this.includeOnlyTrashed && this.trashedDate != null) {
            pst.setTimestamp(++i, this.trashedDate);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public static int retrieveRecordCount(Connection db, int moduleId, int itemId) throws SQLException {
        ResultSet rs;
        int count = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(*) as itemcount FROM opportunity_header o LEFT JOIN opportunity_component oc ON (o.opp_id = oc.opp_id) WHERE opp_id > 0 ");
        if (moduleId == 1) {
            sql.append("AND (o.acctlink = ? OR o.contactlink IN (SELECT contact_id FROM contact c WHERE c.org_id = ? )) ");
        }
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (moduleId == 1) {
            pst.setInt(1, itemId);
            pst.setInt(2, itemId);
        }
        if ((rs = pst.executeQuery()).next()) {
            count = rs.getInt("itemcount");
        }
        rs.close();
        pst.close();
        return count;
    }

    public static boolean isComponentOwner(Connection db, int userId) throws SQLException {
        boolean isOwner = false;
        PreparedStatement pst = db.prepareStatement("SELECT opp_id FROM opportunity_header oh WHERE opp_id > 0 and opp_id in ( SELECT opp_id from opportunity_component oc WHERE oc.owner = ? AND oh.opp_id = oc.opp_id ) ");
        pst.setInt(1, userId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            isOwner = true;
        }
        rs.close();
        pst.close();
        return isOwner;
    }

    public static boolean isInOwnerOrManagerHierarchy(Connection db, int accessTypeRule, String ownerString, String managerString) throws SQLException {
        ResultSet rs;
        boolean isOwnerHierarchy = false;
        boolean isManagerHierarchy = false;
        PreparedStatement pst = null;
        if (accessTypeRule == 626030334) {
            pst = db.prepareStatement("SELECT opp_id FROM opportunity_header oh WHERE opp_id > 0 and opp_id in ( SELECT opp_id from opportunity_component oc WHERE oc.owner IN (" + ownerString + ") AND oh.opp_id = oc.opp_id ) ");
            rs = pst.executeQuery();
            if (rs.next()) {
                isOwnerHierarchy = true;
            }
            rs.close();
            pst.close();
        }
        if ((rs = (pst = db.prepareStatement("SELECT oh.opp_id FROM opportunity_header oh WHERE oh.opp_id > 0 AND oh.manager IN (" + managerString + ") ")).executeQuery()).next()) {
            isManagerHierarchy = true;
        }
        rs.close();
        pst.close();
        return isOwnerHierarchy || isManagerHierarchy;
    }

    public void moveOpportunitiesToAccount(Connection db, int orgId) throws SQLException {
        for (OpportunityHeader opp : this) {
            opp.setContactLink(-1);
            opp.setAccountLink(orgId);
            opp.update(db);
        }
    }

    public void invalidateUserData(ActionContext context, Connection db) throws SQLException {
        for (OpportunityHeader tmpOpportunityHeader : this) {
            tmpOpportunityHeader.invalidateUserData(context, db);
        }
    }

    public boolean updateStatus(Connection db, ActionContext context, boolean toTrash, int tmpUserId) throws SQLException {
        for (OpportunityHeader tmpOppHeader : this) {
            tmpOppHeader.updateStatus(db, context, toTrash, tmpUserId);
        }
        return true;
    }
}

