/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.modules.pipeline.beans.OpportunityBean;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class OpportunityList
extends ArrayList {
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    protected int includeEnabled = 1;
    protected PagedListInfo pagedListInfo = null;
    protected int orgId = -1;
    protected int contactId = -1;
    protected ArrayList ignoreTypeIdList = new ArrayList();
    protected String description = null;
    protected int enteredBy = -1;
    protected boolean hasAlertDate = false;
    protected Date alertDate = null;
    protected int owner = -1;
    protected String ownerIdRange = null;
    protected String units = null;
    protected String accountOwnerIdRange = null;
    protected Date alertRangeStart = null;
    protected Date alertRangeEnd = null;
    protected Date closeDateStart = null;
    protected Date closeDateEnd = null;
    protected int stage = -1;
    private boolean queryOpenOnly = false;
    private boolean queryClosedOnly = false;
    private boolean excludeClosedComponents = false;
    private boolean buildComponentInfo = false;
    private int typeId = 0;
    private Timestamp trashedDate = null;
    private boolean includeOnlyTrashed = false;
    protected int accessType = -1;
    protected int controlledHierarchyOnly = -1;
    private boolean includeOnlyForGraph = false;
    private int manager = -1;
    private double defaultTerms = 1.0;
    private String defaultUnits = null;
    private int siteId = -1;
    private boolean includeAllSites = true;
    private boolean exclusiveToSite = false;
    protected HashMap errors = new HashMap();
    protected HashMap warnings = new HashMap();

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setQueryClosedOnly(boolean queryClosedOnly) {
        this.queryClosedOnly = queryClosedOnly;
    }

    public void setWarnings(HashMap tmp) {
        this.warnings = tmp;
    }

    public HashMap getWarnings() {
        return this.warnings;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = Integer.parseInt(typeId);
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public int getStage() {
        return this.stage;
    }

    public void setStage(int stage) {
        this.stage = stage;
    }

    public void setStage(String stage) {
        this.stage = Integer.parseInt(stage);
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public boolean getBuildComponentInfo() {
        return this.buildComponentInfo;
    }

    public void setBuildComponentInfo(boolean buildComponentInfo) {
        this.buildComponentInfo = buildComponentInfo;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setAccountOwnerIdRange(String accountOwnerIdRange) {
        this.accountOwnerIdRange = accountOwnerIdRange;
    }

    public void setExcludeClosedComponents(boolean excludeClosedComponents) {
        this.excludeClosedComponents = excludeClosedComponents;
    }

    public boolean getExcludeClosedComponents() {
        return this.excludeClosedComponents;
    }

    public int getIncludeEnabled() {
        return this.includeEnabled;
    }

    public void setIncludeEnabled(int includeEnabled) {
        this.includeEnabled = includeEnabled;
    }

    public void setOwnerIdRange(String ownerIdRange) {
        this.ownerIdRange = ownerIdRange;
    }

    public void setAlertRangeStart(Date tmp) {
        this.alertRangeStart = tmp;
    }

    public void setAlertRangeStart(String tmp) {
        this.alertRangeStart = Date.valueOf(tmp);
    }

    public void setAlertRangeEnd(Date tmp) {
        this.alertRangeEnd = tmp;
    }

    public void setAlertRangeEnd(String tmp) {
        this.alertRangeEnd = Date.valueOf(tmp);
    }

    public Date getAlertRangeStart() {
        return this.alertRangeStart;
    }

    public Date getAlertRangeEnd() {
        return this.alertRangeEnd;
    }

    public boolean getQueryOpenOnly() {
        return this.queryOpenOnly;
    }

    public void setQueryOpenOnly(boolean queryOpenOnly) {
        this.queryOpenOnly = queryOpenOnly;
    }

    public void setHasAlertDate(boolean tmp) {
        this.hasAlertDate = tmp;
    }

    public void setAlertDate(Date tmp) {
        this.alertDate = tmp;
    }

    public Date getCloseDateStart() {
        return this.closeDateStart;
    }

    public Date getCloseDateEnd() {
        return this.closeDateEnd;
    }

    public void setCloseDateStart(Date tmp) {
        this.closeDateStart = tmp;
    }

    public void setCloseDateStart(String tmp) {
        try {
            java.util.Date tmpDate = DateFormat.getDateInstance(3).parse(tmp);
            this.closeDateStart = new Date(new java.util.Date().getTime());
            this.closeDateStart.setTime(tmpDate.getTime());
        }
        catch (Exception e) {
            this.closeDateStart = null;
        }
    }

    public void setCloseDateEnd(Date tmp) {
        this.closeDateEnd = tmp;
    }

    public void setCloseDateEnd(String tmp) {
        try {
            java.util.Date tmpDate = DateFormat.getDateInstance(3).parse(tmp);
            this.closeDateEnd = new Date(new java.util.Date().getTime());
            this.closeDateEnd.setTime(tmpDate.getTime());
        }
        catch (Exception e) {
            this.closeDateEnd = null;
        }
    }

    public void setOwner(int tmp) {
        this.owner = tmp;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public String getAccountOwnerIdRange() {
        return this.accountOwnerIdRange;
    }

    public String getOwnerIdRange() {
        return this.ownerIdRange;
    }

    public int getListSize() {
        return this.size();
    }

    public String getUnits() {
        return this.units;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public boolean getHasAlertDate() {
        return this.hasAlertDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setIncludeOnlyTrashed(boolean tmp) {
        this.includeOnlyTrashed = tmp;
    }

    public void setIncludeOnlyTrashed(String tmp) {
        this.includeOnlyTrashed = DatabaseUtils.parseBoolean(tmp);
    }

    public void setIncludeOnlyForGraph(boolean tmp) {
        this.includeOnlyForGraph = tmp;
    }

    public void setIncludeOnlyForGraph(String tmp) {
        this.includeOnlyForGraph = DatabaseUtils.parseBoolean(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public boolean getIncludeOnlyTrashed() {
        return this.includeOnlyTrashed;
    }

    public boolean getIncludeOnlyForGraph() {
        return this.includeOnlyForGraph;
    }

    public HashMap getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public int getAccessType() {
        return this.accessType;
    }

    public void setAccessType(int tmp) {
        this.accessType = tmp;
    }

    public void setAccessType(String tmp) {
        this.accessType = Integer.parseInt(tmp);
    }

    public int getControlledHierarchyOnly() {
        return this.controlledHierarchyOnly;
    }

    public void setControlledHierarchyOnly(int tmp) {
        this.controlledHierarchyOnly = tmp;
    }

    public void setControlledHierarchyOnly(String tmp) {
        this.controlledHierarchyOnly = Integer.parseInt(tmp);
    }

    public void setControlledHierarchy(int tmp, String ownerRange) {
        this.controlledHierarchyOnly = tmp;
        this.ownerIdRange = ownerRange;
    }

    public int getManager() {
        return this.manager;
    }

    public void setManager(int tmp) {
        this.manager = tmp;
    }

    public void setManager(String tmp) {
        this.manager = Integer.parseInt(tmp);
    }

    public double getDefaultTerms() {
        return this.defaultTerms;
    }

    public void setDefaultTerms(double tmp) {
        this.defaultTerms = tmp;
    }

    public void setDefaultTerms(String tmp) {
        this.defaultTerms = Double.parseDouble(tmp);
    }

    public String getDefaultUnits() {
        return this.defaultUnits;
    }

    public void setDefaultUnits(String tmp) {
        this.defaultUnits = tmp;
    }

    public boolean getIncludeAllSites() {
        return this.includeAllSites;
    }

    public void setIncludeAllSites(boolean tmp) {
        this.includeAllSites = tmp;
    }

    public void setIncludeAllSites(String tmp) {
        this.includeAllSites = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getExclusiveToSite() {
        return this.exclusiveToSite;
    }

    public void setExclusiveToSite(boolean tmp) {
        this.exclusiveToSite = tmp;
    }

    public void setExclusiveToSite(String tmp) {
        this.exclusiveToSite = DatabaseUtils.parseBoolean(tmp);
    }

    public void setSearchText(String tmp) {
        this.description = tmp;
    }

    public String getSearchText() {
        return this.description;
    }

    public boolean buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM opportunity_header x LEFT JOIN opportunity_component oc on (x.opp_id = oc.opp_id) LEFT JOIN organization org ON (x.acctlink = org.org_id) LEFT JOIN contact ct ON (x.contactlink = ct.contact_id) LEFT JOIN lookup_site_id lsi ON (x.site_id = lsi.code), lookup_stage y WHERE y.code = oc.stage AND x.opp_id > -1 ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(oc.description) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("oc.description", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY oc.closedate DESC ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("x.opp_id AS header_opp_id, x.description AS header_description, x.acctlink AS header_acctlink, x.contactlink AS header_contactlink, x.entered AS header_entered, x.enteredby AS header_enteredby, x.modified AS header_modified, x.modifiedby AS header_modifiedby, x.trashed_date AS header_trashed_date, x.manager AS header_manager, x.access_type AS header_access_type, x." + DatabaseUtils.addQuotes(db, "lock") + " AS header_lock, " + "x.custom1_integer AS header_custom1_integer, x.site_id AS header_site_id, " + "org.name AS acct_name, org.enabled AS accountenabled, " + "ct.namelast AS last_name, ct.namefirst AS first_name, " + "ct.org_name AS ctcompany, lsi.description as sitename, " + "oc.*, y.description AS stagename " + "FROM opportunity_header x " + "LEFT JOIN opportunity_component oc ON (x.opp_id = oc.opp_id) " + "LEFT JOIN organization org ON (x.acctlink = org.org_id) " + "LEFT JOIN contact ct ON (x.contactlink = ct.contact_id) " + "LEFT JOIN lookup_site_id lsi ON (x.site_id = lsi.code), " + "lookup_stage y " + "WHERE y.code = oc.stage " + "AND x.opp_id > 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            OpportunityBean oppBean = new OpportunityBean();
            oppBean.setHeader(new OpportunityHeader(rs));
            oppBean.setComponent(new OpportunityComponent(rs));
            this.add(oppBean);
        }
        rs.close();
        pst.close();
        for (OpportunityBean oppBean : this) {
            oppBean.getHeader().buildFiles(db);
            oppBean.getComponent().buildTypes(db);
            if (!this.getBuildComponentInfo()) continue;
            oppBean.getHeader().retrieveComponentCount(db);
            oppBean.getHeader().buildTotal(db);
        }
        return true;
    }

    public void addIgnoreTypeId(String tmp) {
        this.ignoreTypeIdList.add(tmp);
    }

    public void addIgnoreTypeId(int tmp) {
        this.ignoreTypeIdList.add(String.valueOf(tmp));
    }

    public int reassignElements(Connection db, int newOwner) throws SQLException {
        int total = 0;
        for (OpportunityBean oppBean : this) {
            if (!oppBean.getComponent().reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }

    public void delete(Connection db, ActionContext context, String baseFilePath) throws SQLException {
        for (OpportunityBean oppBean : this) {
            oppBean.getHeader().delete(db, context, baseFilePath);
        }
    }

    protected void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.orgId != -1) {
            sqlFilter.append("AND (x.acctlink = ? OR x.contactlink IN (SELECT contact_id FROM contact c WHERE c.org_id = ? )) ");
        }
        if (this.contactId != -1) {
            sqlFilter.append("AND x.contactlink = ? ");
        }
        if (this.enteredBy != -1) {
            sqlFilter.append("AND x.enteredby = ? ");
        }
        if (!this.includeAllSites && this.orgId == -1 && this.contactId == -1) {
            if (this.siteId > -1) {
                sqlFilter.append("AND (x.site_id = ? ");
                if (!this.exclusiveToSite) {
                    sqlFilter.append(" OR x.site_id IS NULL ");
                }
                sqlFilter.append(") ");
            } else {
                sqlFilter.append("AND x.site_id IS NULL ");
            }
        }
        if (this.hasAlertDate) {
            sqlFilter.append("AND oc.alertdate IS NOT NULL ");
        }
        if (this.ignoreTypeIdList.size() > 0) {
            Iterator iList = this.ignoreTypeIdList.iterator();
            sqlFilter.append("AND x.contactlink NOT IN (");
            while (iList.hasNext()) {
                String placeHolder = (String)iList.next();
                sqlFilter.append("?");
                if (!iList.hasNext()) continue;
                sqlFilter.append(",");
            }
            sqlFilter.append(") ");
        }
        if (this.description != null) {
            if (this.description.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(x.description) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(x.description) = ? ");
            }
        }
        if (this.alertDate != null) {
            sqlFilter.append("AND oc.alertdate = ? ");
        }
        if (this.alertRangeStart != null) {
            sqlFilter.append("AND oc.alertdate >= ? ");
        }
        if (this.alertRangeEnd != null) {
            sqlFilter.append("AND oc.alertdate < ? ");
        }
        if (this.closeDateStart != null) {
            sqlFilter.append("AND oc.closedate >= ? ");
        }
        if (this.closeDateEnd != null) {
            sqlFilter.append("AND oc.closedate <= ? ");
        }
        if (this.controlledHierarchyOnly != -1) {
            if (this.controlledHierarchyOnly == 0) {
                sqlFilter.append("AND (oc.owner IN (" + this.ownerIdRange + ") " + "OR x.access_type = ?) ");
            } else {
                sqlFilter.append("AND oc.owner IN (" + this.ownerIdRange + ") ");
            }
        } else {
            if (this.owner != -1) {
                sqlFilter.append("AND oc.owner = ? ");
            }
            if (this.ownerIdRange != null) {
                sqlFilter.append("AND oc.owner in (" + this.ownerIdRange + ") ");
            }
        }
        if (this.accountOwnerIdRange != null) {
            sqlFilter.append("AND x.acctlink IN (SELECT org_id FROM organization WHERE owner IN (" + this.accountOwnerIdRange + ")) ");
        }
        if (this.manager != -1) {
            sqlFilter.append("AND x.manager = ? ");
        }
        if (this.units != null) {
            sqlFilter.append("AND oc.units = ? ");
        }
        if (this.includeEnabled == 1 || this.includeEnabled == 0) {
            sqlFilter.append("AND oc.enabled = ? ");
        }
        if (this.stage != -1) {
            sqlFilter.append("AND oc.stage = ? ");
        }
        if (this.queryOpenOnly) {
            sqlFilter.append("AND x.opp_id IN (SELECT opp_id from opportunity_component oc where oc.opp_id = x.opp_id AND oc.closed IS NULL) ");
        }
        if (this.queryClosedOnly) {
            sqlFilter.append("AND x.opp_id NOT IN (SELECT opp_id from opportunity_component oc where oc.opp_id = x.opp_id AND oc.closed IS NULL) ");
        }
        if (this.typeId > 0) {
            sqlFilter.append("AND oc.id IN (select ocl.opp_id from opportunity_component_levels ocl where ocl.type_id = ?) ");
        }
        if (this.excludeClosedComponents) {
            sqlFilter.append("AND oc.closed IS NULL ");
        }
        if (this.includeOnlyTrashed) {
            sqlFilter.append("AND x.trashed_date IS NOT NULL ");
        } else if (this.trashedDate != null) {
            sqlFilter.append("AND x.trashed_date = ? ");
        } else {
            sqlFilter.append("AND x.trashed_date IS NULL ");
        }
        if (this.includeOnlyForGraph && (this.defaultUnits == null || "".equals(this.defaultUnits))) {
            sqlFilter.append("AND ((oc.units = ? AND oc.id IN ( SELECT id FROM opportunity_component WHERE " + DatabaseUtils.addTimestampInterval(db, 3, "terms", "closedate") + " > " + DatabaseUtils.getCurrentTimestamp(db) + " )) OR ( oc.units = ? AND oc.id IN (  " + "SELECT id FROM opportunity_component WHERE " + DatabaseUtils.addTimestampInterval(db, 2, "terms", "closedate") + " > " + DatabaseUtils.getCurrentTimestamp(db) + " ))) ");
        } else if (this.defaultUnits != null && !"".equals(this.defaultUnits) && this.includeOnlyForGraph) {
            sqlFilter.append("AND oc.id IN ( SELECT id FROM opportunity_component WHERE " + DatabaseUtils.addTimestampInterval(db, 2, "terms", "closedate", this.defaultUnits, Math.round(this.defaultTerms)) + " > " + DatabaseUtils.getCurrentTimestamp(db) + " ) ");
        }
        if (this.excludeClosedComponents) {
            sqlFilter.append("AND oc.closed IS NULL ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.orgId != -1) {
            pst.setInt(++i, this.orgId);
            pst.setInt(++i, this.orgId);
        }
        if (this.contactId != -1) {
            pst.setInt(++i, this.contactId);
        }
        if (this.enteredBy != -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (!this.includeAllSites && this.orgId == -1 && this.contactId == -1 && this.siteId > -1) {
            pst.setInt(++i, this.siteId);
        }
        if (this.ignoreTypeIdList.size() > 0) {
            Iterator iList = this.ignoreTypeIdList.iterator();
            while (iList.hasNext()) {
                int thisType = Integer.parseInt((String)iList.next());
                pst.setInt(++i, thisType);
            }
        }
        if (this.description != null) {
            pst.setString(++i, this.description.toLowerCase());
        }
        if (this.alertDate != null) {
            DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(this.alertDate.getTime()));
        }
        if (this.alertRangeStart != null) {
            DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(this.alertRangeStart.getTime()));
        }
        if (this.alertRangeEnd != null) {
            DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(this.alertRangeEnd.getTime()));
        }
        if (this.closeDateStart != null) {
            DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(this.closeDateStart.getTime()));
        }
        if (this.closeDateEnd != null) {
            DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(this.closeDateEnd.getTime()));
        }
        if (this.controlledHierarchyOnly == 0) {
            DatabaseUtils.setInt(pst, ++i, this.getAccessType());
        } else if (this.controlledHierarchyOnly == -1 && this.owner != -1) {
            pst.setInt(++i, this.owner);
        }
        if (this.manager != -1) {
            pst.setInt(++i, this.manager);
        }
        if (this.units != null) {
            pst.setString(++i, this.units);
        }
        if (this.includeEnabled == 1) {
            pst.setBoolean(++i, true);
        } else if (this.includeEnabled == 0) {
            pst.setBoolean(++i, false);
        }
        if (this.stage != -1) {
            pst.setInt(++i, this.stage);
        }
        if (this.typeId > 0) {
            pst.setInt(++i, this.typeId);
        }
        if (!this.includeOnlyTrashed && this.trashedDate != null) {
            pst.setTimestamp(++i, this.trashedDate);
        }
        if (this.includeOnlyForGraph && (this.defaultUnits == null || "".equals(this.defaultUnits))) {
            pst.setString(++i, "M");
            pst.setString(++i, "W");
        }
        return i;
    }

    public static int retrieveRecordCount(Connection db, int moduleId, int itemId) throws SQLException {
        ResultSet rs;
        int count = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(*) as itemcount FROM opportunity_header o WHERE o.opp_id > 0 AND trashed_date IS NULL ");
        if (moduleId == 1) {
            sql.append("AND (o.acctlink = ? OR o.contactlink IN (SELECT contact_id FROM contact c WHERE c.org_id = ? )) ");
        }
        if (moduleId == 2) {
            sql.append("AND o.contactlink = ? ");
        }
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (moduleId == 1) {
            pst.setInt(1, itemId);
            pst.setInt(2, itemId);
        }
        if (moduleId == 2) {
            pst.setInt(1, itemId);
        }
        if ((rs = pst.executeQuery()).next()) {
            count = rs.getInt("itemcount");
        }
        rs.close();
        pst.close();
        return count;
    }

    public boolean updateStatus(Connection db, ActionContext context, boolean toTrash, int tmpUserId) throws SQLException {
        for (OpportunityBean tmpOpportunityBean : this) {
            tmpOpportunityBean.getHeader().updateStatus(db, context, toTrash, tmpUserId);
        }
        return true;
    }
}

