/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Set;
import java.util.TimeZone;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.base.ScheduledActions;
import org.aspcfs.modules.mycfs.base.CalendarEventList;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.base.OpportunityComponentList;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.web.CalendarView;

public class OpportunityListScheduledActions
extends OpportunityComponentList
implements ScheduledActions {
    private ActionContext context = null;
    private CFSModule module = null;
    private int userId = -1;

    public void setModule(CFSModule tmp) {
        this.module = tmp;
    }

    public void setContext(ActionContext tmp) {
        this.context = tmp;
    }

    public void setUserId(int tmp) {
        this.userId = tmp;
    }

    public void setUserId(String tmp) {
        this.userId = Integer.parseInt(tmp);
    }

    public ActionContext getContext() {
        return this.context;
    }

    public CFSModule getModule() {
        return this.module;
    }

    public int getUserId() {
        return this.userId;
    }

    public void buildAlerts(CalendarView companyCalendar, Connection db) throws SQLException {
        try {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("OppListScheduledActions -> Building opportunity alerts");
            }
            TimeZone timeZone = companyCalendar.getCalendarInfo().getTimeZone();
            this.setOwner(this.userId);
            this.setHasAlertDate(true);
            this.buildShortList(db);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("OppListScheduledActions -> size of opps: " + this.size());
            }
            for (OpportunityComponent thisOpp : this) {
                String alertDate = DateUtils.getServerToUserDateString(timeZone, 3, thisOpp.getAlertDate());
                companyCalendar.addEvent(alertDate, CalendarEventList.EVENT_TYPES[2], (Object)thisOpp);
            }
        }
        catch (SQLException e) {
            throw new SQLException("Error Building Opportunity Calendar Alerts");
        }
    }

    public void buildAlertCount(CalendarView companyCalendar, Connection db) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("OppListScheduledActions -> Building Alert Counts ");
        }
        try {
            TimeZone timeZone = companyCalendar.getCalendarInfo().getTimeZone();
            this.setOwner(this.userId);
            this.setHasAlertDate(true);
            HashMap dayEvents = this.queryRecordCount(db, timeZone);
            Set s = dayEvents.keySet();
            for (String thisDay : s) {
                companyCalendar.addEventCount(thisDay, CalendarEventList.EVENT_TYPES[2], dayEvents.get(thisDay));
            }
        }
        catch (SQLException e) {
            throw new SQLException("Error Building Opportunity Calendar Alert Counts");
        }
    }
}

