/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.aspcfs.modules.base.Note;
import org.aspcfs.utils.DatabaseUtils;

public class OpportunityNote
extends Note {
    public OpportunityNote() {
        this.isContact = false;
        this.isOrg = false;
    }

    public OpportunityNote(ResultSet rs) throws SQLException {
        this.isContact = false;
        this.isOrg = false;
        this.buildRecord(rs);
    }

    public OpportunityNote(Connection db, String noteId) throws SQLException {
        this.isContact = false;
        this.isOrg = false;
        if (noteId == null) {
            throw new SQLException("Note ID not specified.");
        }
        Statement st = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM note WHERE id = " + noteId + " ");
        st = db.createStatement();
        rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        st.close();
        if (this.getId() == -1) {
            throw new SQLException("Note record not found.");
        }
    }

    public void process(Connection db, int oppHeaderId, int enteredBy, int modifiedBy) throws SQLException {
        if (this.getEnabled()) {
            if (this.getId() == -1) {
                this.insert(db, oppHeaderId, enteredBy);
            } else {
                this.update(db, modifiedBy);
            }
        } else {
            this.delete(db);
        }
    }

    public void insert(Connection db, int oppHeaderId, int enteredBy) throws SQLException {
        this.setId(DatabaseUtils.getNextSeq(db, "note_id_seq"));
        PreparedStatement pst = db.prepareStatement("INSERT INTO note (" + (this.getId() > -1 ? "id, " : "") + "org_id, contact_id, opp_id, subject, body, enteredby, modifiedby) " + "VALUES " + "(" + (this.getId() > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?) ");
        int i = 0;
        if (this.getId() > -1) {
            pst.setInt(++i, this.getId());
        }
        pst.setInt(++i, this.getOrgId());
        pst.setInt(++i, this.getContactId());
        pst.setInt(++i, oppHeaderId);
        pst.setString(++i, this.getSubject());
        pst.setString(++i, this.getBody());
        pst.setInt(++i, enteredBy);
        pst.setInt(++i, enteredBy);
        pst.execute();
        pst.close();
        this.setId(DatabaseUtils.getCurrVal(db, "note_id_seq", this.getId()));
    }

    public void update(Connection db, int modifiedBy) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE note SET body = ?, subject = ?, modifiedby = ? WHERE id = ? ");
        int i = 0;
        pst.setString(++i, this.getBody());
        pst.setString(++i, this.getSubject());
        pst.setInt(++i, modifiedBy);
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
    }

    public void delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM note WHERE id = ? ");
        int i = 0;
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
    }
}

