/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.base;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.FileItem;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationReport;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.Report;
import org.aspcfs.modules.base.ReportRow;
import org.aspcfs.modules.pipeline.base.OpportunityList;
import org.aspcfs.modules.pipeline.beans.OpportunityBean;

public class OpportunityReport
extends OpportunityList {
    protected Report rep = new Report();
    protected String delimiter = ",";
    protected String header = null;
    protected String tdFormat = "";
    protected String filePath = "";
    protected String filenameToUse = "";
    protected FileItem thisItem = new FileItem();
    protected int limitId = -1;
    protected String subject = "";
    protected int enteredBy = -1;
    protected int modifiedBy = -1;
    protected ArrayList criteria = null;
    protected String[] params = new String[]{"id", "type", "description", "organization", "contact", "owner", "amount1", "amount2", "amount3", "stageName", "stageDate", "probability", "revenueStart", "terms", "alertDate", "commission", "entered", "enteredBy", "modified", "modifiedBy"};
    protected OrganizationReport orgReportJoin = new OrganizationReport();
    protected boolean joinOrgs = false;

    public void setRep(Report tmp) {
        this.rep = tmp;
    }

    public void setDelimiter(String tmp) {
        this.delimiter = tmp;
    }

    public void setHeader(String tmp) {
        this.header = tmp;
    }

    public void setTdFormat(String tmp) {
        this.tdFormat = tmp;
    }

    public Report getRep() {
        return this.rep;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getHeader() {
        return this.header;
    }

    public String getTdFormat() {
        return this.tdFormat;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public FileItem getThisItem() {
        return this.thisItem;
    }

    public void setFilePath(String tmp) {
        this.filePath = tmp;
    }

    public void setThisItem(FileItem tmp) {
        this.thisItem = tmp;
    }

    public String getSubject() {
        return this.subject;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setSubject(String tmp) {
        this.subject = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public OrganizationReport getOrgReportJoin() {
        return this.orgReportJoin;
    }

    public boolean getJoinOrgs() {
        return this.joinOrgs;
    }

    public void setOrgReportJoin(OrganizationReport tmp) {
        this.orgReportJoin = tmp;
    }

    public void setJoinOrgs(boolean tmp) {
        this.joinOrgs = tmp;
    }

    public int getLimitId() {
        return this.limitId;
    }

    public void setLimitId(int limitId) {
        this.limitId = limitId;
    }

    public ArrayList getCriteria() {
        return this.criteria;
    }

    public void setCriteria(String[] criteriaString) {
        if (criteriaString != null) {
            this.params = criteriaString;
        }
        this.criteria = new ArrayList<String>(Arrays.asList(this.params));
    }

    public String[] getParams() {
        return this.params;
    }

    public void setParams(String[] params) {
        this.params = params;
    }

    public String getFilenameToUse() {
        return this.filenameToUse;
    }

    public void setFilenameToUse(String filenameToUse) {
        this.filenameToUse = filenameToUse;
    }

    public void buildReportBaseInfo() {
        this.rep.setDelimitedCharacter(this.delimiter);
        if (this.header != null) {
            this.rep.setHeader(this.header + ": " + this.subject);
        }
    }

    public void buildReportHeaders() {
        if (this.joinOrgs) {
            this.orgReportJoin.buildReportHeaders(this.rep);
        }
        for (String param : this.criteria) {
            if (param.equals("id")) {
                this.rep.addColumn("Opportunity ID");
            }
            if (param.equals("type")) {
                this.rep.addColumn("Type(s)");
            }
            if (param.equals("description")) {
                this.rep.addColumn("Description");
            }
            if (param.equals("organization")) {
                this.rep.addColumn("Organization");
            }
            if (param.equals("contact")) {
                this.rep.addColumn("Contact");
            }
            if (param.equals("owner")) {
                this.rep.addColumn("Owner");
            }
            if (param.equals("amount1")) {
                this.rep.addColumn("Low Amount");
            }
            if (param.equals("amount2")) {
                this.rep.addColumn("Best Guess Amount");
            }
            if (param.equals("amount3")) {
                this.rep.addColumn("High Amount");
            }
            if (param.equals("stageName")) {
                this.rep.addColumn("Stage");
            }
            if (param.equals("stageDate")) {
                this.rep.addColumn("Stage Date");
            }
            if (param.equals("probability")) {
                this.rep.addColumn("Prob. of Close");
            }
            if (param.equals("revenueStart")) {
                this.rep.addColumn("Revenue Start");
            }
            if (param.equals("terms")) {
                this.rep.addColumn("Terms");
            }
            if (param.equals("alertDate")) {
                this.rep.addColumn("Alert Date");
            }
            if (param.equals("commission")) {
                this.rep.addColumn("Commission");
            }
            if (param.equals("entered")) {
                this.rep.addColumn("Entered");
            }
            if (param.equals("enteredBy")) {
                this.rep.addColumn("Entered By");
            }
            if (param.equals("modified")) {
                this.rep.addColumn("Modified");
            }
            if (!param.equals("modifiedBy")) continue;
            this.rep.addColumn("Modified By");
        }
    }

    public void buildReportData(Connection db, ActionContext context) throws SQLException {
        this.buildList(db);
        boolean writeOut = false;
        Organization tempOrg = null;
        for (OpportunityBean oppBean : this) {
            ReportRow thisRow = new ReportRow();
            if (this.joinOrgs && oppBean.getHeader().getAccountLink() > -1) {
                tempOrg = new Organization(db, oppBean.getHeader().getAccountLink());
                if (this.limitId > -1) {
                    if (tempOrg.getOwner() == this.limitId) {
                        this.orgReportJoin.addDataRow(thisRow, tempOrg);
                        writeOut = true;
                    }
                } else {
                    this.orgReportJoin.addDataRow(thisRow, tempOrg);
                    writeOut = true;
                }
            }
            if (!this.joinOrgs || writeOut) {
                for (String param : this.criteria) {
                    if (param.equals("id")) {
                        thisRow.addCell(oppBean.getComponent().getId());
                    }
                    if (param.equals("type")) {
                        thisRow.addCell(oppBean.getComponent().getTypes().valuesAsString());
                    }
                    if (param.equals("description")) {
                        thisRow.addCell(oppBean.getComponent().getDescription());
                    }
                    if (param.equals("organization")) {
                        if (oppBean.getHeader().getContactLink() > -1) {
                            thisRow.addCell(oppBean.getHeader().getContactCompanyName());
                        } else {
                            thisRow.addCell(oppBean.getHeader().getAccountName());
                        }
                    }
                    if (param.equals("contact")) {
                        thisRow.addCell(oppBean.getHeader().getContactName());
                    }
                    if (param.equals("owner")) {
                        thisRow.addCell(UserList.retrieveUserContact(context, oppBean.getComponent().getOwner()).getNameLastFirst());
                    }
                    if (param.equals("amount1")) {
                        thisRow.addCell(String.valueOf(oppBean.getComponent().getLow()));
                    }
                    if (param.equals("amount2")) {
                        thisRow.addCell(String.valueOf(oppBean.getComponent().getGuess()));
                    }
                    if (param.equals("amount3")) {
                        thisRow.addCell(String.valueOf(oppBean.getComponent().getHigh()));
                    }
                    if (param.equals("stageName")) {
                        thisRow.addCell(oppBean.getComponent().getStageName());
                    }
                    if (param.equals("stageDate")) {
                        thisRow.addCell(oppBean.getComponent().getStageDateString());
                    }
                    if (param.equals("probability")) {
                        thisRow.addCell(String.valueOf(oppBean.getComponent().getCloseProb()));
                    }
                    if (param.equals("revenueStart")) {
                        thisRow.addCell(oppBean.getComponent().getCloseDateString());
                    }
                    if (param.equals("terms")) {
                        thisRow.addCell(String.valueOf(oppBean.getComponent().getTerms()));
                    }
                    if (param.equals("alertDate")) {
                        thisRow.addCell(oppBean.getComponent().getAlertDateString());
                    }
                    if (param.equals("commission")) {
                        thisRow.addCell(String.valueOf(oppBean.getComponent().getCommission()));
                    }
                    if (param.equals("entered")) {
                        thisRow.addCell(oppBean.getComponent().getEnteredString());
                    }
                    if (param.equals("enteredBy")) {
                        thisRow.addCell(UserList.retrieveUserContact(context, oppBean.getComponent().getEnteredBy()).getNameLastFirst());
                    }
                    if (param.equals("modified")) {
                        thisRow.addCell(oppBean.getComponent().getModifiedString());
                    }
                    if (!param.equals("modifiedBy")) continue;
                    thisRow.addCell(UserList.retrieveUserContact(context, oppBean.getComponent().getModifiedBy()).getNameLastFirst());
                }
                this.rep.addRow(thisRow);
            }
            writeOut = false;
        }
    }

    public void buildReportFull(Connection db, ActionContext context) throws SQLException {
        this.buildReportBaseInfo();
        this.buildReportHeaders();
        this.buildReportData(db, context);
    }

    public boolean saveAndInsert(Connection db) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        this.filenameToUse = formatter.format(new Date());
        File f = new File(this.filePath);
        f.mkdirs();
        File fileLink = new File(this.filePath + this.filenameToUse + ".csv");
        this.rep.saveHtml(this.filePath + this.filenameToUse + ".html");
        this.rep.saveDelimited(this.filePath + this.filenameToUse + ".csv");
        if (this.joinOrgs) {
            this.thisItem.setLinkModuleId(10);
        } else {
            this.thisItem.setLinkModuleId(12);
        }
        this.thisItem.setLinkItemId(0);
        this.thisItem.setEnteredBy(this.enteredBy);
        this.thisItem.setModifiedBy(this.modifiedBy);
        this.thisItem.setSubject(this.subject);
        this.thisItem.setClientFilename("opportunityreport-" + this.filenameToUse + ".csv");
        this.thisItem.setFilename(this.filenameToUse);
        this.thisItem.setSize((int)fileLink.length());
        this.thisItem.insert(db);
        return true;
    }
}

