/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.beans;

import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;

public class OpportunityBean
extends GenericBean {
    private OpportunityHeader header = null;
    private OpportunityComponent component = null;
    private int actionId = -1;

    public OpportunityBean() {
        this.header = new OpportunityHeader();
        this.component = new OpportunityComponent();
    }

    public OpportunityBean(OpportunityHeader tmp1, OpportunityComponent tmp2) {
        this.header = tmp1;
        this.component = tmp2;
    }

    public void setActionId(int actionId) {
        this.actionId = actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = Integer.parseInt(actionId);
    }

    public int getActionId() {
        return this.actionId;
    }

    public OpportunityComponent getComponent() {
        return this.component;
    }

    public OpportunityHeader getHeader() {
        return this.header;
    }

    public void setComponent(OpportunityComponent tmp) {
        this.component = tmp;
    }

    public void setHeader(OpportunityHeader tmp) {
        this.header = tmp;
    }

    public boolean insert(Connection db) throws SQLException {
        try {
            db.setAutoCommit(false);
            this.header.insert(db);
            this.component.insert(db);
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public boolean insert(Connection db, ActionContext context) throws Exception {
        boolean headerInserted = false;
        boolean componentInserted = false;
        try {
            db.setAutoCommit(false);
            headerInserted = this.header.insert(db, context);
            this.component.setHeaderId(this.header.getId());
            componentInserted = this.component.insert(db, context);
            if (this.actionId > 0) {
                this.header.updateLog(db, this.actionId);
            }
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public static ArrayList getTimeZoneParams() {
        return OpportunityComponent.getTimeZoneParams();
    }

    public static ArrayList getNumberParams() {
        return OpportunityComponent.getNumberParams();
    }
}

