/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.components;

import java.sql.Connection;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.apps.workFlowManager.ComponentInterface;
import org.aspcfs.controller.objectHookManager.ObjectHookComponent;
import org.aspcfs.modules.accounts.base.OrganizationHistory;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.base.OpportunityComponentList;

public class UpdateOpportunityContactHistory
extends ObjectHookComponent
implements ComponentInterface {
    public static final String LEVEL = "history.level";
    public static final String CONTACT_ID = "history.contactId";
    public static final String PREVIOUS_CONTACT_ID = "history.previousContactId";
    public static final String ORG_ID = "history.orgId";
    public static final String PREVIOUS_ORG_ID = "history.previousOrgId";
    public static final String LINK_OBJECT_ID = "history.linkObjectId";
    public static final String LINK_ITEM_ID = "history.linkItemId";
    public static final String DESCRIPTION = "history.description";
    public static final String ENABLED = "history.enabled";
    public static final String STATUS = "history.status";
    public static final String TYPE = "history.type";
    public static final String MODIFIED_BY = "history.modifiedby";
    public static final String RESET = "history.reset";

    public String getDescription() {
        return "Reset the contact's history for all component entries";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ComponentContext context) {
        boolean result = false;
        OpportunityComponentList componentList = null;
        OrganizationHistory history = null;
        String reset = null;
        Connection db = null;
        try {
            db = UpdateOpportunityContactHistory.getConnection(context);
            reset = context.getParameter(RESET);
            int contactId = context.getParameterAsInt(CONTACT_ID);
            int previousContactId = context.getParameterAsInt(PREVIOUS_CONTACT_ID);
            int orgId = context.getParameterAsInt(ORG_ID);
            int previousOrgId = context.getParameterAsInt(PREVIOUS_ORG_ID);
            componentList = new OpportunityComponentList();
            componentList.setHeaderId(context.getParameterAsInt(LINK_ITEM_ID));
            componentList.buildList(db);
            for (OpportunityComponent component : componentList) {
                history = new OrganizationHistory();
                if (reset.equals("contact")) {
                    if (previousContactId != -1 && previousContactId != 0 && previousContactId != contactId) {
                        history.setContactId(previousContactId);
                    } else {
                        history.setContactId(contactId);
                    }
                } else if (reset.equals("account")) {
                    if (previousOrgId != -1 && previousOrgId != 0 && previousOrgId != orgId) {
                        history.setOrgId(previousOrgId);
                    } else {
                        history.setOrgId(orgId);
                    }
                }
                history.setLinkObjectId(context.getParameterAsInt(LINK_OBJECT_ID));
                history.setLinkItemId(component.getId());
                history.queryRecord(db);
                if (reset.equals("contact")) {
                    history.setContactId(contactId);
                    history.setOrgId(-1);
                } else if (reset.equals("account")) {
                    history.setOrgId(orgId);
                    history.setContactId(-1);
                }
                history.setLevel(context.getParameterAsInt(LEVEL));
                history.setDescription(context.getParameter(DESCRIPTION));
                history.setStatus(context.getParameter(STATUS));
                history.setType(context.getParameter(TYPE));
                history.setModifiedBy(context.getParameter(MODIFIED_BY));
                history.setEnteredBy(context.getParameter(MODIFIED_BY));
                history.setReset(true);
                if (history.getId() > -1) {
                    history.update(db);
                    result = true;
                    continue;
                }
                history.insert(db);
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            UpdateOpportunityContactHistory.freeConnection(context, db);
        }
        return result;
    }
}

