/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.pipeline.jobs;

import java.io.File;
import java.util.Hashtable;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.StatefulJob;

public class ResetGraphDataJob
implements StatefulJob {
    public static String fs = System.getProperty("file.separator");

    public void execute(JobExecutionContext context) throws JobExecutionException {
        SchedulerContext schedulerContext = null;
        try {
            File[] files;
            schedulerContext = context.getScheduler().getContext();
            String applicationPath = schedulerContext.getString("ApplicationPath");
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ResetGraphDataJob-> Expiring graph data...");
            }
            Hashtable globalStatus = (Hashtable)schedulerContext.get((Object)"SystemStatus");
            for (SystemStatus thisSystem : globalStatus.values()) {
                UserList thisList = thisSystem.getHierarchyList();
                UserList fullChildList = null;
                for (User thisUser : thisList) {
                    UserList shortChildList = thisUser.getShortChildList();
                    fullChildList = thisUser.getFullChildList(shortChildList, new UserList());
                    for (User indUser : fullChildList) {
                        indUser.setIsValid(false, true);
                        indUser.setIsValidLead(false, true);
                        indUser.setRevenueIsValid(false, true);
                    }
                }
            }
            File graphFolder = new File(applicationPath + "graphs" + fs);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ResetGraphDataJob-> Directory: " + graphFolder.getPath());
            }
            if (graphFolder.isDirectory() && (files = graphFolder.listFiles()) != null) {
                for (int i = 0; i < files.length; ++i) {
                    File thisFile = files[i];
                    thisFile.delete();
                }
            }
        }
        catch (Exception e) {
            throw new JobExecutionException(e.getMessage());
        }
    }
}

