/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.PermissionCategory;
import org.aspcfs.modules.products.actions.ProductCategories;
import org.aspcfs.modules.products.base.ProductCatalogList;
import org.aspcfs.modules.products.base.ProductCategory;
import org.aspcfs.modules.products.base.ProductCategoryList;
import org.aspcfs.utils.web.PagedListInfo;

public final class ProductCatalogEditor
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return "DefaultOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandOptions(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-view")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "OptionsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-view")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductCategory thisCategory = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            ProductCategoryList categoryList = new ProductCategoryList();
            ProductCatalogList productList = new ProductCatalogList();
            PagedListInfo productListInfo = this.getPagedListInfo(context, "productListInfo");
            productListInfo.setLink("ProductCatalogEditor.do?command=List&moduleId=" + moduleId);
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                categoryList.setParentId(Integer.parseInt(categoryId));
                productList.setCategoryId(Integer.parseInt(categoryId));
                thisCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                context.getRequest().setAttribute("parentCategory", (Object)thisCategory);
                ProductCategories.buildHierarchy(db, context);
            } else {
                categoryList.setTopOnly(1);
                productList.setHasCategories(0);
            }
            categoryList.buildList(db);
            productList.setBuildActivePrice(true);
            productList.setPagedListInfo(productListInfo);
            String trashed = context.getRequest().getParameter("trashed");
            if ("true".equals(trashed)) {
                productList.setIncludeOnlyTrashed(true);
            }
            productList.buildList(db);
            context.getRequest().setAttribute("trashed", (Object)trashed);
            context.getRequest().setAttribute("categoryList", (Object)categoryList);
            context.getRequest().setAttribute("productList", (Object)productList);
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ListOK";
    }
}

