/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.actions;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemVersion;
import com.zeroio.webutils.FileDownload;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.apps.transfer.reader.mapreader.PropertyMap;
import org.aspcfs.controller.ImportManager;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.PermissionCategory;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.base.Import;
import org.aspcfs.modules.base.ImportList;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.products.base.ProductCatalogImages;
import org.aspcfs.modules.products.base.ProductCatalogImport;
import org.aspcfs.modules.products.base.ProductCatalogList;
import org.aspcfs.modules.products.base.ProductImportValidate;
import org.aspcfs.utils.FileUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public class ProductCatalogImports
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return this.executeCommandView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-imports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "ProductCatalogImportListInfo");
        String moduleId = context.getRequest().getParameter("moduleId");
        try {
            db = this.getConnection(context);
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            pagedListInfo.setLink("ProductCatalogImports.do?command=View&moduleId=" + moduleId);
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            SystemStatus systemStatus = this.getSystemStatus(context);
            ImportManager manager = systemStatus.getImportManager(context);
            ImportList thisList = new ImportList();
            thisList.setType(33020045);
            thisList.setPagedListInfo(pagedListInfo);
            if ("my".equals(pagedListInfo.getListView())) {
                thisList.setEnteredBy(this.getUserId(context));
            }
            thisList.setManager(manager);
            thisList.setSystemStatus(systemStatus);
            thisList.buildList(db);
            thisList.updateRecordCounts();
            context.getRequest().setAttribute("ImportList", (Object)thisList);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ProductCatalogImports.getReturn(context, "View");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandNew(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-imports-add")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            this.buildFormElements(db, context);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ProductCatalogImports.getReturn(context, "New");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-imports-add")) {
            return "PermissionError";
        }
        HashMap<String, String> errors = new HashMap<String, String>();
        HashMap warnings = new HashMap();
        Connection db = null;
        boolean productCatalogRecordInserted = false;
        boolean isValid = false;
        boolean fileRecordInserted = false;
        boolean zipFileRecordInserted = false;
        boolean zipFileErrors = false;
        SystemStatus systemStatus = this.getSystemStatus(context);
        ProductCatalogImport thisImport = (ProductCatalogImport)context.getFormBean();
        String filePath = this.getPath(context, "products");
        try {
            FileItem thisItem;
            FileInfo newFileInfo;
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            String subject = (String)parts.get("newImport");
            String description = (String)parts.get("description");
            String comments = (String)parts.get("comments");
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            thisImport.setEnteredBy(this.getUserId(context));
            thisImport.setModifiedBy(this.getUserId(context));
            thisImport.setType(33020045);
            thisImport.setName(subject);
            thisImport.setDescription(description);
            thisImport.setComments(comments);
            if (!(parts.get("id") instanceof FileInfo) || ((FileInfo)parts.get("id")).getClientFileName().length() > 250) {
                fileRecordInserted = false;
                if (!(parts.get("id") instanceof FileInfo)) {
                    errors.put("fileError", systemStatus.getLabel("object.validation.incorrectFileName"));
                } else {
                    errors.put("fileError", systemStatus.getLabel("object.validation.longFileName"));
                }
                this.processErrors(context, errors);
                isValid = this.validateObject(context, db, thisImport);
                context.getRequest().setAttribute("name", (Object)subject);
                isValid = false;
            } else {
                isValid = this.validateObject(context, db, thisImport);
                if (isValid && (productCatalogRecordInserted = thisImport.insert(db)) && parts.get("id") instanceof FileInfo) {
                    newFileInfo = (FileInfo)parts.get("id");
                    thisItem = new FileItem();
                    thisItem.setLinkModuleId(33020045);
                    thisItem.setLinkItemId(thisImport.getId());
                    thisItem.setEnteredBy(this.getUserId(context));
                    thisItem.setModifiedBy(this.getUserId(context));
                    thisItem.setSubject(subject);
                    thisItem.setClientFilename(newFileInfo.getClientFileName());
                    thisItem.setFilename(newFileInfo.getRealFilename());
                    thisItem.setVersion(1.0);
                    thisItem.setSize(newFileInfo.getSize());
                    isValid = this.validateObject(context, db, thisItem);
                    if (isValid) {
                        fileRecordInserted = thisItem.insert(db);
                    }
                }
            }
            isValid = false;
            if (!(parts.get("imageId") instanceof FileInfo)) {
                zipFileRecordInserted = false;
            } else {
                isValid = this.validateObject(context, db, thisImport);
                if (isValid && productCatalogRecordInserted && parts.get("imageId") instanceof FileInfo) {
                    newFileInfo = (FileInfo)parts.get("imageId");
                    thisItem = new FileItem();
                    thisItem.setLinkModuleId(33020045);
                    thisItem.setLinkItemId(thisImport.getId());
                    thisItem.setEnteredBy(this.getUserId(context));
                    thisItem.setModifiedBy(this.getUserId(context));
                    thisItem.setSubject(subject);
                    thisItem.setClientFilename(newFileInfo.getClientFileName());
                    thisItem.setFilename(newFileInfo.getRealFilename());
                    thisItem.setVersion(1.0);
                    thisItem.setSize(newFileInfo.getSize());
                    isValid = this.validateObject(context, db, thisItem);
                    if (isValid) {
                        zipFileRecordInserted = thisItem.insert(db);
                    }
                }
            }
            if (productCatalogRecordInserted && fileRecordInserted) {
                thisImport = new ProductCatalogImport(db, thisImport.getId());
                try {
                    thisImport.buildFileDetails(db);
                }
                catch (SQLException e) {
                    thisImport.delete(db);
                    thisImport.setId(-1);
                    errors.put("fileError", systemStatus.getLabel("object.validation.badFileFormat"));
                    this.processErrors(context, errors);
                }
                if (zipFileRecordInserted) {
                    try {
                        thisImport.buildZipFileDetails(db);
                    }
                    catch (SQLException e) {
                        thisImport.delete(db);
                        thisImport.setId(-1);
                        zipFileErrors = true;
                        errors.put("imagesError", systemStatus.getLabel("object.validation.badImagesFileFormat"));
                        this.processErrors(context, errors);
                    }
                }
                thisImport.setSystemStatus(systemStatus);
            } else if (productCatalogRecordInserted) {
                thisImport.delete(db);
                thisImport.setId(-1);
            }
            context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (fileRecordInserted && productCatalogRecordInserted && !zipFileErrors) {
            return ProductCatalogImports.getReturn(context, "Save");
        }
        return this.executeCommandNew(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-imports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            SystemStatus systemStatus = this.getSystemStatus(context);
            String importId = context.getRequest().getParameter("importId");
            ProductCatalogImport thisImport = new ProductCatalogImport(db, Integer.parseInt(importId));
            thisImport.buildFileDetails(db);
            if (FileItem.fileExists((Connection)db, (int)-1, (String)"%.zip", (int)thisImport.getId(), (int)thisImport.getType()) > 0) {
                thisImport.buildZipFileDetails(db);
            }
            thisImport.setSystemStatus(systemStatus);
            ImportManager manager = systemStatus.getImportManager(context);
            Object activeImport = manager.getImport(thisImport.getId());
            if (thisImport.isRunning() && activeImport != null) {
                thisImport.updateRecordCounts(manager);
            } else if (thisImport.isRunning() && activeImport == null) {
                thisImport.updateStatus(db, 4);
            }
            this.buildFormElements(db, context);
            context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ProductCatalogImports.getReturn(context, "Details");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInitValidate(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-imports-add")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            String filePath;
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            String importId = context.getRequest().getParameter("importId");
            ProductCatalogImport thisImport = new ProductCatalogImport(db, Integer.parseInt(importId));
            thisImport.buildFileDetails(db);
            if (FileItem.fileExists((Connection)db, (int)-1, (String)"%.zip", (int)thisImport.getId(), (int)thisImport.getType()) > 0) {
                thisImport.buildZipFileDetails(db);
            }
            context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
            String propertyFile = context.getServletContext().getRealPath("/") + "WEB-INF" + System.getProperty("file.separator") + "cfs-import-properties.xml";
            PropertyMap thisMap = new PropertyMap(propertyFile, "productCatalog");
            FileItem importFile = thisImport.getFile();
            context.getRequest().setAttribute("FileItem", (Object)importFile);
            if (FileItem.fileExists((Connection)db, (int)-1, (String)"%.zip", (int)thisImport.getId(), (int)thisImport.getType()) > 0) {
                FileItem importZipFile = thisImport.getZipFileItem();
                context.getRequest().setAttribute("ZipFileItem", (Object)importZipFile);
                String zipFilePath = this.getPath(context, "products") + ProductCatalogImports.getDatePath(importZipFile.getModified()) + importZipFile.getFilename();
            }
            if (FileUtils.fileExists(filePath = this.getPath(context, "products") + ProductCatalogImports.getDatePath(importFile.getModified()) + importFile.getFilename())) {
                ProductImportValidate validator = new ProductImportValidate();
                validator.setProductCatalogImport(thisImport);
                validator.setFilePath(filePath);
                validator.setPropertyMap(thisMap);
                validator.initialize();
                context.getRequest().setAttribute("ImportValidator", (Object)validator);
            } else {
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.importFileDoesNotExist"));
            }
            this.buildValidateFormElements(db, context, thisImport);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ProductCatalogImports.getReturn(context, "InitValidate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandValidate(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-imports-add")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            String filePath;
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            String importId = context.getRequest().getParameter("importId");
            ProductCatalogImport thisImport = new ProductCatalogImport(db, Integer.parseInt(importId));
            thisImport.buildFileDetails(db);
            if (FileItem.fileExists((Connection)db, (int)-1, (String)"%.zip", (int)thisImport.getId(), (int)thisImport.getType()) > 0) {
                thisImport.buildZipFileDetails(db);
            }
            thisImport.setProperties(context.getRequest());
            context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
            String propertyFile = context.getServletContext().getRealPath("/") + "WEB-INF" + System.getProperty("file.separator") + "cfs-import-properties.xml";
            PropertyMap thisMap = new PropertyMap(propertyFile, "productCatalog");
            FileItem importFile = thisImport.getFile();
            context.getRequest().setAttribute("FileItem", (Object)importFile);
            if (FileItem.fileExists((Connection)db, (int)-1, (String)"%.zip", (int)thisImport.getId(), (int)thisImport.getType()) > 0) {
                FileItem importZipFile = thisImport.getZipFileItem();
                context.getRequest().setAttribute("ZipFileItem", (Object)importZipFile);
                ProductCatalogImages imagesFileItem = ProductCatalogImages.processZipFile(thisImport.getZipFileItem(), this.getPath(context, "products") + ProductCatalogImports.getDatePath(importZipFile.getModified()));
                thisImport.setImageList(imagesFileItem);
            }
            if (FileUtils.fileExists(filePath = this.getPath(context, "products") + ProductCatalogImports.getDatePath(importFile.getModified()) + importFile.getFilename())) {
                ProductImportValidate validator = new ProductImportValidate();
                validator.setProductCatalogImport(thisImport);
                validator.setFilePath(filePath);
                validator.setPropertyMap(thisMap);
                validator.validate(context.getRequest());
                context.getRequest().setAttribute("ImportValidator", (Object)validator);
                if (validator.getErrors().size() == 0) {
                    String string = this.executeCommandProcess(context);
                    return string;
                }
            } else {
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.importFileDoesNotExist"));
            }
            this.buildValidateFormElements(db, context, thisImport);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ProductCatalogImports.getReturn(context, "Validate");
    }

    public String executeCommandProcess(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            ProductImportValidate validator = (ProductImportValidate)context.getRequest().getAttribute("ImportValidator");
            ProductCatalogImport thisImport = (ProductCatalogImport)context.getRequest().getAttribute("ImportDetails");
            FileItem thisItem = (FileItem)context.getRequest().getAttribute("FileItem");
            ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
            SystemStatus systemStatus = this.getSystemStatus(context);
            ImportManager manager = systemStatus.getImportManager(context);
            Object activeImport = manager.getImport(thisImport.getId());
            if (activeImport == null) {
                thisImport.setSystemStatus(systemStatus);
                thisImport.setPropertyMap(validator.getPropertyMap());
                thisImport.setLookupAccount(true);
                thisImport.setFilePath(validator.getFilePath());
                thisImport.setUserId(this.getUserId(context));
                thisImport.setConnectionElement(ce);
                thisImport.setFileItem(thisItem);
                manager.add(thisImport);
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("${thisImport.name}", thisImport.getName());
                Template template = new Template(systemStatus.getLabel("object.validation.actionError.importAlreadyRunning"));
                template.setParseElements(map);
                context.getRequest().setAttribute("actionError", (Object)template.getParsedText());
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            return "SystemError";
        }
        return ProductCatalogImports.getReturn(context, "Process");
    }

    public String executeCommandCancel(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-imports-add")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        String importId = context.getRequest().getParameter("importId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            ImportManager manager = systemStatus.getImportManager(context);
            if (!manager.cancel(Integer.parseInt(importId))) {
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.importNotRunning"));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            return "SystemError";
        }
        if ("list".equals(context.getRequest().getParameter("return"))) {
            return ProductCatalogImports.getReturn(context, "Cancel");
        }
        return ProductCatalogImports.getReturn(context, "CancelDetails");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        Connection db = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        if (!this.hasPermission(context, "product-catalog-product-imports-delete")) {
            return "PermissionError";
        }
        String importId = context.getRequest().getParameter("importId");
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            SystemStatus systemStatus = this.getSystemStatus(context);
            ProductCatalogImport thisImport = new ProductCatalogImport(db, Integer.parseInt(importId));
            DependencyList dependencies = thisImport.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            if (dependencies.size() == 0) {
                htmlDialog.setShowAndConfirm(false);
                htmlDialog.setDeleteUrl("javascript:window.location.href='ProductCatalogImports.do?command=Delete&moduleId=" + moduleId + "&importId=" + importId + "'");
            } else {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
                htmlDialog.addButton(systemStatus.getLabel("button.deleteAll"), "javascript:window.location.href='ProductCatalogImports.do?command=Delete&moduleId=" + moduleId + "&importId=" + importId + "'");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        Connection db = null;
        if (!this.hasPermission(context, "product-catalog-product-imports-delete")) {
            return "PermissionError";
        }
        String moduleId = context.getRequest().getParameter("moduleId");
        String importId = context.getRequest().getParameter("importId");
        try {
            db = this.getConnection(context);
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            ProductCatalogImport thisImport = new ProductCatalogImport(db, Integer.parseInt(importId));
            int recordDeleted = thisImport.updateStatus(db, 8);
            if (recordDeleted > 0) {
                FileItem importFile = new FileItem(db, thisImport.getId(), 33020045);
                importFile.delete(db, this.getPath(context, "products"));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("refreshUrl", (Object)("ProductCatalogImports.do?command=View&moduleId=" + moduleId));
        return ProductCatalogImports.getReturn(context, "Delete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownload(ActionContext context) {
        block24: {
            if (!this.hasPermission(context, "product-catalog-product-imports-view")) {
                return "PermissionError";
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            Exception errorMessage = null;
            String itemId = context.getRequest().getParameter("fid");
            String importId = context.getRequest().getParameter("importId");
            String stream = context.getRequest().getParameter("stream");
            String version = context.getRequest().getParameter("ver");
            FileItem thisItem = null;
            ProductCatalogImport thisImport = null;
            Connection db = null;
            try {
                db = this.getConnection(context);
                thisImport = new ProductCatalogImport(db, Integer.parseInt(importId));
                thisItem = new FileItem(db, Integer.parseInt(itemId), Integer.parseInt(importId), 33020045);
                if (version != null) {
                    thisItem.buildVersionList(db);
                }
            }
            catch (Exception e) {
                errorMessage = e;
            }
            finally {
                this.freeConnection(context, db);
            }
            try {
                if (version == null) {
                    FileItem itemToDownload = thisItem;
                    itemToDownload.setEnteredBy(this.getUserId(context));
                    String filePath = this.getPath(context, "products") + ProductCatalogImports.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                    FileDownload fileDownload = new FileDownload();
                    fileDownload.setFullPath(filePath);
                    fileDownload.setDisplayName(itemToDownload.getClientFilename());
                    if (fileDownload.fileExists()) {
                        if ("true".equals(stream)) {
                            fileDownload.setFileTimestamp(thisItem.getModificationDate().getTime());
                            fileDownload.streamContent(context);
                        } else {
                            fileDownload.sendFile(context);
                        }
                    } else {
                        db = null;
                        System.err.println("ProductCatalogImports-> Trying to send a file that does not exist");
                        context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                        context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
                        context.getRequest().setAttribute("FileItem", (Object)itemToDownload);
                        String string = ProductCatalogImports.getReturn(context, "Details");
                        return string;
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block24;
                }
                FileItemVersion itemToDownload = thisItem.getVersion(Double.parseDouble(version));
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "products") + ProductCatalogImports.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    fileDownload.sendFile(context);
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block24;
                }
                db = null;
                System.err.println("ProductCatalogImports-> Trying to send a file that does not exist");
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                String string = this.executeCommandView(context);
                return string;
            }
            catch (SocketException se) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println(se.toString());
                }
            }
            catch (Exception e) {
                context.getRequest().setAttribute("Error", (Object)e);
                String string = "SystemError";
                return string;
            }
            finally {
                if (db != null) {
                    this.freeConnection(context, db);
                }
            }
        }
        return "-none-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandApprove(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-imports-edit")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        String importId = context.getRequest().getParameter("importId");
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            ProductCatalogImport thisImport = new ProductCatalogImport(db, Integer.parseInt(importId));
            if (thisImport.canApprove()) {
                thisImport.updateStatus(db, 7);
            } else {
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.importNotSuccessful"));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ProductCatalogImports.getReturn(context, "Approve");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewResults(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-imports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String importId = context.getRequest().getParameter("importId");
        String moduleId = context.getRequest().getParameter("moduleId");
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "ProductCatalogImportResultsInfo");
        pagedListInfo.setLink("ProductCatalogImports.do?command=ViewResults&importId=" + importId + "&moduleId=" + moduleId);
        try {
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            db = this.getConnection(context);
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            ProductCatalogImport thisImport = new ProductCatalogImport(db, Integer.parseInt(importId));
            context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
            ProductCatalogList thisList = new ProductCatalogList();
            thisList.setDetermineCategory(true);
            thisList.setPagedListInfo(pagedListInfo);
            pagedListInfo.setSearchCriteria(thisList, context);
            thisList.setImportId(Integer.parseInt(importId));
            thisList.setExcludeUnapprovedProducts(false);
            thisList.buildList(db);
            context.getRequest().setAttribute("ImportResults", (Object)thisList);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return ProductCatalogImports.getReturn(context, "ViewResults");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandProductDetails(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-imports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String productId = context.getRequest().getParameter("productId");
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            ProductCatalog thisProductCatalog = new ProductCatalog();
            thisProductCatalog.setBuildCategories(true);
            thisProductCatalog.setBuildPriceList(true);
            thisProductCatalog.queryRecord(db, Integer.parseInt(productId));
            context.getRequest().setAttribute("ProductDetails", (Object)thisProductCatalog);
            FileItem thumbnail = null;
            FileItem smallImage = null;
            FileItem largeImage = null;
            if (thisProductCatalog.getThumbnailImageId() != -1) {
                thumbnail = new FileItem(db, thisProductCatalog.getThumbnailImageId());
            }
            if (thisProductCatalog.getSmallImageId() != -1) {
                smallImage = new FileItem(db, thisProductCatalog.getSmallImageId());
            }
            if (thisProductCatalog.getLargeImageId() != -1) {
                largeImage = new FileItem(db, thisProductCatalog.getLargeImageId());
            }
            context.getRequest().setAttribute("ThumbnailImage", (Object)thumbnail);
            context.getRequest().setAttribute("SmallImage", (Object)smallImage);
            context.getRequest().setAttribute("LargeImage", (Object)largeImage);
            Import thisImport = new Import(db, thisProductCatalog.getImportId());
            context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ProductCatalogImports.getReturn(context, "ProductDetails");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteProduct(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-imports-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordDeleted = false;
        String productId = context.getRequest().getParameter("productId");
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            ProductCatalog thisProductCatalog = new ProductCatalog(db, Integer.parseInt(productId));
            if (thisProductCatalog.getStatusId() != 7) {
                recordDeleted = thisProductCatalog.delete(db, this.getPath(context, "products"));
                this.processErrors(context, thisProductCatalog.getErrors());
                if (!recordDeleted) {
                    context.getRequest().setAttribute("ProductDetails", (Object)thisProductCatalog);
                }
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordDeleted) {
            return ProductCatalogImports.getReturn(context, "DeleteContact");
        }
        if ("list".equals(context.getRequest().getParameter("return"))) {
            return ProductCatalogImports.getReturn(context, "DeleteProductFailedList");
        }
        return ProductCatalogImports.getReturn(context, "DeleteProductFailedDetails");
    }

    private void buildValidateFormElements(Connection db, ActionContext context, ProductCatalogImport thisImport) throws SQLException {
    }

    private void buildFormElements(Connection db, ActionContext context) throws SQLException {
        SystemStatus systemStatus = this.getSystemStatus(context);
        LookupList siteList = new LookupList(db, "lookup_site_id");
        siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("SiteList", (Object)siteList);
    }
}

