/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.PermissionCategory;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.products.actions.ProductCategories;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.products.base.ProductCategory;
import org.aspcfs.modules.products.base.ProductOption;
import org.aspcfs.modules.products.base.ProductOptionConfigurator;
import org.aspcfs.modules.products.base.ProductOptionConfiguratorList;
import org.aspcfs.modules.products.base.ProductOptionList;
import org.aspcfs.modules.products.base.ProductOptionValues;
import org.aspcfs.modules.products.base.ProductOptionValuesList;
import org.aspcfs.modules.products.configurator.OptionConfigurator;
import org.aspcfs.modules.products.configurator.OptionProperty;
import org.aspcfs.modules.products.configurator.OptionPropertyList;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.PagedListInfo;

public final class ProductCatalogOptions
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-view")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductOptionList optionList = new ProductOptionList();
        PagedListInfo optionListInfo = this.getPagedListInfo(context, "ProductCatalogOptionListInfo");
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            String productId = context.getRequest().getParameter("productId");
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(productId));
            context.getRequest().setAttribute("productCatalog", (Object)catalog);
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("productCategory", (Object)parentCategory);
            }
            optionListInfo.setLink("ProductCatalogOptions.do?command=List&moduleId=" + moduleId + "&productId=" + productId + "&categoryId=" + categoryId);
            optionList.setPagedListInfo(optionListInfo);
            optionList.setProductId(productId);
            optionList.setBuildConfigDetails(true);
            optionList.buildList(db);
            context.getRequest().setAttribute("OptionList", (Object)optionList);
            ProductOptionList completeList = new ProductOptionList();
            completeList.setProductId(productId);
            completeList.buildList(db);
            context.getRequest().setAttribute("CompleteList", (Object)completeList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-add")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductOptionConfiguratorList configList = new ProductOptionConfiguratorList();
        ProductOptionList optionList = new ProductOptionList();
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            String productId = context.getRequest().getParameter("productId");
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(productId));
            context.getRequest().setAttribute("productCatalog", (Object)catalog);
            configList.buildList(db);
            context.getRequest().setAttribute("configuratorList", (Object)configList);
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("productCategory", (Object)parentCategory);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-view")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            String productId = context.getRequest().getParameter("productId");
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(productId));
            context.getRequest().setAttribute("productCatalog", (Object)catalog);
            String optionId = context.getRequest().getParameter("optionId");
            ProductOption option = new ProductOption();
            option.setBuildConfigDetails(true);
            option.queryRecord(db, Integer.parseInt(optionId));
            context.getRequest().setAttribute("productOption", (Object)option);
            OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, option.getConfiguratorId());
            configurator.queryProperties(db, option.getId(), true);
            OptionPropertyList propertyList = configurator.getPropertyList();
            context.getRequest().setAttribute("propertyList", (Object)propertyList);
            String configName = configurator.getName();
            context.getRequest().setAttribute("configName", (Object)configName);
            boolean allowMultiplePrices = configurator.getAllowMultiplePrices();
            context.getRequest().setAttribute("allowMultiplePrices", (Object)new String(allowMultiplePrices ? "true" : "false"));
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("productCategory", (Object)parentCategory);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandOptionSource(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String option = context.getRequest().getParameter("choice");
            if (option != null) {
                if ("old".equals(option.trim())) {
                    String catalogId = context.getRequest().getParameter("catalogId");
                    HashMap<Integer, String> selectedElements = new HashMap<Integer, String>();
                    if (catalogId != null) {
                        ProductOptionList optionList = new ProductOptionList();
                        optionList.setProductId(catalogId);
                        optionList.buildList(db);
                        for (ProductOption thisOption : optionList) {
                            selectedElements.put(new Integer(thisOption.getId()), "");
                        }
                        context.getSession().setAttribute("selectedElements", selectedElements);
                    }
                    String string = this.executeCommandOptionList(context);
                    return string;
                }
                String string = this.executeCommandLoadConfigurator(context);
                return string;
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandOptionList(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-view")) {
            return "PermissionError";
        }
        Connection db = null;
        PagedListInfo optionListInfo = this.getPagedListInfo(context, "ProductCatalogOptionListInfo");
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String catalogId = context.getRequest().getParameter("catalogId");
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(catalogId));
            context.getRequest().setAttribute("ProductCatalog", (Object)catalog);
            String configId = context.getRequest().getParameter("oldConfigId");
            context.getRequest().setAttribute("configId", (Object)configId);
            HashMap selectedList = new HashMap();
            HashMap finalElementList = (HashMap)context.getSession().getAttribute("finalElements");
            if (context.getRequest().getParameter("previousSelection") != null) {
                StringTokenizer st = new StringTokenizer(context.getRequest().getParameter("previousSelection"), "|");
                while (st.hasMoreTokens()) {
                    selectedList.put(new Integer(st.nextToken()), "");
                }
            } else {
                selectedList = (HashMap)context.getSession().getAttribute("selectedElements");
            }
            int rowCount = 1;
            while (context.getRequest().getParameter("hiddenelementid" + rowCount) != null) {
                int elementId = 0;
                elementId = Integer.parseInt(context.getRequest().getParameter("hiddenelementid" + rowCount));
                if (context.getRequest().getParameter("checkelement" + rowCount) != null) {
                    if (selectedList.get(new Integer(elementId)) == null) {
                        selectedList.put(new Integer(elementId), "");
                    }
                } else {
                    selectedList.remove(new Integer(elementId));
                }
                ++rowCount;
            }
            if (context.getRequest().getParameter("finalsubmit") != null && context.getRequest().getParameter("finalsubmit").equalsIgnoreCase("true")) {
                finalElementList = (HashMap)selectedList.clone();
                System.out.println("finalElements : " + finalElementList);
                context.getSession().setAttribute("finalElements", (Object)finalElementList);
                String elementId = this.executeCommandAddOptionMappings(context);
                return elementId;
            }
            ProductOptionList optionList = new ProductOptionList();
            optionListInfo.setLink("ProductCatalogOptions.do?command=OptionList&moduleId=" + moduleId + "&catalogId=" + catalogId + "&configId=" + configId);
            optionList.setPagedListInfo(optionListInfo);
            optionList.setConfiguratorId(configId);
            optionList.buildList(db);
            context.getRequest().setAttribute("OptionList", (Object)optionList);
            context.getSession().setAttribute("selectedElements", (Object)selectedList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "OptionListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddOptionMappings(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String catalogId = context.getRequest().getParameter("catalogId");
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(catalogId));
            context.getRequest().setAttribute("ProductCatalog", (Object)catalog);
            ProductOptionList oldList = new ProductOptionList();
            oldList.setProductId(catalogId);
            oldList.buildList(db);
            ProductOptionList newList = new ProductOptionList();
            String finalElements = context.getRequest().getParameter("finalElements");
            if (finalElements != null) {
                StringTokenizer st = new StringTokenizer(finalElements, ",");
                while (st.hasMoreTokens()) {
                    String id = String.valueOf(st.nextToken());
                    newList.add(new ProductOption(db, Integer.parseInt(id)));
                }
            }
            newList.addProductMapping(db, oldList, catalog.getId());
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRemoveMapping(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            String productId = context.getRequest().getParameter("productId");
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(productId));
            context.getRequest().setAttribute("productCatalog", (Object)catalog);
            String optionId = context.getRequest().getParameter("optionId");
            ProductOption option = new ProductOption(db, Integer.parseInt(optionId));
            option.removeProductMapping(db, Integer.parseInt(productId));
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("productCategory", (Object)parentCategory);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductOption option = null;
        String moduleId = context.getRequest().getParameter("moduleId");
        String categoryId = context.getRequest().getParameter("categoryId");
        String productId = context.getRequest().getParameter("productId");
        String optionId = context.getRequest().getParameter("optionId");
        HtmlDialog htmlDialog = new HtmlDialog();
        Exception errorMessage = null;
        String returnUrl = context.getRequest().getParameter("return");
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            option = new ProductOption(db, Integer.parseInt(optionId));
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            DependencyList dependencies = option.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
            if (dependencies.canDelete()) {
                htmlDialog.addButton(systemStatus.getLabel("button.deleteAll"), "javascript:window.location.href='ProductCatalogOptions.do?command=Delete&optionId=" + optionId + "&action=delete&return=" + returnUrl + "&moduleId=" + (moduleId != null ? moduleId : "") + "&categoryId=" + (categoryId != null ? categoryId : "") + "&productId=" + (productId != null ? productId : "") + "'");
            }
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
            return "ConfirmDeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        Object errorMessage = null;
        boolean recordDeleted = false;
        String moduleId = context.getRequest().getParameter("moduleId");
        String categoryId = context.getRequest().getParameter("categoryId");
        String productId = context.getRequest().getParameter("productId");
        String returnUrl = context.getRequest().getParameter("return");
        returnUrl = returnUrl + "&moduleId=" + moduleId + "&categoryId=" + (categoryId != null ? categoryId : "") + "&productId=" + (productId != null ? productId : "");
        try {
            db = this.getConnection(context);
            String optionId = context.getRequest().getParameter("optionId");
            ProductOption option = new ProductOption(db, Integer.parseInt(optionId));
            recordDeleted = option.delete(db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordDeleted) {
                context.getRequest().setAttribute("refreshUrl", (Object)returnUrl);
                return "DeleteOK";
            }
            return "SystemError";
        }
        context.getRequest().setAttribute("actionError", (Object)this.getSystemStatus(context).getLabel("object.validation.actionError.productOptionDeletion"));
        context.getRequest().setAttribute("refreshUrl", (Object)returnUrl);
        return "DeleteError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddNew(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-add")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductOptionConfiguratorList configList = new ProductOptionConfiguratorList();
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String catalogId = context.getRequest().getParameter("catalogId");
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(catalogId));
            context.getRequest().setAttribute("ProductCatalog", (Object)catalog);
            configList.buildList(db);
            context.getRequest().setAttribute("ConfiguratorList", (Object)configList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddNewOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandLoadConfigurator(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-add")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductOption productOption = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            String productId = context.getRequest().getParameter("productId");
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(productId));
            context.getRequest().setAttribute("productCatalog", (Object)catalog);
            String configId = context.getRequest().getParameter("configId");
            context.getRequest().setAttribute("configId", (Object)configId);
            OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, Integer.parseInt(configId));
            if (context.getRequest().getParameter("action") != null) {
                String optionId = context.getRequest().getParameter("optionId");
                configurator.queryProperties(db, Integer.parseInt(optionId), false);
                productOption = context.getRequest().getAttribute("productOption") == null ? new ProductOption(db, Integer.parseInt(optionId)) : (ProductOption)((Object)context.getRequest().getAttribute("productOption"));
                productOption.setLabel(configurator.getLabel());
                context.getRequest().setAttribute("productOption", (Object)productOption);
            }
            OptionPropertyList propertyList = null;
            propertyList = context.getRequest().getAttribute("PropertyList") != null ? (OptionPropertyList)context.getRequest().getAttribute("PropertyList") : configurator.getPropertyList();
            for (OptionProperty thisProperty : propertyList) {
                thisProperty.prepareContext(db, context.getRequest());
            }
            context.getRequest().setAttribute("PropertyList", (Object)propertyList);
            String configName = configurator.getName();
            context.getRequest().setAttribute("configName", (Object)configName);
            boolean allowMultiplePrices = configurator.getAllowMultiplePrices();
            context.getRequest().setAttribute("allowMultiplePrices", (Object)new String(allowMultiplePrices ? "true" : "false"));
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("productCategory", (Object)parentCategory);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return "LoadConfiguratorOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertOption(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-add")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductOption option = (ProductOption)((Object)context.getFormBean());
        SystemStatus systemStatus = this.getSystemStatus(context);
        boolean isValid = false;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            String productId = context.getRequest().getParameter("productId");
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(productId));
            context.getRequest().setAttribute("productCatalog", (Object)catalog);
            String configId = context.getRequest().getParameter("configId");
            context.getRequest().setAttribute("configId", (Object)configId);
            option.setConfiguratorId(configId);
            OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, Integer.parseInt(configId));
            try {
                configurator.setProperties(context.getRequest());
            }
            catch (Exception exp) {
                // empty catch block
            }
            boolean allowMultiplePrices = configurator.getAllowMultiplePrices();
            context.getRequest().setAttribute("allowMultiplePrices", (Object)new String(allowMultiplePrices ? "true" : "false"));
            if (!configurator.getPropertyList().isValid(systemStatus)) {
                context.getRequest().setAttribute("PropertyList", (Object)configurator.getPropertyList());
                context.getRequest().setAttribute("productOption", (Object)option);
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.genericActionError"));
                String string = this.executeCommandLoadConfigurator(context);
                return string;
            }
            if (this.validateObject(context, db, (Object)option) && this.validateObject(context, db, configurator)) {
                isValid = true;
            }
            if (!isValid) {
                context.getRequest().setAttribute("PropertyList", (Object)configurator.getPropertyList());
                context.getRequest().setAttribute("productOption", (Object)option);
                String string = this.executeCommandLoadConfigurator(context);
                return string;
            }
            configurator.saveProperties(db, option);
            option.setLabel(configurator.getLabel());
            context.getRequest().setAttribute("productOption", (Object)option);
            context.getRequest().setAttribute("propertyList", (Object)configurator.getPropertyList());
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("productCategory", (Object)parentCategory);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return "InsertOptionOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateOption(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductOption option = (ProductOption)((Object)context.getFormBean());
        SystemStatus systemStatus = this.getSystemStatus(context);
        boolean isValid = false;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            String productId = context.getRequest().getParameter("productId");
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(productId));
            context.getRequest().setAttribute("productCatalog", (Object)catalog);
            String configId = context.getRequest().getParameter("configId");
            context.getRequest().setAttribute("configId", (Object)configId);
            option.setConfiguratorId(configId);
            OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, Integer.parseInt(configId));
            try {
                configurator.setProperties(context.getRequest());
            }
            catch (Exception exp) {
                // empty catch block
            }
            boolean allowMultiplePrices = configurator.getAllowMultiplePrices();
            context.getRequest().setAttribute("allowMultiplePrices", (Object)new String(allowMultiplePrices ? "true" : "false"));
            if (!configurator.getPropertyList().isValid(systemStatus)) {
                context.getRequest().setAttribute("PropertyList", (Object)configurator.getPropertyList());
                context.getRequest().setAttribute("productOption", (Object)option);
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.genericActionError"));
                String string = this.executeCommandLoadConfigurator(context);
                return string;
            }
            if (this.validateObject(context, db, (Object)option) && this.validateObject(context, db, configurator)) {
                isValid = true;
            }
            if (!isValid) {
                context.getRequest().setAttribute("PropertyList", (Object)configurator.getPropertyList());
                context.getRequest().setAttribute("productOption", (Object)option);
                String string = this.executeCommandLoadConfigurator(context);
                return string;
            }
            configurator.updateProperties(db, option);
            option.setLabel(configurator.getLabel());
            context.getRequest().setAttribute("productOption", (Object)option);
            context.getRequest().setAttribute("propertyList", (Object)configurator.getPropertyList());
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("productCategory", (Object)parentCategory);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return "UpdateOptionOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPricingList(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String catalogId = context.getRequest().getParameter("catalogId");
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(catalogId));
            context.getRequest().setAttribute("ProductCatalog", (Object)catalog);
            String optionId = context.getRequest().getParameter("optionId");
            ProductOption option = new ProductOption(db, Integer.parseInt(optionId));
            context.getRequest().setAttribute("ProductOption", (Object)option);
            OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, option.getConfiguratorId());
            configurator.queryProperties(db, option.getId(), false);
            ProductOptionValuesList pricingList = new ProductOptionValuesList();
            pricingList.setOptionId(optionId);
            pricingList.buildList(db);
            context.getRequest().setAttribute("PricingList", (Object)pricingList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return "PricingListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandValueList(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String catalogId = context.getRequest().getParameter("catalogId");
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(catalogId));
            context.getRequest().setAttribute("ProductCatalog", (Object)catalog);
            String optionId = context.getRequest().getParameter("optionId");
            ProductOption option = new ProductOption(db, Integer.parseInt(optionId));
            context.getRequest().setAttribute("ProductOption", (Object)option);
            String resultId = context.getRequest().getParameter("resultId");
            String displayValue = context.getRequest().getParameter("displayValue");
            ProductOptionValuesList pricingList = new ProductOptionValuesList();
            if (optionId != null && resultId != null) {
                pricingList.setOptionId(optionId);
                pricingList.setResultId(resultId);
                pricingList.buildList(db);
            }
            context.getRequest().setAttribute("resultId", (Object)resultId);
            context.getRequest().setAttribute("DisplayText", (Object)displayValue);
            context.getRequest().setAttribute("PricingList", (Object)pricingList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ValueListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddPricing(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String catalogId = context.getRequest().getParameter("catalogId");
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(catalogId));
            context.getRequest().setAttribute("ProductCatalog", (Object)catalog);
            String optionId = context.getRequest().getParameter("optionId");
            ProductOption option = new ProductOption(db, Integer.parseInt(optionId));
            context.getRequest().setAttribute("ProductOption", (Object)option);
            int nextRangeMin = ProductOption.getNextRangeMin(db, option.getId());
            context.getRequest().setAttribute("nextRangeMin", (Object)String.valueOf(nextRangeMin));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddPricingOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertPricing(ActionContext context) {
        Connection db = null;
        boolean isValid = false;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String catalogId = context.getRequest().getParameter("catalogId");
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(catalogId));
            context.getRequest().setAttribute("ProductCatalog", (Object)catalog);
            String optionId = context.getRequest().getParameter("optionId");
            ProductOption option = new ProductOption(db, Integer.parseInt(optionId));
            context.getRequest().setAttribute("ProductOption", (Object)option);
            ProductOptionValues value = (ProductOptionValues)((Object)context.getFormBean());
            isValid = this.validateObject(context, db, (Object)value);
            if (isValid) {
                value.insert(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        if (isValid) {
            return this.executeCommandPricingList(context);
        }
        return this.executeCommandAddPricing(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddMapping(ActionContext context) {
        Connection db = null;
        boolean isValid = false;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            String catalogId = context.getRequest().getParameter("catalogId");
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(catalogId));
            context.getRequest().setAttribute("ProductCatalog", (Object)catalog);
            String optionId = context.getRequest().getParameter("optionId");
            ProductOption option = new ProductOption(db, Integer.parseInt(optionId));
            context.getRequest().setAttribute("ProductOption", (Object)option);
            String valueId = context.getRequest().getParameter("valueId");
            if (valueId != null) {
                String refreshUrl = "ProductCatalogOptionPricings.do?command=PricingList&catalogId=" + catalogId + "&moduleId=" + moduleId + "&optionId=" + optionId;
                context.getRequest().setAttribute("refreshUrl", (Object)refreshUrl);
            } else {
                ProductOptionValues value = (ProductOptionValues)((Object)context.getFormBean());
                isValid = this.validateObject(context, db, (Object)value);
                if (isValid) {
                    value.insert(db);
                }
                String refreshUrl = "ProductCatalogOptionPricings.do?command=PricingList&catalogId=" + catalogId + "&moduleId=" + moduleId + "&optionId=" + optionId;
                context.getRequest().setAttribute("refreshUrl", (Object)refreshUrl);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddMappingOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRemovePricing(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String optionId = context.getRequest().getParameter("optionId");
            ProductOption option = new ProductOption(db, Integer.parseInt(optionId));
            context.getRequest().setAttribute("ProductOption", (Object)option);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandPricingList(context);
    }
}

