/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.Thumbnail;
import com.zeroio.webutils.FileDownload;
import java.io.File;
import java.net.SocketException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.PermissionCategory;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.products.actions.ProductCategories;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.products.base.ProductCatalogList;
import org.aspcfs.modules.products.base.ProductCatalogPricing;
import org.aspcfs.modules.products.base.ProductCatalogPricingList;
import org.aspcfs.modules.products.base.ProductCategory;
import org.aspcfs.modules.products.base.ProductCategoryList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.ImageUtils;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class ProductCatalogs
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearchForm(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            LookupList typeSelect = new LookupList(db, "lookup_product_type");
            typeSelect.addItem(-1, "All Types");
            context.getRequest().setAttribute("TypeSelect", (Object)typeSelect);
            PagedListInfo catalogListInfo = this.getPagedListInfo(context, "SearchProductCatalogListInfo");
            catalogListInfo.setCurrentLetter("");
            catalogListInfo.setCurrentOffset(0);
            if (!"".equals(catalogListInfo.getSearchOptionValue("searchcodeCategoryId")) && !"-1".equals(catalogListInfo.getSearchOptionValue("searchcodeCategoryId"))) {
                String categoryId = catalogListInfo.getSearchOptionValue("searchcodeCategoryId");
                ProductCategory category = new ProductCategory(db, Integer.parseInt(categoryId));
                context.getRequest().setAttribute("ProductCategory", (Object)category);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SearchOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearch(ActionContext context) {
        Connection db = null;
        ProductCatalogList catalogList = new ProductCatalogList();
        PagedListInfo searchListInfo = this.getPagedListInfo(context, "SearchProductCatalogListInfo");
        this.resetPagedListInfo(context);
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            searchListInfo.setLink("ProductCatalogs.do?command=Search&moduleId=" + moduleId);
            catalogList.setPagedListInfo(searchListInfo);
            catalogList.setTypeId(searchListInfo.getFilterKey("listFilter1"));
            catalogList.setCategoryId(searchListInfo.getFilterKey("listFilter2"));
            searchListInfo.setSearchCriteria(catalogList, context);
            if ("all".equals(searchListInfo.getListView())) {
                catalogList.setActive(-1);
            }
            if ("enabled".equals(searchListInfo.getListView())) {
                catalogList.setActive(1);
            }
            if ("disabled".equals(searchListInfo.getListView())) {
                catalogList.setActive(0);
            }
            catalogList.buildList(db);
            context.getRequest().setAttribute("CatalogList", (Object)catalogList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddCategoryMappings(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String catalogId = context.getRequest().getParameter("catalogId");
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(catalogId));
            context.getRequest().setAttribute("ProductCatalog", (Object)catalog);
            ProductCategoryList oldList = new ProductCategoryList();
            oldList.setProductId(catalogId);
            oldList.buildList(db);
            ProductCategoryList newList = new ProductCategoryList();
            String finalElements = context.getRequest().getParameter("finalElements");
            if (finalElements != null) {
                StringTokenizer st = new StringTokenizer(finalElements, ",");
                while (st.hasMoreTokens()) {
                    String id = String.valueOf(st.nextToken());
                    newList.add(new ProductCategory(db, Integer.parseInt(id)));
                }
            }
            newList.addProductMapping(db, oldList, catalog.getId());
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandCategoryList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRemoveCategoryMapping(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String catalogId = context.getRequest().getParameter("productId");
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(catalogId));
            context.getRequest().setAttribute("ProductCatalog", (Object)catalog);
            String categoryId = context.getRequest().getParameter("categoryId");
            catalog.removeCategoryMapping(db, Integer.parseInt(categoryId));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandCategoryList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCategoryList(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String catalogId = context.getRequest().getParameter("productId");
            String categoryId = context.getRequest().getParameter("categoryId");
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(catalogId));
            catalog.setCategoryId(categoryId);
            context.getRequest().setAttribute("productCatalog", (Object)catalog);
            PagedListInfo categoryListInfo = this.getPagedListInfo(context, "CategoryListInfo");
            ProductCategoryList categoryList = new ProductCategoryList();
            categoryList.setProductId(catalogId);
            categoryList.setPagedListInfo(categoryListInfo);
            categoryList.buildList(db);
            for (ProductCategory ctgry : categoryList) {
                ProductCategoryList fullName = new ProductCategoryList();
                fullName = ProductCategory.buildFullName(db, fullName, ctgry.getId(), true);
                ctgry.setFullPath(fullName);
                ctgry.buildProductList(db);
            }
            context.getRequest().setAttribute("CategoryList", (Object)categoryList);
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("productCategory", (Object)parentCategory);
            }
            ProductCategoryList completeList = new ProductCategoryList();
            completeList.setProductId(catalogId);
            completeList.buildList(db);
            context.getRequest().setAttribute("CompleteList", (Object)completeList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "CategoryListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-add")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList typeSelect = systemStatus.getLookupList(db, "lookup_product_type");
            typeSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogTypeList", (Object)typeSelect);
            LookupList formatSelect = systemStatus.getLookupList(db, "lookup_product_format");
            formatSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogFormatList", (Object)formatSelect);
            LookupList shippingSelect = systemStatus.getLookupList(db, "lookup_product_shipping");
            shippingSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogShippingList", (Object)shippingSelect);
            LookupList shipTimeSelect = systemStatus.getLookupList(db, "lookup_product_ship_time");
            shipTimeSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogShipTimeList", (Object)shipTimeSelect);
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("parentCategory", (Object)parentCategory);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsert(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordInserted = false;
        boolean isValid = false;
        ProductCatalog insCatalog = null;
        ProductCatalog newCatalog = (ProductCatalog)((Object)context.getFormBean());
        newCatalog.setEnteredBy(this.getUserId(context));
        newCatalog.setModifiedBy(this.getUserId(context));
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            if (newCatalog.getActivePrice() != null && newCatalog.getActivePrice().getPriceAmount() > 0.0) {
                newCatalog.getActivePrice().setEnabled(newCatalog.getEnabled());
                newCatalog.getActivePrice().setEnteredBy(this.getUserId(context));
                newCatalog.getActivePrice().setModifiedBy(this.getUserId(context));
                newCatalog.getActivePrice().setStartDate(newCatalog.getStartDate());
                newCatalog.getActivePrice().setExpirationDate(newCatalog.getExpirationDate());
            }
            isValid = this.validateObject(context, db, (Object)newCatalog);
            if (newCatalog.getActivePrice() != null && newCatalog.getActivePrice().getPriceAmount() > 0.0) {
                boolean bl = isValid = this.validateObject(context, db, (Object)newCatalog.getActivePrice()) && isValid;
            }
            if (isValid && (recordInserted = newCatalog.insert(db)) && newCatalog.getActivePrice() != null && newCatalog.getActivePrice().getPriceAmount() > 0.0) {
                insCatalog = new ProductCatalog(db, newCatalog.getId());
                newCatalog.getActivePrice().setProductId(insCatalog.getId());
                recordInserted = newCatalog.getActivePrice().insert(db);
            }
            if (recordInserted && isValid) {
                if (insCatalog == null || insCatalog.getId() == -1) {
                    insCatalog = new ProductCatalog(db, newCatalog.getId());
                }
                context.getRequest().setAttribute("productCatalog", (Object)insCatalog);
                String categoryId = context.getRequest().getParameter("categoryId");
                if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                    ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                    ProductCategories.buildHierarchy(db, context);
                    context.getRequest().setAttribute("productCategory", (Object)parentCategory);
                }
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (!recordInserted || !isValid) {
            context.getRequest().setAttribute("productCatalog", (Object)newCatalog);
            return this.executeCommandAdd(context);
        }
        if (recordInserted && isValid) {
            return "InsertOK";
        }
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandClone(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-add")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            if (context.getRequest().getAttribute("productCatalog") == null) {
                String productId = context.getRequest().getParameter("productId");
                ProductCatalog cloneProduct = new ProductCatalog(db, Integer.parseInt(productId));
                cloneProduct.resetBaseInfo();
                context.getRequest().setAttribute("productCatalog", (Object)cloneProduct);
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList typeSelect = systemStatus.getLookupList(db, "lookup_product_type");
            typeSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogTypeList", (Object)typeSelect);
            LookupList formatSelect = systemStatus.getLookupList(db, "lookup_product_format");
            formatSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogFormatList", (Object)formatSelect);
            LookupList shippingSelect = systemStatus.getLookupList(db, "lookup_product_shipping");
            shippingSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogShippingList", (Object)shippingSelect);
            LookupList shipTimeSelect = systemStatus.getLookupList(db, "lookup_product_ship_time");
            shipTimeSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogShipTimeList", (Object)shipTimeSelect);
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("parentCategory", (Object)parentCategory);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "CloneOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveClone(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordInserted = false;
        boolean isValid = false;
        ProductCatalog insCatalog = null;
        ProductCatalog newCatalog = (ProductCatalog)((Object)context.getFormBean());
        newCatalog.setEnteredBy(this.getUserId(context));
        newCatalog.setModifiedBy(this.getUserId(context));
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            String cloneSourceId = context.getRequest().getParameter("productId");
            ProductCatalog cloneSource = new ProductCatalog();
            cloneSource.setBuildOptions(true);
            cloneSource.setBuildPriceList(true);
            cloneSource.queryRecord(db, Integer.parseInt(cloneSourceId));
            if (newCatalog.getActivePrice() != null && newCatalog.getActivePrice().getPriceAmount() > 0.0) {
                newCatalog.getActivePrice().setEnabled(newCatalog.getEnabled());
                newCatalog.getActivePrice().setEnteredBy(this.getUserId(context));
                newCatalog.getActivePrice().setModifiedBy(this.getUserId(context));
                newCatalog.getActivePrice().setStartDate(newCatalog.getStartDate());
                newCatalog.getActivePrice().setExpirationDate(newCatalog.getExpirationDate());
            }
            isValid = this.validateObject(context, db, (Object)newCatalog);
            if (newCatalog.getActivePrice() != null && newCatalog.getActivePrice().getPriceAmount() > 0.0) {
                boolean bl = isValid = this.validateObject(context, db, (Object)newCatalog.getActivePrice()) && isValid;
            }
            if (isValid && (recordInserted = newCatalog.insert(db)) && newCatalog.getActivePrice() != null && newCatalog.getActivePrice().getPriceAmount() > 0.0) {
                insCatalog = new ProductCatalog(db, newCatalog.getId());
                newCatalog.getActivePrice().setProductId(insCatalog.getId());
                recordInserted = newCatalog.getActivePrice().insert(db);
            }
            if (recordInserted && isValid) {
                if (insCatalog == null || insCatalog.getId() == -1) {
                    insCatalog = new ProductCatalog(db, newCatalog.getId());
                }
                context.getRequest().setAttribute("productCatalog", (Object)insCatalog);
                String categoryId = context.getRequest().getParameter("categoryId");
                if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                    ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                    ProductCategories.buildHierarchy(db, context);
                    context.getRequest().setAttribute("productCategory", (Object)parentCategory);
                }
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (!recordInserted || !isValid) {
            context.getRequest().setAttribute("productCatalog", (Object)newCatalog);
            return this.executeCommandClone(context);
        }
        if (recordInserted && isValid) {
            return "SaveCloneOK";
        }
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMove(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductCatalog product = null;
        ProductCategory category = null;
        Exception errorMessage = null;
        try {
            String parentId;
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            String returnAction = context.getRequest().getParameter("returnAction");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            ProductCategoryList selectedList = new ProductCategoryList();
            String productId = context.getRequest().getParameter("productId");
            String string = parentId = context.getRequest().getParameter("parentId") != null && !"".equals(context.getRequest().getParameter("parentId")) ? context.getRequest().getParameter("parentId") : "-1";
            if (Integer.parseInt(productId) != -1) {
                product = new ProductCatalog(db, Integer.parseInt(productId));
                product.buildCategories(db);
                context.getRequest().setAttribute("productCatalog", (Object)product);
                selectedList = product.getCategoryList();
                context.getRequest().setAttribute("checkedList", (Object)product.getCategoryList());
            } else {
                String selected = context.getRequest().getParameter("selected");
                selectedList = new ProductCategoryList();
                if (selected != null && !"".equals(selected)) {
                    selectedList = selectedList.buildListFromIds(db, selected);
                    context.getRequest().setAttribute("checkedList", (Object)selectedList);
                }
            }
            String categoryId = context.getRequest().getParameter("categoryId");
            if (Integer.parseInt(categoryId) != -1) {
                category = new ProductCategory(db, Integer.parseInt(categoryId));
                context.getRequest().setAttribute("productCategory", (Object)category);
            }
            ProductCategoryList categoryList = new ProductCategoryList();
            categoryList.setParentId(parentId);
            if ("-1".equals(parentId)) {
                categoryList.setTopOnly(1);
            }
            categoryList.setBuildChildCount(true);
            categoryList.buildList(db);
            if ("-1".equals(parentId)) {
                ProductCategoryList tmpList = new ProductCategoryList();
                for (ProductCategory thisCategory : selectedList) {
                    ProductCategoryList parentList = new ProductCategoryList();
                    parentList = ProductCategory.buildFullName(db, parentList, thisCategory.getId(), false);
                    tmpList.addAll(parentList);
                }
                ProductCategoryList.buildHierarchyFromSelectedIds(db, categoryList, tmpList);
            }
            context.getRequest().setAttribute("categoryHierarchy", (Object)categoryList);
            context.getRequest().setAttribute("action", (Object)"moveProduct");
            context.getRequest().setAttribute("returnAction", (Object)returnAction);
            context.getRequest().setAttribute("parentId", (Object)parentId);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (context.getRequest().getParameter("mode") != null) {
                return "MoveChunkOK";
            }
            return "MoveOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveMove(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String id = context.getRequest().getParameter("id");
        String returnAction = context.getRequest().getParameter("returnAction");
        String[] category = context.getRequest().getParameterValues("categoryElt");
        try {
            db = this.getConnection(context);
            String ids = "";
            if (category != null) {
                for (int i = 0; i < category.length; ++i) {
                    ids = ids + category[i] + "|";
                }
            }
            ProductCategoryList newList = new ProductCategoryList();
            newList = newList.buildListFromIds(db, ids);
            if (!"set".equals(returnAction)) {
                ProductCatalog thisProduct = new ProductCatalog(db, Integer.parseInt(id));
                thisProduct.buildCategories(db);
                newList.addProductMapping(db, thisProduct.getCategoryList(), thisProduct.getId());
                String string = "PopupCloseOK";
                return string;
            }
            context.getRequest().setAttribute("categoryList", (Object)newList);
            String string = "MultiselectCloseOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-view")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductCatalog thisProduct = null;
        Exception errorMessage = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            int productId = Integer.parseInt(context.getRequest().getParameter("productId"));
            thisProduct = new ProductCatalog(db, productId);
            thisProduct.buildCategories(db);
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("productCategory", (Object)parentCategory);
            }
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace();
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("productCatalog", thisProduct);
            return "DetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductCatalog catalog = null;
        Exception errorMessage = null;
        try {
            String categoryId;
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList typeSelect = systemStatus.getLookupList(db, "lookup_product_type");
            typeSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogTypeList", (Object)typeSelect);
            LookupList formatSelect = systemStatus.getLookupList(db, "lookup_product_format");
            formatSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogFormatList", (Object)formatSelect);
            LookupList shippingSelect = systemStatus.getLookupList(db, "lookup_product_shipping");
            shippingSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogShippingList", (Object)shippingSelect);
            LookupList shipTimeSelect = systemStatus.getLookupList(db, "lookup_product_ship_time");
            shipTimeSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogShipTimeList", (Object)shipTimeSelect);
            if (context.getRequest().getAttribute("productCatalog") == null) {
                int productId = Integer.parseInt(context.getRequest().getParameter("productId"));
                catalog = new ProductCatalog(db, productId);
                catalog.buildCategories(db);
                context.getRequest().setAttribute("productCatalog", (Object)catalog);
            }
            if ((categoryId = context.getRequest().getParameter("categoryId")) != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("productCategory", (Object)parentCategory);
            }
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace();
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "ModifyOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        int recordUpdated;
        boolean isValid;
        block14: {
            if (!this.hasPermission(context, "product-catalog-product-edit")) {
                return "PermissionError";
            }
            Connection db = null;
            isValid = false;
            recordUpdated = -1;
            ProductCatalog updatedCatalog = null;
            ProductCatalog catalog = (ProductCatalog)((Object)context.getFormBean());
            catalog.setModifiedBy(this.getUserId(context));
            try {
                db = this.getConnection(context);
                String moduleId = context.getRequest().getParameter("moduleId");
                if (moduleId == null || "-1".equals(moduleId)) {
                    moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
                }
                PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
                context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
                catalog.buildActivePrice(db);
                isValid = this.validateObject(context, db, (Object)catalog);
                if (isValid) {
                    recordUpdated = catalog.update(db);
                }
                if (recordUpdated > 0 && isValid) {
                    updatedCatalog = new ProductCatalog(db, catalog.getId());
                    updatedCatalog.buildCategories(db);
                    context.getRequest().setAttribute("productCatalog", (Object)updatedCatalog);
                    String categoryId = context.getRequest().getParameter("categoryId");
                    if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                        ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                        ProductCategories.buildHierarchy(db, context);
                        context.getRequest().setAttribute("productCategory", (Object)parentCategory);
                    }
                    break block14;
                }
                context.getRequest().setAttribute("productCatalog", (Object)catalog);
                String string = this.executeCommandModify(context);
                return string;
            }
            catch (Exception e) {
                context.getRequest().setAttribute("Error", (Object)e);
                e.printStackTrace(System.out);
                String string = "SystemError";
                return string;
            }
            finally {
                this.freeConnection(context, db);
            }
        }
        if (recordUpdated > 0 && isValid) {
            if (context.getRequest().getParameter("return") != null) {
                if ("list".equals(context.getRequest().getParameter("return"))) {
                    return "UpdateOK";
                }
            } else {
                return this.executeCommandDetails(context);
            }
        }
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductCatalog product = null;
        String moduleId = context.getRequest().getParameter("moduleId");
        String categoryId = context.getRequest().getParameter("categoryId");
        String productId = context.getRequest().getParameter("productId");
        HtmlDialog htmlDialog = new HtmlDialog();
        Exception errorMessage = null;
        String returnUrl = context.getRequest().getParameter("return");
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            product = new ProductCatalog(db, Integer.parseInt(productId));
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            DependencyList dependencies = product.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
            if (dependencies.canDelete()) {
                htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='ProductCatalogs.do?command=Trash&productId=" + productId + "&action=delete&return=" + returnUrl + "&moduleId=" + (moduleId != null ? moduleId : "") + "&categoryId=" + (categoryId != null ? categoryId : "") + "'");
            } else {
                htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='ProductCatalogs.do?command=Trash&productId=" + productId + "&action=disable&return=" + returnUrl + "&moduleId=" + (moduleId != null ? moduleId : "") + "&categoryId=" + (categoryId != null ? categoryId : "") + "&forceDelete=true" + "'");
            }
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
            return "ConfirmDeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        boolean recordDeleted = false;
        ProductCatalog thisProduct = null;
        Connection db = null;
        String moduleId = context.getRequest().getParameter("moduleId");
        String categoryId = context.getRequest().getParameter("categoryId");
        String returnUrl = context.getRequest().getParameter("return");
        try {
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            returnUrl = returnUrl + "&moduleId=" + moduleId + "&categoryId=" + (categoryId != null ? categoryId : "");
            db = this.getConnection(context);
            String productId = context.getRequest().getParameter("productId");
            thisProduct = new ProductCatalog(db, Integer.parseInt(productId));
            if (context.getRequest().getParameter("action") != null) {
                if (context.getRequest().getParameter("action").equals("delete")) {
                    recordDeleted = thisProduct.delete(db, ProductCatalogs.getDbNamePath(context));
                } else if (context.getRequest().getParameter("action").equals("disable")) {
                    thisProduct.setEnabled(false);
                    int resultCount = thisProduct.update(db);
                    if (resultCount == 1) {
                        recordDeleted = true;
                    }
                }
            }
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
            System.out.println(errorMessage.getMessage());
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordDeleted) {
                context.getRequest().setAttribute("refreshUrl", (Object)returnUrl);
                return "DeleteOK";
            }
            this.processErrors(context, thisProduct.getErrors());
            return "SystemError";
        }
        context.getRequest().setAttribute("actionError", (Object)this.getSystemStatus(context).getLabel("object.validation.actionError.productDeletion"));
        context.getRequest().setAttribute("refreshUrl", (Object)returnUrl);
        return "DeleteError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandTrash(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        boolean recordUpdated = false;
        ProductCatalog thisProduct = null;
        Connection db = null;
        String moduleId = context.getRequest().getParameter("moduleId");
        String categoryId = context.getRequest().getParameter("categoryId");
        String returnUrl = context.getRequest().getParameter("return");
        try {
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            returnUrl = returnUrl + "&moduleId=" + moduleId + "&categoryId=" + (categoryId != null ? categoryId : "");
            db = this.getConnection(context);
            String productId = context.getRequest().getParameter("productId");
            thisProduct = new ProductCatalog(db, Integer.parseInt(productId));
            if (context.getRequest().getParameter("action").equals("disable")) {
                thisProduct.setEnabled(false);
                int resultCount = thisProduct.update(db);
                if (resultCount == 1) {
                    recordUpdated = true;
                }
            } else {
                recordUpdated = thisProduct.updateStatus(db, true, this.getUserId(context));
            }
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
            System.out.println(errorMessage.getMessage());
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordUpdated) {
                context.getRequest().setAttribute("refreshUrl", (Object)returnUrl);
                return "DeleteOK";
            }
            this.processErrors(context, thisProduct.getErrors());
            return "SystemError";
        }
        context.getRequest().setAttribute("actionError", (Object)this.getSystemStatus(context).getLabel("object.validation.actionError.productDeletion"));
        context.getRequest().setAttribute("refreshUrl", (Object)returnUrl);
        return "DeleteError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRestore(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        boolean recordUpdated = false;
        ProductCatalog thisProduct = null;
        Connection db = null;
        String moduleId = context.getRequest().getParameter("moduleId");
        String categoryId = context.getRequest().getParameter("categoryId");
        try {
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            db = this.getConnection(context);
            String productId = context.getRequest().getParameter("productId");
            thisProduct = new ProductCatalog(db, Integer.parseInt(productId));
            recordUpdated = thisProduct.updateStatus(db, false, this.getUserId(context));
        }
        catch (Exception e) {
            try {
                errorMessage = e;
                System.out.println(errorMessage.getMessage());
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
        }
        this.freeConnection(context, db);
        if (errorMessage == null) {
            if (recordUpdated) {
                return this.executeCommandDetails(context);
            }
            this.processErrors(context, thisProduct.getErrors());
            return "SystemError";
        }
        context.getRequest().setAttribute("actionError", (Object)this.getSystemStatus(context).getLabel("object.validation.actionError.productDeletion"));
        return "DeleteError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandImageList(ActionContext context) {
        Connection db = null;
        ProductCatalog catalog = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId) && !"-1".equals(categoryId)) {
                ProductCategory category = new ProductCategory(db, Integer.parseInt(categoryId));
                context.getRequest().setAttribute("productCategory", (Object)category);
            }
            ProductCategories.buildHierarchy(db, context);
            String productId = context.getRequest().getParameter("productId");
            catalog = new ProductCatalog(db, Integer.parseInt(productId));
            context.getRequest().setAttribute("productCatalog", (Object)catalog);
            FileItem thumbnail = null;
            FileItem smallImage = null;
            FileItem largeImage = null;
            if (catalog.getThumbnailImageId() != -1) {
                thumbnail = new FileItem(db, catalog.getThumbnailImageId());
            }
            if (catalog.getSmallImageId() != -1) {
                smallImage = new FileItem(db, catalog.getSmallImageId());
            }
            if (catalog.getLargeImageId() != -1) {
                largeImage = new FileItem(db, catalog.getLargeImageId());
            }
            context.getRequest().setAttribute("ThumbnailImage", (Object)thumbnail);
            context.getRequest().setAttribute("SmallImage", (Object)smallImage);
            context.getRequest().setAttribute("LargeImage", (Object)largeImage);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ImageListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUploadFile(ActionContext context) {
        Connection db = null;
        boolean isValid = false;
        boolean recordInserted = false;
        try {
            String filePath = this.getPath(context, "products");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            String productId = context.getRequest().getParameter("productId");
            String subject = "Attachment";
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(productId));
            context.getRequest().setAttribute("productCatalog", (Object)catalog);
            if (parts.get("id" + productId) instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("id" + productId);
                FileItem thisItem = new FileItem();
                thisItem.setLinkModuleId(200403194);
                thisItem.setLinkItemId(catalog.getId());
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                thisItem.setFolderId(-1);
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setVersion(1.0);
                thisItem.setSize(newFileInfo.getSize());
                isValid = this.validateObject(context, db, thisItem);
                if (isValid) {
                    recordInserted = thisItem.insert(db);
                }
                thisItem.setDirectory(filePath);
                if (thisItem.isImageFormat()) {
                    File thumbnailFile = new File(newFileInfo.getLocalFile().getPath() + "TH");
                    ImageUtils.saveThumbnail(newFileInfo.getLocalFile(), thumbnailFile, 133.0, 133.0);
                    Thumbnail thumbnail = new Thumbnail();
                    thumbnail.setId(thisItem.getId());
                    thumbnail.setFilename(newFileInfo.getRealFilename() + "TH");
                    thumbnail.setVersion(thisItem.getVersion());
                    thumbnail.setSize((int)thumbnailFile.length());
                    thumbnail.setEnteredBy(thisItem.getEnteredBy());
                    thumbnail.setModifiedBy(thisItem.getModifiedBy());
                    thumbnail.insert(db);
                }
                if (recordInserted && isValid) {
                    String imageType = (String)parts.get("imageType");
                    if ("thumbnail".equals(imageType)) {
                        catalog.setThumbnailImageId(thisItem.getId());
                    } else if ("small".equals(imageType)) {
                        catalog.setSmallImageId(thisItem.getId());
                    } else if ("large".equals(imageType)) {
                        catalog.setLargeImageId(thisItem.getId());
                    }
                    catalog.updateImages(db);
                }
            } else {
                recordInserted = false;
                HashMap<String, String> errors = new HashMap<String, String>();
                SystemStatus systemStatus = this.getSystemStatus(context);
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                this.processErrors(context, errors);
            }
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandImageList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRemoveFile(ActionContext context) {
        Connection db = null;
        try {
            String itemId = context.getRequest().getParameter("fid");
            String productId = context.getRequest().getParameter("productId");
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId) && !"-1".equals(categoryId)) {
                ProductCategory category = new ProductCategory(db, Integer.parseInt(categoryId));
                context.getRequest().setAttribute("productCategory", (Object)category);
            }
            db = this.getConnection(context);
            ProductCatalog catalog = new ProductCatalog(db, Integer.parseInt(productId));
            String imageType = context.getRequest().getParameter("imageType");
            catalog.removeFileItem(db, Integer.parseInt(itemId), imageType, this.getPath(context, "products"));
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandImageList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownloadFile(ActionContext context) {
        Exception errorMessage;
        block18: {
            errorMessage = null;
            String itemId = context.getRequest().getParameter("fid");
            String productId = context.getRequest().getParameter("productId");
            String categoryId = context.getRequest().getParameter("categoryId");
            FileItem thisItem = null;
            Connection db = null;
            try {
                db = this.getConnection(context);
                if (categoryId != null && !"".equals(categoryId) && !"-1".equals(categoryId)) {
                    ProductCategory category = new ProductCategory(db, Integer.parseInt(categoryId));
                    context.getRequest().setAttribute("productCategory", (Object)category);
                }
                thisItem = new FileItem(db, Integer.parseInt(itemId), Integer.parseInt(productId), 200403194);
            }
            catch (Exception e) {
                errorMessage = e;
            }
            finally {
                this.freeConnection(context, db);
            }
            try {
                FileItem itemToDownload = thisItem;
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "products") + ProductCatalogs.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    fileDownload.sendFile(context);
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block18;
                }
                db = null;
                System.err.println("ProductCatalogs-> Trying to send a file that does not exist");
                context.getRequest().setAttribute("actionError", (Object)"The requested download no longer exists on the system");
                String string = this.executeCommandImageList(context);
                return string;
            }
            catch (SocketException se) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println(se.toString());
                }
            }
            catch (Exception e) {
                errorMessage = e;
                System.out.println(e.toString());
            }
            finally {
                if (db != null) {
                    this.freeConnection(context, db);
                }
            }
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPricingList(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-view")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductCatalog catalog = null;
        Exception errorMessage = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            int productId = Integer.parseInt(context.getRequest().getParameter("productId"));
            catalog = new ProductCatalog(db, productId);
            context.getRequest().setAttribute("productCatalog", (Object)catalog);
            ProductCatalogPricingList activePriceList = new ProductCatalogPricingList();
            activePriceList.setProductId(catalog.getId());
            activePriceList.setEnabled(1);
            activePriceList.buildList(db);
            context.getRequest().setAttribute("ActivePriceList", (Object)activePriceList);
            ProductCatalogPricingList inactivePriceList = new ProductCatalogPricingList();
            inactivePriceList.setProductId(catalog.getId());
            inactivePriceList.setEnabled(0);
            inactivePriceList.buildList(db);
            context.getRequest().setAttribute("InactivePriceList", (Object)inactivePriceList);
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("productCategory", (Object)parentCategory);
            }
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace();
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("ProductCatalog", catalog);
            return "PricingListOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddPricing(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-add")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductCatalog catalog = null;
        Exception errorMessage = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            int productId = Integer.parseInt(context.getRequest().getParameter("productId"));
            catalog = new ProductCatalog(db, productId);
            context.getRequest().setAttribute("productCatalog", (Object)catalog);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList taxSelect = systemStatus.getLookupList(db, "lookup_product_tax");
            taxSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("TaxSelect", (Object)taxSelect);
            LookupList currencySelect = systemStatus.getLookupList(db, "lookup_currency");
            currencySelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CurrencySelect", (Object)currencySelect);
            LookupList recurringTypeSelect = systemStatus.getLookupList(db, "lookup_recurring_type");
            recurringTypeSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("RecurringTypeSelect", (Object)recurringTypeSelect);
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("productCategory", (Object)parentCategory);
            }
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace();
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("ProductCatalog", catalog);
            return "AddPricingOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyPricing(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductCatalog catalog = null;
        Exception errorMessage = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            int productId = Integer.parseInt(context.getRequest().getParameter("productId"));
            catalog = new ProductCatalog(db, productId);
            context.getRequest().setAttribute("productCatalog", (Object)catalog);
            if (context.getRequest().getAttribute("Pricing") == null) {
                int pricingId = Integer.parseInt(context.getRequest().getParameter("pricingId"));
                ProductCatalogPricing pricing = new ProductCatalogPricing(db, pricingId);
                context.getRequest().setAttribute("Pricing", (Object)pricing);
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList taxSelect = systemStatus.getLookupList(db, "lookup_product_tax");
            taxSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("TaxSelect", (Object)taxSelect);
            LookupList currencySelect = systemStatus.getLookupList(db, "lookup_currency");
            currencySelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CurrencySelect", (Object)currencySelect);
            LookupList recurringTypeSelect = systemStatus.getLookupList(db, "lookup_recurring_type");
            recurringTypeSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("RecurringTypeSelect", (Object)recurringTypeSelect);
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("productCategory", (Object)parentCategory);
            }
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace();
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("ProductCatalog", catalog);
            return "PricingModifyOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertPricing(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean isValid = false;
        ProductCatalog catalog = null;
        ProductCatalogPricing pricing = (ProductCatalogPricing)((Object)context.getFormBean());
        pricing.setEnteredBy(this.getUserId(context));
        pricing.setModifiedBy(this.getUserId(context));
        boolean recordInserted = false;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            int productId = Integer.parseInt(context.getRequest().getParameter("productId"));
            catalog = new ProductCatalog(db, productId);
            context.getRequest().setAttribute("productCatalog", (Object)catalog);
            pricing.setProductId(productId);
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("productCategory", (Object)parentCategory);
            }
            if (isValid = this.validateObject(context, db, (Object)pricing)) {
                recordInserted = pricing.insert(db);
            }
            if (!recordInserted || !isValid) {
                context.getRequest().setAttribute("Pricing", (Object)pricing);
                String string = this.executeCommandAddPricing(context);
                return string;
            }
            pricing = new ProductCatalogPricing(db, pricing.getId());
            pricing.updatePriceStatus(db, true);
            context.getRequest().setAttribute("Pricing", (Object)pricing);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted && isValid) {
            return this.executeCommandPricingList(context);
        }
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdatePricing(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean isValid = false;
        ProductCatalog catalog = null;
        Object errorMessage = null;
        ProductCatalogPricing updatePricing = null;
        ProductCatalogPricing pricing = (ProductCatalogPricing)((Object)context.getFormBean());
        pricing.setModifiedBy(this.getUserId(context));
        int recordUpdated = 0;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            int productId = Integer.parseInt(context.getRequest().getParameter("productId"));
            catalog = new ProductCatalog(db, productId);
            context.getRequest().setAttribute("productCatalog", (Object)catalog);
            pricing.setProductId(productId);
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("productCategory", (Object)parentCategory);
            }
            if (isValid = this.validateObject(context, db, (Object)pricing)) {
                recordUpdated = pricing.update(db);
            }
            if (recordUpdated == 1 && isValid) {
                updatePricing = new ProductCatalogPricing(db, pricing.getId());
                updatePricing.updatePriceStatus(db, true);
                context.getRequest().setAttribute("Pricing", (Object)updatePricing);
            } else {
                context.getRequest().setAttribute("Pricing", (Object)pricing);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordUpdated == 1 && isValid) {
            return this.executeCommandPricingDetails(context);
        }
        return this.executeCommandModifyPricing(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPricingDetails(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-view")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductCatalog catalog = null;
        ProductCatalogPricing pricing = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            int productId = Integer.parseInt(context.getRequest().getParameter("productId"));
            catalog = new ProductCatalog(db, productId);
            context.getRequest().setAttribute("productCatalog", (Object)catalog);
            int pricingId = Integer.parseInt(context.getRequest().getParameter("pricingId"));
            pricing = new ProductCatalogPricing(db, pricingId);
            context.getRequest().setAttribute("Pricing", (Object)pricing);
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("productCategory", (Object)parentCategory);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "PricingDetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDisablePricing(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductCatalog catalog = null;
        ProductCatalogPricing pricing = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            int productId = Integer.parseInt(context.getRequest().getParameter("productId"));
            catalog = new ProductCatalog(db, productId);
            context.getRequest().setAttribute("productCatalog", (Object)catalog);
            int pricingId = Integer.parseInt(context.getRequest().getParameter("pricingId"));
            pricing = new ProductCatalogPricing(db, pricingId);
            context.getRequest().setAttribute("Pricing", (Object)pricing);
            pricing.updatePriceStatus(db, false);
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("productCategory", (Object)parentCategory);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (context.getRequest().getParameter("return") != null && "details".equals(context.getRequest().getParameter("return"))) {
            return this.executeCommandPricingDetails(context);
        }
        return this.executeCommandPricingList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandEnablePricing(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductCatalog catalog = null;
        ProductCatalogPricing pricing = null;
        boolean status = false;
        try {
            String categoryId;
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            int productId = Integer.parseInt(context.getRequest().getParameter("productId"));
            catalog = new ProductCatalog(db, productId);
            context.getRequest().setAttribute("ProductCatalog", (Object)catalog);
            int pricingId = Integer.parseInt(context.getRequest().getParameter("pricingId"));
            pricing = new ProductCatalogPricing(db, pricingId);
            context.getRequest().setAttribute("Pricing", (Object)pricing);
            status = pricing.updatePriceStatus(db, true);
            if (!status) {
                context.getRequest().setAttribute("actionError", (Object)this.getSystemStatus(context).getLabel("product.priceNotActivated"));
            }
            if ((categoryId = context.getRequest().getParameter("categoryId")) != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("productCategory", (Object)parentCategory);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (context.getRequest().getParameter("return") != null && "details".equals(context.getRequest().getParameter("return"))) {
            return this.executeCommandPricingDetails(context);
        }
        return this.executeCommandPricingList(context);
    }

    private void resetPagedListInfo(ActionContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandEnableProduct(ActionContext context) {
        Connection db = null;
        boolean isValid = false;
        ProductCatalog catalog = null;
        boolean status = false;
        String returnLocation = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId == null || "-1".equals(moduleId)) {
                moduleId = Integer.toString(PermissionCategory.lookupId(db, 330041409));
            }
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            int catalogId = Integer.parseInt(context.getRequest().getParameter("catalogId"));
            catalog = new ProductCatalog(db, catalogId);
            context.getRequest().setAttribute("ProductCatalog", (Object)catalog);
            status = DatabaseUtils.parseBoolean(context.getRequest().getParameter("status").trim());
            catalog.setEnabled(status);
            isValid = this.validateObject(context, db, (Object)catalog);
            if (isValid) {
                catalog.update(db);
            }
            returnLocation = context.getRequest().getParameter("return");
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (returnLocation.equals("list")) {
            return this.executeCommandSearch(context);
        }
        if (returnLocation.equals("details")) {
            return this.executeCommandDetails(context);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewCategories(ActionContext context) {
        Connection db = null;
        ProductCategoryList list = new ProductCategoryList();
        try {
            String ctgId = context.getRequest().getParameter("categoryId");
            if (ctgId == null || "".equals(ctgId)) {
                ctgId = (String)context.getRequest().getAttribute("categoryId");
            }
            String categories = context.getRequest().getParameter("categories");
            db = this.getConnection(context);
            if (categories != null && !"".equals(categories)) {
                list = list.buildListFromIds(db, categories);
            }
            for (ProductCategory ctgry : list) {
                ProductCategoryList fullName = new ProductCategoryList();
                fullName = ProductCategory.buildFullName(db, fullName, ctgry.getId(), true);
                ctgry.setFullPath(fullName);
                ctgry.buildProductList(db);
            }
            context.getRequest().setAttribute("categoryList", (Object)list);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ViewCategoriesOK";
    }
}

