/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.webutils.FileDownload;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.PermissionCategory;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.products.base.ProductCategory;
import org.aspcfs.modules.products.base.ProductCategoryList;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class ProductCategories
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearchForm(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            LookupList typeSelect = new LookupList(db, "lookup_product_category_type");
            typeSelect.addItem(-1, "All Types");
            context.getRequest().setAttribute("TypeSelect", (Object)typeSelect);
            PagedListInfo categoryListInfo = this.getPagedListInfo(context, "SearchProductCategoryListInfo");
            categoryListInfo.setCurrentLetter("");
            categoryListInfo.setCurrentOffset(0);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SearchOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearch(ActionContext context) {
        ProductCategoryList categoryList = new ProductCategoryList();
        PagedListInfo searchListInfo = this.getPagedListInfo(context, "SearchProductCategoryListInfo");
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            searchListInfo.setLink("ProductCategories.do?command=Search&moduleId=" + moduleId);
            categoryList.setPagedListInfo(searchListInfo);
            categoryList.setTypeId(searchListInfo.getFilterKey("listFilter1"));
            searchListInfo.setSearchCriteria(categoryList, context);
            if ("all".equals(searchListInfo.getListView())) {
                categoryList.setEnabled(-1);
            }
            if ("enabled".equals(searchListInfo.getListView())) {
                categoryList.setEnabled(1);
            }
            if ("disabled".equals(searchListInfo.getListView())) {
                categoryList.setEnabled(0);
            }
            categoryList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)categoryList);
            String string = "ListOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-add")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList typeSelect = systemStatus.getLookupList(db, "lookup_product_category_type");
            typeSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CategoryTypeList", (Object)typeSelect);
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory parentCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                ProductCategories.buildHierarchy(db, context);
                context.getRequest().setAttribute("parentCategory", (Object)parentCategory);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSubCategoryList(ActionContext context) {
        ProductCategoryList categoryList = new ProductCategoryList();
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String categoryId = context.getRequest().getParameter("categoryId");
            ProductCategory category = new ProductCategory(db, Integer.parseInt(categoryId));
            context.getRequest().setAttribute("ProductCategory", (Object)category);
            PagedListInfo subCatListInfo = this.getPagedListInfo(context, "SubCategoryListInfo");
            categoryList = new ProductCategoryList();
            categoryList.setParentId(categoryId);
            categoryList.setPagedListInfo(subCatListInfo);
            categoryList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)categoryList);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SubCategoryListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsert(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordInserted = false;
        boolean isValid = false;
        ProductCategory insCategory = null;
        ProductCategory newCategory = (ProductCategory)((Object)context.getFormBean());
        newCategory.setEnteredBy(this.getUserId(context));
        newCategory.setModifiedBy(this.getUserId(context));
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            isValid = this.validateObject(context, db, (Object)newCategory);
            if (isValid) {
                recordInserted = newCategory.insert(db);
            }
            if (recordInserted && isValid) {
                insCategory = new ProductCategory(db, newCategory.getId());
                context.getRequest().setAttribute("ProductCategory", (Object)insCategory);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted && isValid) {
            return "InsertOK";
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            LookupList typeSelect = systemStatus.getLookupList(db, "lookup_product_category_type");
            typeSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CategoryTypeList", (Object)typeSelect);
            String catId = context.getRequest().getParameter("catId");
            ProductCategory category = new ProductCategory(db, Integer.parseInt(catId));
            ProductCategories.buildHierarchy(db, context);
            context.getRequest().setAttribute("productCategory", (Object)category);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ModifyOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean isValid = false;
        int recordInserted = -1;
        ProductCategory insCategory = null;
        ProductCategory newCategory = (ProductCategory)((Object)context.getFormBean());
        newCategory.setModifiedBy(this.getUserId(context));
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            isValid = this.validateObject(context, db, (Object)newCategory);
            if (isValid) {
                recordInserted = newCategory.update(db);
            }
            if (recordInserted > -1 && isValid) {
                insCategory = new ProductCategory(db, newCategory.getId());
                context.getRequest().setAttribute("productCategory", (Object)insCategory);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted > -1 && isValid) {
            return "UpdateOK";
        }
        return this.executeCommandModify(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMove(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductCategory category = null;
        Exception errorMessage = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permissionCategory);
            String categoryId = context.getRequest().getParameter("categoryId");
            category = new ProductCategory(db, Integer.parseInt(categoryId));
            context.getRequest().setAttribute("productCategory", (Object)category);
            ProductCategoryList categoryList = new ProductCategoryList();
            categoryList.setTopOnly(1);
            categoryList.buildList(db);
            categoryList.setLevel(1);
            ProductCategoryList.buildHierarchy(db, categoryList);
            categoryList.buildCompleteHierarchy();
            context.getRequest().setAttribute("categoryHierarchy", (Object)categoryList);
            context.getRequest().setAttribute("action", (Object)"moveCategory");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "MoveOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveMove(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String id = context.getRequest().getParameter("id");
        String categoryId = context.getRequest().getParameter("categoryId");
        try {
            db = this.getConnection(context);
            ProductCategory thisCategory = new ProductCategory(db, Integer.parseInt(id));
            ProductCategory category = thisCategory.getChild(db, Integer.parseInt(categoryId));
            if (category != null) {
                category.updateParent(db, thisCategory.getParentId());
            }
            thisCategory.updateParent(db, Integer.parseInt(categoryId));
            String string = "PopupCloseOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductCategory category = null;
        String moduleId = context.getRequest().getParameter("moduleId");
        String categoryId = context.getRequest().getParameter("categoryId");
        String parentId = context.getRequest().getParameter("parentId");
        HtmlDialog htmlDialog = new HtmlDialog();
        Exception errorMessage = null;
        String returnUrl = context.getRequest().getParameter("return");
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            category = new ProductCategory(db, Integer.parseInt(categoryId));
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            DependencyList dependencies = category.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("productCategory.deleteMsg") + "\n\n" + systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
            htmlDialog.addButton(systemStatus.getLabel("button.deleteAll"), "javascript:window.location.href='ProductCategories.do?command=Delete&action=delete&return=" + returnUrl + "&moduleId=" + (moduleId != null ? moduleId : "") + "&categoryId=" + (parentId != null ? parentId : "") + "&catId=" + category.getId() + "'");
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
            return "ConfirmDeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        boolean recordDeleted = false;
        ProductCategory thisCategory = null;
        Connection db = null;
        String returnUrl = context.getRequest().getParameter("return");
        String moduleId = context.getRequest().getParameter("moduleId");
        String parentId = context.getRequest().getParameter("parentId");
        returnUrl = returnUrl + "&moduleId=" + moduleId + "&categoryId=" + (parentId != null ? parentId : "");
        try {
            db = this.getConnection(context);
            String categoryId = context.getRequest().getParameter("catId");
            thisCategory = new ProductCategory(db, Integer.parseInt(categoryId));
            if (context.getRequest().getParameter("action") != null) {
                if (context.getRequest().getParameter("action").equals("delete")) {
                    recordDeleted = thisCategory.delete(db, this.getPath(context, "products"));
                } else if (context.getRequest().getParameter("action").equals("disable")) {
                    // empty if block
                }
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordDeleted) {
                context.getRequest().setAttribute("refreshUrl", (Object)returnUrl);
                return "DeleteOK";
            }
            this.processErrors(context, thisCategory.getErrors());
            return "SystemError";
        }
        context.getRequest().setAttribute("actionError", (Object)this.getSystemStatus(context).getLabel("object.validation.actionError.categoryDeletion"));
        context.getRequest().setAttribute("refreshUrl", (Object)returnUrl);
        return "DeleteError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-view")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductCategory newCategory = null;
        Exception errorMessage = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            int categoryId = Integer.parseInt(context.getRequest().getParameter("categoryId"));
            newCategory = new ProductCategory(db, categoryId);
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace();
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("ProductCategory", newCategory);
            return "DetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandImageList(ActionContext context) {
        Connection db = null;
        ProductCategory category = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String categoryId = context.getRequest().getParameter("categoryId");
            category = new ProductCategory(db, Integer.parseInt(categoryId));
            context.getRequest().setAttribute("ProductCategory", (Object)category);
            FileItem thumbnail = null;
            FileItem smallImage = null;
            FileItem largeImage = null;
            if (category.getThumbnailImageId() != -1) {
                thumbnail = new FileItem(db, category.getThumbnailImageId());
            }
            if (category.getSmallImageId() != -1) {
                smallImage = new FileItem(db, category.getSmallImageId());
            }
            if (category.getLargeImageId() != -1) {
                largeImage = new FileItem(db, category.getLargeImageId());
            }
            context.getRequest().setAttribute("ThumbnailImage", (Object)thumbnail);
            context.getRequest().setAttribute("SmallImage", (Object)smallImage);
            context.getRequest().setAttribute("LargeImage", (Object)largeImage);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ImageListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownloadFile(ActionContext context) {
        Exception errorMessage;
        block17: {
            errorMessage = null;
            String itemId = context.getRequest().getParameter("fid");
            String categoryId = context.getRequest().getParameter("categoryId");
            FileItem thisItem = null;
            Connection db = null;
            try {
                db = this.getConnection(context);
                ProductCategory category = new ProductCategory(db, Integer.parseInt(categoryId));
                thisItem = new FileItem(db, Integer.parseInt(itemId), Integer.parseInt(categoryId), 200403195);
            }
            catch (Exception e) {
                errorMessage = e;
            }
            finally {
                this.freeConnection(context, db);
            }
            try {
                FileItem itemToDownload = thisItem;
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "products") + ProductCategories.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    fileDownload.sendFile(context);
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block17;
                }
                db = null;
                System.err.println("ProductCategories-> Trying to send a file that does not exist");
                context.getRequest().setAttribute("actionError", (Object)"The requested download no longer exists on the system");
                String string = this.executeCommandImageList(context);
                return string;
            }
            catch (SocketException se) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println(se.toString());
                }
            }
            catch (Exception e) {
                errorMessage = e;
                System.out.println(e.toString());
            }
            finally {
                if (db != null) {
                    this.freeConnection(context, db);
                }
            }
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRemoveFile(ActionContext context) {
        Connection db = null;
        try {
            String itemId = context.getRequest().getParameter("fid");
            String categoryId = context.getRequest().getParameter("categoryId");
            db = this.getConnection(context);
            ProductCategory category = new ProductCategory(db, Integer.parseInt(categoryId));
            String imageType = context.getRequest().getParameter("imageType");
            category.removeFileItem(db, Integer.parseInt(itemId), imageType, this.getPath(context, "products"));
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return this.executeCommandImageList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUploadFile(ActionContext context) {
        Connection db = null;
        boolean isValid = false;
        Object errorMessage = null;
        boolean recordInserted = false;
        try {
            String filePath = this.getPath(context, "products");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String categoryId = context.getRequest().getParameter("categoryId");
            String subject = "Attachment";
            ProductCategory category = new ProductCategory(db, Integer.parseInt(categoryId));
            context.getRequest().setAttribute("ProductCategory", (Object)category);
            if (parts.get("id" + categoryId) instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("id" + categoryId);
                FileItem thisItem = new FileItem();
                thisItem.setLinkModuleId(200403195);
                thisItem.setLinkItemId(category.getId());
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                thisItem.setFolderId(-1);
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setVersion(1.0);
                thisItem.setSize(newFileInfo.getSize());
                isValid = this.validateObject(context, db, thisItem);
                if (isValid) {
                    recordInserted = thisItem.insert(db);
                }
                if (recordInserted && isValid) {
                    String imageType = (String)parts.get("imageType");
                    if ("thumbnail".equals(imageType)) {
                        category.setThumbnailImageId(thisItem.getId());
                    } else if ("small".equals(imageType)) {
                        category.setSmallImageId(thisItem.getId());
                    } else if ("large".equals(imageType)) {
                        category.setLargeImageId(thisItem.getId());
                    }
                    isValid = this.validateObject(context, db, (Object)category);
                    if (isValid) {
                        category.update(db);
                    }
                }
            } else {
                recordInserted = false;
                HashMap<String, String> errors = new HashMap<String, String>();
                SystemStatus systemStatus = this.getSystemStatus(context);
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                this.processErrors(context, errors);
            }
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandImageList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMappingList(ActionContext context) {
        Connection db = null;
        ProductCategory category = null;
        Exception errorMessage = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            int categoryId = Integer.parseInt(context.getRequest().getParameter("categoryId"));
            category = new ProductCategory(db, categoryId);
            ProductCategoryList mappings = new ProductCategoryList();
            mappings.setMasterCategoryId(category.getId());
            mappings.buildList(db);
            context.getRequest().setAttribute("MappingList", (Object)mappings);
            LookupList typeSelect = new LookupList(db, "lookup_product_category_type");
            context.getRequest().setAttribute("CategoryTypeList", (Object)typeSelect);
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace();
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("ProductCategory", category);
            return "MappingListOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddMapping(ActionContext context) {
        Connection db = null;
        ProductCategory category = null;
        Exception errorMessage = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            int categoryId = Integer.parseInt(context.getRequest().getParameter("categoryId"));
            category = new ProductCategory(db, categoryId);
            context.getRequest().setAttribute("ProductCategory", (Object)category);
            ProductCategoryList mappings = new ProductCategoryList();
            mappings.setMasterCategoryId(category.getId());
            mappings.setExcludeMappedCategories(true);
            mappings.buildList(db);
            context.getRequest().setAttribute("MappingList", (Object)mappings);
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace();
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "AddMappingOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRemoveMapping(ActionContext context) {
        Connection db = null;
        ProductCategory category1 = null;
        Exception errorMessage = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            int cat1 = Integer.parseInt(context.getRequest().getParameter("categoryId"));
            category1 = new ProductCategory(db, cat1);
            context.getRequest().setAttribute("ProductCategory", (Object)category1);
            int cat2 = Integer.parseInt(context.getRequest().getParameter("cat2"));
            category1.removeCategoryMapping(db, cat2);
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace();
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return this.executeCommandMappingList(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertMapping(ActionContext context) {
        Connection db = null;
        ProductCategory category = null;
        Exception errorMessage = null;
        try {
            db = this.getConnection(context);
            int categoryId = Integer.parseInt(context.getRequest().getParameter("categoryId"));
            category = new ProductCategory(db, categoryId);
            String mapcategory = context.getRequest().getParameter("mapcategory");
            if (mapcategory != null) {
                category.addCategory(db, Integer.parseInt(mapcategory));
            }
            context.getRequest().setAttribute("ProductCategory", (Object)category);
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace();
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return this.executeCommandMappingList(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    private void resetPagedListInfo(ActionContext context) {
    }

    public static final void buildHierarchy(Connection db, ActionContext context) throws SQLException {
        String categoryId = context.getRequest().getParameter("categoryId");
        if (categoryId != null && !"-1".equals(categoryId) && !"0".equals(categoryId)) {
            LinkedHashMap categoryLevels = new LinkedHashMap();
            ProductCategory.buildHierarchy(db, categoryLevels, Integer.parseInt(categoryId));
            context.getRequest().setAttribute("categoryLevels", categoryLevels);
        }
    }
}

