/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.PermissionCategory;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.products.base.ProductCatalogList;
import org.aspcfs.modules.products.base.ProductCategory;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class ProductCategoryProducts
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        Connection db = null;
        ProductCategory category = null;
        ProductCatalogList catalogList = null;
        PagedListInfo catalogListInfo = this.getPagedListInfo(context, "ProductCatalogListInfo");
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String categoryId = context.getRequest().getParameter("categoryId");
            category = new ProductCategory(db, Integer.parseInt(categoryId));
            context.getRequest().setAttribute("ProductCategory", (Object)category);
            catalogListInfo.setLink("ProductCategoryProducts.do?command=List&moduleId=" + moduleId + "&categoryId=" + categoryId);
            catalogList = new ProductCatalogList();
            catalogList.setPagedListInfo(catalogListInfo);
            catalogList.setCategoryId(categoryId);
            catalogList.buildList(db);
            context.getRequest().setAttribute("ProductList", (Object)catalogList);
            ProductCatalogList completeList = new ProductCatalogList();
            completeList.setCategoryId(categoryId);
            completeList.buildList(db);
            context.getRequest().setAttribute("CompleteList", (Object)completeList);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        Connection db = null;
        ProductCategory category = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String categoryId = context.getRequest().getParameter("categoryId");
            category = new ProductCategory(db, Integer.parseInt(categoryId));
            context.getRequest().setAttribute("ProductCategory", (Object)category);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandOptionSource(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String option = context.getRequest().getParameter("choice");
            if (option != null) {
                if ("old".equals(option.trim())) {
                    String categoryId = context.getRequest().getParameter("categoryId");
                    HashMap<Integer, String> selectedElements = new HashMap<Integer, String>();
                    if (categoryId != null) {
                        ProductCatalogList productList = new ProductCatalogList();
                        productList.setCategoryId(categoryId);
                        productList.buildList(db);
                        for (ProductCatalog thisCatalog : productList) {
                            selectedElements.put(new Integer(thisCatalog.getId()), "");
                        }
                        context.getSession().setAttribute("selectedElements", selectedElements);
                    }
                    String string = this.executeCommandProductList(context);
                    return string;
                }
                String string = this.executeCommandAddProduct(context);
                return string;
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandProductList(ActionContext context) {
        Connection db = null;
        PagedListInfo catalogListInfo = this.getPagedListInfo(context, "ProductCatalogListInfo");
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String categoryId = context.getRequest().getParameter("categoryId");
            ProductCategory category = new ProductCategory(db, Integer.parseInt(categoryId));
            context.getRequest().setAttribute("ProductCategory", (Object)category);
            HashMap selectedList = new HashMap();
            HashMap finalElementList = (HashMap)context.getSession().getAttribute("finalElements");
            if (context.getRequest().getParameter("previousSelection") != null) {
                StringTokenizer st = new StringTokenizer(context.getRequest().getParameter("previousSelection"), "|");
                while (st.hasMoreTokens()) {
                    selectedList.put(new Integer(st.nextToken()), "");
                }
            } else {
                selectedList = (HashMap)context.getSession().getAttribute("selectedElements");
            }
            int rowCount = 1;
            while (context.getRequest().getParameter("hiddenelementid" + rowCount) != null) {
                int elementId = 0;
                elementId = Integer.parseInt(context.getRequest().getParameter("hiddenelementid" + rowCount));
                if (context.getRequest().getParameter("checkelement" + rowCount) != null) {
                    if (selectedList.get(new Integer(elementId)) == null) {
                        selectedList.put(new Integer(elementId), "");
                    }
                } else {
                    selectedList.remove(new Integer(elementId));
                }
                ++rowCount;
            }
            if (context.getRequest().getParameter("finalsubmit") != null && context.getRequest().getParameter("finalsubmit").equalsIgnoreCase("true")) {
                finalElementList = (HashMap)selectedList.clone();
                System.out.println("finalElements : " + finalElementList);
                context.getSession().setAttribute("finalElements", (Object)finalElementList);
                String elementId = this.executeCommandAddCategoryMappings(context);
                return elementId;
            }
            ProductCatalogList catalogList = new ProductCatalogList();
            catalogListInfo.setLink("ProductCategoryProducts.do?command=ProductList&moduleId=" + moduleId + "&categoryId=" + categoryId);
            catalogList.setPagedListInfo(catalogListInfo);
            catalogList.buildList(db);
            context.getRequest().setAttribute("ProductList", (Object)catalogList);
            context.getSession().setAttribute("selectedElements", (Object)selectedList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ProductListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddProduct(ActionContext context) {
        Connection db = null;
        ProductCategory category = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String categoryId = context.getRequest().getParameter("categoryId");
            category = new ProductCategory(db, Integer.parseInt(categoryId));
            context.getRequest().setAttribute("ProductCategory", (Object)category);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList typeSelect = systemStatus.getLookupList(db, "lookup_product_type");
            typeSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogTypeList", (Object)typeSelect);
            LookupList formatSelect = systemStatus.getLookupList(db, "lookup_product_format");
            formatSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogFormatList", (Object)formatSelect);
            LookupList shippingSelect = systemStatus.getLookupList(db, "lookup_product_shipping");
            shippingSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogShippingList", (Object)shippingSelect);
            LookupList shipTimeSelect = systemStatus.getLookupList(db, "lookup_product_ship_time");
            shipTimeSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogShipTimeList", (Object)shipTimeSelect);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddProductOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddCategoryMappings(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String categoryId = context.getRequest().getParameter("categoryId");
            ProductCategory category = new ProductCategory(db, Integer.parseInt(categoryId));
            context.getRequest().setAttribute("ProductCategory", (Object)category);
            ProductCatalogList oldList = new ProductCatalogList();
            oldList.setCategoryId(categoryId);
            oldList.buildList(db);
            ProductCatalogList newList = new ProductCatalogList();
            String finalElements = context.getRequest().getParameter("finalElements");
            if (finalElements != null) {
                StringTokenizer st = new StringTokenizer(finalElements, ",");
                while (st.hasMoreTokens()) {
                    String id = String.valueOf(st.nextToken());
                    newList.add(new ProductCatalog(db, Integer.parseInt(id)));
                }
            }
            newList.addCategoryMapping(db, oldList, category.getId());
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsert(ActionContext context) {
        Connection db = null;
        boolean recordInserted = false;
        boolean isValid = false;
        ProductCategory category = null;
        ProductCatalog insCatalog = null;
        ProductCatalog newCatalog = (ProductCatalog)((Object)context.getFormBean());
        newCatalog.setEnteredBy(this.getUserId(context));
        newCatalog.setModifiedBy(this.getUserId(context));
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            int categoryId = Integer.parseInt(context.getRequest().getParameter("categoryId"));
            category = new ProductCategory(db, categoryId);
            context.getRequest().setAttribute("ProductCategory", (Object)category);
            isValid = this.validateObject(context, db, (Object)newCatalog);
            if (isValid) {
                recordInserted = newCatalog.insert(db);
            }
            if (recordInserted && isValid) {
                insCatalog = new ProductCatalog(db, newCatalog.getId());
                category.addCatalog(db, insCatalog.getId());
                context.getRequest().setAttribute("ProductCatalog", (Object)insCatalog);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted && isValid) {
            return "InsertOK";
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        Connection db = null;
        ProductCategory category = null;
        ProductCatalog catalog = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String categoryId = context.getRequest().getParameter("categoryId");
            category = new ProductCategory(db, Integer.parseInt(categoryId));
            context.getRequest().setAttribute("ProductCategory", (Object)category);
            String catalogId = context.getRequest().getParameter("catalogId");
            catalog = new ProductCatalog(db, Integer.parseInt(catalogId));
            context.getRequest().setAttribute("ProductCatalog", (Object)catalog);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        Connection db = null;
        ProductCatalog catalog = null;
        ProductCategory category = null;
        Exception errorMessage = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            int categoryId = Integer.parseInt(context.getRequest().getParameter("categoryId"));
            category = new ProductCategory(db, categoryId);
            context.getRequest().setAttribute("ProductCategory", (Object)category);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList typeSelect = systemStatus.getLookupList(db, "lookup_product_type");
            typeSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogTypeList", (Object)typeSelect);
            LookupList formatSelect = systemStatus.getLookupList(db, "lookup_product_format");
            formatSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogFormatList", (Object)formatSelect);
            LookupList shippingSelect = systemStatus.getLookupList(db, "lookup_product_shipping");
            shippingSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogShippingList", (Object)shippingSelect);
            LookupList shipTimeSelect = systemStatus.getLookupList(db, "lookup_product_ship_time");
            shipTimeSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CatalogShipTimeList", (Object)shipTimeSelect);
            int catalogId = Integer.parseInt(context.getRequest().getParameter("catalogId"));
            catalog = new ProductCatalog(db, catalogId);
            context.getRequest().setAttribute("ProductCatalog", (Object)catalog);
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace();
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "ModifyOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        Connection db = null;
        int recordUpdated = -1;
        boolean isValid = false;
        ProductCatalog updatedCatalog = null;
        ProductCatalog catalog = (ProductCatalog)((Object)context.getFormBean());
        catalog.setModifiedBy(this.getUserId(context));
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String categoryId = context.getRequest().getParameter("categoryId");
            ProductCategory category = new ProductCategory(db, Integer.parseInt(categoryId));
            context.getRequest().setAttribute("ProductCategory", (Object)category);
            isValid = this.validateObject(context, db, (Object)catalog);
            if (isValid) {
                recordUpdated = catalog.update(db);
            }
            if (recordUpdated > 0 && isValid) {
                updatedCatalog = new ProductCatalog(db, catalog.getId());
                context.getRequest().setAttribute("ProductCatalog", (Object)updatedCatalog);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordUpdated > 0 && isValid) {
            return this.executeCommandDetails(context);
        }
        return this.executeCommandModify(context);
    }
}

