/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.PermissionCategory;
import org.aspcfs.modules.products.base.ProductOption;
import org.aspcfs.modules.products.base.ProductOptionConfigurator;
import org.aspcfs.modules.products.base.ProductOptionConfiguratorList;
import org.aspcfs.modules.products.base.ProductOptionList;
import org.aspcfs.modules.products.configurator.OptionConfigurator;
import org.aspcfs.modules.products.configurator.OptionProperty;
import org.aspcfs.modules.products.configurator.OptionPropertyList;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public final class ProductOptions
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearchForm(ActionContext context) {
        Connection db = null;
        ProductOptionConfiguratorList configList = new ProductOptionConfiguratorList();
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            configList.buildList(db);
            HtmlSelect configSelect = configList.getHtmlSelect();
            configSelect.addItem(-1, "All Types", 0);
            context.getRequest().setAttribute("ConfigSelect", (Object)configSelect);
            PagedListInfo optionListInfo = this.getPagedListInfo(context, "SearchProductOptionListInfo");
            optionListInfo.setCurrentLetter("");
            optionListInfo.setCurrentOffset(0);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SearchOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearch(ActionContext context) {
        Connection db = null;
        ProductOptionList optionList = new ProductOptionList();
        PagedListInfo searchListInfo = this.getPagedListInfo(context, "SearchProductOptionListInfo");
        this.resetPagedListInfo(context);
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            searchListInfo.setLink("ProductOptions.do?command=Search&moduleId=" + moduleId);
            optionList.setPagedListInfo(searchListInfo);
            optionList.setConfiguratorId(searchListInfo.getFilterKey("listFilter1"));
            searchListInfo.setSearchCriteria(optionList, context);
            if ("all".equals(searchListInfo.getListView())) {
                optionList.setEnabled(-1);
            }
            if ("enabled".equals(searchListInfo.getListView())) {
                optionList.setEnabled(1);
            }
            if ("disabled".equals(searchListInfo.getListView())) {
                optionList.setEnabled(0);
            }
            optionList.buildList(db);
            context.getRequest().setAttribute("OptionList", (Object)optionList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        Connection db = null;
        ProductOptionConfiguratorList configList = new ProductOptionConfiguratorList();
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            configList.buildList(db);
            context.getRequest().setAttribute("ConfiguratorList", (Object)configList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return ProductOptions.getReturn(context, "Add");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsert(ActionContext context) {
        Connection db = null;
        boolean recordInserted = false;
        ProductOption insOption = null;
        ProductOption newOption = (ProductOption)((Object)context.getFormBean());
        try {
            String popup;
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            recordInserted = newOption.insert(db);
            if (!recordInserted) {
                this.processErrors(context, newOption.getErrors());
                String string = this.executeCommandAdd(context);
                return string;
            }
            insOption = new ProductOption(db, newOption.getId());
            context.getRequest().setAttribute("ProductOption", (Object)insOption);
            if (context.getRequest().getParameter("popup") != null && "true".equals(popup = context.getRequest().getParameter("popup"))) {
                String catalogId = context.getRequest().getParameter("catalogId");
                String url = context.getRequest().getParameter("action");
                String params = "&moduleId=" + moduleId + "&catalogId=" + catalogId;
                url = url + params;
                context.getRequest().setAttribute("refreshUrl", (Object)url);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return ProductOptions.getReturn(context, "Insert");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmEnable(ActionContext context) {
        Connection db = null;
        String returnUrl = context.getRequest().getParameter("return");
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String optionId = context.getRequest().getParameter("optionId");
            ProductOption option = new ProductOption(db, Integer.parseInt(optionId));
            OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, option.getConfiguratorId());
            HtmlDialog htmlDialog = new HtmlDialog();
            htmlDialog.setTitle("Centric CRM: Product Catalog Editor");
            if (configurator.enableOption(db, option.getId())) {
                htmlDialog.addMessage("The option can be successfully enabled...<br><br>");
                htmlDialog.addButton("Enable", "javascript:window.location.href='ProductOptions.do?command=Enable&optionId=" + optionId + "&return=" + returnUrl + "';");
                htmlDialog.addButton("Cancel", "javascript:parent.window.close()");
                context.getRequest().setAttribute("refreshUrl", (Object)returnUrl);
            } else {
                HashMap errors = configurator.getErrors();
                htmlDialog.addMessage("The option could not be enabled because of the following errors:<br><br>");
                for (String error : errors.values()) {
                    htmlDialog.addMessage(error);
                }
                htmlDialog.addButton("Cancel", "javascript:parent.window.close()");
            }
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ConfirmEnableOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandEnable(ActionContext context) {
        Connection db = null;
        String returnUrl = context.getRequest().getParameter("return");
        String moduleId = context.getRequest().getParameter("moduleId");
        returnUrl = returnUrl + "&moduleId=" + moduleId;
        try {
            db = this.getConnection(context);
            String optionId = context.getRequest().getParameter("optionId");
            ProductOption option = new ProductOption(db, Integer.parseInt(optionId));
            option.setEnabled(true);
            option.update(db);
            context.getRequest().setAttribute("refreshUrl", (Object)returnUrl);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return "EnableOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String optionId = context.getRequest().getParameter("optionId");
            ProductOption option = new ProductOption(db, Integer.parseInt(optionId));
            context.getRequest().setAttribute("ProductOption", (Object)option);
            OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, option.getConfiguratorId());
            configurator.queryProperties(db, Integer.parseInt(optionId), false);
            OptionPropertyList propertyList = null;
            propertyList = context.getRequest().getAttribute("PropertyList") != null ? (OptionPropertyList)context.getRequest().getAttribute("PropertyList") : configurator.getPropertyList();
            for (OptionProperty thisProperty : propertyList) {
                thisProperty.prepareContext(db, context.getRequest());
            }
            context.getRequest().setAttribute("PropertyList", (Object)propertyList);
            String name = configurator.getName();
            context.getRequest().setAttribute("configName", (Object)name);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ModifyOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandLoadConfigurator(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String configId = context.getRequest().getParameter("configId");
            context.getRequest().setAttribute("configId", (Object)configId);
            OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, Integer.parseInt(configId));
            OptionPropertyList propertyList = null;
            propertyList = context.getRequest().getAttribute("PropertyList") != null ? (OptionPropertyList)context.getRequest().getAttribute("PropertyList") : configurator.getPropertyList();
            for (OptionProperty thisProperty : propertyList) {
                thisProperty.prepareContext(db, context.getRequest());
            }
            context.getRequest().setAttribute("PropertyList", (Object)propertyList);
            String name = configurator.getName();
            context.getRequest().setAttribute("configName", (Object)name);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return ProductOptions.getReturn(context, "LoadConfigurator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertOption(ActionContext context) {
        Connection db = null;
        ProductOption option = (ProductOption)((Object)context.getFormBean());
        SystemStatus systemStatus = this.getSystemStatus(context);
        boolean isValid = false;
        try {
            String popup;
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String configId = context.getRequest().getParameter("configId");
            option.setConfiguratorId(configId);
            context.getRequest().setAttribute("ProductOption", (Object)option);
            OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, Integer.parseInt(configId));
            configurator.setProperties(context.getRequest());
            if (!configurator.getPropertyList().isValid(systemStatus)) {
                context.getRequest().setAttribute("PropertyList", (Object)configurator.getPropertyList());
                String string = this.executeCommandLoadConfigurator(context);
                return string;
            }
            isValid = this.validateObject(context, db, (Object)option);
            boolean bl = isValid = this.validateObject(context, db, configurator) && isValid;
            if (!isValid) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("ProductOptions-> Unable to save properties");
                }
                context.getRequest().setAttribute("PropertyList", (Object)configurator.getPropertyList());
                String string = this.executeCommandLoadConfigurator(context);
                return string;
            }
            configurator.saveProperties(db, option);
            String html = configurator.getHtml();
            context.getRequest().setAttribute("HtmlString", (Object)html);
            if (context.getRequest().getParameter("popup") != null && "true".equals(popup = context.getRequest().getParameter("popup"))) {
                String catalogId = context.getRequest().getParameter("catalogId");
                String url = context.getRequest().getParameter("action");
                String params = "&moduleId=" + moduleId + "&catalogId=" + catalogId;
                url = url + params;
                context.getRequest().setAttribute("refreshUrl", (Object)url);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return ProductOptions.getReturn(context, "InsertOption");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        Connection db = null;
        ProductOption option = (ProductOption)((Object)context.getFormBean());
        SystemStatus systemStatus = this.getSystemStatus(context);
        boolean isValid = false;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String configId = context.getRequest().getParameter("configId");
            context.getRequest().setAttribute("configId", (Object)configId);
            option.setConfiguratorId(configId);
            context.getRequest().setAttribute("ProductOption", (Object)option);
            OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, Integer.parseInt(configId));
            configurator.setProperties(context.getRequest());
            if (!configurator.getPropertyList().isValid(systemStatus)) {
                context.getRequest().setAttribute("PropertyList", (Object)configurator.getPropertyList());
                String string = this.executeCommandModify(context);
                return string;
            }
            isValid = this.validateObject(context, db, (Object)option);
            boolean bl = isValid = this.validateObject(context, db, configurator) && isValid;
            if (!isValid) {
                context.getRequest().setAttribute("PropertyList", (Object)configurator.getPropertyList());
                String string = this.executeCommandModify(context);
                return string;
            }
            configurator.updateProperties(db, option);
            String html = configurator.getHtml();
            context.getRequest().setAttribute("HtmlString", (Object)html);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandDetails(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            String optionId = context.getRequest().getParameter("optionId");
            ProductOption option = new ProductOption(db, Integer.parseInt(optionId));
            context.getRequest().setAttribute("ProductOption", (Object)option);
            OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, option.getConfiguratorId());
            configurator.queryProperties(db, Integer.parseInt(optionId), true);
            String html = configurator.getHtml();
            context.getRequest().setAttribute("HtmlString", (Object)html);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DetailsOK";
    }

    private void resetPagedListInfo(ActionContext context) {
    }
}

