/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.PermissionCategory;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.products.actions.ProductCategories;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.products.base.ProductCatalogList;
import org.aspcfs.modules.products.base.ProductCategory;
import org.aspcfs.modules.products.base.ProductCategoryList;
import org.aspcfs.modules.products.base.ProductOption;
import org.aspcfs.modules.products.base.ProductOptionConfigurator;
import org.aspcfs.modules.products.configurator.OptionConfigurator;
import org.aspcfs.modules.products.utils.ProductCategoryCounter;
import org.aspcfs.modules.quotes.base.Quote;
import org.aspcfs.modules.quotes.base.QuoteProduct;
import org.aspcfs.modules.quotes.base.QuoteProductList;
import org.aspcfs.modules.quotes.base.QuoteProductOption;
import org.aspcfs.modules.quotes.base.QuoteProductOptionList;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.PagedListInfo;

public final class ProductsCatalog
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return this.executeCommandCategories(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCategoryList(ActionContext context) {
        ProductCategoryList categoryList = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId != null && !"".equals(moduleId)) {
                PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
                context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            }
            String displayFieldId = context.getRequest().getParameter("displayFieldId");
            String hiddenFieldId = context.getRequest().getParameter("hiddenFieldId");
            categoryList = new ProductCategoryList();
            categoryList.setTypeName("Publication");
            categoryList.setEnabled(1);
            categoryList.buildList(db);
            context.getRequest().setAttribute("categoryList", (Object)categoryList);
            context.getRequest().setAttribute("displayFieldId", (Object)displayFieldId);
            context.getRequest().setAttribute("hiddenFieldId", (Object)hiddenFieldId);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "CategoryListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandProductList(ActionContext context) {
        int categoryId = Integer.parseInt(context.getRequest().getParameter("id"));
        String displayFieldId = context.getRequest().getParameter("displayFieldId");
        String hiddenFieldId = context.getRequest().getParameter("hiddenFieldId");
        ProductCategoryList trails = new ProductCategoryList();
        ProductCategory category = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            if (moduleId != null && !"".equals(moduleId)) {
                PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
                context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            }
            category = new ProductCategory();
            category.setBuildChildList(true);
            category.setBuildProductList(true);
            category.setBuildActiveProducts(1);
            category.queryRecord(db, categoryId);
            int parentId = category.getParentId();
            while (parentId != -1) {
                ProductCategory parent = new ProductCategory(db, parentId);
                trails.add(0, parent);
                parentId = parent.getParentId();
            }
            context.getRequest().setAttribute("category", (Object)category);
            context.getRequest().setAttribute("trails", (Object)trails);
            context.getRequest().setAttribute("displayFieldId", (Object)displayFieldId);
            context.getRequest().setAttribute("hiddenFieldId", (Object)hiddenFieldId);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ProductListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCategories(ActionContext context) {
        Quote quote = null;
        ProductCategory thisCategory = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            ProductCategoryList categoryList = new ProductCategoryList();
            ProductCatalogList productList = new ProductCatalogList();
            String quoteId = context.getRequest().getParameter("quoteId");
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                categoryList.setParentId(Integer.parseInt(categoryId));
                productList.setCategoryId(Integer.parseInt(categoryId));
                thisCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                context.getRequest().setAttribute("parentCategory", (Object)thisCategory);
                ProductCategories.buildHierarchy(db, context);
            } else {
                categoryList.setTopOnly(1);
                productList.setHasCategories(0);
            }
            categoryList.buildList(db);
            if (categoryList.size() > 0) {
                categoryList.removeNonProductCategories(ProductCategoryCounter.getProductCategoryCounter(db));
            }
            productList.setActive(1);
            productList.setBuildResources(false);
            productList.setBuildActivePrice(true);
            productList.setBuildActiveProductsOnly(1);
            productList.buildList(db);
            context.getRequest().setAttribute("categoryList", (Object)categoryList);
            context.getRequest().setAttribute("productList", (Object)productList);
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, Integer.parseInt(quoteId));
            context.getRequest().setAttribute("quote", (Object)quote);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "CategoriesOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddProducts(ActionContext context) {
        Quote quote = null;
        QuoteProductList quoteProductList = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            String quoteId = context.getRequest().getParameter("quoteId");
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, Integer.parseInt(quoteId));
            quote.retrieveTicket(db);
            context.getRequest().setAttribute("quote", (Object)quote);
            quoteProductList = new QuoteProductList();
            quoteProductList.populate(db, context, this.getUser(context, this.getUserId(context)));
            context.getRequest().setAttribute("quoteProductList", (Object)quoteProductList);
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                ProductCategory thisCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                context.getRequest().setAttribute("parentCategory", (Object)thisCategory);
                ProductCategories.buildHierarchy(db, context);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddProductsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddOptions(ActionContext context) {
        String categoryIdString = context.getRequest().getParameter("categoryId");
        Quote previousQuote = null;
        boolean isValid = false;
        QuoteProduct quoteProduct = null;
        QuoteProductOption quoteProductOption = null;
        ProductCategory category = null;
        Connection db = null;
        try {
            String productIdString;
            db = this.getConnection(context);
            String quoteId = context.getRequest().getParameter("quoteId");
            previousQuote = new Quote(db, Integer.parseInt(quoteId));
            previousQuote.setBuildProducts(true);
            previousQuote.queryRecord(db, Integer.parseInt(quoteId));
            previousQuote.retrieveTicket(db);
            int i = 1;
            while ((productIdString = context.getRequest().getParameter("product_" + i)) != null && !"".equals(productIdString)) {
                String quantityString = context.getRequest().getParameter("qty_" + i);
                String priceString = context.getRequest().getParameter("price_" + i);
                String commentString = context.getRequest().getParameter("comment_" + i);
                if (quantityString != null && !"".equals(quantityString)) {
                    ProductCatalog product = new ProductCatalog(db, Integer.parseInt(productIdString));
                    product.buildActivePrice(db);
                    quoteProduct = new QuoteProduct();
                    quoteProduct.setProductCatalog(product);
                    quoteProduct.setProductId(product.getId());
                    quoteProduct.setComment(commentString);
                    quoteProduct.setQuantity(quantityString);
                    quoteProduct.setQuoteId(previousQuote.getId());
                    quoteProduct.buildPricing(db);
                    if (!"".equals(priceString)) {
                        quoteProduct.setPriceAmount(Double.parseDouble(priceString));
                    }
                    if (isValid = this.validateObject(context, db, (Object)quoteProduct)) {
                        String optionIdString;
                        QuoteProductOptionList optionList = new QuoteProductOptionList();
                        int j = 1;
                        while ((optionIdString = context.getRequest().getParameter("option_" + productIdString + "_" + j)) != null && !"".equals(optionIdString)) {
                            ProductOption option = new ProductOption(db, Integer.parseInt(optionIdString.trim()));
                            quoteProductOption = new QuoteProductOption();
                            OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, option.getConfiguratorId());
                            configurator.queryProperties(db, option.getId(), false);
                            if (configurator.validateUserInput(context.getRequest())) {
                                double priceAdjust = configurator.computePriceAdjust(context.getRequest());
                                quoteProductOption.setProductOptionId(option.getProductOptionId(db, product.getId()));
                                quoteProductOption.setQuantity(1);
                                quoteProductOption.setPriceAmount(priceAdjust);
                                quoteProductOption.setTotalPrice(priceAdjust);
                                isValid = this.validateObject(context, db, (Object)quoteProductOption);
                                if (!isValid) break;
                                quoteProductOption.setOptionId(option.getId());
                                quoteProductOption.setConfiguratorId(option.getConfiguratorId());
                                optionList.add(quoteProductOption);
                            } else if (configurator.hasUserInput(context.getRequest())) {
                                SystemStatus systemStatus = this.getSystemStatus(context);
                                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("quoteProduct.option.validation.actionError"));
                                String string = this.executeCommandAddProducts(context);
                                return string;
                            }
                            ++j;
                        }
                        quoteProduct.insert(db, optionList, context.getRequest());
                    }
                }
                ++i;
            }
            Quote quote = new Quote(db, Integer.parseInt(quoteId));
            quote.setBuildProducts(true);
            quote.queryRecord(db, Integer.parseInt(quoteId));
            quote.retrieveTicket(db);
            this.processUpdateHook(context, (Object)previousQuote, (Object)quote);
            context.getRequest().setAttribute("quote", (Object)quote);
            if (categoryIdString != null && !"".equals(categoryIdString) && !"-1".equals(categoryIdString)) {
                category = new ProductCategory(db, Integer.parseInt(categoryIdString));
                context.getRequest().setAttribute("category", (Object)category);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (isValid) {
            return "AddOptionsOK";
        }
        return this.executeCommandCategories(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandListAllProducts(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-view")) {
            return "PermissionError";
        }
        String moduleId = context.getRequest().getParameter("moduleId");
        ProductCatalogList productList = null;
        PagedListInfo productCatalogListInfo = this.getPagedListInfo(context, "productCatalogListInfo");
        productCatalogListInfo.setLink("ProductsCatalog.do?command=ListAllProducts&moduleId=" + moduleId);
        Connection db = null;
        try {
            db = this.getConnection(context);
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            productList = new ProductCatalogList();
            productList.setPagedListInfo(productCatalogListInfo);
            productList.setBuildResources(true);
            productList.buildList(db);
            context.getRequest().setAttribute("productList", (Object)productList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "ViewProducts", "View Products");
        return "AllProductsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewProductDetails(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-view")) {
            return "PermissionError";
        }
        ProductCategoryList categoryList = null;
        ProductCatalog productDetails = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            int id = Integer.parseInt(context.getRequest().getParameter("productId"));
            productDetails = new ProductCatalog(db, id);
            categoryList = new ProductCategoryList();
            categoryList.buildList(db);
            context.getRequest().setAttribute("categoryList", (Object)categoryList);
            context.getRequest().setAttribute("productDetails", (Object)productDetails);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ViewProductOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddProduct(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-add")) {
            return "PermissionError";
        }
        ProductCategoryList categoryList = null;
        ProductCatalog productDetails = new ProductCatalog();
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            categoryList = new ProductCategoryList();
            categoryList.buildList(db);
            context.getRequest().setAttribute("categoryList", (Object)categoryList);
            context.getRequest().setAttribute("productDetails", (Object)productDetails);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddProductOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveProduct(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean isValid = false;
        boolean inserted = false;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            ProductCatalog thisProduct = (ProductCatalog)((Object)context.getFormBean());
            thisProduct.setEnteredBy(this.getUserId(context));
            thisProduct.setModifiedBy(this.getUserId(context));
            isValid = this.validateObject(context, db, (Object)thisProduct);
            if (isValid) {
                inserted = thisProduct.insert(db);
            }
            thisProduct.addCategoryMapping(db, Integer.parseInt(context.getRequest().getParameter("categoryId")));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandListAllProducts(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyProduct(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-edit")) {
            return "PermissionError";
        }
        ProductCategoryList categoryList = null;
        ProductCatalog productDetails = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            int id = Integer.parseInt(context.getRequest().getParameter("productId"));
            productDetails = new ProductCatalog(db, id);
            categoryList = new ProductCategoryList();
            categoryList.buildList(db);
            context.getRequest().setAttribute("categoryList", (Object)categoryList);
            context.getRequest().setAttribute("productDetails", (Object)productDetails);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ModifyProductOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateProduct(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean isValid = false;
        int inserted = -1;
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            ProductCatalog thisProduct = (ProductCatalog)((Object)context.getFormBean());
            thisProduct.setModifiedBy(this.getUserId(context));
            isValid = this.validateObject(context, db, (Object)thisProduct);
            if (isValid) {
                inserted = thisProduct.update(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (isValid && inserted > -1) {
            return this.executeCommandListAllProducts(context);
        }
        return this.executeCommandModifyProduct(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDeleteProduct(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        ProductCatalog productDetails = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        try {
            db = this.getConnection(context);
            String moduleId = context.getRequest().getParameter("moduleId");
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            SystemStatus systemStatus = this.getSystemStatus(context);
            int id = Integer.parseInt(context.getRequest().getParameter("productId"));
            productDetails = new ProductCatalog(db, id);
            htmlDialog.setTitle("Centric CRM: Products - Product");
            DependencyList dependencies = productDetails.processDependencies(db);
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (dependencies.canDelete()) {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header3"));
                htmlDialog.addButton(systemStatus.getLabel("button.deleteAll"), "javascript:window.location.href='ProductsCatalog.do?command=DeleteProduct&action=delete&productId=" + id + "&moduleId=" + moduleId + "'");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
            } else {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.unableHeader"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteProduct(ActionContext context) {
        if (!this.hasPermission(context, "product-catalog-product-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordDeleted = false;
        ProductCatalog productDetails = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        int id = -1;
        String moduleId = context.getRequest().getParameter("moduleId");
        try {
            db = this.getConnection(context);
            PermissionCategory permissionCategory = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permissionCategory);
            id = Integer.parseInt(context.getRequest().getParameter("productId"));
            productDetails = new ProductCatalog(db, id);
            recordDeleted = productDetails.delete(db, ProductsCatalog.getDbNamePath(context));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.productDeletion"));
            context.getRequest().setAttribute("refreshUrl", (Object)("ProductsCatalog.do?command=ViewProduct&productId=" + id + "&moduleId=" + moduleId));
            String string = "DeleteError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordDeleted) {
            context.getRequest().setAttribute("refreshUrl", (Object)("ProductsCatalog.do?command=ListAllProducts&moduleId=" + moduleId));
            return ProductsCatalog.getReturn(context, "Delete");
        }
        context.getRequest().setAttribute("refreshUrl", (Object)("ProductsCatalog.do?command=ViewProduct&productId=" + id + "&moduleId=" + moduleId));
        return ProductsCatalog.getReturn(context, "Delete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPopupSelector(ActionContext context) {
        Connection db = null;
        String displayFieldId = null;
        ProductCatalogList productList = null;
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            context.getSession().removeAttribute("ProductCatalogSelectorInfo");
        }
        HashMap selectedList = new HashMap();
        String previousSelection = context.getRequest().getParameter("previousSelection");
        PagedListInfo lookupSelectorInfo = this.getPagedListInfo(context, "ProductCatalogSelectorInfo");
        if (previousSelection != null) {
            StringTokenizer st = new StringTokenizer(previousSelection, "|");
            StringTokenizer st1 = new StringTokenizer(context.getRequest().getParameter("previousSelectionDisplay"), "|");
            while (st.hasMoreTokens() && st1.hasMoreTokens()) {
                selectedList.put(new Integer(st.nextToken()), st1.nextToken());
            }
        }
        if (context.getRequest().getParameter("displayFieldId") != null) {
            displayFieldId = context.getRequest().getParameter("displayFieldId");
        }
        if ("true".equals(context.getRequest().getParameter("reset")) && context.getSession().getAttribute("finalElements") != null && context.getRequest().getParameter("previousSelection") == null) {
            selectedList = (HashMap)((HashMap)context.getSession().getAttribute("finalElements")).clone();
        }
        int rowCount = 1;
        while (context.getRequest().getParameter("hiddenelementid" + rowCount) != null) {
            int elementId = 0;
            String elementValue = "";
            elementId = Integer.parseInt(context.getRequest().getParameter("hiddenelementid" + rowCount));
            if (context.getRequest().getParameter("checkelement" + rowCount) != null) {
                if (context.getRequest().getParameter("elementvalue" + rowCount) != null) {
                    elementValue = context.getRequest().getParameter("elementvalue" + rowCount);
                }
                if (selectedList.get(new Integer(elementId)) == null) {
                    selectedList.put(new Integer(elementId), elementValue);
                } else {
                    selectedList.remove(new Integer(elementId));
                    selectedList.put(new Integer(elementId), elementValue);
                }
            } else {
                selectedList.remove(new Integer(elementId));
            }
            ++rowCount;
        }
        try {
            db = this.getConnection(context);
            productList = new ProductCatalogList();
            ProductCategoryList categoryList = new ProductCategoryList();
            String categoryId = context.getRequest().getParameter("categoryId");
            if (categoryId != null && !"".equals(categoryId.trim()) && Integer.parseInt(categoryId) != -1) {
                categoryList.setParentId(Integer.parseInt(categoryId));
                productList.setCategoryId(Integer.parseInt(categoryId));
                ProductCategory thisCategory = new ProductCategory(db, Integer.parseInt(categoryId));
                context.getRequest().setAttribute("parentCategory", (Object)thisCategory);
                ProductCategories.buildHierarchy(db, context);
            } else {
                categoryList.setTopOnly(1);
                productList.setHasCategories(0);
            }
            productList.setPagedListInfo(lookupSelectorInfo);
            productList.setBuildResources(false);
            productList.setSelectedItems(selectedList);
            String listType = context.getRequest().getParameter("listType");
            if (context.getRequest().getParameter("contractId") != null && !"".equals(context.getRequest().getParameter("contractId")) && "single".equals(listType)) {
                categoryList.setServiceContractId(context.getRequest().getParameter("contractId"));
                productList.setServiceContractId(context.getRequest().getParameter("contractId"));
            }
            productList.buildList(db);
            categoryList.buildList(db);
            context.getRequest().setAttribute("categoryList", (Object)categoryList);
            context.getRequest().setAttribute("productList", (Object)productList);
            if ("true".equals(context.getRequest().getParameter("finalsubmit")) && "single".equals(listType)) {
                rowCount = Integer.parseInt(context.getRequest().getParameter("rowcount"));
                int elementId = Integer.parseInt(context.getRequest().getParameter("hiddenelementid" + rowCount));
                String elementValue = context.getRequest().getParameter("elementvalue" + rowCount);
                selectedList.clear();
                selectedList.put(new Integer(elementId), elementValue);
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("selectedElements", (Object)selectedList);
        context.getRequest().setAttribute("DisplayFieldId", (Object)displayFieldId);
        return "PopupProductListOK";
    }
}

