/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import com.darkhorseventures.framework.beans.GenericBean;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.orders.base.Order;
import org.aspcfs.modules.orders.base.OrderPayment;
import org.aspcfs.modules.orders.base.OrderProduct;
import org.aspcfs.modules.products.base.CustomerProductHistory;
import org.aspcfs.modules.products.base.CustomerProductHistoryList;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.quotes.base.Quote;
import org.aspcfs.utils.DatabaseUtils;

public class CustomerProduct
extends GenericBean {
    private int id = -1;
    private int orgId = -1;
    private int orderId = -1;
    private int orderItemId = -1;
    private String description = null;
    private int statusId = -1;
    private Timestamp statusDate = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private boolean enabled = true;
    private int productId = -1;
    private int quoteProductId = -1;
    private boolean buildProductCatalog = false;
    private ProductCatalog product = null;
    private boolean buildFileList = false;
    private FileItemList fileItemList = new FileItemList();
    private boolean buildHistoryList = false;
    private CustomerProductHistoryList historyList = new CustomerProductHistoryList();
    private Timestamp lastOrdered = null;
    private Order lastOrder = null;

    public void setBuildProductCatalog(boolean tmp) {
        this.buildProductCatalog = tmp;
    }

    public void setBuildProductCatalog(String tmp) {
        this.buildProductCatalog = DatabaseUtils.parseBoolean(tmp);
    }

    public void setQuoteProductId(int tmp) {
        this.quoteProductId = tmp;
    }

    public void setQuoteProductId(String tmp) {
        this.quoteProductId = Integer.parseInt(tmp);
    }

    public int getQuoteProductId() {
        return this.quoteProductId;
    }

    public boolean getBuildProductCatalog() {
        return this.buildProductCatalog;
    }

    public void setProduct(ProductCatalog tmp) {
        this.product = tmp;
    }

    public ProductCatalog getProduct() {
        return this.product;
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public int getProductId() {
        return this.productId;
    }

    public void setBuildHistoryList(boolean tmp) {
        this.buildHistoryList = tmp;
    }

    public void setBuildHistoryList(String tmp) {
        this.buildHistoryList = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildHistoryList() {
        return this.buildHistoryList;
    }

    public void setLastOrder(Order tmp) {
        this.lastOrder = tmp;
    }

    public Order getLastOrder() {
        return this.lastOrder;
    }

    public void setLastOrdered(Timestamp tmp) {
        this.lastOrdered = tmp;
    }

    public void setLastOrdered(String tmp) {
        this.lastOrdered = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getLastOrdered() {
        return this.lastOrdered;
    }

    public void setHistoryList(CustomerProductHistoryList tmp) {
        this.historyList = tmp;
    }

    public CustomerProductHistoryList getHistoryList() {
        return this.historyList;
    }

    public void setBuildFileList(boolean tmp) {
        this.buildFileList = tmp;
    }

    public void setBuildFileList(String tmp) {
        this.buildFileList = DatabaseUtils.parseBoolean(tmp);
    }

    public void setFileItemList(FileItemList tmp) {
        this.fileItemList = tmp;
    }

    public boolean getBuildFileList() {
        return this.buildFileList;
    }

    public FileItemList getFileItemList() {
        return this.fileItemList;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setOrderId(int tmp) {
        this.orderId = tmp;
    }

    public void setOrderId(String tmp) {
        this.orderId = Integer.parseInt(tmp);
    }

    public void setOrderItemId(int tmp) {
        this.orderItemId = tmp;
    }

    public void setOrderItemId(String tmp) {
        this.orderItemId = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setStatusDate(Timestamp tmp) {
        this.statusDate = tmp;
    }

    public void setStatusDate(String tmp) {
        this.statusDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getOrderId() {
        return this.orderId;
    }

    public int getOrderItemId() {
        return this.orderItemId;
    }

    public String getDescription() {
        return this.description;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public Timestamp getStatusDate() {
        return this.statusDate;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public CustomerProduct() {
    }

    public CustomerProduct(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public CustomerProduct(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void buildFileList(Connection db) throws SQLException {
        this.fileItemList.setLinkModuleId(423200418);
        this.fileItemList.setLinkItemId(this.getId());
        this.fileItemList.buildList(db);
        for (FileItem thisItem : this.fileItemList) {
            thisItem.buildVersionList(db);
        }
    }

    public void buildProductCatalog(Connection db) throws SQLException {
        if (this.productId > -1) {
            this.product = new ProductCatalog(db, this.productId);
        }
    }

    public void buildHistoryList(Connection db) throws SQLException {
        this.historyList.setOrgId(this.getOrgId());
        this.historyList.setCustomerProductId(this.getId());
        this.historyList.buildList(db);
        if (this.historyList.size() > 1) {
            CustomerProductHistory thisHistory = (CustomerProductHistory)((Object)this.historyList.get(this.historyList.size() - 1));
            this.lastOrdered = thisHistory.getProductStartDate();
            this.lastOrder = new Order(db, thisHistory.getOrderId());
        }
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Customer Product Number");
        }
        PreparedStatement pst = db.prepareStatement(" SELECT cp.*, pc.product_id AS product_id,  qe.product_id AS quote_product_id  FROM customer_product cp  LEFT JOIN order_product op ON (cp.order_item_id = op.item_id)  LEFT JOIN product_catalog pc ON (op.product_id = pc.product_id)  LEFT JOIN order_entry oe ON (cp.order_id = oe.order_id)  LEFT JOIN quote_entry qe ON (oe.quote_id = qe.quote_id)  WHERE cp.customer_product_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Customer Product not found");
        }
        if (this.buildFileList) {
            this.buildFileList(db);
        }
        if (this.buildHistoryList) {
            this.buildHistoryList(db);
        }
        if (this.buildProductCatalog) {
            this.buildProductCatalog(db);
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("customer_product_id"));
        this.orgId = rs.getInt("org_id");
        this.orderId = DatabaseUtils.getInt(rs, "order_id");
        this.orderItemId = DatabaseUtils.getInt(rs, "order_item_id");
        this.description = rs.getString("description");
        this.statusId = DatabaseUtils.getInt(rs, "status_id");
        this.statusDate = rs.getTimestamp("status_date");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.enabled = rs.getBoolean("enabled");
        this.quoteProductId = DatabaseUtils.getInt(rs, "quote_product_id");
        this.productId = this.quoteProductId != -1 ? this.quoteProductId : DatabaseUtils.getInt(rs, "product_id");
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "customer_product_customer_product_id_seq");
        sql.append("INSERT INTO customer_product (org_id, order_id, order_item_id, description,  status_id, status_date, ");
        if (this.id > -1) {
            sql.append("customer_product_id, ");
        }
        if (this.entered != null) {
            sql.append("entered, ");
        }
        sql.append("enteredby, ");
        if (this.modified != null) {
            sql.append("modified, ");
        }
        sql.append("modifiedby, enabled) ");
        sql.append("VALUES( ?, ?, ?, ?, ?, ?, ");
        if (this.id > -1) {
            sql.append("?, ");
        }
        if (this.entered != null) {
            sql.append("?, ");
        }
        sql.append("?, ");
        if (this.modified != null) {
            sql.append("?, ");
        }
        sql.append("?, ? )");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.getOrgId());
        DatabaseUtils.setInt(pst, ++i, this.getOrderId());
        DatabaseUtils.setInt(pst, ++i, this.getOrderItemId());
        pst.setString(++i, this.getDescription());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        pst.setTimestamp(++i, this.getStatusDate());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.entered != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        pst.setInt(++i, this.getEnteredBy());
        if (this.modified != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setInt(++i, this.getModifiedBy());
        pst.setBoolean(++i, this.getEnabled());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "customer_product_customer_product_id_seq", this.id);
        result = true;
        return result;
    }

    public boolean delete(Connection db, int itemId, String filePath) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Customer Product ID not specified");
        }
        boolean commit = true;
        boolean recordDeleted = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            FileItem thisItem = new FileItem(db, itemId, this.getId(), 423200418);
            thisItem.delete(db, filePath);
            PreparedStatement pst = db.prepareStatement("SELECT quote_id FROM order_entry WHERE quote_id > -1 AND order_id IN (SELECT DISTINCT(order_id)  FROM customer_product_history  WHERE customer_product_id = ?  AND order_id NOT IN ( SELECT order_id FROM customer_product WHERE                       customer_product_id = ? )) ");
            pst.setInt(1, this.getId());
            pst.setInt(2, this.getId());
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                Quote thisQuote = new Quote(db, rs.getInt("quote_id"));
                thisQuote.delete(db);
            }
            rs.close();
            pst.close();
            pst = db.prepareStatement("SELECT DISTINCT(order_id) FROM customer_product_history WHERE customer_product_id = ? AND order_id NOT IN ( SELECT order_id FROM customer_product WHERE                       customer_product_id = ? ) ");
            boolean i = true;
            pst.setInt(1, this.getId());
            pst.setInt(2, this.getId());
            rs = pst.executeQuery();
            while (rs.next()) {
                Order thisOrder = new Order(db, rs.getInt("order_id"));
                thisOrder.delete(db);
            }
            rs.close();
            pst.close();
            pst = db.prepareStatement("SELECT payment_id, order_item_id FROM order_payment WHERE order_item_id IN  (SELECT order_item_id FROM customer_product_history cph   WHERE customer_product_id = ? ) ");
            pst.setInt(1, this.getId());
            rs = pst.executeQuery();
            while (rs.next()) {
                OrderPayment thisPayment = new OrderPayment(db, rs.getInt("payment_id"));
                thisPayment.delete(db);
            }
            rs.close();
            pst.close();
            this.buildHistoryList(db);
            int size = this.getHistoryList().size();
            this.historyList.delete(db);
            pst = db.prepareStatement(" DELETE FROM customer_product WHERE customer_product_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            OrderProduct thisProduct = new OrderProduct(db, this.getOrderItemId());
            thisProduct.delete(db);
            Order thisOrder = new Order(db, this.getOrderId());
            recordDeleted = thisOrder.delete(db);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return recordDeleted;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE customer_product  SET description = ?,      status_id = ?,      status_date = ?,      modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + "     modifiedby = ?, " + "     enabled = ? ");
        sql.append("WHERE order_id = ? ");
        sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.getDescription());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        pst.setTimestamp(++i, this.getStatusDate());
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setBoolean(++i, this.getEnabled());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        Dependency thisDependency;
        ResultSet rs;
        PreparedStatement pst;
        DependencyList dependencyList = new DependencyList();
        try {
            int orderscount;
            pst = db.prepareStatement("SELECT COUNT(DISTINCT(order_id)) as orderscount FROM customer_product_history WHERE customer_product_id = ? ");
            pst.setInt(1, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (orderscount = rs.getInt("orderscount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("orders");
                thisDependency.setCount(orderscount);
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        try {
            int quotescount;
            pst = db.prepareStatement("SELECT COUNT(*) as quotescount FROM order_entry WHERE quote_id > -1 AND order_id IN (SELECT DISTINCT(order_id)  FROM customer_product_history  WHERE customer_product_id = ? )");
            pst.setInt(1, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (quotescount = rs.getInt("quotescount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("quotes");
                thisDependency.setCount(quotescount);
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    public boolean hasHistory() {
        if (this.historyList != null) {
            return this.historyList.size() > 1;
        }
        return false;
    }

    public void queryRecordFromItemId(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Order Product Number");
        }
        PreparedStatement pst = db.prepareStatement(" SELECT cp.*, op.product_id AS product_id,  qe.product_id AS quote_product_id  FROM customer_product cp  LEFT JOIN customer_product_history hist  ON ( cp.customer_product_id = hist.customer_product_id )  LEFT JOIN order_product op ON (cp.order_item_id = op.item_id)  LEFT JOIN order_entry oe ON (cp.order_id = oe.order_id)  LEFT JOIN quote_entry qe ON (qe.quote_id = oe.quote_id)  WHERE hist.order_item_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("Customer Product not found");
        }
        if (this.buildFileList) {
            this.buildFileList(db);
        }
        if (this.buildHistoryList) {
            this.buildHistoryList(db);
        }
    }
}

