/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class CustomerProductHistory
extends GenericBean {
    private int id = -1;
    private int customerProductId = -1;
    private int orgId = -1;
    private int orderId = -1;
    private int orderItemId = -1;
    private Timestamp productStartDate = null;
    private Timestamp productEndDate = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private boolean enabled = true;
    private String productName = null;
    private String shortDescription = null;
    private String categoryName = null;
    private double priceAmount = 0.0;

    public void setShortDescription(String tmp) {
        this.shortDescription = tmp;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setProductName(String tmp) {
        this.productName = tmp;
    }

    public void setCategoryName(String tmp) {
        this.categoryName = tmp;
    }

    public void setPriceAmount(double tmp) {
        this.priceAmount = tmp;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public double getPriceAmount() {
        return this.priceAmount;
    }

    public void setOrderItemId(int tmp) {
        this.orderItemId = tmp;
    }

    public void setOrderItemId(String tmp) {
        this.orderItemId = Integer.parseInt(tmp);
    }

    public int getOrderItemId() {
        return this.orderItemId;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setCustomerProductId(int tmp) {
        this.customerProductId = tmp;
    }

    public void setCustomerProductId(String tmp) {
        this.customerProductId = Integer.parseInt(tmp);
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setOrderId(int tmp) {
        this.orderId = tmp;
    }

    public void setOrderId(String tmp) {
        this.orderId = Integer.parseInt(tmp);
    }

    public void setProductStartDate(Timestamp tmp) {
        this.productStartDate = tmp;
    }

    public void setProductStartDate(String tmp) {
        this.productStartDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setProductEndDate(Timestamp tmp) {
        this.productEndDate = tmp;
    }

    public void setProductEndDate(String tmp) {
        this.productEndDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getCustomerProductId() {
        return this.customerProductId;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getOrderId() {
        return this.orderId;
    }

    public Timestamp getProductStartDate() {
        return this.productStartDate;
    }

    public Timestamp getProductEndDate() {
        return this.productEndDate;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public CustomerProductHistory() {
    }

    public CustomerProductHistory(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public CustomerProductHistory(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Customer Product History Number");
        }
        PreparedStatement pst = db.prepareStatement(" SELECT cph.history_id, cph.customer_product_id, cph.org_id, cph.order_id,         cph.product_start_date, cph.product_end_date, cph.entered, cph.enteredby,         cph.modified, cph.modifiedby, cph.order_item_id,         pc.product_name, pc.short_description, pcp.price_amount, pcat.category_name  FROM customer_product_history cph  LEFT JOIN order_entry o ON (cph.order_id = o.order_id)  LEFT JOIN order_product op ON (cph.order_item_id = op.item_id)  LEFT JOIN product_catalog pc ON (op.product_id = pc.product_id)  LEFT JOIN product_catalog_category_map pccm ON (pc.product_id = pccm.product_id)  LEFT JOIN product_category pcat ON (pccm.category_id = pcat.category_id)  LEFT JOIN product_catalog_pricing pcp ON (pc.product_id = pcp.product_id)  WHERE cph.history_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Customer Product History not found");
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("history_id"));
        this.customerProductId = rs.getInt("customer_product_id");
        this.orgId = rs.getInt("org_id");
        this.orderId = DatabaseUtils.getInt(rs, "order_id");
        this.productStartDate = rs.getTimestamp("product_start_date");
        this.productEndDate = rs.getTimestamp("product_end_date");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.orderItemId = rs.getInt("order_item_id");
        this.productName = rs.getString("product_name");
        this.shortDescription = rs.getString("short_description");
        this.categoryName = rs.getString("category_name");
        this.priceAmount = rs.getDouble("price_amount");
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "customer_product_history_history_id_seq");
        sql.append("INSERT INTO customer_product_history (" + (this.id > -1 ? "history_id, " : "") + "customer_product_id, org_id, order_id, " + " product_start_date, product_end_date, ");
        if (this.entered != null) {
            sql.append("entered, ");
        }
        sql.append("enteredby, ");
        if (this.modified != null) {
            sql.append("modified, ");
        }
        sql.append("modifiedby, order_item_id) ");
        sql.append("VALUES( ?, ?, ?, ?, ?, ");
        if (this.id > -1) {
            sql.append("?, ");
        }
        if (this.entered != null) {
            sql.append("?, ");
        }
        sql.append("?, ");
        if (this.modified != null) {
            sql.append("?, ");
        }
        sql.append("?, ? )");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.getCustomerProductId());
        pst.setInt(++i, this.getOrgId());
        DatabaseUtils.setInt(pst, ++i, this.getOrderId());
        DatabaseUtils.setTimestamp(pst, ++i, this.getProductStartDate());
        DatabaseUtils.setTimestamp(pst, ++i, this.getProductEndDate());
        if (this.entered != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        pst.setInt(++i, this.getEnteredBy());
        if (this.modified != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getOrderItemId());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "customer_product_history_history_id_seq", this.id);
        result = true;
        return result;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Customer Product History ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("DELETE FROM customer_product_history WHERE history_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE customer_product_history  SET order_id = ?,      order_item_id = ?      product_start_date = ?,      product_end_date = ?,      modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + "     modifiedby = ? ");
        sql.append("WHERE history_id = ? ");
        sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getOrderId());
        DatabaseUtils.setInt(pst, ++i, this.getOrderItemId());
        pst.setTimestamp(++i, this.getProductStartDate());
        pst.setTimestamp(++i, this.getProductEndDate());
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }
}

