/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.products.base.CustomerProductHistory;
import org.aspcfs.utils.web.PagedListInfo;

public class CustomerProductHistoryList
extends ArrayList {
    public static final String tableName = "customer_product_history";
    public static final String uniqueField = "history_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int orgId = -1;
    private int orderId = -1;
    private int customerProductId = -1;
    private int orderItemId = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setOrderId(int tmp) {
        this.orderId = tmp;
    }

    public void setOrderId(String tmp) {
        this.orderId = Integer.parseInt(tmp);
    }

    public void setCustomerProductId(int tmp) {
        this.customerProductId = tmp;
    }

    public void setCustomerProductId(String tmp) {
        this.customerProductId = Integer.parseInt(tmp);
    }

    public void setOrderItemId(int tmp) {
        this.orderItemId = tmp;
    }

    public void setOrderItemId(String tmp) {
        this.orderItemId = Integer.parseInt(tmp);
    }

    public int getOrderItemId() {
        return this.orderItemId;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getOrderId() {
        return this.orderId;
    }

    public int getCustomerProductId() {
        return this.customerProductId;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM customer_product_history cph  WHERE cph.history_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
                items = this.prepareFilter(pst);
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("cph.entered", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY cph.order_id, cph.product_start_date ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("  cph.history_id, cph.customer_product_id, cph.org_id, cph.order_id,   cph.product_start_date, cph.product_end_date, cph.entered, cph.enteredby,   cph.modified, cph.modifiedby, cph.order_item_id,   pc.product_name, pc.short_description, pcp.price_amount, pcat.category_name  FROM customer_product_history cph  LEFT JOIN order_entry o ON (cph.order_id = o.order_id)  LEFT JOIN order_product op ON (cph.order_item_id = op.item_id)  LEFT JOIN product_catalog pc ON (op.product_id = pc.product_id)  LEFT JOIN product_catalog_category_map pccm ON (pc.product_id = pccm.product_id)  LEFT JOIN product_category pcat ON (pccm.category_id = pcat.category_id)  LEFT JOIN product_catalog_pricing pcp ON (pc.product_id = pcp.product_id)  WHERE cph.history_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            CustomerProductHistory productHistory = new CustomerProductHistory(rs);
            this.add(productHistory);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.orgId > -1) {
            sqlFilter.append("AND cph.org_id = ? ");
        }
        if (this.orderId > -1) {
            sqlFilter.append("AND cph.order_id = ? ");
        }
        if (this.orderItemId > -1) {
            sqlFilter.append(" AND cph.order_item_id = ? ");
        }
        if (this.customerProductId > -1) {
            sqlFilter.append("AND cph.customer_product_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    public void delete(Connection db) throws SQLException {
        for (CustomerProductHistory thisHistory : this) {
            thisHistory.delete(db);
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.orgId > -1) {
            pst.setInt(++i, this.orgId);
        }
        if (this.orderId > -1) {
            pst.setInt(++i, this.orderId);
        }
        if (this.orderItemId > -1) {
            pst.setInt(++i, this.orderItemId);
        }
        if (this.customerProductId > -1) {
            pst.setInt(++i, this.customerProductId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public int getCustomerProductIdFromOrderProductId(int id) throws SQLException {
        int result = -1;
        for (CustomerProductHistory customerProductHistory : this) {
            if (customerProductHistory.getOrderItemId() != id) continue;
            result = customerProductHistory.getCustomerProductId();
            break;
        }
        return result;
    }
}

