/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.products.base.CustomerProduct;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class CustomerProductList
extends ArrayList {
    public static final String tableName = "customer_product";
    public static final String uniqueField = "customer_product_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int orgId = -1;
    private int orderId = -1;
    private int orderItemId = -1;
    private int statusId = -1;
    private int enabled = -1;
    private int productId = -1;
    private boolean matchProduct = true;
    private boolean buildProductCatalog = false;
    private boolean buildFileList = false;
    private boolean buildHistoryList = false;
    private boolean svgProductsOnly = false;
    private boolean historyExists = false;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setHistoryExists(boolean tmp) {
        this.historyExists = tmp;
    }

    public void setHistoryExists(String tmp) {
        this.historyExists = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getHistoryExists() {
        return this.historyExists;
    }

    public void setBuildProductCatalog(boolean tmp) {
        this.buildProductCatalog = tmp;
    }

    public void setBuildProductCatalog(String tmp) {
        this.buildProductCatalog = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildProductCatalog() {
        return this.buildProductCatalog;
    }

    public void setSvgProductsOnly(boolean tmp) {
        this.svgProductsOnly = tmp;
    }

    public void setSvgProductsOnly(String tmp) {
        this.svgProductsOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getSvgProductsOnly() {
        return this.svgProductsOnly;
    }

    public void setMatchProduct(boolean tmp) {
        this.matchProduct = tmp;
    }

    public void setMatchProduct(String tmp) {
        this.matchProduct = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getMatchProduct() {
        return this.matchProduct;
    }

    public void setBuildHistoryList(boolean tmp) {
        this.buildHistoryList = tmp;
    }

    public void setBuildHistoryList(String tmp) {
        this.buildHistoryList = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildHistoryList() {
        return this.buildHistoryList;
    }

    public void setBuildFileList(boolean tmp) {
        this.buildFileList = tmp;
    }

    public void setBuildFileList(String tmp) {
        this.buildFileList = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildFileList() {
        return this.buildFileList;
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public int getProductId() {
        return this.productId;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setOrderId(int tmp) {
        this.orderId = tmp;
    }

    public void setOrderId(String tmp) {
        this.orderId = Integer.parseInt(tmp);
    }

    public void setOrderItemId(int tmp) {
        this.orderItemId = tmp;
    }

    public void setOrderItemId(String tmp) {
        this.orderItemId = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getOrderId() {
        return this.orderId;
    }

    public int getOrderItemId() {
        return this.orderItemId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM customer_product cp  LEFT JOIN order_product op ON (cp.order_item_id = op.item_id)  LEFT JOIN order_entry oe ON (cp.order_id = oe.order_id)  LEFT JOIN quote_entry qe ON (oe.quote_id = qe.quote_id)  WHERE cp.customer_product_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
                items = this.prepareFilter(pst);
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("cp.entered", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY cp.order_id");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append(" cp.*, op.product_id AS product_id,  qe.product_id AS quote_product_id  FROM customer_product cp  LEFT JOIN order_product op ON (cp.order_item_id = op.item_id)  LEFT JOIN order_entry oe ON (cp.order_id = oe.order_id)  LEFT JOIN quote_entry qe ON (oe.quote_id = qe.quote_id)  WHERE cp.customer_product_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            CustomerProduct product = new CustomerProduct(rs);
            this.add(product);
        }
        rs.close();
        pst.close();
        if (this.buildFileList) {
            for (CustomerProduct thisProduct : this) {
                thisProduct.buildFileList(db);
            }
        }
        if (this.buildHistoryList) {
            for (CustomerProduct thisProduct : this) {
                thisProduct.buildHistoryList(db);
            }
        }
        if (this.buildProductCatalog) {
            for (CustomerProduct thisProduct : this) {
                thisProduct.buildProductCatalog(db);
            }
        }
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.orgId > -1) {
            sqlFilter.append("AND cp.org_id = ? ");
        }
        if (this.orderId > -1) {
            sqlFilter.append("AND cp.order_id = ? ");
        }
        if (this.orderItemId > -1) {
            sqlFilter.append("AND cp.order_item_id = ? ");
        }
        if (this.statusId > -1) {
            sqlFilter.append("AND cp.status = ? ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND cp.enabled = ? ");
        }
        if (this.productId > -1) {
            if (this.matchProduct) {
                sqlFilter.append("AND ( qe.product_id = ? OR op.product_id = ? ) ");
            } else {
                sqlFilter.append("AND ( qe.product_id <> ? OR op.product_id <> ? ) ");
            }
        }
        if (this.svgProductsOnly) {
            sqlFilter.append("AND cp.customer_product_id IN (SELECT link_item_id FROM project_files WHERE client_filename LIKE '%.svg') ");
        }
        if (this.historyExists) {
            sqlFilter.append("AND cp.customer_product_id IN ( SELECT customer_product_id FROM (   SELECT customer_product_id, count(history_id) as history   FROM customer_product_history   GROUP BY customer_product_id) tmp WHERE tmp.history > 1) ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.orgId > -1) {
            pst.setInt(++i, this.orgId);
        }
        if (this.orderId > -1) {
            pst.setInt(++i, this.orderId);
        }
        if (this.orderItemId > -1) {
            pst.setInt(++i, this.orderItemId);
        }
        if (this.statusId > -1) {
            pst.setInt(++i, this.statusId);
        }
        if (this.enabled == 1) {
            pst.setBoolean(++i, true);
        } else if (this.enabled == 0) {
            pst.setBoolean(++i, false);
        }
        if (this.productId > -1) {
            pst.setInt(++i, this.productId);
            pst.setInt(++i, this.productId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public int getCustomerProductIdFromOrderProductId(int id) throws SQLException {
        int result = -1;
        for (CustomerProduct customerProduct : this) {
            if (customerProduct.getOrderItemId() != id) continue;
            result = customerProduct.getId();
            break;
        }
        return result;
    }
}

