/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class Package
extends GenericBean {
    private int id = -1;
    private int categoryId = -1;
    private String name = null;
    private String abbreviation = null;
    private String shortDescription = null;
    private String longDescription = null;
    private int thumbnailImageId = -1;
    private int smallImageId = -1;
    private int largeImageId = -1;
    private int listOrder = -1;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private Timestamp startDate = null;
    private Timestamp expirationDate = null;
    private boolean enabled = false;

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setAbbreviation(String tmp) {
        this.abbreviation = tmp;
    }

    public void setShortDescription(String tmp) {
        this.shortDescription = tmp;
    }

    public void setLongDescription(String tmp) {
        this.longDescription = tmp;
    }

    public void setThumbnailImageId(int tmp) {
        this.thumbnailImageId = tmp;
    }

    public void setThumbnailImageId(String tmp) {
        this.thumbnailImageId = Integer.parseInt(tmp);
    }

    public void setSmallImageId(int tmp) {
        this.smallImageId = tmp;
    }

    public void setSmallImageId(String tmp) {
        this.smallImageId = Integer.parseInt(tmp);
    }

    public void setLargeImageId(int tmp) {
        this.largeImageId = tmp;
    }

    public void setLargeImageId(String tmp) {
        this.largeImageId = Integer.parseInt(tmp);
    }

    public void setListOrder(int tmp) {
        this.listOrder = tmp;
    }

    public void setListOrder(String tmp) {
        this.listOrder = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setStartDate(Timestamp tmp) {
        this.startDate = tmp;
    }

    public void setStartDate(String tmp) {
        this.startDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setExpirationDate(Timestamp tmp) {
        this.expirationDate = tmp;
    }

    public void setExpirationDate(String tmp) {
        this.expirationDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public int getThumbnailImageId() {
        return this.thumbnailImageId;
    }

    public int getSmallImageId() {
        return this.smallImageId;
    }

    public int getLargeImageId() {
        return this.largeImageId;
    }

    public int getListOrder() {
        return this.listOrder;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public Timestamp getExpirationDate() {
        return this.expirationDate;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public Package() {
    }

    public Package(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public Package(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Package ID specified");
        }
        PreparedStatement pst = db.prepareStatement(" SELECT    package_id, category_id, package_name, abbreviation, short_description, long_description    thumbnail_image_id, small_image_id, large_image_id, list_order,    entered, enteredby, modified, modifiedby, start_date, expiration_date, enabled  FROM package  WHERE package_id = ?  ORDER BY package_name ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Package not found");
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("package_id"));
        this.categoryId = DatabaseUtils.getInt(rs, "category_id");
        this.name = rs.getString("package_name");
        this.abbreviation = rs.getString("abbreviation");
        this.shortDescription = rs.getString("short_description");
        this.longDescription = rs.getString("long_description");
        this.thumbnailImageId = DatabaseUtils.getInt(rs, "thumbnail_image_id");
        this.smallImageId = DatabaseUtils.getInt(rs, "small_image_id");
        this.largeImageId = DatabaseUtils.getInt(rs, "large_image_id");
        this.listOrder = DatabaseUtils.getInt(rs, "list_order");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.startDate = rs.getTimestamp("start_date");
        this.expirationDate = rs.getTimestamp("expiration_date");
        this.enabled = rs.getBoolean("enabled");
    }

    public void delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Package ID not specified.");
        }
        int i = 0;
        PreparedStatement pst = db.prepareStatement("DELETE FROM package WHERE package_id = ? ");
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        StringBuffer sql = new StringBuffer();
        try {
            db.setAutoCommit(false);
            this.id = DatabaseUtils.getNextSeq(db, "package_package_id_seq");
            sql.append("INSERT INTO package (" + (this.id > -1 ? "package_id, " : "") + "   category_id, package_name, abbreviation, short_description, " + "   long_description, thumbnail_image_id, " + "   small_image_id, large_image_id, list_order, " + "   enteredby, ");
            if (this.entered != null) {
                sql.append("entered, ");
            }
            sql.append("modifiedBy, ");
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("start_date, expiration_date, enabled) ");
            sql.append("VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            sql.append("?, ");
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("?, ?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            DatabaseUtils.setInt(pst, ++i, this.getCategoryId());
            pst.setString(++i, this.getName());
            pst.setString(++i, this.getAbbreviation());
            pst.setString(++i, this.getShortDescription());
            pst.setString(++i, this.getLongDescription());
            DatabaseUtils.setInt(pst, ++i, this.getThumbnailImageId());
            DatabaseUtils.setInt(pst, ++i, this.getSmallImageId());
            DatabaseUtils.setInt(pst, ++i, this.getLargeImageId());
            DatabaseUtils.setInt(pst, ++i, this.getListOrder());
            pst.setInt(++i, this.getEnteredBy());
            if (this.entered != null) {
                pst.setTimestamp(++i, this.getEntered());
            }
            pst.setInt(++i, this.getModifiedBy());
            if (this.modified != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            DatabaseUtils.setTimestamp(pst, ++i, this.getStartDate());
            DatabaseUtils.setTimestamp(pst, ++i, this.getExpirationDate());
            pst.setBoolean(++i, this.getEnabled());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "package_package_id_seq", this.id);
            db.commit();
            result = true;
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return result;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE package SET category_id = ?,      abbreviation = ?,      short_description = ?,      long_description = ?,      thumbnail_image_id = ?,      small_image_id = ?,      large_image_id = ?,      list_order = ?,      modifiedBy = ? ,      modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + "     start_date = ?, " + "     expiration_date = ?, " + "     enabled = ? ");
        sql.append("WHERE package_id = ? ");
        sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getCategoryId());
        pst.setString(++i, this.getAbbreviation());
        pst.setString(++i, this.getShortDescription());
        pst.setString(++i, this.getLongDescription());
        DatabaseUtils.setInt(pst, ++i, this.getThumbnailImageId());
        DatabaseUtils.setInt(pst, ++i, this.getSmallImageId());
        DatabaseUtils.setInt(pst, ++i, this.getLargeImageId());
        DatabaseUtils.setInt(pst, ++i, this.getListOrder());
        pst.setInt(++i, this.getModifiedBy());
        pst.setTimestamp(++i, this.getStartDate());
        pst.setTimestamp(++i, this.getExpirationDate());
        pst.setBoolean(++i, this.getEnabled());
        pst.setInt(++i, this.getId());
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }
}

