/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.modules.products.base.Package;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class PackageList
extends ArrayList
implements SyncableList {
    public static final String tableName = "package";
    public static final String uniqueField = "package_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int enabled = -1;
    private int categoryId = -1;

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer("");
        StringBuffer sqlCount = new StringBuffer("");
        StringBuffer sqlFilter = new StringBuffer("");
        StringBuffer sqlOrder = new StringBuffer("");
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM package  WHERE package_id > -1");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append(" SELECT ");
        }
        sqlSelect.append("   package_id, category_id, package_name, abbreviation, short_description, long_description,    thumbnail_image_id, small_image_id, large_image_id, list_order,    entered, enteredby, modified, modifiedby, start_date, expiration_date, enabled  FROM package  WHERE package_id > -1 ");
        sqlOrder.append(" ORDER BY package_name ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Package thisPackage = new Package(rs);
            this.add(thisPackage);
        }
        rs.close();
        pst.close();
    }

    public void delete(Connection db) throws SQLException {
        for (Package thisPackage : this) {
            thisPackage.delete(db);
        }
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) {
        if (this.id > -1) {
            sqlFilter.append("AND package_id = ? ");
        }
        if (this.categoryId > -1) {
            sqlFilter.append("AND category_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND entered >= ? ");
            }
            sqlFilter.append("AND entered < ? ");
        } else if (this.syncType == 3) {
            sqlFilter.append("AND modified >= ? ");
            sqlFilter.append("AND entered < ? ");
            sqlFilter.append("AND modified < ? ");
        } else if (this.syncType == 5) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND entered >= ? ");
            }
            if (this.nextAnchor != null) {
                sqlFilter.append("AND entered < ? ");
            }
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND enabled = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.categoryId > -1) {
            pst.setInt(++i, this.categoryId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        } else if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        } else if (this.syncType == 5) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            if (this.nextAnchor != null) {
                pst.setTimestamp(++i, this.nextAnchor);
            }
        }
        if (this.enabled == 1) {
            pst.setBoolean(++i, true);
        } else if (this.enabled == 0) {
            pst.setBoolean(++i, false);
        }
        return i;
    }
}

